/*
   Non-Midas C Application For Sonet Acquisition/Playback

   Author: Bill Owen
*/

/* **********Sonet Module Type Names Were Changed In Version ice318b11 ***************/
/* Uncomment The #define OLDMODNAMES Line If Using Software Prior To ice318b11       */
/* Comment The #define OLDMODNAMES Line If Using Software Version ice318b11 Or Later */
/* If You Use The Wrong Module Names, Error Messages Will Be Reported                */
/*************************************************************************************/
/* #define OLDMODNAMES  1  */  
#ifdef OLDMODNAMES 
#define SR1MOD   "IOM=SNTXD"
#define SR2MOD   "IOM=SNTR2XD"
#define SR4MOD   "IOM=SNTR4XD"
#define SR5MOD   "IOM=SNTR5XD"
#else
#define SR1MOD   "IOM=SNTXD"
#define SR2MOD   "IOM=SNTXDR2"
#define SR4MOD   "IOM=SNTXDR4"
#define SR5MOD   "IOM=SNTXDR5"
#endif

#define DEVN "ICEPIC,DEVNO=%d,%s,%s,%s,,"


#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <unistd.h>



#include "icedefs.h"
#include "icelib.h"

#define FLAGS 0

#define INITFILESIZE 10 

int testacq (PICSTRUCT *p, int test,int playacq, int filesize,int_4 ploops,int_4 numport,char *fnpa,char *fnpb,int_4 vhsflag); 
int testmap (PICSTRUCT *p, int bytes);
int_4 findstrlocation (char *fstr, char *s);

/*******************************************************************************/
int main (int argc, char *argv[])
{
  PICSTRUCT  p;
  char devname[160],flagstr[80];
  int_4 flags = FLAGS;
  int_4 Mcbreak = 0;
  int_4 status,i;
  int_4 test,idev;
  int_4 playloops;
  int_4 numport = 1;
  int_4 flagindex = 8;
  int_4 vhsflag   = 0;
 
  int  pora     = 1;            /* Play = 0, Acq = 1, Acquisition Default              */
  int  filesize = INITFILESIZE; /* Default Acquisition/Playback File Size = 10 GBytes  */
  char fnamepa[80];             /* Path & Filename Of Acquisition/Playback File-Port A */
  char fnamepb[80];             /* Path & Filename Of Acquisition/Playback File-Port B */    


  if (argc <= 1) 
   {
    BAIL:
    printf("Syntax:  testsnt <mod type> <devno> <test> <size in GB> <loops> <ports> <filenameA> <filenameB> <flags> \n\n");
    printf("              <mod type>       = r1:SonetR1 OR r2:SonetR2 OR r4:SonetR4 OR r5:SonetR5 modules\n");
    printf("              <devno>          = 0|1|2 ... \n");
    printf("              <test>           = acq OR play\n"); 
    printf("              <size in GB>     = number of GBytes to acq or playback\n");
    printf("              <loops>          = # of playback loops through file, 1 for acquire\n");
    printf("              <ports>          = port to acquire, 1 for A, 2 for B, 3 for both A & B\n");
    printf("              <filenameA>      = filename AND path to playback or acquire\n");
    printf("              <filenameB>      = OPTIONAL-filename AND path to playback or acquire for 2nd channel\n");  
    printf("              <flags>          = example: OC3 or OC12 or OC24 or OC48 or OC48,OC12FROMOCX,OC12NUM=1\n");
    exit(0);
   }

  if (argc > 2)
    idev = atoi(argv[2]); 
  else 
    idev = 0;

  if (argc > 3)
   {
    if (strcmp(argv[3],"all")==0) test=0;
    else if (strcmp(argv[3],"play")==0)
      { 
        test = -9;
        pora =  0;
      }   
    else if (strcmp(argv[3],"acq")==0) test=-9;
    else if (strcmp(argv[3],"tacq")==0) test=-6;
    else if (strcmp(argv[3],"vhs")==0) { test=-7; flags |= FLG_VHS; }
    else if (strcmp(argv[3],"8e1")==0) test=-8;
    else if (strcmp(argv[3],"sniff")==0) test=-1;
    else if (strcmp(argv[3],"nvr")==0) test=-2;
    else if (strcmp(argv[3],"map")==0) test=-3;   /* Test Driver To See If Memory Mapped */
    else if (strcmp(argv[3],"reset")==0) test=-4;
    else test = atoi(argv[3]); 
   }
 else
  test = 0;

  /* File Size For Acquisition or Playback */  
  if (argc > 4) 
    filesize = atoi(argv[4]);

  if (argc > 5)
    playloops = atoi(argv[5]);
  else 
    playloops = 1; /* If No Input Only Loop Once   */

  if (pora == 1)  /* If Acquisition Loop Only Once */
    playloops = 1;

  if (argc > 6)
    numport = atoi(argv[6]); 
  
  if (argc > 7)
    { 
      if (numport != 2)
        strcpy(fnamepa,argv[7]);
      else
        strcpy(fnamepb,argv[7]);

      if ((argc > 8) && (numport == 3))
        strcpy(fnamepb,argv[8]); 
    }

  if (numport == 3)
    flagindex = 9;
  else
    flagindex = 8;

  if (argc > flagindex) 
    { 
      for (i=0; argv[flagindex][i]!=0; i++)
        {
         flagstr[i] = argv[flagindex][i];
         if (flagstr[i]>'Z')
           flagstr[i] -= 32;
        } 
     flagstr[i]=0;
   }
  else
   strcpy(flagstr,"NONE");

 /* Setup Card Config String Based On Module Type */
  if (strcmp(argv[1],"r6")==0)  /* Sonet Rev 6 */
    {
      if ((strstr(flagstr,"VHS") != NULL) || (strstr(flagstr,"vhs") != NULL))
        {
          vhsflag = 1;
          if (numport == 3)   
            {
              printf("VHS Modes Uses PIC Card Resources From Both Ports\n");
              printf("You Can Only Use VHS Mode For Single Port Acq/Play--NOT Both\n");
            }
        } 
       
      if (pora == 0)
        {
          if (numport == 1) 
            sprintf(devname,DEVN,idev,"IOM=DXSNTR6","MUXCLK=N",flagstr);
          else
            sprintf(devname,DEVN,idev,"IOM=DXSNTR6","MUXCLK=N",flagstr);
        } 
      else
        { 
          if (vhsflag == 0)  
            sprintf(devname,DEVN,idev,"IOM=SNTXDR6","IOC=II",flagstr);
           else 
            { 
              if (numport == 1)
                sprintf(devname,DEVN,idev,"IOM=SNTXDR6","MUXCLK=N",flagstr);
              else 
                sprintf(devname,DEVN,idev,"IOM=SNTXDR6","MUXCLK=N",flagstr);
            }  
        }
    }
   else if (strcmp(argv[1],"r5")==0)  /* Sonet Rev 5 */
    {
      if ((strstr(flagstr,"VHS") != NULL) || (strstr(flagstr,"vhs") != NULL))
        {
          vhsflag = 1;
          if (numport == 3)   
            {
              printf("VHS Modes Uses PIC Card Resources From Both Ports\n");
              printf("You Can Only Use VHS Mode For Single Port Acq/Play--NOT Both\n");
            }
        } 
       
      if (pora == 0)
        {
          if (numport == 1) 
            sprintf(devname,DEVN,idev,"IOM=DXSNTR5","MUXCLK=A",flagstr);
          else
            sprintf(devname,DEVN,idev,"IOM=DXSNTR5","MUXCLK=B",flagstr);
        } 
      else
        { 
          if (vhsflag == 0)  
            sprintf(devname,DEVN,idev,SR5MOD,"",flagstr);
           else 
            { 
              if (numport == 1)
                sprintf(devname,DEVN,idev,SR5MOD,"MUXCLK=A",flagstr);
              else 
                sprintf(devname,DEVN,idev,SR5MOD,"MUXCLK=B",flagstr);
            }  
        }
    }
   else if (strcmp(argv[1],"r4")==0)  /* Sonet Rev 4 */
    {
      if ((strstr(flagstr,"VHS") != NULL) || (strstr(flagstr,"vhs") != NULL))
        {
          vhsflag = 1;
          if (numport == 3)   
            {
              printf("VHS Modes Uses PIC Card Resources From Both Ports\n");
              printf("You Can Only Use VHS Mode For Single Port Acq/Play--NOT Both\n");
            }
        } 
       
      if (pora == 0)
        {
          if (numport == 1) 
            sprintf(devname,DEVN,idev,"IOM=DXSNTR4","MUXCLK=A",flagstr);
          else
            sprintf(devname,DEVN,idev,"IOM=DXSNTR4","MUXCLK=B",flagstr);
        } 
      else
        { 
          if (vhsflag == 0)  
            sprintf(devname,DEVN,idev,SR4MOD,"IOC=II",flagstr);
           else 
            { 
              if (numport == 1)
                sprintf(devname,DEVN,idev,SR4MOD,"MUXCLK=A",flagstr);
              else 
                sprintf(devname,DEVN,idev,SR4MOD,"MUXCLK=B",flagstr);
            }  
        }
    }
  else if (strcmp(argv[1],"r2")==0)  /* Sonet Rev 2 */
    {
      if ((strstr(flagstr,"VHS") != NULL) || (strstr(flagstr,"vhs") != NULL))
        {
          vhsflag = 1;
          if (numport == 3)   
            {
              printf("VHS Modes Uses PIC Card Resources From Both Ports\n");
              printf("You Can Only Use VHS Mode For Single Port Acq/Play--NOT Both\n");
            }
        }  
       
      if (pora == 0)
        sprintf(devname,DEVN,idev,"IOM=DXSNTR2","MUXCLK=B",flagstr);
      else
        { 
          if (vhsflag == 0)  
            sprintf(devname,DEVN,idev,SR2MOD,"IOC=II",flagstr);
           else 
            sprintf(devname,DEVN,idev,SR2MOD,"MUXCLK=B",flagstr);
        }
    }
  else   /* Sonet Rev 1 */
    {
      if (pora == 0)
        sprintf(devname,DEVN,idev,"IOM=DXSNT","MUXCLK=B",flagstr);
      else
        sprintf(devname,DEVN,idev,SR1MOD,"IOC=II",flagstr); 
    }

  printf ("Starting ICE test %d on %s with flags=%s\n",test,devname,flagstr); 

  /* Open Card For Access */
  status = pic_open (&p, devname, &Mcbreak, flags);

  if (status > 0)
   {
     if (test == -1) status = pic_sniff (&p, 0);
     if (test == -2) pic_nvram (&p,"",-1);
     if (test == -3) status = testmap (&p, 1048576);
     if (test == -4) status = pic_reset (&p, 0); 
     if (test <= -6) status = testacq (&p, test, pora, filesize,playloops,numport,fnamepa,fnamepb,vhsflag);

     if (test >=  0) status = pic_test (&p, test, 1); 
     status = pic_close (&p);
   }
  else 
     printf ("Error opening device - tests aborted\n");
  
  printf ("Finished\n");
}

/*******************************************************************************/
int testacq (PICSTRUCT *p, int test,int playacq, int filesize,int_4 ploops,int_4 numport,char *fnpa,char *fnpb, int_4 vhsflag)
 {

#define MEGMEMBUF 0       /* Setting MEGMEMBUF To Non-Zero Overrides Memory Calculations Below Based On Sample Rate */
                          /* If Non-zero, Total Memory Allocated Will Be MEGMEMBUF * ONEMEG                         */

#define ONEMEG    1048576
#define VHSMEMBUF 768     /* 6 Byte Aligned For Very High Speed Mode PIC4T & OC24 Rates Only*/
#define ZERO    0


  int_4 dmac[2];
  int_u4 nbytes[2],count[2];
  int_4 *data[2];
  int i,status[2],flags;
  int_4 ii,quadsize;
  int_4 bytestransfer,err=0;
  int_4 loopcnt[2] ;
  int_u4 quadcnt[2], numquads, quadindex;
  int fp[2];
  int actp = 0;
  unsigned char *datab[2];
  int numbuffers;

  int_u4 megsinmembuf = 0;
  int_u4 totalmegs;
  DMAMAP map[2];

 
  /* Allocate Mem Based On Signal Acquire Rate If User Has Not Set Memory */
  if (MEGMEMBUF == 0) 
     {
       if (findstrlocation ("OC192",p->config) >= 0)  
         megsinmembuf = 4048;  
       if ((findstrlocation ("OC48",p->config) >= 0) || (findstrlocation ("OC48FROMOCX",p->config) >= 0)) 
         megsinmembuf = 4048;
       if ((findstrlocation ("OC24",p->config) >= 0) || (findstrlocation ("OC24FROMOCX",p->config) >= 0))
         megsinmembuf = 1024;
       if ((findstrlocation ("OC12",p->config) >= 0) || (findstrlocation ("OC12FROMOCX",p->config) >= 0))
         megsinmembuf =  512;  
       if ((findstrlocation ("OC3",p->config)  >= 0) || (findstrlocation ("OC3FROMOCX",p->config) >= 0))
        megsinmembuf =   128 ; 
     }
  else
    megsinmembuf = MEGMEMBUF;       

  if (megsinmembuf == 0)        /* Assume OC3 If No Flags Specified Or Mem Not Specified   */
    {
      megsinmembuf = 64;
      printf("Assuming OC3 Data Rate For Memory Allocation, Will Attempt To Alocate 64 Meg\n");
      printf("Reason: No Flags Specified & Mem Alloc #define Not Set\n\n");
    }              

  if (vhsflag == 1)             /* Special Case Of PIC4T & OC24 Data Rate                  */
    megsinmembuf  = VHSMEMBUF;

  totalmegs  = filesize * 1024; /* Total Megs Of FileSize To Acquire                       */  
  
  if ((totalmegs%megsinmembuf) != 0) 
    totalmegs = ((totalmegs/megsinmembuf) + 1) * megsinmembuf;


 /* Initialize File Loop Count and Total Quad Count */
  for (ii=0;ii<2;ii++)
    {
      loopcnt[ii] = 0;
      quadcnt[ii] = 0;     
    } 

  /* reset the card */
  pic_reset (p, 0);

  flags = 0;
#if _IEEE
  flags |= FLG_BIGEND;
#endif

  /* load gate array code to gen test ramp on IOC 
     the default IOC code is loaded in the pic_reset() call 
     this call is ONLY for these special test cases */

  if (test == -6) {    /* tuner */
    pic_loadfile (p, "*_iir", FLG_IOC);
    /* set I/O port for 16bit acquisition at 20MHz on Tuner 1 */
    dmac[0] = pic_ioport (p, IOPT_TUNER, 1, -1, -1, 16, 20000000, 0.1,32,0,flags);
    count[0] = 128*1024;
  } 
  else if (test == -7) {   /* vhs */
    pic_loadfile (p, "*_iirv", FLG_IOC);
    /* set I/O port for 32bit acquisition at 20MHz on Module 3 (1|2 mux) */
    dmac[0] = pic_ioport (p, IOPT_MODULE, 3, -1, -1, -16, 20000000, 0.0,0,0,flags);
    count[0] = 3*256*1024;
  } 
  else if (test == -8) {   /* 8e1 */
    pic_loadfile (p, "*_8e1t", FLG_IOC);
    flags |= FLG_DUAL;
    /* set I/O port for 1bit acquisition at 8x2MHz on Module 1 */
    dmac[0] = pic_ioport (p, IOPT_MODULE, 1, -1, -1, 1, 16000000, 0.0,0,0,flags);
    count[0] = 256*1024;
   } 
  else
   {     /* Playback */ 
      
      if (playacq == 0) 
        {
          if (p->type != ICEPIC5)  /* Only Load FPGA If Card Type != PIC5 */
            { 
              if (vhsflag == 1)
                pic_loadfile (p, "*_oo", FLG_IOC); 
              else  
                pic_loadfile (p, "*_ooy", FLG_IOC);
            }

          if (numport != 2) 
            {
              if (vhsflag == 1)
                dmac[0] = pic_ioport (p, IOPT_MODULE, 1, -1, 1, 8, 160000000, 0.0,0,0,flags);
              else   
                dmac[0] = pic_ioport (p, IOPT_MODULE, 1, -1, 1, 8, 80000000, 0.0,0,0,flags);
            }
          if (numport != 1)
            {
              if (vhsflag == 1)
                dmac[1] = pic_ioport (p, IOPT_MODULE, 2, -1, 1, 8, 160000000, 0.0,0,0,flags);
              else   
                dmac[1] = pic_ioport (p, IOPT_MODULE, 2, -1, 1, 8, 80000000, 0.0,0,0,flags);
            } 
        }
      else  /* Acquisition */
       {    
          if (p->type != ICEPIC5)   /* Only Load FPGA If Card Type != PIC5 */          
            { 
              if (vhsflag == 1) 
                pic_loadfile (p, "*_iix", FLG_IOC);
              else    
                pic_loadfile (p, "*_ii", FLG_IOC);
            }

          if (numport != 2)
            {
              if (vhsflag == 1)
               dmac[0] = pic_ioport (p, IOPT_MODULE, 1, -1, -1, 8,160000000, 0.0,0,0,flags);
              else    
                dmac[0] = pic_ioport (p, IOPT_MODULE, 1, -1, -1, 8,80000000, 0.0,0,0,flags);
            }
          if (numport != 1)
            {
              if (vhsflag == 1)
                dmac[1] = pic_ioport (p, IOPT_MODULE, 2, -1, -1, 8,160000000, 0.0,0,0,flags);
              else   
                dmac[1] = pic_ioport (p, IOPT_MODULE, 2, -1, -1, 8,80000000, 0.0,0,0,flags);
            }
        }  
     }

  if (numport != 2)   /* Port A Being Used */
    {
      if (dmac[0]<=0)
        {
           printf("Port A-IO Port Allocation Failed\n");
           return -1;
        }
     /* map the buffer to physical memory */
      count[0]  = (megsinmembuf * ONEMEG)/4;  /*  Size of Our Mem Buffer For Port A in DWORDS */
      nbytes[0] = count[0]*4;       
      status[0] = pic_mapmem (p, &map[0], (nbytes[0]/4096) * -1, 1);
      if (status[0] <= 0)
        {
          printf("%s%d%s\n","Program's attempt to allocate ",megsinmembuf," MBytes For Acquisition or Playback Failed!!!");
          printf("Option #1: Increase Mappable Memory Using setram Program in $ICEROOT/drv/lnx\n");
          printf("Option #2: Set #define MEGMEMBUF In testsnt.c To Value Lower Than Listed Above And Recompile\n");
          return -1;
        }
      
      data[0] = (int_u4 *)map[0].vaddr;
      datab[0] = (unsigned char *)data[0]; /* Byte Data Pointer From DWORD Pointer */

      if (playacq == 1)
         fp[0] = open(fnpa,O_RDWR|O_CREAT|O_TRUNC,S_IRGRP|S_IWGRP|S_IROTH|S_IWOTH|S_IRUSR|S_IWUSR);
      else
         fp[0] = open(fnpa,O_RDONLY);
  
      if (fp[0] == -1)
       {
          printf("Cannot open file %s \n",fnpa);
          exit(-1);     
       }

    }

   if (numport != 1)  /* Port B Being Used */
    {
      if (dmac[1]<=0)
        {
           printf("Port B-IO Port Allocation Failed\n");
           return -1;
        }
     /* map the buffer to physical memory */
      count[1]  = (megsinmembuf * ONEMEG)/4;  /*  Size of Our Mem Buffer For Port B in DWORDS */
      nbytes[1] = count[1]*4;
      status[1] = pic_mapmem (p, &map[1], (nbytes[1]/4096) * -1, 1); 
      if (status[1] <=0)
        {
          printf("%s%d%s\n","Program's attempt to allocate ",megsinmembuf," MBytes For Acquisition or Playback Failed!!!");
          printf("Option #1: Increase Mappable Memory Using setram Program in $ICEROOT/drv/lnx\n");
          printf("Option #2: Set #define MEGMEMBUF In testsnt.c To Value Lower Than Listed Above And Recompile\n");
          return -1;
        }
      data[1] = (int_u4 *)map[1].vaddr;
      datab[1] = (unsigned char *)data[1]; /* Byte Data Pointer From DWORD Pointer */

      if (playacq == 1)
        fp[1] = open(fnpb,O_RDWR|O_CREAT|O_TRUNC,S_IRGRP|S_IWGRP|S_IROTH|S_IWOTH|S_IWUSR|S_IRUSR);
      else
        fp[1] = open(fnpb,O_RDONLY);
  
      if (fp[1] == -1)
       {
          printf("Cannot open file %s \n",fnpb);
          exit(-1);     
       }

    } 

 
 /* Divide Memory Buffer Into 4 Quadrants (pieces) */
 /* And Determine number of 1 Meg Transfers In Each Quadrant */
  quadsize    = megsinmembuf/4; /* For 512/4 MByte Buffer quadsize = 128 transfers of 1Meg in 512/4 Mem Buffer*/

 /* Determine Number Of Quadrants For Entire Transfer         */
 /* Filesize = # GBytes For Acquire, Buffer Size = 512 MBytes */
 /* number of memory buffers for transfer = 8 * # Gbytes      */
  numquads = totalmegs/megsinmembuf * 4; 
  
  if (playacq == 0)  /* Playback Of File */
    {
      if (numport != 2)
        { 
          quadcnt[0] = 4;  /* Init Count of Quads Transferred */
          for (ii=0;ii<megsinmembuf;ii++)
            {
              bytestransfer = read(fp[0],datab[0]+(ii*ONEMEG),ONEMEG);               
              if (bytestransfer != ONEMEG)
                {
                  printf("%s%d\n","Initial Read Wrong: Incorrect amount = ",bytestransfer);
                  pic_reset (p, 0);  /* reset the card to reload the standard IOC code */
                  return(-1);
                }
            }
        }

      if (numport != 1)
        { 
          quadcnt[1] = 4;  /* Init Count of Quads Transferred */
          for (ii=0;ii<megsinmembuf;ii++)
            {
              bytestransfer = read(fp[1],datab[1]+(ii*ONEMEG),ONEMEG);               
              if (bytestransfer != ONEMEG)
                {
                    printf("%s%d\n","Initial Read Wrong: Incorrect amount = ",bytestransfer);
                    pic_reset (p, 0);  /* reset the card to reload the standard IOC code */ 
                    return(-1);
                }
            }
        } 
     }

  /* setup the DMA handler */
  if (numport != 2)
    {
 
      if (playacq == 0)
        status[0] = pic_dmasetup (p, dmac[0], 1, &map[0], -1, 0);       
      else
        status[0] = pic_dmasetup (p, dmac[0], -1, &map[0], -1, 0);       
      if (status[0] < 0)
        {
         printf("DMA Start Failed Port A\n");
         return(-1);
        }
     
      loopcnt[0] = 0;  
     /* Start Continuous Acquistion/Playback Port A*/
      status[0] = pic_dmafunc (p, dmac[0], DMA_CONTINUOUS);
      status[0] = pic_dmafunc (p, dmac[0], DMA_STATUS);
    }
  else 
    loopcnt[0] = ploops;

  if (numport != 1)
    {
      if (playacq == 0)
        status[1] = pic_dmasetup (p, dmac[1], 1, &map[1], -1, 0);
      else
        status[1] = pic_dmasetup (p, dmac[1], -1, &map[1], -1, 0);
      if (status[1] < 0)
       {
         printf("DMA Start Failed Port B\n");
         return(-1);
       }
      loopcnt[1] = 0; /* Init Loop Counter */ 

      /* Start Continuous Acquistion/Playback */
       status[1] = pic_dmafunc (p, dmac[1], DMA_CONTINUOUS);
       status[1] = pic_dmafunc (p, dmac[1], DMA_STATUS);
    }
  else 
    loopcnt[1] = ploops;
  
 /* Continue Until Done Number Of Loops For Playback (Should Always Be 1 For Acquire) */ 
 while ((loopcnt[0] < ploops) || (loopcnt[1] < ploops))
  {
    if  (loopcnt[actp] < ploops)
     {                      
       quadindex = quadcnt[actp] % 4;  /* Determine Which Quadrant We Are Operating In */             

       if ((status[actp] >= ((quadindex*quadsize) *ONEMEG)) && (status[actp] < ((quadindex+1)*quadsize*ONEMEG) )) 
         {
           usleep(10000); /* Wait For Data To Be Available */
           status[actp] = pic_dmafunc (p, dmac[actp], DMA_STATUS); /* Get Offset Of Card Transfer in Mem */
         }  
       else
         {
           if (playacq == 1) /* acq */
             {
               for (ii=0;ii<quadsize;ii++) /* number of 1 Meg Transfers per quadrant */
                {
                  bytestransfer = write(fp[actp],datab[actp]+(((quadindex*quadsize)+ii) * ONEMEG),ONEMEG);                   
                  if (bytestransfer != ONEMEG)
                    {
                      printf("%s%d\n","bytestransfer Wrong: Incorrect amount = ",bytestransfer);
                      break; /* Break out of ii loop */
                    }
                 } /* For ii */
             }
           else
             {
               for (ii=0;ii<quadsize;ii++)
                 {
                   bytestransfer = read(fp[actp],datab[actp]+(((quadindex*quadsize)+ii) * ONEMEG),ONEMEG);                  
                   if (bytestransfer != ONEMEG)
                     {
                       printf("%s%d\n","bytestransfer Wrong: Incorrect amount = ",bytestransfer);
                       break; /* Break out of ii loop */
                     }
                 }  /* For ii */   
              }

           quadcnt[actp]= quadcnt[actp] + 1; /* Increment To Look To Next Quadrant */  

           if ((quadcnt[actp] % 8) == 0)     /* See If Finished 2 x Whole Buf Trans*/
             { 
               if (actp == 0)
                 printf("Port A: ");
               else
                 printf("Port B: ");
               printf("%s%d%s%d","Loop #",loopcnt[actp]+1," Disk Transferred Gigabytes = ",(quadcnt[actp]/4 * megsinmembuf)/1024);
               printf("%s%d\n",".",((quadcnt[actp]/4 * megsinmembuf)%1024)/100);
             }

           status[actp] = pic_dmafunc (p, dmac[actp], DMA_STATUS);
           if ((status[actp] > ((quadindex*quadsize)*ONEMEG)) && (status[actp] < (((quadindex+1)*quadsize)*ONEMEG)))
             printf("%s%ld\n","Overflow: Status = ",status[actp]);

           if (quadcnt[actp] == numquads)  /* See If Finished Whole File */
             {
               loopcnt[actp] = loopcnt[actp] + 1;
               quadcnt[actp] = 0;
               if (playacq == 0)
                 lseek(fp[actp],0,SEEK_SET); /* Reposition To Start Of File */
             }           
         } 
         
     } /* IF loopcnt */

    actp = (actp + 1)% 2;  /* Bounce Between Port 1 And Port 2 Transfers */

  } /* while loops < loopcnt */

  if (numport != 2)
    {
      close(fp[0]);
     /* Stop ICEPIC card DMA Port A*/
      status[0] = pic_dmafunc (p, dmac[0], DMA_CANCEL);
     /* unmap the buffer to physical memory */
      status[0] = pic_mapmem (p, &map[0], (nbytes[0]/4096) * -1, -1);      
    }
  if (numport != 1)
     {
      close(fp[1]);
     /* Stop ICEPIC card DMA Port A*/
      status[1] = pic_dmafunc (p, dmac[1], DMA_CANCEL);
     /* unmap the buffer to physical memory */
      status[1] = pic_mapmem (p, &map[1], (nbytes[1]/4096) * -1, -1); 
    }

  /* reset the card to reload the standard IOC code */
  pic_reset (p, 0);

  return 1;
}

/*******************************************************************************/
int testmap (PICSTRUCT *p, int nbytes) {
  int_4 nstart,*data,status;

  /* map the buffer to physical memory */
  status = pic_map (p, &data, &nstart, nbytes, 1);
  if (status<=0) return -1;

  printf("MAP nstart=%08x nbytes=%08x data=%08x\n",nstart,nbytes,data);

  /* unmap the buffer to physical memory */
  status = pic_map (p, &data, &nstart, nbytes, -1);

  return 1;
}
/*******************************************************************************/
int_4 findstr (char *fstr,char *astr) 
{
  int i,j,k,delim; char c;
  for (i=0; astr[i]!=0; i++) {
    c = astr[i];
    delim = (c==',' || c=='+' || c=='(' || c=='|'); /* valid front delimiter */
    if (delim || i==0) {
      if (delim) k=i+1; else k=0;
      for (j=0; fstr[j]!=0; j++) {
        if (astr[k+j]!=fstr[j]) goto NOMATCH;
      }
      c = astr[k+j];
      delim = (c==',' || c=='+' || c==')' || c=='|' || c=='='); /* valid tail delimiter */
      if (delim) return (k);  
      i+=(j-1);
    }
    NOMATCH:;
  }
  return (-1);
}
/*******************************************************************************/
int_4 findstrlocation (char *fstr, char *s) 
{
  int i,value=0,mult=1;
  i = findstr(fstr,s);
  if (i < 0) return -1;    /* state not present */
  i += strlen(fstr);
  if (s[i]!='=') return 1;    /* state present */
  if (s[i+1]=='-') { mult=-1; i++; }
  for (i++; s[i] >= '0' && s[i] <= '9'; i++) {
    value = value*10 + (s[i]-48);
  }
  return value*mult;    /* value switch */
}
