/*
   Use ICE driver to copy physical memory to file
   Author: Jeff Schoen
*/

#include <stdlib.h>
#include <stdio.h>
#include <unistd.h>
#include <string.h>
#include <math.h>

#include "icedefs.h"
#include "icelib.h"

int main (int argc, char *argv[]) {
  PICSTRUCT ps, *p=&ps;
  DMAMAP map;
  FILE *fp;
  char *fn,*sn,*an,*un;
  int_4 i,j,n,size,Mcbreak=0,status=0,*data;

  if (argc < 4) {
    BAIL:
    printf("Syntax:  pmemcpy <file|none|dmesg> <bytes> <addr> ... <bytesN> <addrN>\n");
    exit(0);
  }

  fn = argv[1];

for (n=3; n<argc; n+=2) {

  sn = argv[n-1];
  size = atoi(sn);
  an = argv[n];

  un = index(an,'_');
  if (un==NULL) sscanf(an,"%lx",&map.paddr);
  else { sscanf(an,"%x_%lx",&i,&map.paddr); map.paddr += ((int_8)i)<<32; }

  printf("Copy %d bytes at %016lx to %s\n",size,map.paddr,fn);

  status = pic_open (p,"ICERAM",&Mcbreak,0);
  if (status<0) { printf("Problem opening ICERAM\n"); goto BAIL2; }

  if (strcmp("dmesg",fn)==0) { 
    pic_ioctl (p,IOCTL_PMDUMP,0,(int_4*)(int_x)map.paddr,size);
    printf("Use dmesg to see results\n");
    goto BAIL1;
  }

  status = pic_mapmem (p,&map,size,3);
  if (status<0) { printf("Problem mapping ICERAM\n"); goto BAIL1; }

  if (strcmp("none",fn)==0) { 
    data = (int_4*)map.vaddr;
    for (i=0; i<(size>>2); i+=8) {
      printf(" i=%04x ",i);
      for (j=0; j<8; j++) printf(" %08x",data[i+j]);
      printf("\n");
    }
  } else {
    fp = fopen(fn,"w+");
    fwrite (map.vaddr,size,1,fp);
    fclose(fp);
  }

  status = pic_mapmem (p,&map,size,-3);
  BAIL1:
  status = pic_close (p);
  BAIL2:
  continue;

}

  if (status<0) exit(EXIT_FAILURE);
  else          exit(EXIT_SUCCESS);
}

