/*
   Example routine to process an ICE-RAM input buffer to output buffer using /RTFILE modes

   Author: Jeff Schoen

*/

#include <stdlib.h>
#include <unistd.h>
#include <stdio.h>
#include <signal.h>
#include <string.h>
#include <ctype.h>
#include "icedefs.h"
#include "fiolib.h"

int ctrlc;
void cleanup() { ctrlc=1; }

long atolx (char *s) {
  int l = strlen(s);
  int x = toupper(s[l-1]);
  long d = atol(s);
  if (x=='K') d *= 1024;
  if (x=='M') d *= 1024*1024;
  if (x=='G') d *= 1024*1024*1024;
  return d;
}

int main (int argc, char *argv[])
{
  int nr,nw,nxfer,flags,status=-1;
  FIOSTRUCT *fi=NULL,*fo=NULL;
  char *fno,*fni;
  void *bx=NULL;
  long count;

  if (argc < 5) {
    printf("Syntax:  icertf <infile> <outfile> <nxfer> <count>\n");
    printf("         <infile>  = Input filename \n");
    printf("         <outfile> = Output filename \n");
    printf("         <nxfer>   = Transfer length in bytes (ex 64K, 1M)\n");
    printf("         <total>   = Exit after <total> bytes transfered or (0=contunuous with Ctrl-C to exit)\n");
    printf(" case sensitive\n");
    exit(0);
  }

  fni = argv[1];
  fno = argv[2];
  nxfer = atolx(argv[3]); 
  count = atolx(argv[4]); 
  flags = FIO_BLUE|FIO_RTFILE|FIO_ICERAM|FIO_VERBOSE;

  fi = fioOpen(fni,FIO_INPUT|flags); if (fi==NULL) { printf("Err opening input RAM file=%s\n",fni); goto BAIL; }
  fo = fioOpen(fno,FIO_INOUT|flags); if (fo==NULL) { printf("Err opening output RAM file=%s\n",fno); goto BAIL; }
  bx = malloc(nxfer);                if (bx==NULL) { printf("Err allocating XFER buffer of len=%d bytes\n",nxfer); goto BAIL; }

  status=0; ctrlc=0; 
  signal (SIGINT,cleanup);	// set Crtl-C handler

  for (;!ctrlc;) {		// loop until Crtl-C exit

    nr = fioRead(fi,bx,nxfer);
    if (nr<0) break;
    if (nr==0) { usleep(10000); continue; }

    /* modify buffer here to send to the output */

    nw = fioWrite(fo,bx,nr);
    if (nw!=nr) { printf("Err writing data bytes=%d stat=%d\n",nr,nw); break; }
    if (count!=0) { count -= nw; if (count<=0) break; }

  }

  BAIL:
  if (bx!=NULL) free(bx);
  if (fi!=NULL) fioClose(fi);
  if (fo!=NULL) fioClose(fo);

  exit (status);
}
