/*
   Example non-Midas IceCore loopback test routine for an ICE-PIC card

   Author: Jeff Schoen

   Notes:  we are using MBITS=-16 to transfer 32b of data each clock no matter what the underlying format

*/
#define DEVN "ICEPIC,DEVNO=%d,IOM1=NONE,IOM2=NONE,PM1=K8M,PM2=K8M,MUXCLK=P,PMFPGA=%s,VERBOSE=1,MBITS=-16,"
#define DEVO "%s,PORT=PM0CORE%d,OPORT=PM%dCORE%d,"
#define DEVI "%s,IPORT=PM0CORE%d,PORT=PM%dCORE%d,%s,"

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include "icedefs.h"
#include "icelib.h"

int main (int argc, char *argv[])
{
  char devn[128],devio[256],*func,*pmsig,*cconf;
  int_4 flags = 0;
  int_4 Mcbreak = 0;
  int_4 nmap = 0x40000, nxfer = 0x1000;
  int_4 status,fstat,devno,cport,cpmi,side;

  PICSTRUCT p,po,pi;
  FILE *fpo,*fpi;
  DMAMAP mapo,mapi;
  int_4 dmaco,dmaci;
  int_4 fstato,fstati;
  char *fno,*fni;
  void *bufo,*bufi;

  if (argc < 8) {
    printf("Syntax:  icecore <func> <devno> <pmsig> <cport> <cconfig> <infile> <outfile> \n");
    printf("         <func>    = RUN \n");
    printf("         <devno>   = device index 0|1|2 ... \n");
    printf("         <pmsig>   = signature of PM load, ex. u1 \n");
    printf("         <cport>   = Core port index 11|12|13|14, 21..24  \n");
    printf("         <cconfig> = Core config string, ex ""(NAME=Noop,L:DEC=1)|VERBOSE"" \n");
    printf("         <ifile>   = Input filename \n");
    printf("         <ofile>   = Output filename \n");
    printf(" case sensitive\n");
    exit(0);
  }

  func   = argv[1];
  devno  = atoi(argv[2]); 
  pmsig  = argv[3];
  cport  = atoi(argv[4]); 
  cconf  = argv[5];
  fni    = argv[6];
  fno    = argv[7];

  cpmi  = (cport<10)? 1 : cport/10; 
  cport = cport%10;
  side  = (cport&1)?1:2;

  /* open the input/output files */
  fpi = fopen(fni, "r" ); if (fpi==NULL) { printf("Err opening ifile=%s\n",fni); goto BAILF; }
  fpo = fopen(fno, "w" ); if (fpo==NULL) { printf("Err opening ofile=%s\n",fno); goto BAILF; }

  sprintf(devn,DEVN,devno,pmsig);
  status = pic_open (&p, devn, &Mcbreak, flags);
  if (status<0) { printf("Err opening PIC config=%s\n",devn); goto BAILP; }
  status = pic_reset (&p, 0); 
  status = pic_close (&p);

  sprintf(devio,DEVO,devn,side,cpmi,cport);
  status = pic_open (&po, devio, &Mcbreak, flags);

  sprintf(devio,DEVI,devn,side,cpmi,cport,cconf);
  status = pic_open (&pi, devio, &Mcbreak, flags);

  /* map the buffers to physical memory */
  status = pic_mapmem (&po, &mapo, nmap, 1); if (status<0) { printf("Err mapping obuf\n"); goto BAILM; } bufo = (void *)mapo.vaddr;
  status = pic_mapmem (&pi, &mapi, nmap, 1); if (status<0) { printf("Err mapping ibuf\n"); goto BAILM; } bufi = (void *)mapi.vaddr;

  /* open the IO ports     defaults   dir bits rate freq dec gain flags */
  dmaco = pic_ioport (&po, -1, -1, -1,  1, -16, 10e6, 0.0, 1, 0, 0);
  dmaci = pic_ioport (&pi, -1, -1, -1, -1, -16, 10e6, 0.0, 1, 0, 0);

  /* setup the DMA handler */
  status = pic_dmasetup (&po, dmaco,  1, &mapo, -1, 0);
  status = pic_dmasetup (&pi, dmaci, -1, &mapi, -1, 0);

  /* start DMAs */
  status = pic_dmafunc (&po, dmaco, DMA_ONDEMAND); 
  status = pic_dmafunc (&pi, dmaci, DMA_CONTINUOUS); 

  /* multiple shot overlapped transfer loop */
  for (;;) {
    status = pic_dmaxptr (&po, dmaco, &bufo, nxfer, FLG_NOWAIT);
    if (status>0) {
      fstat  = fread(bufo,1,status,fpi);
      if (fstat!=status) break; /* input file complete */
    }

    status = pic_dmaxptr (&pi, dmaci, &bufi, nxfer, FLG_NOWAIT);
    if (status>0) {
      fstat = fwrite(bufi,1,status,fpo);
      if (fstat!=status) printf("Err: Write status=%d of %d bytes\n",fstat,status);
    }
  } 

  /* remove channel from queue */
  status = pic_dmafunc (&po, dmaco, DMA_CANCEL); 
  status = pic_dmafunc (&pi, dmaci, DMA_CANCEL); 

  BAIL:
  /* unmap the buffer from physical memory */
  status = pic_mapmem (&po, &mapo, nmap, -1);
  status = pic_mapmem (&pi, &mapi, nmap, -1);

  BAILM:
  /* close the PIC card */
  pic_close (&pi);
  pic_close (&po);

  BAILP:
  /* close the input/output file */
  fclose(fpo);
  fclose(fpi);

  BAILF:
  exit (status);
}
