function [status] = ice (func, port, fname, ...
	rate, size, bits, clks, dec, freq, gain)

prog = '$ICEROOT/test/ice'
if exist('func','var') == 0
  func = 'ACQUIRE';
end
func = upper(func);
if exist('port','var') == 0
  port = 'MODULE1';
end
port = upper(port);
devty = 'PIC'
devno = '0'
if exist('fname','var') == 0
  fname = 'mydata.dat';
end
if exist('clks','var') == 0
  clks = 'I';
end
if exist('rate','var') == 0
  rate = 10000000;
end
if exist('size','var') == 0
  size = 4*1024*1024;
end
if exist('bits','var') == 0
  bits = 16;
end
if exist('dec','var') == 0
  dec = 64;
end
if exist('freq','var') == 0
  freq = rate/4;
end
if exist('gain','var') == 0
  gain = 0;
end

[cmdstr,errstr] = sprintf('%s %s %s %s %s %s %d %s %d %d %d %f %d', ...
	prog,func,devty,devno,port,fname,bits,clks,rate,size,dec,freq,gain);
status = unix( cmdstr );

file = fopen(fname,'r');
[data,count] = fread(file,2048,'int16');
fclose(file);

plot(data);

return
