!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
! Event handler for HORUS tester
!   msg=message sam=snapAppMacro
!
! This macro is an event handler called by the horus.tbl snapapp table.
!
! Notes:
!
! Once the Event Mode=SNAP or Mode=PB, it will poll until the Event
!   Duration is reached to reset the graphical widget. 
! An Event can be retriggered at any time by a message or button click.
! An Event trigger during a snapshot will produce overlapped snapshots each 
!   with the Duration setting when it is started.  Please limit this behavior
!   to less than 3 overlapped snapshots.
!
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

startmacro o:msg o:sam

!say "What ^msg.name"
set gc sam.controls

if msg.name eqs "GTIME" then		! comes once per second
  timex msg.data soy=l:time

elseif msg.name eqs "GCHAN" then	! comes per GCHAN button
  set l:nn ^gc.GCHAN.v
  set t:tt {CORE=^nn,L:FBD=,D:FS=,D:FREQ=}
  set spr sam.reg.snap1.reg.sp
  res ans spr.table(tt)
  set l:dec ans.fbd/2
  warn "Set chan to ^nn freq=^ans.freq dec=^ans.fbd"
  set spnc sam.reg.snap4.controls
  set spnc.MODE.action "SETUP"
  pause 1
  set spnc.FREQ.action ^ans.freq/1e6
  set spnc.DEC.action  "^dec"
  set spnc.MODE.action "RTMEM"

elseif msg.name eqs "GTEST" then	! comes per GTEST button
  timex now time
  set d:time time+1
  set l:nn ^gc.GCHAN.v
  set spr sam.reg.snap1.reg.sp
  set spi sam.reg.snap2.reg.sp
  set spw sam.reg.snap3.reg.sp
  set spn sam.reg.snap4.reg.sp
  if nn gt 1 then set spi sam.reg.snap2.reg.sp^nn
  set t:tt {CORE=^nn,L:FBD=,D:FS=,D:FREQ=}

 if msg.data eqs "SNAP" then
  erase test_fb test_nb test_wb
  invoke spi.startArchiver(test_fb,0.2)
  invoke spw.startArchiver(test_wb,0.2)
  invoke spn.startArchiver(test_nb,0.2)
  pause 1
  while file(test_wb).key(ARCHOFF) nrexists or file(test_fb).key(ARCHOFF) nrexists
    pause 0.1
  endwhile
!  status test_wb
!  status test_nb
!  status test_fb

 elseif msg.data eqs "TFDOA" then
  res ans spr.table(tt)
  icetfdoa/nopipe/tolr=1000 test_wb test_fb ,,,, ans.freq 1

 elseif msg.data eqs "WB-CORREL" then
  res ans spr.table(tt)
  tuner test_wb test_wbt ans.freq ans.fs/ans.fbd ,, 0 ans.fbd CF
  thin test_fb test_fbt 100k +10k
  fastcorr test_wbt test_fbt test_corr
  calc xs file(test_wbt).tc+file(test_wbt).xs file(test_fbt).tc+file(test_fbt).xs -
  header test_corr xs=xs
  plot/all test_corr cm=mag y2=300e9

 elseif msg.data eqs "NB-CORREL" then
  res ans spr.table(tt)
  thin test_fb test_fbt 100k +10k
  fastcorr test_nb test_fbt test_corr
  calc xs file(test_nb).tc+file(test_nb).xs file(test_fbt).tc+file(test_fbt).xs -
  header test_corr xs=xs
  plot/all test_corr cm=mag y2=300e9

 endif
  set gc.GTEST.v Done

endif

endmacro

