package nxm.ice.prim;

import nxm.sys.inc.*;
import nxm.sys.lib.*;
import nxm.ice.lib.ICEPacket;
import nxm.ice.lib.Archiver;
import nxm.ice.prim.sourcepic;

/**
  Fan in multichannel packetized data from seperate pipes.

  @author Jeff Schoen
  @version $Id: picfanin.java,v 1.3 2001/04/25 17:08:12 schoenj Exp $
*/
public class picfanin extends Primitive {

  private DataFile hi,his[],ho;
  private int nchan, ichan, lchan, xferp;
  private int select, cper, skip, iskp[];
  private ICEPacket pkt;
  private Data db;
  private boolean renumo,renumi,swap,strip,hasip;
  private Archiver ha;

  public int open() {

    nchan = MA.getL("NCHAN");
    skip  = MA.getL("/SKIP",0);
    swap  = MA.getState("/SWAP");
    strip = MA.getState("/STRIP");
    renumo = MA.getState("/RENUM");
    renumi = MA.getState("/RENUMI");
    select= MA.getL("/SELECT",-1);

    String root = MA.getCS("IN");
    his = new DataFile[nchan];
    iskp = new int[nchan];
    for (int nc=0; nc<nchan; nc++) {
      hi = new DataFile();
      hi.init(this,root+(nc+1),"1000,2000","S#,C#",0);
      hi.open();
      his[nc]=hi;
      iskp[nc]=0;
    }
    hi = his[0];
    pkt = (ICEPacket)hi.getPacketHandler();
    hasip = (pkt!=null);

    ho = MA.getDataFile("OUT",hi,0);
    if (!hasip) {
      xfer = MA.getL("/TL",(int)(4096/hi.dbpe));
      pkt = new ICEPacket(hi.getFormat(),xfer,ICEPacket.FIXED);
      ho.setPacketHandler(pkt);
    }
    if (strip) ho.setPacketHandler(null);
    ho.open(ho.OUTPUT);
    if (!strip) pkt = (ICEPacket)ho.getPacketHandler();
    if (pkt==null) M.error("Could not packetize output file");

    startArchiver();

    xfer = MA.getL("/TL",pkt.getFixedSize());
    if (ho.getTypeCodeClass()==2) xfer=1;
    db = ho.getDataBuffer(xfer);
    ichan = nchan-1;

    return (NORMAL);
  }

  public int process() {

    // find a channel with data
    int lchan = ichan;
    for (;;) {
      ichan = (++ichan)%nchan;
      hi = his[ichan];
      if (hi.avail()>=xfer) break;	// has data
      if (ichan==lchan) return (NOOP);	// no data anywhere
    }

    // get the next data buffer
    int n = hi.read(db);
    if (n==0) return (NOOP);
    if (n<0) return (FINISH);

    // transfer packet header
    if (hasip) pkt.copyFrom( (ICEPacket)hi.getPacketHandler() );
    int cn = ichan+1;
    if (renumi) cn += (pkt.getChannel()-1)*nchan;
    if (renumo) pkt.setChannel(cn);

    // bail if not selected
    if (select>=0 && select!=cn) return (NORMAL);

    // write to archive file
    if (ha!=null) {
      ha.setPktHeader( (ICEPacket)hi.getPacketHandler() );
      ha.write(0,db.buf,0,n*ha.bpa,ichan);
    }

    if (skip>0) {
      if (--iskp[ichan]<=0) iskp[ichan]=skip;
      else return (NORMAL);
    }

    // swap bytes to undo SDDS hardware swapped data buffers
    if (swap) Convert.swap2(db.buf,0,db.buf.length>>1);

    // copy data to output
    ho.write(db);

    return (NORMAL);
  }

  public int close() {
    for (int nc=0; nc<nchan; nc++) his[nc].close();
    ho.close();
    if (ha!=null) ha.close();
    return (NORMAL);
  }

  public int getChannels() { return nchan; }
  public int getSelect () { return select; }
  public void setSelect (int chan) { select = chan; }

  private void startArchiver() {
    String fname = MA.getS("/ARCH");
    if (StringUtil.isNullOrEmpty(fname)) return;
    sourcepic sp = (sourcepic)MA.getO("/SP");
    ICEPacket apkt = new ICEPacket(ho.getFormat(),pkt.getSize(),0);
    ha = new Archiver(sp);
    ha.init (sp,fname,ho,0);
    ha.setPacketHandler(apkt);
    ha.setNChan(nchan);
    ha.setFS(0);
    ha.open(ha.NATIVE|ha.OPTIONAL);
    if (!ha.isOpen) ha=null;
  }

}
