package nxm.ice.prim;

import java.awt.Container;
import java.awt.Desktop;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.net.URI;
import java.net.URL;

import javax.swing.JEditorPane;
import javax.swing.JScrollPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.Document;
import javax.swing.text.html.HTMLFrameHyperlinkEvent;

import nxm.sys.lib.BaseFile;
import nxm.sys.lib.FileName;
import nxm.sys.lib.Foreign;
import nxm.sys.lib.GPrimitive;
import nxm.sys.lib.Message;
import nxm.sys.lib.Shell;
import nxm.sys.lib.TextFile;
import nxm.sys.libg.GAlert;
import nxm.sys.libg.GFiles;
import nxm.sys.libg.GMenu;
import nxm.sys.libg.MWindow;

/** Displays text/html content in a Midas window.

    @author Jeff Schoen
*/
public class browse extends GPrimitive implements MouseListener, MouseMotionListener, HyperlinkListener {

  private int level=0,status=0;
  private boolean exiting;
  private JScrollPane jsp;
  private JEditorPane jep;
  private URL[] urls = new URL[10];
  private int[] scrolls = new int[10];
  /** constant for middle mouse button (MMB) clicked.*/
  private static final int MIDDLE_MOUSE_BUTTON = 2;
  /** constant for right mouse button (RMB) clicked.*/
  private static final int RIGHT_MOUSE_BUTTON = 3;

  private static Desktop desktop;
  static {
    try { desktop = Desktop.getDesktop(); }
    catch (Exception e) { Shell.warning("Unable to get java.awt.Desktop instance for using browse(URI) method: "+e); }
  }

  /** default constructor */
  public browse () {}

  public int open() {
    String sfn = MA.getCS("URL");
    URL url = formURL(sfn);
    urls[level] = url;

    MW = new MWindow("Text/HTML Browser",this);
    MW.open();
    MW.addTo(this);
    jep = new JEditorPane();
    jep.setContentType("text/html");
    jep.setEditable(false);
    jep.addHyperlinkListener(this);
    jep.addMouseMotionListener(this);
    jep.addMouseListener(this);
    showDoc(url);
    jsp = new JScrollPane();
    jsp.setViewportView(jep);
    Container panel = MW.getPanel();
    panel.setLayout(new java.awt.BorderLayout());
    panel.add(jsp);
    panel.revalidate();	// to get jsp to repaint
    return NORMAL;
  }

  private void revalidate() {
    Container panel = MW.getPanel();
    if (panel==null || !panel.isShowing()) return;
    Container parent = panel.getParent();
    if (parent==null || !parent.isShowing()) return;
    parent.revalidate();
    panel.revalidate();
  }

  private URL formURL (String sfn) {
    if (!sfn.startsWith("\"")) sfn = "\""+sfn+"\"";
    FileName fn = BaseFile.getFileNameFor(this,sfn);
    sfn = fn.getFullName();
    sfn = sfn.replaceAll("\\\\","/");
    URL url = null;
    if (sfn.indexOf(":")!=4) sfn="file:"+sfn;
    try { url = (new URI(sfn)).toURL(); }
    catch (Exception e) { System.out.println("Bad URL: "+e); }
    return url;
  }

  private void showDoc (URL url) {
    try {
      Document doc = jep.getDocument(); // next line to force reload
      if (doc!=null) doc.putProperty(Document.StreamDescriptionProperty,null);
      jep.setPage(url);
    }
    catch (Exception e) { System.out.println("Bad Document: "+e); }
  }

  public int process () {
    if (exiting) return FINISH;
    return NOOP;
  }

  public int close() {
    MW.close();
    return NORMAL;
  }

  // MW listener
  public int processMessage (Message msg) {
//  System.out.println("Got msg: "+msg+" "+msg.data);
    switch (msg.name) {
      case "PAINT":     break;
      case "REFRESH":   MW.refresh(); break;
      case "RESIZE":    MW.resize(1); revalidate(); break;
      case "WINDOW":    if (msg.info==0) exiting=true; break;
      case "SAVEFILE":  saveCurrent(); break;
      case "SAVEFILEAS": saveCurrent(msg.data.toString()); break;
      case "BUTTON":    if (msg.info==2) new GMenu (MW,"Browse","Back,Forward,---,Edit,Sync,Save,SaveAs,OpenBrowser,OpenEditor,---,Exit",0,0,this); break;
      case "OPENFILE":
        URL url = formURL(msg.data.toString());
        if (msg.info<0) level++; else level=msg.info;
        urls[level]=url;
        showDoc(url);
        break;
      case "BROWSE":
        switch (msg.data.toString()) {
          case "BACK":
            if (level<=0);
            else if (jep.isEditable()) verifyCurrent();
            else showDoc(urls[--level]);
            break;
          case "FORWARD":
            if (urls[level+1]==null);
            else if (jep.isEditable()) verifyCurrent();
            else showDoc(urls[++level]);
            break;
          case "OPENBROWSER":   openBrowser(urls[level]); break;
          case "OPENEDITOR":    openEditor(urls[level]); break;
          case "SYNC":          if (jep.isEditable()) saveCurrent(); break;
          case "EDIT":          jep.setEditable(true); break;
          case "SAVE":          saveCurrent(); break;
          case "SAVEAS":        jep.setEditable(false); new GFiles(MW,"SaveFileAs",urls[level].toString(),"*.txt|java|jv|c|sv|v",null,M,0,0,0,this); break;
          case "EXIT":          exiting=true; break;
          default: M.warning("Browse menu item="+msg.data+" not coded yet");
        }
    }
    return NORMAL;
  }

  private void verifyCurrent () {
    new GAlert (MW,"SaveFile","Save current modifications? ","Yes,No",1,0,this);
  }

  private void saveCurrent () {
    String fn = urls[level].toString();
    saveCurrent(fn);
  }

  private void saveCurrent (String fn) {
    jep.setEditable(false);
    String s = jep.getText();
    TextFile tf = new TextFile(fn);
    M.info("Saving file as: "+fn);
    tf.open(TextFile.OUTPUT);
    tf.write(s);
    tf.close();
  }

  /** Open the browser
   *
   *  @param url URL
   *  @return true if successful
   */
  public boolean openBrowser (URL url) {
    boolean result = false;
    if (desktop!=null && url!=null) { // if we have java.awt.Desktop instance AND URL is not null
      try {
        desktop.browse(new URI(url.toString())); // Java6 API
        // if we got here without an Exceptions, then URL was probably opened in browser
        result = true;
      }
      catch (Exception e) { Shell.printStackTrace(e); }
    }
    return result;
  }

  /** Open the editor
   *
   * @param url URL
   * @return true if successful
   */
  public boolean openEditor (URL url) {
    String editor = MR.getString("ENV.EDITOR");
    String sfn = url.toString();
    if (sfn.startsWith("file:")) sfn = sfn.substring(5);
    Foreign.runInternal (M,editor+" "+sfn);
    return true;
  }

  // jep mouse listeners
  public void mouseEntered (MouseEvent e) { }
  public void mouseExited (MouseEvent e) { }
  public void mousePressed (MouseEvent e) { }
  public void mouseReleased (MouseEvent e) { }
  public void mouseClicked (MouseEvent e) {
    int button = event2button(e);
    if ((button==RIGHT_MOUSE_BUTTON) && level>0) {
      showDoc(urls[--level]);
    }
    if ((button==MIDDLE_MOUSE_BUTTON)) {
      new GMenu (MW,"Browse","Back,Forward,---,Edit,Sync,Save,SaveAs,OpenBrowser,OpenEditor,---,Exit",0,0,this);
    }
  }
  public void mouseMoved (MouseEvent e) {
    MW.px = e.getX();
    MW.py = e.getY();
  }
  public void mouseDragged (MouseEvent e) { }

  /** Convert event to button number
   *
   *  @param me MouseEvent
   *  @return button number
   */
   private static int event2button (MouseEvent me) {
     int button = me.getButton();
     int modifiers = me.getModifiersEx();
     if (button == 0) { // lets try and get it from the extended modifiers, this will handle buttons that are being pressed and not released
       if ((modifiers & MouseEvent.BUTTON1_DOWN_MASK) != 0) button = MouseEvent.BUTTON1;
       else if ((modifiers & MouseEvent.BUTTON2_DOWN_MASK) != 0) button = MouseEvent.BUTTON2;
       else if ((modifiers & MouseEvent.BUTTON3_DOWN_MASK) != 0) button = MouseEvent.BUTTON3;
       else button = MouseEvent.BUTTON1;
     }
     else if(button>MouseEvent.BUTTON3) button = MouseEvent.BUTTON1;
     return button;
   }

  // jep hyperlink listeners
  public void hyperlinkUpdate (HyperlinkEvent evt) {
    if (evt.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
      if (evt instanceof HTMLFrameHyperlinkEvent) {
        M.warning("Frame hyperlink event");
      } else if (level>=urls.length-1) {
        M.warning("Too many hyperlinkevt.getURL() levels");
      } else {
        URL url = evt.getURL();
        String surl = url.toString();
        int iq = surl.indexOf('?');
        if (iq<0) urls[++level]=url;
        else if (surl.charAt(iq-1)=='/') {
          surl = urls[level].toString()+surl.substring(iq);
          try { url = (new URI(surl)).toURL(); } catch (Exception e) { System.out.println("Browse: "+e); }
          }
        showDoc(url);
      }
    }
  }

}
