!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!  TIVO Client macro
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
startmacro/msgid=main/mlog/client=7007 t:config

debug on trace

timex now sec=timecode

pipe on

  panel/setup/controls=gc/logger

  rmif/prange=5 /client 

  view/id=toc

  plot/id=tvp1 type=rast axis=frame options=+BS readout=+T
  plot/id=tvp2 type=rast axis=frame options=+BS readout=+T
  plot/id=tvp3 type=rast axis=frame options=+BS readout=+T
  plot/id=tvp4 type=rast axis=frame options=+BS readout=+T

  gcontrol label  "FUNC"   "TiVo"
  gcontrol button "MODE"   "" "Add,Del,Exit" /nc=3
  gcontrol label  "DOWN"   "DownLoad"
  gcontrol button "DACT"   "" "Single,All" /nc=2
  gcontrol choice "BAND"   "BandWidth" "Full,Narrow" "Full"
  gcontrol choice "PROT"   "Protocol " "Http,Mftp" "Http"
  gcontrol prompt "AFNAME" "File" snapset.afname
  gcontrol tval   "ATCT"   "Top" 0 1 -1 1  /edit=f
  gcontrol tval   "ATCL"   "Len" 0 1 -1 1  /edit=f

  gcontrol label  "ANAL"   "Analysis" 0
  gcontrol button "APLOT"  "" "TD-Line,TD-Raster,Histogram,FD-Line,FD-Raster,Stats" /nc=2
  gcontrol button "DMOD"   "Demod" "None,AM,FM,PSK,QPSK" "NONE"
  gcontrol button "AUDIO"  "Audio" "None,JMF,RTP" "NONE"
  gcontrol choice "AFFT"   "Fft Size" affts "4K" /input

  gcontrol label  "TIVO"  "TiVo FD Raster" 
  gcontrol button "TIVOM" "" "<<,<,RT,>,>>" "RT" /onerow 
  gcontrol tval   "TIVOS" "Bottom" 0 1 -1 1 
  gcontrol choice "TIVOL" "Window" "All,1:00,5:00,10:00,1:00:00,2:00:00" "1:00" /input

pipe off

endmacro

procedure open
set this.timers 2
set this.timer(0) 1
set this.timer(1) 10
return

procedure processMessage

!say "Got message ^msg.name = ^msg.data from ^msg.fid"

if msg.fid eqs "RMIF" then		! handle server/client messaging
  if msg.name eqs "OPEN"
    info "Got open ^msg.data from ^msg.fid"
  elseif msg.name eqs "OPENED"
    info "Got opened ^msg.data from ^msg.fid"
    pause 0.5  ! make sure plots are up
    set gc.COMP.action "PLOT"
  elseif msg.name eqs "CLOSE"
    info "Got close ^msg.data from ^msg.fid"
  elseif msg.name eqs "CLOSED"
    info "Got closed ^msg.data from ^msg.fid"
  endif

elseif msg.name eqs "GET" then		! server side
  set t:sets msg.data
  foreach key intable sets
    if key eqs "HEAD" then
      set sets.HEAD.TIME (gc.TIME.v-sets.HEAD.length)
    elseif key eqs "DATA" then
      set sets.DATA.TIME (gc.TIME.v-sets.DATA.length)
      noop/bg ^{afn}(~^{sets.DATA.TIME}:+~^{sets.DATA.LENGTH}) udp://9091/^sets.DATA.UDP
    else
      set sets.^key gc.^{key}.value
    endif
  endfor
  message send "REPLY" msg "RET" ,, sets

elseif msg.name eqs "RET" then		! client side
  set t:sets msg.data
  foreach key intable sets
    if key eqss "TIVO" then 
      ! TIVO messages handled locally
    else
      set gc.^{key}.value "^sets.^key"
      if key eqs "FREQ" call updateFreqMarker
    endif
  endfor

elseif msg.name eqs "SET" then		! server side
  set t:sets msg.data
  foreach key intable sets
    if key eqss "TIVO" then 
      ! TIVO messages handled locally
    elseif key eqs "JOIN" then
      set reg.SP.join msg.data
    elseif key eqs "LEAVE" then
      set reg.SP.leave msg.data
    else
      set gc.^{key}.action "^sets.^key"
    endif
  endfor
  message send "REPLY" msg "ACK" ,, sets

elseif msg.name eqs "ACK" then		! client side
  set t:sets msg.data
  foreach key intable sets
    if key eqs "SYSTEM" then
      call picsystem sets.SYSTEM
    elseif key eqs "REPLAY" then
      set gc.^{key}.value "^sets.^key"
    elseif key eqs "SCALE" then
      set d:scale ^msg.data
    elseif key eqss "TIVO" then
      ! TIVO messages handled locally
    else
      set gc.^{key}.value "^sets.^key"
      if key eqs "FREQ" call updateFreqMarker
    endif
  endfor

elseif msg.name eqs "EXIT"
  pipe stop

elseif msg.name eqs "TIMER" and msg.info eq 0 then  ! 1 sec
  if /client gt 0 then
  elseif reg.sdds rexists then
    set gc.TIME.value reg.sdds.tc.wsec
  elseif reg.sp rexists then
    set gc.TIME.value reg.sp.time.sec
  endif
  if tvfn rexists and gc.TIVOM.v eqs "RT" and gc.TIME.v-gc.TIVOS.v gt 60 then
    call refreshTivoPlot
  endif
  if /server gt 0 then message send rmif ,, "ACK" ,, {TIME=^gc.TIME.v}

elseif msg.name eqs "TIMER" and msg.info eq 1 then  ! 10 sec
  report flush
  if /tivo gt 0 and /headless isfalse and tvfn nrexists then
    call refreshTivoPlot
    call updateFreqMarker
  endif
  if afn neqs "NULL" and afn fexists and /client isFalse then
    status afn timeAt(0)=gc.ATCT.v len=gc.ATCL.v
    if /server gt 0 then message send rmif ,, "ACK" ,, {ATCT=^gc.ATCT.v,ATCL=^gc.ATCL.v}
  endif

elseif msg.name eqs "TIVOM" then
  if msg.data eqs "RT" then
    calc tv ^gc.TIME.v
    set gc.TIVOM.v "RT"
  elseif gc.TIVOL.v eqs "ALL" then
    calc tv ^gc.TIME.v
  elseif msg.data eqs ">" then
    calc tv gc.TIVOS.v ^gc.TIVOL.v 4 / +
  elseif msg.data eqs "<" then
    calc tv gc.TIVOS.v ^gc.TIVOL.v 4 / -
  elseif msg.data eqs ">>" then
    calc tv gc.TIVOS.v ^gc.TIVOL.v +
  elseif msg.data eqs "<<" then
    calc tv gc.TIVOS.v ^gc.TIVOL.v -
  endif
  set gc.TIVOS.action ^tv

elseif msg.name eqs "TIVOS" then
  call refreshTivoPlot

elseif msg.name eqs "TIVOL" then
  call refreshTivoPlot

elseif msg.name eqs "DOWNLOAD" then
  if aux.write eqs "RAM" then
    gc/temp/msg=n alert "TEMP" "Download" "DownLoad not available from Applet - try WebStart"
    return
  endif
  set dlfn msg.data.FNAME.v
  set ulfn "^{gc.AFNAME.v}.tmp(~^msg.data.START.v:+~msg.data.LENGTH.v)"
  noop/bg/gpw/tl=1m http://^remote/Files/^ulfn dlfn
  set gc.ANAL.action "OPEN"

elseif msg.name eqs "APLOT"
  if dlfn nrexists then
    gc/temp alert "ANALYZE" "Analyze" "DownLoad must precede Analysis Options"
    return
  endif
  call analyze msg.data dlfn

elseif msg.name eqs "MODE" and /client gt 0 then
  if msg.data eqs "EXIT" then
    pipe stop
  else
    if dlfn nrexists set dlfn "myfile"
    if /tivo gt 0 then
      calc d:tcs reg.TVRP.t1 10 * round 10 /
      calc d:tcl reg.TVRP.y2-reg.TVRP.y1 10 * round 10 /
      calc d:fw reg.TVRP.x2-reg.TVRP.x1 round
      calc d:fc reg.TVRP.x1+(fw/2) round
    else
      set d:tcs gc.ATCT.value
      set d:tcl 10.0
      set d:fc 0
      set d:fw 1e6*gc.RATE.v/2
    endif
    gc/temp dialog "DOWNLOAD" "DownLoad ARCH=^gc.AFNAME.v" 300 -5 dlog
    gc/panel=dlog tval   "START"   "TimeStart" tcs 1 -1 1
    gc/panel=dlog choice "LENGTH"  "Duration " "1,2,5,10,30,1:00,2:00,5:00,10:00" "^tcl" /units="sec" /input
    gc/panel=dlog dval   "FCENTER" "FreqCenter" fc 1 -1 1000 /units="Hz"
    gc/panel=dlog dval   "FWIDTH"  "FreqWidth " fw 1 -1 1000 /units="Hz"
    gc/panel=dlog prompt "FNAME"   "ToFile" dlfn
  endif

elseif msg.name eqs "ANALYZE"
  say "Got an abort message"
endif
return


procedure refreshTivoPlot
if tvfn nrexists then
  set tvfn "^{gc.AFNAME.v}_psd.tmp"
  if /client gt 0 set tvfn "http://^remote/Files/^tvfn"
  message send "TVRP" ,, "OPENFILE" -1 tvfn
endif
message send "TVRP" ,, "UNZOOM" -1
if gc.TIVOM.v eqs "RT" then
  message send "TVRP" ,, "FILE" ,, "REREAD" 
  if gc.TIVOL.v eqs "ALL" then
    message send "TVRP" ,, "PANTW" 0 (0,0)
  else
    set d:tvl ^gc.TIVOL.v
    set gc.TIVOS.v gc.TIME.v
    set d:tvs gc.TIVOS.v 
    message send "TVRP" ,, "PANTW" 0 (tvs,-tvl)
  endif
else
  set d:tvl ^gc.TIVOL.v 
  set d:tvs gc.TIVOS.v 
  message send "TVRP" ,, "PANTW" 0 (tvs,-tvl)
endif
return

procedure analyze s:atype cs:afile
gc/temp/handle=tmpalert alert "ANALYZE" "Analyze" "Processing snapshot ^dlfn" "ABORT"
if atype eqs "HISTOGRAM"
  histogram afile ramhist -scale +scale 1
  plot/bg/all ramhist 
elseif atype eqs "TD-LINE"
  plot/bg afile
elseif atype eqs "TD-RASTER"
  plot/bg afile{fs=gc.FRAME.v}
elseif atype eqs "FD-LINE"
  fft afile ramspec ^gc.AFFT.v navg=-1
  plot/bg ramspec cm=10log
elseif atype eqs "FD-RASTER"
  fft afile ramspec ^gc.AFFT.v navg=1
  plot/bg ramspec cm=10log
endif
invoke ,, tmpalert.close
rem tmpalert
return

