startmacro/msgid=main cs:ifn[] cs:out[]

set scl 32k
set raux aux.read
switch inc inc get 4
set l:xfer 2k
set l:cons inc*xfer
calc dbwf 1.9

invoke types=nxm.ice.core.Modefs.modList

set s:balgs "AMDet,Pow2,None"
set s:balgsp "^balgs,Pow1,Mag2,CMul,CSqu,CPow2,CMag2"
set s:calgs "Pow1,Pow2,Pow4,Pow8,None"
set s:calgsp "^calgs,Pow12,Pow16,Pow20,Pow24,Pow28,DPow4"
set t:calgamps {Pow1=12,Pow2=9,Pow4=6,Pow8=3,Pow12=1,Pow16=1,Pow20=1,Pow24=1,Pow28=1}

set s:lmode "Setup"
set f:scale 1.0
set l:selidx 0
set l:selected 0
set l:osize 0

switch "NFFT" l:nfft get 2k
switch "DEFQAM" defqam get "QAM"
switch "DDC" ddc get 1 1
switch "ROW" row get -1
switch "RFFREQ" rffreq get 0
switch "SIGFILE" sigfile get "sigscan_temp"
switch "SERVER" server get 0

call handleTheme
call makeTemplate

switch "SCL" f:scale get scale
table acfg load/t nxm.iq.tbl.dmcfg_auto.tbl /flags=default

if /findPrelim nisnull then
  call findID
  if this.pc.macro rexists and type neqss "?" then 
    set t:wcd {MOD=^type,BAUD=^baud,COFF=^cent,BW=^fbw}
    message send parent.main ,, "WIDCOM" row wcd 
  endif
  stop
endif

invoke fecs=nxm.ice.core.Modefs.fecList
invoke maps=nxm.ice.core.Modefs.mapList

pipe on
panel/setup/controls=gc/logger/poll=.25
set reg.panel.borders "-Top|Right"

gc label  "ACT" "Function"
gc button "MODE" "Mode" "Setup,Scan,ID,Run,<<,Exit,Find,RunID,Commit,>>" lmode /nc=2 /toff
gc file   "FILE" "File" ,,, raux
gc dval   "SOIF" "SOI Freq" 0 1 -1 1 /units=MHz
gc dval   "SOIW" "SOI BW  " 0 1 -1 1 /units=MHz
gc dval   "SOIN" "SOI SNR " 0 1 -1 1 /units=dB
gc dval   "PROG" "Progress" 0 0 1 0.01 /gauge /mon=reg.noop.progress
gc label  "SCN"  "Scan Config"
gc choice "FBIN" "ResBW     " "100,500,1000,2500,5000,10e3,25e3,50e3,100e3,250e3,500e3,1e6,2e6,~4K,~16K,~64K" "~4K" /input /units=Hz
gc choice "SCAN" "ScanMode  " "Auto,Selection,Time&Freq,Center70p,Center80p,Center90p,All" "Auto"
gc fval   "THRE" "Threshold " 6 1 72 1 /units=dB
gc lval   "NTOP" "MaxSignals" 128 0 512 16
gc label  "MODL" "Demod Config"
gc choice "TYPE" "ModType  " "Auto,None,^types" "None" /input 
gc choice "BALG" "BaudAlg  " balgsp "CMul"
gc dval   "BAUD" "BaudRate " 1 0 1000 1  /units=MHz
gc choice "CALG" "CenterAlg" calgsp "Pow1"
gc lval   "COFF" "CenterOff" 0 0 -1e6 1e6  /units=Hz
if /uwb isfalse
!gc fvalue "COST" "MMA Cost  " 0 1 -1 /mon=reg.iq.F:MMA_COST /fmt=#0.###### /nomsg
!gc fvalue "DISP" "MMA Disp  " 0 1 -1 /mon=reg.iq.F:MMA_DISP /fmt=#0.###### /nomsg
!gc fvalue "KURT" "KurtosisMf" 0 1 -1 /mon=reg.iq.F:KMM_MFACT /fmt=#0.###### /nomsg
endif
gc fvalue "CVAR" "ClusterVar" 0 1 -1 /mon=reg.iq.F:DDC_CVAR /fmt=#0.###### /nomsg
gc fvalue "COFG" "CarrierOff" 0 1 -1 /mon=reg.iq.F:COFF /fmt=#0 /nomsg
gc fvalue "PLLBW" "CarTrakBW" 0.02 1 -1 
gc lvalue "MMAT" "MMA Taps  " 5 -1 15 1
gc choice "MAP"  "MAP Type  " maps "BRGC"
gc choice "FEC"  "FEC Type  " fecs "None"
gc prompt "UPP"  "FEC UPP   " "0x0"
gc fvalue "SCALE" "Scaling  " scale 1 -1 1
gc choice "ADAPT" "Adapt    " "On,Off,Reset,Restart,Dump" "On"

plot/id=dp _p6 cm=rvi type=point x1=-scl x2=scl y1=-scl y2=scl /tl=xfer
plot/id=tp _p0{fs=2k,cl=^inc} type=line y1=-32k y2=32k
plot/id=sp type=line /warn=no 
plot/id=br type=line 

view/id=lst sigfile nxm.ice.cfg.siglist.tbl /fill

plot/id=wbr/all axis=trframe
plot/id=wbp/all axis=brframe
set reg.wbr.mimic wbp
set reg.wbp.mimic wbr
feature ,, ff {NAME=FF,TYPE=VLINE|DATA,COLOR=#0080A0} wbp

if server gt 0 then 
  icermif/id=rmif/http server 
endif

set this.timers 1
set this.timer(0) 1
set findMode "IDLE"

pipe run
if ifn nfexists then
  warn "Input file ^ifn not found"
else
  set gc.FILE.action ifn
endif


pipe off

endmacro

procedure processMessage m:msg
!say "Message ^msg.name ^msg.data"

if msg.name eqs "TIMER" then
  if gc.MODE.v eqs "FIND" and findMode eqss "BEST" then
    calc acost 0.075 ! gc.COST.v ABS
    foreach/rev mod inlist modlist 
      res reg.iq_^{mod}.F:DDC_CVAR /res=cv
      res reg.iq_^{mod}.F:MMA_COST /res=cost
      calc cost cost ABS
      if cv lt gc.CVAR.v and cost lt acost and mod neqs gc.TYPE.v then
	set gc.TYPE.v mod
	set gc.CVAR.v cv
        set reg.IQ reg.iq_^mod
	set pipename "_p6_^mod"
	set reg.RT_FANIN.state "RESTART"
      endif
    endfor
  endif

elseif msg.name eqs "MODE"
  if msg.data eqs "COMMIT"
    calc freq gc.SOIF.v gc.COFF.v*1e-6 +
    set t:wcd {FILE=^sigfile,INDEX=^selidx,MOD=^gc.TYPE.v,BAUD=^gc.BAUD.v,FREQ=^freq,BW=^gc.SOIW.v}
    if this.pc.macro rexists then
      message send parent.main ,, "COMSCAN" row wcd
      info "Message COMSCAN sent to row=^row of ^this.pc.macro.name"
    else
      warn "No parent macro for COMSCAN=^wcd message"
    endif
    set gc.MODE.v lmode
    return
  endif
  call stopID
  if msg.data eqs "RUN" 
    if gc.TYPE.v eqss "?" or gc.TYPE.v eqs "NONE"
      warn "No Mod type selected. Must run ID first"
    elseif gc.TYPE.v eqs "QAM"
      info "Not a valid type=^gc.TYPE.v to run. Select QAM type"
    else
      call runID 
    endif
  elseif msg.data eqs "RUNID"
    call findTest 1
  elseif msg.data eqs "SCAN"
    call doScan gc.SCAN.v
    set gc.MODE.v "Setup"
    set reg.panel.borders "+Right"
  elseif msg.data eqs "ID"
    if osize gt 0 and selidx eq 0 then
      call doScanIDs
      set gc.MODE.v "Setup"
    elseif gc.SOIW.v le 0
      warn "Must select signal first"
    else
      sendto "MAIN" "FIND" "PRELIM"
    endif
  elseif msg.data eqs "<<"
    set gc.MODE.v lmode
    if selidx le 0 then set selidx osize+1
    call selectRow selidx-1 1
  elseif msg.data eqs ">>" 
    set gc.MODE.v lmode
    if selidx ge osize then set selidx -1
    call selectRow selidx+1 1
  elseif msg.data eqs "SETUP"
  elseif msg.data eqs "FIND"
    gcontrol/temp menu "FIND" "Find" "Prelim,Baud,Center,TestID,TestIDs,BestPSK,BestQAM,BestQAMX" 
  elseif msg.data eqs "EXIT"
    pipe stop
  endif
  set lmode gc.MODE.v

elseif msg.name eqs "SCAN"
  call findPrep

elseif msg.name eqs "FIND"
  if msg.data eqs "PRELIM"
    call findID
    sendto "BR" "OPENFILE" "widspec|widpeak" info=-1
    sendto "SP" "OPENFILE" "widpsd" info=-1
    sendto "TP" "OPENFILE" "widtun" info=-1
    set gc.BAUD.v baud
    set gc.BALG.v balg
    set gc.COFF.v cent
    set gc.CALG.v calg
    set gc.TYPE.v type
    set gc.MODE.v "Setup"
  elseif msg.data eqs "BAUD"
    call findBaud gc.BALG.v
    set gc.BAUD.v baud
    sendto "BR" "OPENFILE" "widspec|widpeak" info=-1
    set gc.MODE.v "Setup"
  elseif msg.data eqs "CENTER"
    call findCenter gc.CALG.v
    set gc.COFF.v cent
    sendto "BR" "OPENFILE" "widspec|widpeak" info=-1
    set gc.MODE.v "Setup"
  elseif msg.data eqs "TESTID"
    call findTest 0
  elseif msg.data eqs "TESTIDs"
    call findTest 1
  elseif msg.data eqs "BESTFSK"
    call findBest "FSK,4FSK"
  elseif msg.data eqs "BESTPSK"
    call findBest "BPSK,QPSK,OQPSK,8PSK,16APSK,32APSK,64APSK"
  elseif msg.data eqs "BESTQAM"
    call findBest "QPSK,8QAM,16QAM,32QAM,64QAM,128QAM,256QAM"
  elseif msg.data eqs "BESTQAMX"
    call findBest "QPSK,16QAM,32QAM,64QAM,128QAM,256QAM,512QAM,1024QAM"
  endif
  set findMode msg.data

elseif msg.name eqs "SOIF"
  set freq gc.SOIF.v
  set ff.x freq*1e6
elseif msg.name eqs "SOIW"
  set fbw gc.SOIW.v
  set ff.dx fbw*1e6

elseif msg.name eqs "BALG"
  sendto main "FIND" "BAUD"
elseif msg.name eqs "CALG"
  sendto main "FIND" "CENTER"

elseif msg.name eqs "FILE"
  set ifn gc.FILE.v
  call findPrep
elseif msg.name eqs "TYPE"
  if gc.MODE.v eqs "RUN" then
    call stopID
    call runID
  endif

elseif msg.name eqs "KURT" 
  say "Kurtosis = ^msg.data"
elseif msg.name eqs "CVAR" 
  say "ClustVar = ^msg.data"
elseif msg.name eqs "SCALE" 
  set f:scale msg.data
elseif msg.name eqs "FBIN" 
  call findPrep
elseif msg.name eqs "ADAPT" 
  set reg.iq.L:MMA_EQ msg.data

elseif msg.fid eqs "WBR" then
  if msg.name eqs "MARK" then
    calc l:iy msg.data.y file(widinpsds).ys - file(widinpsds).yd / round 0 max file(widinpsds).size-1 min
    noop widinpsds(iy:+1) widinpsd
    header widinpsd fs=0
    sendto "WBP" "FILE" "REREAD" 
  elseif msg.name eqs "DRAGBOX" and msg.info eq 101 then
  endif

elseif msg.fid eqs "WBP" then
  if msg.name eqs "MARK" then
    call stopID
    call clickTune 1 msg.data.x msg.data.y
    set l:selidx -1
  elseif msg.name eqs "DRAGBOX" and msg.info eq 101 and selidx le 0 then
    call stopID
    call clickTune 2 msg.data.xmin msg.data.xmax msg.data.ymin msg.data.ymax
    set l:selidx -2
  endif

elseif msg.fid eqs "LST" then
  if msg.name eqs "SELECT" then
    call selectRow msg.data.ROW -1
  endif

elseif msg.name eqs "EXIT"
  pipe stop
endif
return

procedure findPrep
call stopID
if ifn eqs "" then return
set iform file(ifn).format
info "Reformatting input file=^ifn ..."
if gc.FBIN.v eqss "~" then
  sedit gc.FBIN.v l:scanfft "TRIM" "~"
  calc gc.FBIN.v file(ifn).rate scanfft / 100 / round 1 max 100 *
else
  calc l:scanfft file(ifn).rate ^gc.FBIN.v / power2
endif
switch "MAXLEN" l:len get 4m
calc l:len file(ifn).size len min
statistics/id=noop ifn(0:len) max=smax
if iform eqs "CB" then calc smax smax*256
calc scale 10k/smax fix 1 max
set gc.SCALE.v scale
if gc.SCAN.v eqs "TIME&FREQ" then
  set reg.panel.borders "+Top"
  calc l:len file(ifn).size
  calc l:navg len scanfft / 128 / 1 max
  fcalc/id=noop widin{form=ci} ifn(0:len) scale *
  fft/log/id=noop widin widinpsds scanfft navg=navg
  sendto "WBR" "OPENFILE" "widinpsds" info=-1
  if rffreq neq 0 headermod widinpsds xs=(rffreq*1e6)+file(widinpsds).xs
  noop widinpsds(0:+1) widinpsd
  header widinpsd fs=0
else
  set reg.panel.borders "-Top"
  fcalc/id=noop widin{form=ci} ifn(0:len) scale *
  fft/1d/log/id=noop widin widinpsd scanfft navg=-1 
  if rffreq neq 0 headermod widinpsd xs=(rffreq*1e6)+file(widinpsd).xs
endif
statistics widinpsd sdev=wavg
calc gc.THRE.v wavg 2 / round
calc fs file(ifn).rate
sendto "WBP" "OPENFILE" "widinpsd" info=-1
return

procedure runID

set fbw 1.1*gc.SOIW.v*1e6
set fwin 0.35*fbw
set freq gc.SOIF.v*1e6 
set type gc.TYPE.v
set f:scale gc.SCALE.v
calc tfreq freq rffreq*1e6 -
sedit "nxm.iq.tbl.dmcfg_^type" config "LOCASE"
table cfg load/t ^{config}.tbl /flags=default
set d:cfg.IQ.FSYM gc.BAUD.v*1e6
set s:cfg.FEC gc.FEC.v
set l:cfg.UPP ^gc.UPP.v
set s:cfg.MAP gc.MAP.v
set s:cfg.MMA.EQ gc.ADAPT.v
set d:dbwf 1.9
if /uwb then set d:dbwf 1.3
if gc.MMAT.v gt 0 set l:cfg.MMA.TAPS ^gc.MMAT.v
calc gain scale log 3.332 * 6 * -6 +
pipe init
if /bypass then
  noop/id=noop/wrap ifn _p0 
else
  noop/id=noop/wrap ifn _ifn 
  icecore/id=ddc _ifn _p0 "DDC;ICE" FS=fs FREQ=tfreq DBWF=dbwf BW=fbw GAIN=gain NTAP=63 AGC=2 AMDES=(0.7071/2) /ifmt=CI /ofmt=CI
endif
set d:sr file(_p0).rate
set d:cfg.IQ.INFS sr
fft/id=rt_fft _p0{fs=2k,cl=^inc} _p9 nfft=2k navg=8 /nexp=1 /psd /log
if /uwb then
  icecore/id=iq _p0 _p6 "IQUWB;IQ" /cfg=cfg /ifmt=ci /ofmt=ci /itl=1k /otl=4k
else
  icecore/id=iq _p0 _p6 "DMOD;IQ" /cfg=cfg /ifmt=ci /ofmt=ci /itl=1k /otl=4k
endif
sendto "TP" "OPENFILE" "_p0{fs=2k,cl=^inc}" info=-1
sendto "SP" "OPENFILE" "_p9" info=-1
if out neqs "" noop _p6 out
pipe run
return


procedure findID

set fbw gc.SOIW.v*1e6 
set fwin 0.4*fbw
set freq gc.SOIF.v*1e6 
set baudmin fbw*0.40
set baudmax fbw*0.95
set type "??" ! if cant find anything
set baud -1
set cent 0
set balg "None"
set calg "None"
set f:scale gc.SCALE.v
calc tfreq freq rffreq*1e6 -
switch "MAXOLEN" olen get 32k
table acfg load/t nxm.iq.tbl.dmcfg_auto.tbl /flags=default

! tune out short segment of signal and AGC 
calc gain scale log 3.332 * 6 * -6 +
icecore/olen=olen ifn widtun "DDC;ICE" FS=fs FREQ=tfreq DBWF=dbwf BW=fbw GAIN=gain NTAP=63 AGC=2 AMDES=(0.7071/2) /ifmt=CI /ofmt=CI
fcalc widagc widtun 1/16K * 

! enough data to process ?
status widagc rate=trate size=size
if size lt nfft then
  warn "File size=^size too short infft=^nfft to process"
  return
endif
set peaktop 0

! try regular PSD
fft/1d/log widtun widpsd nfft=nfft navg=-1
call getPeak widpsd(~-fwin:~fwin) 5 9
if npeaks eq 2 or npeaks eq 4 then
  call calcFSKbaud fbw
  if baud gt 0 then
    set type "FSK^npeaks"
    set balg "Pow1"
    set calg "Pow1"
  endif
endif

! try AMDET and POW2 for baud
if baud le 0
  fcalc <widagc mag >widmag2 
  fft/1d/log widmag2 widspec nfft=nfft navg=-1
  call getPeak widspec(~baudmin:~baudmax) 2 6
  if npeaks eq 1 then set baud peakloc/1e6 balg "AMDet"
  set peaktop peakamp	! peak for AMDet
  fcalc <widagc square >widpow2 
  fft/1d/log widpow2 widspec nfft=nfft navg=-1
  call getPeak widspec(~baudmin:~baudmax) 2 6
  if npeaks eq 1 and peakamp gt peaktop then set baud peakloc/1e6 type "OQPSK" balg "Pow2"
endif

! look for undersampled image
if baud gt 0 then
  calc fimage trate baud*1e6 - 
  if fimage lt fbw*0.8 then set baud fimage/1e6
endif

! try POW4 for center freq
if baud gt 0 and type eqss "??" then
  calc coff baud*1e6/5
  fcalc <widagc square square >widpow4 
  fft/1d/log widpow4 widspec nfft=nfft navg=-1
  call getPeak widspec(~-coff:~coff) 2 6
  if npeaks eq 1 then set cent peakloc/4 calg "Pow4"
endif

! try POW8 for center freq
if baud gt 0 and type eqss "??" and calg neqs "Pow4" then
  calc coff baud*1e6/5
  fcalc <widagc square square square >widpow8 
  fft/1d/log widpow8 widspec nfft=nfft navg=-1
  call getPeak widspec(~-coff:~coff) 2 4
  if npeaks eq 1 then set cent peakloc/8 type "8PSK" calg "Pow8"
endif

if baud gt 0 and cent ne 0 and selidx le 0 then
  calc gc.SOIF.v gc.SOIF.v cent/1e6 +
  set ff.x gc.SOIF.v*1e6
endif

! try MMA for internals
if baud gt 0 and type eqs "??" then
  set d:brate baud*1e6
  set d:spin cent/brate
  icecore widagc widssr "IQSSR;IQ" FS=trate FSYM=brate /cfg=acfg.ssr /ifmt=cf /ofmt=cf /itl=1k /otl=1k
  noop widssr(-8K:) widloop	! spin on last 4K samples
  icecore widloop widmma "IQMMAX;IQ" RECYCLE=8K SPIN=spin SNR=snr &
	/ilen=-2 /olen=64k /cfg=acfg.mma /cout=cmma /ifmt=cf /ofmt=cf /itl=1k /otl=1k
  set type cmma.mod cent cmma.spin*brate
  invoke cmma.close()
endif

if selidx gt 0 then
  calc freq freq cent + 1e3 / round 1e3 /  ! to kHz in MHz
  set file(sigfile).data(selidx-1,"FREQ",freq)
  set file(sigfile).data(selidx-1,"MOD",type)
  set file(sigfile).data(selidx-1,"BAUD",baud)
  sendto "LST" "FILES" "REREAD"
endif
return

procedure findTest l:despin
calc spin gc.COFF.v gc.BAUD.v*1e6 /
calc ctbw gc.PLLBW.v 
calc mmat gc.MMAT.v 
pipe init
icecore/id=IQ_MMA widloop _p0 "IQMMAX;IQ" RECYCLE=8K SPIN=spin S:MOD=^gc.TYPE.v L:DESPIN=^despin F:CTPLLBW=^ctbw L:TAPS=^mmat &
					/ilen=-2 /cfg=acfg.mma /ifmt=cf /ofmt=cf /itl=1k /otl=1k
fcalc/id=noop _p6 _p0 scl *
noop _p0 widmma
pipe run
return

procedure calcFSKbaud f:fbw
set fmin 0
set fmax 0
foreach ii insize npeaks
  calc fmin fmin peakloc^ii min
  calc fmax fmax peakloc^ii max
endfor
calc f:fdif fmax-fmin
if fdif lt fbw*0.5 return
calc f:cent fmin+fmax 2 /
if cent gt fbw*0.05 or cent lt -fbw*0.05 return
if npeaks eq 2 calc f:baud fdif 1e6 /
if npeaks eq 4 calc f:baud fdif 3e6 /
return


procedure findPrelimX
set fbw gc.SOIW.v*1e6
calc l:dec fs fbw*1.9 /
set freq gc.SOIF.v*1e6 
switch "MAXOLEN" l:olen get 32k

if dec le -1 then
 set l:dec 1
 info "Prelim Resampling to SOI Freq=^gc.SOIF.v BW=^gc.SOIW.v"
 newrate/id=noop_ widin widtun fs*2
elseif ddc then
 info "Prelim Tuning DDC core to SOI Freq=^gc.SOIF.v BW=^gc.SOIW.v"
 icecore/id=noop_/olen=olen widin widtun "DDC;ICE" FS=file(widin).rate FREQ=freq DBWF=dbwf BW=fbw GAIN=-6 NTAP=63 /ifmt=CI /ofmt=CI
else
 info "Prelim Tuning DDC prim to SOI Freq=^gc.SOIF.v BW=^gc.SOIW.v"
 tuner/id=noop_ widin widtun freq fbw ,, 0 dec "CI"
endif
status widtun rate=trate
statistics widtun max=amax 
fcalc widagc widtun 1.414/amax *

!info "Finding Baud Rate ..."
foreach balg inlist balgs
  if gc rexists set gc.BALG.v balg
  call findBaud balg
  if baud gt 0 break
endfor

!info "Finding Center Frequency ..."
set type "NONE" ! if cant find anything
set lfamp 0
set cent 0
set calg "None"
foreach alg inlist calgs
  if gc rexists set gc.CALG.v alg
  call findCenter ^alg 
  if famp gt 0 then
    if lfamp gt famp*.8 then break	! use last one
    set calg alg
    if alg eqs "POW1"
      if npeaks eq 4 set type "FSK4"
      if npeaks eq 2 set type "FSK2"
      if npeaks eq 1 set type "CW"
      set fmin 0
      set fmax 0
      foreach ii insize npeaks
        calc fmin fmin peakloc^ii min
        calc fmax fmax peakloc^ii max
      endfor
      calc f:cent fmin+fmax 2 /
      if npeaks eq 2 calc f:baud fmax-fmin 1e6 /
      if npeaks eq 4 calc f:baud fmax-fmin 3e6 /
      if type neqs "NONE" break
    elseif alg eqs "POW2"
      set type "BPSK"
    elseif alg eqs "POW4"
      set type "QAM"
      if balg eqs "POW2" then set type "OQPSK"
    elseif alg eqs "POW8"
      set type "8PSK"
    elseif alg eqs "POW16"
      set type "32APSK"
    elseif alg eqs "POW12"
      set type "16APSK"
    endif
    set f:cent coff
    set lfamp famp
  endif
endfor
if gc rexists set gc.CALG.v calg
if gc rexists set gc.COFF.v cent
if balg eqs "NONE" and calg eqs "NONE" then set type "CW"
if type eqs "QAM" then set type defqam 
if selidx gt 0 then
  calc freq freq cent + 1e3 / round 1e3 /  ! to kHz in MHz
  set file(sigfile).data(selidx-1,"FREQ",freq)
  set file(sigfile).data(selidx-1,"MOD",type)
  set file(sigfile).data(selidx-1,"BAUD",baud)
  sendto "LST" "FILES" "REREAD"
endif
if msg.data eqs "PRELIM"
  call findBaud balg	! for plots
endif
return

procedure doAlg s:alg
if alg eqs "AMDET" then
  fcalc widdif widagc mag
elseif alg eqs "MAG" then
  fcalc widdif widagc mag
elseif alg eqs "MAG2" then
  fcalc widdif widagc mag2
elseif alg eqs "CMUL" then
  fcalc widdif widagc widagc(1:) ~*
elseif alg eqs "CMAG2" then
  fcalc widdif widagc widagc(1:) ~* mag2
elseif alg eqs "CPOW2" then
  fcalc widdif widagc widagc(1:) ~* square
elseif alg eqs "CSQU" then
  fcalc widdif widagc widagc ~*
elseif alg eqs "POW1" then
  fcalc widdif widagc 
elseif alg eqs "POW2" then
  fcalc widdif widagc square
elseif alg eqs "POW4" then
  fcalc widdif widagc square square
elseif alg eqs "POW8" then
  fcalc widdif widagc square square square
elseif alg eqs "POW12" then
  fcalc widdif widagc square square 3 **
elseif alg eqs "POW16" then
  fcalc widdif widagc square square square square
elseif alg eqs "DPOW4" then
  fcalc widtmp widagc square square
  fcalc widdif widtmp widtmp(1:) ~*
elseif "POW" subs alg then
  sedit alg power "TRIM" "POW"
  fcalc widdif widagc ^power pow
else
  warn "Unsupported alg=^alg"
endif
return

procedure findBaud s:alg 
info "Finding Baud Rate ... Alg=^alg"
set f:baud -1
if alg eqs "NONE" return
call doAlg alg
fft/1d/log widtun widpsd nfft=nfft navg=-1
fft/1d/log widdif widspec nfft=nfft navg=-1
set baudmin fbw*0.40
set baudmax fbw*0.95
call getPeak widspec(~baudmin:~baudmax) 2 6
if npeaks eq 1 then
  calc fimage trate peakloc - 
  if fimage lt fbw*0.8 then set peakloc fimage
  set f:baud peakloc/1e6
endif
!info "Found Baud = ^baud MHz, Center Freq = ^cent Hz, Alg = ^alg, Mod Type = ^type"
return

procedure findCenter s:alg 
call doAlg alg
set algp 1
calc xdel file(widdif).xd
if alg eqs "POW1" then
  calc fwin 0.4*fbw
  set l:ntop 5
elseif "POW" subs alg then
  sedit alg l:algp "TRIM" "POW"
  calc fwin 0.15/algp 0.1 min fbw *
  set l:ntop 2
endif
header widdif xd=xdel*algp
fft/1d/log widtun widpsd nfft=nfft navg=-1
fft/1d/log widdif widspec nfft=nfft navg=-1
if calgamps.^alg rexists then
  call getPeak widspec(~-fwin:~fwin) ^ntop calgamps.^alg
else
  call getPeak widspec ^ntop 6
endif
if npeaks ge 1 then
  set coff peakloc
  set famp peakamp
else
  set coff 0
  set famp 0
endif
return

procedure findBest s:modlist
set mod gc.TYPE.v
set baud gc.BAUD.v*1e6
set f:scale gc.SCALE.v
set ifn gc.FILE.v
calc freq gc.SOIF.v*1e6 gc.COFF.v +
calc tfreq freq rffreq*1e6 -
switch inc inc get 16
pipe init
if ddc then
 info "Tuning DDC to SOI ..."
 noop/id=noop/wrap ifn _ifn 
 calc gain scale log 3.332 * 6 * -6 +
 icecore/id=rt_tun _ifn _p0 "DDC;ICE" FS=file(ifn).rate FREQ=tfreq DBWF=dbwf BW=gc.SOIW.v*1.1e6 GAIN=gain /ifmt=CI /ofmt=CI
else
 noop/id=noop/wrap ifn _ifn 
 tuner/id=rt_tun _ifn _ifnt tfreq gc.SOIW.v*1e6 ,, 0 dec "CF"
 fcalc/id=rt_fc/mon _p0{form=ci} _ifnt scale *
endif
set d:sr file(_p0).rate
fft/id=rt_fft _p0{fs=2k,cl=^inc} _p9 nfft=2k navg=8 /nexp=1 /psd /log
foreach mod inlist modlist
  say "Starting MT=^mod"
  set gc.TYPE.v mod
  set pipename "_p6_^mod"
  sedit "nxm.iq.tbl.dmcfg_^mod" config "LOCASE"
  table cfg load/t ^{config}.tbl /flags=default
  set d:cfg.IQ.FSYM baud
  set d:cfg.IQ.INFS sr
  set s:cfg.FEC gc.FEC.v
  set l:cfg.UPP ^gc.UPP.v
  set s:cfg.MAP gc.MAP.v
  if gc.MMAT.v gt 0 then
    set l:cfg.MMA.TAPS ^gc.MMAT.v
  endif
  if /uwb then
    icecore/id=iq_^mod _p0 pipename "IQUWB;IQ" /cfg=cfg /ifmt=ci /ofmt=ci /itl=1k /otl=4k
  else
    icecore/id=iq_^mod _p0 pipename "DMOD;IQ" /cfg=cfg /ifmt=ci /ofmt=ci /itl=1k /otl=4k
  endif
  set reg.iq reg.iq_^mod	! selected for displays
endfor
noop/id=rt_fanin pipename _p6
if out neqs "" then
  noop _p6 out
endif
sendto "TP" "OPENFILE" "_p0{fs=2k,cl=^inc}" info=-1
sendto "SP" "OPENFILE" "_p9" info=-1
pipe run
return

procedure stopID
if reg.noop rexists then
  reg "FINISH" noop 
  while reg.noop rexists 
    pause 0.1
  endwhile
  foreach key intable reg
    if key eqss "IQ_" and reg.^key rexists reg FINISH ^key
    if key eqss "RT_" and reg.^key rexists reg FINISH ^key
  endfor
  rem reg.iq
endif
set findMode "IDLE"
return

procedure setSOI f:freq f:fbw f:snr
set gc.SOIF.v freq
set gc.SOIW.v fbw
set gc.SOIN.v snr
set ff.x freq*1e6
set ff.dx fbw*1e6
return

procedure clickTune l:mode d:f1 d:f2 d:f3 d:f4
set d:freq f1*1e-6
set d:smax fs*1e-6*0.95
set f:snr  30
if mode eq 1 then
  set fsig f1  ! center freq
  set asig f2  ! amplitude
  file open/b spf widinpsd
  set df spf.xdelta
  calc l:icent fsig-spf.xstart df / round 0 max spf.size min
  set amax spf.data(icent)
  do i1 icent-1 0 -1
    if spf.data(i1) lt asig break
  enddo
  do i2 icent+1 spf.size-1 +1
    if spf.data(i2) lt asig break
  enddo
  calc freq (i1+i2)/2 df * spf.xstart + 1e-6 * 
  calc fbw (i2-i1) df * 1e-6 *
  calc snr amax asig -
  file close spf
  if fbw gt smax  then
    warn "Auto BandWidth of ^fbw MHz wider than typical limit of ^smax . Try clicking at mid amplitude."
  endif
endif
if mode eq 2 then
  calc fbw (f2-f1) 1e-6 *
  calc freq (f2+f1)/2 1e-6 *
  calc snr (f4-f3)
endif
call setSOI freq fbw snr
sendto "LST" "DESELECT"
if gc.MODE.v eqss "RUN" set gc.MODE.action "SETUP"
return

procedure doScan s:range

status widinpsd size=len
if range eqs "AUTO" then
  set range "ALL"
  if selidx eq -2 set range "SELECT"
endif
if range eqs "ALL" then
  noop widinpsd widscan
elseif range eqs "CENTER70P" then
  thin widinpsd widscan len*.15 len*.85
elseif range eqs "CENTER80P" then
  thin widinpsd widscan len*.10 len*.90
elseif range eqs "CENTER90P" then
  thin widinpsd widscan len*.05 len*.95
elseif range eqss "SELECT" then
  thin widinpsd widscan (gc.SOIF.v-(gc.SOIW.v/2))*1e6 (gc.SOIF.v+(gc.SOIW.v/2))*1e6 /absc
elseif range eqss "ZOOM" then
  noop widinpsd widscan
endif

set l:ntop gc.NTOP.v
switch "NWIN" nwin get 64
set l:thresh gc.THRE.v
statistics widscan sdev=wavg
status widscan xd=xdelta xs=xstart size=len
set s:flags "STRIP|TAG|LOG"
if thresh gt 12 sedit flags flags "APPEND" "|HITH"
icecore/ofmt=SL widscan widpks{sr=(IND1/SI,IND2/SI,AMP/SL)} "MFPP;ICE" &
	L:frame=len L:ntop=ntop L:width=nwin F:thresh=thresh F:tmin=wavg S:flags=flags
file open/d iwp widpks 
sendto/sync "LST" "CLOSEFILE" 
file open/d/w iwt sigfile 
set l:isize iwp.data(ntop,IND1)	! tag holds how many peaks found
set l:osize 0
do nn 0 isize-1
  set f1 iwp.data(nn,IND1)
  set f2 iwp.data(nn,IND2)
  if f2-f1 lt 5 continue
  calc snr iwp.data(nn,AMP) 64k / (f2-f1) / 
  calc f1 f1 xdelta * xstart +
  calc f2 f2 xdelta * xstart + 
  calc fbw (f2-f1) 1e-6 *
  calc freq (f2+f1)/2 1e-6 *
  file write iwt {ENA=1,FREQ=^freq,BW=^fbw,SNR=^snr,MOD=?,BAUD=0,SPEC=0}
  set l:osize osize+1
enddo
file close iwp
file close iwt
header sigfile size=osize
sendto/sync "LST" "OPENFILE" sigfile info=1
sendto/sync "LST" "DESELECT"
call selectRow 0 0

return

procedure doScanIDs
status sigfile size=size
do nn 1 size
  if gc.MODE.v eqs "SETUP" break
  call selectRow nn 1
  call findID
enddo
call selectRow 0
return

procedure selectRow l:nn l:mode
set l:selidx nn
if mode ge 0 sendto "LST" "SELECTROW" x:nn
if selidx gt 0 and mode neq 0 then
  set freq file(sigfile).data(selidx-1,"FREQ")
  set fbw  file(sigfile).data(selidx-1,"BW")
  set snr  file(sigfile).data(selidx-1,"SNR")
  set mod  file(sigfile).data(selidx-1,"MOD")
  set baud file(sigfile).data(selidx-1,"BAUD")
  call setSOI freq fbw snr
  if mod neqs "?" then
    set gc.TYPE.v mod
    set gc.BAUD.v baud
    set gc.COFF.v 0
  endif
  if gc.MODE.v eqs "RUN" then 
    call stopid
    sendto "MAIN" "MODE" "RUN"
  endif
else
  call setSOI 0 0
endif
return

procedure handleTheme
switch "THEME" theme get env.theme
if theme eqs "GEAR2" or theme eqs "GEAR3" then
  set textcolor "0xc88020"
else
  set textcolor "0x909090"
endif
if theme eqss "GEAR" then
  set plotopts "+contrast"
else
  set plotopts "-contrast"
endif
return

procedure getPeak cs:ifile l:ntop d:threshdb
noop ifile widpeak
!say "Alg=^alg max=^gamax"
fcalc tmp_peak widpeak 100 +
statistics tmp_peak sdev=peaksdev
set peaksdev 0
set len file(tmp_peak).size
!say "Thresh=^threshdb peaksdev=^peaksdev"
icecore/ofmt=SL tmp_peak widpks{sr=(IND1/SI,IND2/SI,AMP/SL)} "MFPP;ICE" &
	L:frame=len L:ntop=ntop L:width=32 F:thresh=threshdb F:tmin=peaksdev/2 S:flags=STRIP|TAG|PEAK|SORT|DIFF|LOG
file open/d iwp widpks 
set d:peakamp0 0
set l:npeaks iwp.data(ntop,IND1)
if /peaks then data widpks
foreach ii insize npeaks
  calc peakamp iwp.data(ii,AMP) 64K /
  if /peaks then say "Peak=^ii Amp=^peakamp Thresh=^threshdb"
  if ii gt 0 and peakamp0-peakamp gt threshdb then
    set npeaks ii
    break
  endif
  calc l:indc iwp.data(ii,IND1) iwp.data(ii,IND2) + 2 /
  calc l:indw iwp.data(ii,IND1) iwp.data(ii,IND2) - abs
  if indw gt 20 then
    set npeaks ii
    break
  endif
  noop tmp_peak(indc-1:indc+2) tmp_poly 
  polyfit tmp_poly 2 coef ,, tmp_fit
  calc peakloc -coef(1) 2*coef(2) /        ! solve -b/2a for y'=0
  set peakamp^ii peakamp
  set peakloc^ii peakloc
endfor
file close iwp
if npeaks eq ntop set npeaks 0		! degenerate case of probably noise 
set peakamp peakamp0
set peakloc peakloc0
if /peaks then res npeaks
return

subroutine makeTemplate
header/create sigfile sr=(ENA/SL,FREQ/SF,BW/SF,SNR/SF,MOD/1A,BAUD/SF,SPEC/SF,FMT/1A)
return

