!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
! Event handler for sensors SNAPAPP table 
!   msg=message sam=snapAppMacro
!
! This macro is an event handler called by the sensors.tbl snapapp table.
!
! Notes:
!
! The multiple sensor macros may be tied together to span a wider frequency range.
! This macro helps SNAPAPP make them act as one.
!
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

startmacro s:func o:p1 o:p2

if func eqs "MSG" then
  set msg p1
  set sam p2
  set gc sam.controls	! snapapp controls
  set ns sam.res.ng	! number of sensor macros
  set mname sam.reg.snap1.name
  set task gc.GTASK.v

!  if "TIME" nsubs msg.name then say "Sensors msg=^msg"

  if sam.res.rfins nrexists then	! initialize
    call makeRFins
    set gc.GXCVR.items rfins
    set sam.res.rfins rfins
    set gc.GSYNC.show 0
    set gc.MAXDUR.show 0
  endif

  if sam.reg.snap1 nrexists		! not up yet

  elseif msg.name eqs "GTIME" and mname eqs "SENSOR" then	! make all of the MODE controls consistent
    set runmode sam.reg.snap1.controls.MODE.v
    if runmode eqss "SNAP"
      set gc.ACTION.v "Stop"
    elseif runmode eqs "SETUP" then
      set gc.ACTION.v "Stop"
    elseif runmode eqs "RECWB" then
      set gc.ACTION.v "REC"
    else
      set gc.ACTION.v "Mon"
    endif
    set gc.MODE_0.v runmode
    if runmode eqs "SETUP" then
      call resetAutoTune
      stop
    endif
    ! ok runmode is active from here on
    if task eqss "TRACK" then	! repeat scan mode
      call doScans 1 2
      sendto parent.sbar "OPENFILE" sidebar info=1
    endif
    if gc.GSCAN.v neqs "OFF" and gc.GSCAN.v neqs "PAUSE" then	! autoscan mode
      call stepAutoTune
    endif

  elseif msg.name eqs "GSCAN" then
    if msg.data eqs "TOGGLE" then
      if gc.GSCAN.v eqs "PAUSE" then
        set gc.GSCAN.v "RESUME"
      else
        set gc.GSCAN.v "PAUSE"
      endif
    endif
    if gc.GSCAN.v eqs "PAUSE" then
    elseif gc.GSCAN.v eqs "RESUME" then
      if sam.res.autotune.name rexists then
        set gc.GSCAN.v sam.res.autotune.name
      else
        set gc.GSCAN.v "Off"
      endif
    elseif gc.GSCAN.v eqss "----" then
    else
      call resetAutoTune
    endif

  elseif msg.name eqs "GXCVR" then
    do l:nn 1 ns	! loop through sensor instances
      sendto parent.snap^nn "XCVR3"  msg.data
    enddo
    sedit msg.data gc.GXCVR.v "TRIM" "" " " "SUBS" "Clear" "" "APPEND" "    "

  elseif msg.name eqs "GTASK" then

    if msg.data eqss "SCAN-" then
      sedit msg.data l:ii "TRIM" "-"
      call openSBar sidebar siglist 0
      call doScans ii ii
      key scanlist add "L:CHANNEL" ii
      noop scanlist sidebar
      call openSBar sidebar siglist 1

    elseif msg.data eqss "SCANID" then
      if sam.reg.snap1.res.runmode neqs "SnapDone" or scanlist nfexists then
	warn "Must have run SnapSpec and Scan-1|2 to use this option"
      else
	status scanlist size=fsize
	key scanlist get "CHANNEL" l:ii
	set fname sam.reg.snap1.res.wbfile^ii
	set rffreq sam.reg.snap1.res.gc.XFREQ^{ii}.v
        set gc.GPROG.v 0
	do ir 1 fsize
	  if gc.GTASK.v neqss "SCANID" break
	  sendto parent.sbar "SELECTROW" ir
!	  sigid "ID" fname scanlist ir-1 rffreq
	  call doID fname scanlist ir-1 rffreq
          set gc.GPROG.v ir/fsize
	  sendto parent.sbar "FILE" "REREAD"
	enddo
	sendto parent.sbar "DESELECT" 
      endif

    elseif msg.data eqss "SCANTOBOT" then
      key scanlist get "CHANNEL" l:ii
      do l:nn 1 ns
        sendto parent.snap^nn "COMSCAN-^ii" {FILE="scanlist",INDEX=-1}
      enddo

    elseif msg.data eqss "SCANTOTRACK" then
      call copyList scanlist sidebar
      call openSBar sidebar siglist 1

    elseif msg.data eqss "TRACK" then
      if sidebar nfexists then
	call makeSig sidebar 1200 1250 1
      endif
      call openSBar sidebar siglist 1

    elseif msg.data eqss "MAKETRACK" then
      gcontrol/temp/handle=fstart dval ,, "Start Freq (MHz) " 1500 1 -1 1
      gcontrol/temp/handle=fstop  dval ,, "Stop Freq (MHz)  " 2500 1 -1 1
      gcontrol/temp/handle=fstep  dval ,, "Step Freq (MHz) " 1 1 -1 1
      call makeSig sidebar fstart.v fstop.v fstep.v
      call openSBar sidebar siglist 1

    elseif msg.data eqss "LOADTRACK" then
      if "^{gc.GFILE.v}.txt" fexists then
        call loadSig gc.GFILE.v gc.GFILE.v
      endif
      noop gc.GFILE.v sidebar
      call openSBar sidebar siglist 1

    elseif msg.data eqss "SAVETRACK" then
      noop sidebar gc.GFILE.v
    endif
    if msg.data eqss "TRACK" then
!    elseif msg.data eqss "SCAN" and gc.MODE_0.v neqs "Setup" then
    else
      set gc.GTASK.v "Done"
    endif

  elseif msg.name eqs "GFILE" then

  elseif msg.name eqs "CLICKRF" and sidebar fexists then
    file open sbf sidebar
    set d:rfc msg.data 
    do ir 1 sbf.size
      set rf sbf.data(ir-1,"FREQ") rfbw sbf.data(ir-1,"BW")/2 
      if rfc gt rf-rfbw and rfc lt rf+rfbw then
	sendto parent.sbar "SELECTROW" ir
        sendto parent.snap1 "TUNER" {FREQ=^rf*1e6,BW=^rfbw*2e6}
        break
      endif
    enddo
    file close sbf

  elseif msg.name eqs "SELECT" then
    if msg.data.type eqs "ROW" then
      do l:nn 1 ns
        sendto parent.snap^nn "TUNER" {FREQ=^msg.data.value.freq*1e6,BW=^msg.data.value.bw*1e6}
      enddo
    endif

  elseif msg.name eqs "DRAGBOX" then
    set l:selidx sam.reg.sbar.selrow
    if task eqss "TRACK" and selidx gt 0 then
      set file(sidebar).data(selidx-1,"FREQ") (msg.data.FREQ+msg.data.XFREQ)/1e6
      set file(sidebar).data(selidx-1,"BW") (msg.data.BW)/1e6
      sendto parent.sbar "FILES" "REREAD"
    endif

  elseif msg.name eqs "RECONFIG" then
    ! ignore for now

  elseif msg.name eqs "EXTRACT" then
    set l:ii msg.info
    if mname eqs "SNAPPER" then
      set arch sam.reg.snap^{ii}.res.gc.AFNAME.v
      set rffreq sam.reg.snap^{ii}.reg.SP.RFFREQ
    else
      set arch sam.reg.snap1.res.gc.AFN^{ii}.v
      set rffreq sam.reg.snap1.reg.SPW^{ii}.RFFREQ
    endif
    set gpw gc.GPROG gpw.v 0	! icearchive looks in parent for this
    switch "CARD^ii" card get "CPU"
    switch "CARD" card get card
    icearchive/id=arch/bg "EXTRACT" arch /tbl=^msg.data /rffreq=^rffreq /card=^card
  endif

elseif func eqs "RUN" then
  snapapp/tbl=sensors sensors1

else
  warn "Unsupported function=^func"
endif

endmacro

procedure saveSig cs:fname cs:oname
sedit fname fname "TRIM" "botcfg_" "." "PREPEND" "botcfg_" "APPEND" ".txt"
file open/t/n tf fname
file write tf "ENA\tFREQ\tBW\tSNR\tMOD\tBAUD\tSPEC\tFMT"
set size file(oname).size
foreach nn insize size
  set t:tab file(oname).dataTable(nn)
  file write tf "^tab.ENA\t^tab.FREQ\t^tab.BW\t^tab.SNR\t^tab.MOD\t^tab.BAUD\t^tab.SPEC\t^tab.FMT"
endfor
file close tf
info "Sig config saved from ifile=^fname to ofile=^oname"
return

procedure loadSig cs:fname cs:oname
!sedit fname fname "TRIM" "" "." "APPEND" ".txt"
convert/parse fname T2B oname "L1|F8|F8|F8|A8|F8|F8|A8|F8|A8" 1
header oname sr(1)="(ENA,)" sr(2)="(FREQ,)" sr(3)="(BW,)" sr(4)="(SNR,)" sr(5)="(MOD,)" sr(6)="(BAUD,)" sr(7)="(SPEC,)" sr(8)="(FMT,)"
info "Sig config loaded from ifile=^fname to ofile=^oname"
return

procedure doScans l:i1 l:i2
set runmode sam.reg.snap1.res.runmode 
set thresh gc.GTHRE.v
do l:nn 1 ns	! loop through sensor instances
do l:ii i1 i2
  set fname sam.reg.snap^{nn}.res.psdfile^ii
  set rffreq sam.reg.snap^{nn}.res.gc.XFREQ^{ii}.v
  set rfbw sam.reg.snap^{nn}.res.gc.RATE.v*0.8
  if runmode eqs "SnapDone" then 
    sedit fname fname "APPEND" "i"		! individual y-slice selected
  else
    sedit fname fname "APPEND" "f"		! individual y-slice selected
  endif
  if task eqs "TRACK" then
!    sigid "SCAN" ^fname scanlist ^thresh ^rffreq
    call doScan fname scanlist thresh rffreq
    key scanlist set "CHANNEL" ii "RFCF" rffreq "RFBW" rfbw
    iceutil/msgid=parent.main SCANUP scanlist sidebar
  elseif nn eq 1 and ii eq i1 then
    call doScan fname scanlist thresh rffreq
  else
    call doScan fname scantmp thresh rffreq
    mergefile scantmp scanlist
  endif
enddo
enddo
if task neqs "TRACK" then
  info "Scan with thresh=^thresh dB found ^file(scanlist).size signals"
endif
return

procedure resetAutoTune 
if sam.res.autotune rexists and sam.res.autotune.redo nrexists then
  set sam.res.autotune.redo 1
endif
return

procedure setupAutoTune 
set catune gc.GSCAN.v
set d:rfd ^gc.RATE_0.v*.8
sedit catune d:rf1 "TRIM" "" "-"
sedit catune d:rf2 "TRIM" "-" " "
if "G" subs catune then 
  set mult 1000
else
  set mult 1
endif
if "@" subs catune then 
  sedit catune l:period "TRIM" "@" " "
else
  set period 1
endif
calc rf1 rf1*mult rfd/2 +
calc rf2 rf2*mult rfd/2 -
set t:att {NAME="^catune",RF1=^rf1,RF2=^rf2,RFD=^rfd,RF=^rf1,L:STEPS=^period,L:STEP=0}
return

procedure stepAutoTune l:mode
if sam.res.autotune nrexists or sam.res.autotune.redo rexists then
  call setupAutoTune
  set sam.res.autotune att
endif
set att sam.res.autotune
calc l:doit att.step att.steps mod
set l:att.step att.step+1
if doit neq 0 return
do l:nn 1 ns	! loop through sensor instances
 set hold sam.reg.snap^{nn}.res.gc.HOLD.v
 do l:ii 1 2
  if ii eq hold or hold eq 3 continue
  set sam.reg.snap^{nn}.res.gc.XFREQ^{ii}.action att.rf
  calc att.rf att.rf+att.rfd
  if att.rf ge att.rf2 then set att.rf att.rf1
 enddo
enddo
return

procedure openSBar s:filename s:template l:mode
set sam.reg.panel.borders "+Right"
sendto parent.sbar "OPENTEMPLATE" "nxm.ice.cfg.^{template}.tbl"
sendto parent.sbar "OPENFILE" "^filename" info=^mode
return

procedure makeRFins
set rfins "Bypass,Preset"
foreach id intf nxm.ice.cfg.rfinputs.txt
  sedit rfins rfins "APPEND" "," "APPEND" id
endfor
return

procedure makeSig s:fno d:fstart d:fstop d:fdelta
header/create fno sr=(ENA/SL,FREQ/SF,BW/SF,SNR/SF,MOD/1A,BAUD/SF)
file open/d/w iwt fno
do freq fstart fstop fdelta 
  file write iwt {ENA=0,FREQ=freq,BW=fdelta,SNR=0,MOD=?,BAUD=0}
enddo
file close iwt
return

procedure copyList s:fni s:fno
header/create fno sr=(ENA/SL,FREQ/SF,BW/SF,SNR/SF,MOD/1A,BAUD/SF)
file open/d/w iwt fno
foreach index insize file(fni).size
  set tt file(fni).getDataTable(index)
  if tt.ena le 0 continue
  file write iwt {ENA=1,FREQ=^tt.freq,BW=^tt.bw,SNR=^tt.snr,MOD=^tt.mod,BAUD=^tt.baud}
endfor
file close iwt
return

include sigfuncs.mmi

