!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
! This macro serves up SNAPAPP applications on an ICE Appliance
!
startmacro/msgid=main/mlog s:scfg

global hwalias
set addr env.hostaddr
set name env.hostname
import ICEROOT iceroot

! set default log file
switch "LOGFN" logfn get "sensorfuse" 
if logfn neqs "OFF" then report on logfn{CFL=1M}

! set default config file
switch "TBL" scfg get scfg
switch "OPT" opt get "ice"
switch "PORT" l:port get 8090
switch "CUTS" l:ncut get 4

table nodei create {tostr="App=SensorFuse"}
table nodei setmode "KV"

pipe on

panel/controls=gc/setup/menubar/logger

!icermif/id=rmif/http/title=homepageonly port "q:ack"
iceconnector/id=hub port+1000 "225.1.2.3" nodei nodes

view/id=hubv nodes
plot/id=map world.shp|sv1|sv2|sv3
layer "Geo" geo {NAME=GEO,SVA=SV1,SVB=SV2,SITE=SITE,FLAGS=ALL,TDOA=0,FDOA=0,DTDOA=0.001,DFDOA=0.010} map

plot/id=pfull/db
feature ,, ff {NAME=FF,TYPE=BOX,COLOR=#0080A0} pfull

do nn 1 ncut
  plot/id=pcut^nn/db mimic=pcut1|pcut2|pcut3|pcut4 
  feature ,, ff^nn {NAME=F^nn,TYPE=BOX,COLOR=#0080A0} pcut^nn
enddo

gcontrol label  "FNC"    "Function" "Open"
gcontrol choice "FUNC"   "Function" "Config,AutoGUI,GetFull,GetCuts,GetTDOA,GetTFDOA,GetGeoLoc,...,Done,Exit" "Done"
gcontrol tval   "FTS"    "FTs" 0 1 -1 1
gcontrol tval   "FTD"    "FTd" 60 0 3600 60

gcontrol label  "SOI"    "SOI"
gcontrol tval   "SOITS"  "Ts" 0 1 -1 1 
gcontrol tval   "SOITD"  "Td" 0 1 -1 1 
gcontrol dval   "SOICF"  "CF" 0 1 -1 1 /units=MHz
gcontrol dval   "SOIBW"  "BW" 0 1 -1 1 /units=MHz
gcontrol dval   "SOILAT" "Lat" 0 1 -1 1 /units=Deg
gcontrol dval   "SOILON" "Lon" 0 1 -1 1 /units=Deg
gcontrol dval   "SOIALT" "Alt" 0 1 -1 1 /units=m

gcontrol label  "GEOS"   "GEO Setup"
gcontrol choice "GEOM"   "Geo Mode" "TFDOA-3Ball,TDOA-4Ball" "TFDOA-3Ball,FOA-1Ball"
gcontrol choice "VIEW"   "Map View" "LatLon,Mercator,Geodetic" "Lat"
gcontrol prompt "CUTF"   "CutF" ""
do nn 1 ncut
  gcontrol prompt "CUT^nn" "Cut^nn" ""
enddo

gcontrol label  "GEOE"   "GEO Event"
set reg.panel.controls.geo {}   ! create inner table
gcontrol choice geo.sitemode  "SiteMode  " geo.sitemodelist geo.sitemode
gcontrol choice geo.svecmode  "SVecMode  " geo.svecmodelist geo.svecmode
gcontrol choice geo.tdoamode  "TDOAMode  " geo.tdoamodelist geo.tdoamode
gcontrol choice geo.fdoamode  "FDOAMode  " geo.fdoamodelist geo.fdoamode
gcontrol choice geo.vehicleA  "VehicleA  " "1,2,3,4,5,6,7,8" 1
gcontrol choice geo.vehicleB  "VehicleB  " "1,2,3,4,5,6,7,8" 2
gcontrol tval   geo.time      "CurrTime  " 0 0 86400 1
gcontrol tval   geo.dtime     "dCurrTime " 60 0 86400 1
gcontrol dval   geo.tdoa      "TDOA      " geo.tdoa -1 1 1e-3 /fmt="###.### ?sec"
gcontrol dval   geo.dtdoa     "dTDOA     " geo.dtdoa -25 1 1e-3 /fmt="###.### ?sec"
gcontrol dval   geo.fdoa      "FDOA      " geo.fdoa -1 1 1e-3 /fmt="###.### ?Hz"
gcontrol dval   geo.dfdoa     "dFDOA     " geo.dfdoa -25 1000 1 /fmt="###.### ?Hz"
gcontrol dval   geo.flinkT    "FLinkT    " geo.flinkT 0 1e9 1e3 /fmt="###.### ?Hz"
gcontrol dval   geo.flinkA    "FLinkA    " geo.flinkA 0 1e9 1e3 /fmt="###.### ?Hz"
gcontrol dval   geo.flinkB    "FLinkB    " geo.flinkB 0 1e9 1e3 /fmt="###.### ?Hz"

gcontrol label  "SYS"    "System"
gcontrol choice "DOCS"   "Docs" "Manual,Concepts,Commands,Keys,Flags,Help" ""

pipe run

set gc.FUNC.action "AutoGUI"
set this.timers 2
set this.timer(0) 1
set this.timer(1) 10

pipe off

if logfn neqs "OFF" then report off

endmacro


procedure processMessage

if msg.name eqs "TIMER" then
  if msg.info eq 0 then		! 1 sec
    sendto hubv "FILES" "REREAD"
  else				! 10 sec
  endif

elseif msg.name eqs "FUNC" then
  if msg.data eqs "CONFIG" then
    info "Use Shift-LM-Click in plot frame to set selected sensor node to slot" 
    return
  elseif msg.data eqss "AUTO" then
    info "Use Shift-LM-Click to update Full spectra, Shift-LM-Drag to update NB cuts" 
    return
  elseif msg.data eqs "GETFULL" then
    call getFull
  elseif msg.data eqs "GETCUTS" then
    call getCuts
  elseif msg.data eqs "GETTFDOA" then
    call getTFDOA
  elseif msg.data eqs "GETTDOA" then
    call getTDOA
  elseif msg.data eqs "GETGEOLOC" then
    call getGeoLoc
  elseif msg.data eqs "EXIT" then
    pipe stop
  endif
  set gc.FUNC.v "Done"

elseif msg.name eqs "MARK" then
  if msg.fid eqs "PFULL" and msg.info eq 101 then
    call getFull
  elseif msg.fid eqs "MAP" then
    set geo.pos msg.data
    set gc.SOILAT.v geo.pos.lat
    set gc.SOILON.v geo.pos.lon
    set gc.SOIALT.v geo.pos.alt
  endif

elseif msg.name eqss "GEO."
  set ^msg.name msg.data

elseif msg.name eqs "DRAGBOX" then
  if msg.fid eqs "PFULL" and msg.info eq 101 then
    call setCutBounds msg.data
    if gc.FUNC.v eqss "AUTO" then call getCuts
  elseif msg.fid eqss "PCUT" and msg.info eq 101 then
    call setGeoBounds msg.data
!    if gc.FUNC.v eqss "AUTO" then call getGeo
  endif

elseif msg.name eqs "CONN" then

elseif msg.name eqs "VIEW" then
  set reg.map.view gc.VIEW.v

elseif msg.name eqs "DOCS" then          ! documentation
  if msg.data eqs "HELP" then
    help/gui ,, ice
  elseif msg.data eqs "MANUAL" then
    fname fn "HOME" "IceManual" "pdf" "AUX"
    os/bg xpdf ^fn
  elseif msg.data eqs "CONCEPTS" then
    browse/bg "nxm.ice.docs.help.ice_hlp_all.html"
  elseif msg.data eqs "COMMANDS" then
    browse/bg "nxm.ice.docs.help.ice_exp_all.html"
  endif

else
  ! say "Got ^msg message data= ^msg.data"
  ! the rest need no other action
endif
return

procedure getFull
sedit gc.CUTF.v addr "TRIM" "" ":"
sedit gc.CUTF.v name "TRIM" ":" "" "LOCASE"
if addr eqs "" then
 res sensorfuse_full pic1auto_psd1f
else
 rem sensorfuse_full
 icenet "MSG" ^addr:8080 {name=GETPSD,data={ARCH="^name",TOP=-1,DUR=^gc.FTD.v,FILE="sensorfuse_psd"}}
 icenet "MSG" ^addr:8080 {name=SYNC,info=10}
 icenet "FILE" ^addr:8080 "sensorfuse_full" "sensorfuse_psd"
endif
sendto "PFULL" "OPENFILE" "sensorfuse_full" /info=-1
status sensorfuse_full time=gc.FTS.v xs=nybw
calc nybw -nybw 1e-6 *
return

procedure setCutBounds o:box
calc gc.SOITS.v box.tmin
calc gc.SOITD.v box.tmax-box.tmin
calc gc.SOIBW.v box.xmax-box.xmin abs 1e-6 *
calc gc.SOICF.v box.xmax+box.xmin 2 / 1e-6 *
set ff.x (box.xmax+box.xmin)/2 ff.y (box.ymax+box.ymin)/2 ff.dx (box.xmax-box.xmin) ff.dy (box.ymax-box.ymin)
return

procedure setGeoBounds o:box
calc fc (box.xmax+box.xmin)/2
calc fd (box.xmax-box.xmin)
calc tc (box.ymax+box.ymin)/2
calc td (box.ymax-box.ymin)
do nn 1 ncut
  set ff^{nn}.x fc ff^{nn}.y tc ff^{nn}.dx fd ff^{nn}.dy td
enddo
return

procedure getCuts 
calc l:timeout gc.SOITD.v 2 * round 60 max
if sensorfuse_full rexists then
  ! its a local testfile
  calc t1 gc.SOITS.v
  calc t2 t1+gc.SOITS.v
  calc f1 gc.SOICF.v gc.SOIBW.v/2 - 1e6 *
  calc f2 gc.SOICF.v gc.SOIBW.v/2 + 1e6 *
  do nn 1 ncut
    thin/absc sensorfuse_full sensorfuse_psd^nn t1 t2 ,, f1 f2
    sendto "PCUT^nn" "OPENFILE" "sensorfuse_psd^nn" /info=-1
  enddo
  return
elseif gc.SOITD.v lt 0.5 or gc.SOITS.v lt 1::00:00:00 then
  warn "Invalid time start=^gc.SOITS.v or duration=^gc.SOITD.v sec"
  return
elseif nybw nrexists or gc.SOIBW.v lt 0.005 or gc.SOICF.v lt -nybw or gc.SOICF.v gt nybw then
  warn "Invalid freq CF=^gc.SOICF.v or BW=^gc.SOIBW.v MHz"
  return
endif
info "Getting cuts time=^gc.SOITS.v dur=^gc.SOITD.v sec CF=^gc.SOICF.v BW=^gc.SOIBW.v MHz"
do nn 1 ncut
  if gc.CUT^{nn}.v eqs "" continue
  sedit gc.CUT^{nn}.v addr "TRIM" "" ":"
  sedit gc.CUT^{nn}.v name "TRIM" ":" "" "LOCASE"
  icenet "MSG" ^addr:8080 {name=GETCUT,data={ARCH="^name",TOP=^gc.SOITS.v,DUR=^gc.SOITD.v,CF=^gc.SOICF.v,BW=^gc.SOIBW.v,FILE="sensorfuse_cut"}}
enddo
do nn 1 ncut
  if gc.CUT^{nn}.v eqs "" continue
  sedit gc.CUT^{nn}.v addr "TRIM" "" ":"
  sedit gc.CUT^{nn}.v name "TRIM" ":" "" "LOCASE"
  icenet "MSG" ^addr:8080 {name=SYNC,info=^timeout}
  icenet "FILE" ^addr:8080 "sensorfuse_cut^nn" "sensorfuse_cut"
  fft sensorfuse_cut^nn sensorfuse_psd^nn nfft=2k navg=8
  sendto "PCUT^nn" "OPENFILE" "sensorfuse_psd^nn" /info=-1
enddo
return
