startmacro fn:fin fn:fout s:device l:nchn l:dec d:freq d:dfreq

switch aflags aflags get	! special ICE card flags, like FTTM=2
switch rsize  rsize  get 1	! ram size in seconds
switch oform  oform  get "CI"	! output format
switch pbrate pbrate get 25e6	! playback rate in Hertz
switch gain   gain   get 0	! tuner gain

if fin nfexists then
  error "Cannot find input file: ^fin"
  stop
endif
set iform file(fin).format	! input sample format
set irate 1/file(fin).xdelta	! input sample rate
if "C" subs oform then
  set orate irate/dec/2		! complex output rate
else
  set orate irate/dec		! real output rate
endif
invoke bpa=nxm.sys.lib.Data.getbpa(oform)

set pktlen 16K
set oport "TBANK3"		! use a bank of tuners
set aflags "^aflags|MUXCLK=P"
if nchn gt 256
  set aflags "^aflags|FTTM=3"
  set pktlen 2K
elseif nchn gt 32
  set aflags "^aflags|FTTM=2"
  set pktlen 8K
elseif nchn gt 1
  set aflags "^aflags|FTTM=1"
else
  set oport "TUNER1"		! use a regular tuner
endif
switch frame frame get pktlen/bpa
calc pktlen frame*bpa

picd/flags=aflags reset device t1		! set up for 2->1 loopback
picd/flags=aflags get device "CHNS" mchn 	! determin maximum channels
if nchn gt mchn then
  warn "Limiting desired channels=^nchn to max channels=^mchn for this FTTM configuration"
  set nchn mchn
endif
calc osamp file(fin).length*orate frame / floor 2 max frame * nchn *
calc timeo frame orate / irate * pbrate / 1.5 * 1 + ! add sinkpic buffer prefill

picd create icetuner_in  iform rsize*pbrate irate 
picd create icetuner_out oform rsize*orate orate /round=pktlen /multi=nchn /minrbuf=4

info "Processing file=^fin chan=^nchn at pbrate=^pbrate"

timer set
pipe on
sourcepic icetuner_out fout device dec freq gain /port=oport /timeout=10 &
	/flags=aflags /nchn=nchn /dfreq=dfreq /tl=frame /maxout=osamp /master=sinkpic
sinkpic fin icetuner_in device /port=module2 &
	/flags=aflags /wrap /srate=pbrate /replay=con
pipe waitfor sourcepic
pipe off
timer elapse

if nchn gt 1 then
  header fout fs=frame
  keyword fout add "CHANNELS" nchn
endif
if /plot then
  plot/bg fout view=iyx axis=frame layer={LT="nxm.ice.libg.LayerMC",&
             TYPE=RAST,PROCESS=FFT,NFFT=1k,NCHAN=nchn,MAX=40,MIN=-40}
endif

erase icetuner_in icetuner_out

endmacro

