!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!
! ICEFS - Utility macro for ICE FileSystem maintenance
!
! Inode data structure:
! (ino,ids,mode,next, atime,mtime,ctime, sblk,nblk,nbyt)
!
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
startmacro u:function cs:p1 t:cfg

  timex now wsec=ctsec
  timex 1970:01:01::00:00:00 wsec=jtsec
  calc l:tsec ctsec-jtsec

  switch "SBF" sbfile get p1
  switch "PATH" defpath get "/mnt/icefs"

if function eqs "HELP" or func eqss "EXP" then
  explain icefs

elseif function eqs "MKFS" then
  if cfg eqs "NULL" set t:cfg {}
  if cfg.devlist nrexists set cfg.devlist p1
  if cfg.volumename nrexists set cfg.volumename "ICEFS_DATA"
  if cfg.volumesize nrexists set cfg.volumesize "AUTO"
  if cfg.mountpoint nrexists set cfg.mountpoint "ANY"
  icefs make ifssb cfg
  icefs init ifssb 

elseif function eqs "MAKE" then
  if cfg eqs "NULL" then
    warn "Using default config file=nxm.ice.cfg.icefs.tbl. Contents: "
    set t:cfg nxm.ice.cfg.icefs.tbl
    res/all cfg
    ask ans "Continue with this configuration Y/[N] ?"
    if ans neqss "Y" then stop
  endif
  call parseDeviceList
  if cfg.volumesize neqs "AUTO" then
    calc x:volumesize cfg.volumesize
  elseif cfg.device eqss "iceram"
    sedit aux.^env.ramaux x:volumesize parse 4
  else
    os/stdout=lso ls -al /dev/^devtest
    if lso eqss "brw" then
      os/stdout=x:blocks sudo blockdev --getsz /dev/^devtest
      calc x:volumesize blocks*512	! in blocks
    else
      error "Device name /dev/^devtest does not exist"
      stop
    endif
  endif
  ! enforce defaults
  if cfg.files nrexists set cfg.files 16k
  if cfg.pagesize nrexists set cfg.pagesize 4k
  if cfg.stripesize nrexists set cfg.stripesize 128k
  if cfg.bouncesize nrexists set cfg.bouncesize 256k
  if cfg.blocksize nrexists set cfg.blocksize 16m
  if cfg.label nrexists set cfg.label cfg.volumename
  if cfg.license nrexists set cfg.license "CARD:PAC"

  if cfg.files gt 32k then
    error "Max files=^cfg.files larger than max supported=32K"
  endif

  ! make calculations
  calc l:blocksize cfg.blocksize
  calc l:pagesize cfg.pagesize
  calc l:inodesize 64
  calc l:blocks volumesize/blocksize 
  calc l:blocks blocks*cfg.devices
  calc l:pages  blocksize/pagesize
  calc l:inodes cfg.files
  calc l:supersize inodes 128 *
  calc l:supers supersize-1 blocksize / floor 1 +
  calc l:mapsize blocks*4 
  calc l:maps mapsize-1 blocksize / floor 1 +
  calc l:pages 0
  calc l:soff cfg.stripesize
  calc l:sblks supers+maps
  calc l:superfree blocksize-2K
  calc l:mapfree maps*blocksize mapsize -
  switch "NEXTBLOCK" l:sblks get sblks

  ! create superblock file 
  erase/warn=no sbfile
  waveform sbfile{det=1} "SL" blocks "CONST" 0  
  keyword sbfile add "TAG" "SUPER" "MAGIC" 0x01cef500 "LABEL" cfg.label "MOUNT" cfg.mountpoint "LICENSE" cfg.license &
    "DEVTYPE" cfg.devtype "DEVICE" cfg.device "DEVICES" cfg.devices "DEVLIST" "^cfg.devlist," "SOFF" soff "SKEY" supersize "SMAP" mapsize
  keyword sbfile add "TAG" "BLOCKS" "SIZE" blocksize "TOTAL" blocks "NEXT" sblks "USED" 0 "INODES" supers "MAPS" maps 
  keyword sbfile add "TAG" "PAGES"  "SIZE" pagesize  "TOTAL" pages  "NEXT" 0  "USED" 0 "BLOCK" 0
  keyword sbfile add "TAG" "BOUNCE" "SIZE" cfg.bouncesize 
  keyword sbfile add "TAG" "STRIPE" "SIZE" cfg.stripesize 
  keyword sbfile add "TAG" "INODES" "SIZE" inodesize "TOTAL" inodes "NEXT" 10 "USED" 0 "BLOCK" 0	
  ! add an entry for the root directory of the mount point
  keyword sbfile add "L:ROOT" (1,0,0x41FF,0, tsec,tsec,tsec, 0,0, 0,0,0) 
  keyword sbfile add "INODE" 2 
  keyword sbfile add "L:sb.prm" (3,0,0x81A4,0, tsec,tsec,tsec, 0,0, 0,supers,superfree) 
  keyword sbfile add "L:sb.det" (4,0,0x81A4,0, tsec,tsec,tsec, 0,0, supers,maps,mapfree) 
  keyword sbfile add "INODE" 1 
  keyword sbfile add "L:.etc" (2,0,0x41ED,0, tsec,tsec,tsec, 0,0, 0,0,0) 
  keyword sbfile add "INODE" -1 
  keyword sbfile add "TAG"  "EOF"
  ! the TAG=BLOCKS USED=0 now triggers the initial zeroing of the block list
  say "MakeFS for files=^cfg.files blocks=^blocks bs=^cfg.blocksize ss=^cfg.stripesize"

elseif function eqs "INIT" then
  ! create initial super block file 
  call mklsb
  file open/b/w isb /var/tmp/ifsisb.tmp
  keyword sbfile get "MAGIC" isb.data(0,MAGI)
  keyword sbfile get "SOFF" isb.data(0,SOFF)
  keyword sbfile get "SKEY" isb.data(0,SKEY)
  keyword sbfile get "SMAP" isb.data(0,SMAP)
  keyword sbfile get "DEVTYPE" isb.data(0,DEVT)
  keyword sbfile get "DEVICES" isb.data(0,DEVS)
  keyword sbfile get "SIZE" isb.data(0,BS) /scope=tag=BLOCKS
  keyword sbfile get "SIZE" isb.data(0,SS) /scope=tag=STRIPE
  keyword sbfile get "LABEL" isb.data(0,NAME)
  keyword sbfile get "MAGIC" isb.data(0,MAGX)
  keyword sbfile get "DEVLIST" list
  keyword sbfile get "DEVICES" ndev
  keyword sbfile get "LABEL" label
  keyword sbfile get "DEVICE" dev
  keyword sbfile get "SOFF" soff
  call explist
  sedit list isb.data(0,LST1) range 0 127
  sedit list isb.data(0,LST2) range 128 256
  calc l:soff soff 512 /
  find sbfile sbfn
  set l:idev 0
  foreach dev inlist list
    set isb.data(0,UUID) (0x00f5ce01,ndev,idev,0x0)
    info "Zeroing /dev/^dev superblock area"
    os sudo dd bs=512 if=/dev/zero of=/dev/^dev oflag=direct seek=0 count=9
    if idev eq 0 then
      info "Writing icefs filesystem superblock at ^soff on /dev/^dev"
      os sudo dd bs=512 if=^sbfn of=/dev/^dev oflag=direct seek=^soff count=4
      set isb.data(0,NAME) label
    else
      set isb.data(0,NAME) "^{label}-^idev"
    endif
    info "Writing icefs volume superblock at 0 on /dev/^dev"
    os sudo dd bs=512 if=/var/tmp/ifsisb.det of=/dev/^dev oflag=direct seek=0 count=1
    os sudo dd bs=512 if=/var/tmp/ifsisb.det of=/var/preserve/sb-dev^{idev}.det seek=0 count=1
    set l:idev idev+1
    if idev eq ndev break
  endfor
  file close isb
  erase/all /var/tmp/ifsisb.tmp

elseif function eqss "PART" then
  if p1 eqs "SBX" then set p1 "iceblk0n1,iceblk0n2"
  foreach dev inlist p1
    info "Making single partition on device /dev/^dev
    os sudo sgdisk -o /dev/^dev
    os sudo sgdisk -o /dev/^dev
    os sudo sgdisk -N 1 /dev/^dev
  endfor
  os sudo partprobe 
  os sudo lsblk 
  info "You should reboot at this point to make sure the system has the new partitions in its cache"

elseif function eqs "PRESERVE" then
  if sbfile eqs "SBX" set sbfile "/var/preserve/sb"
  info "Copying /mnt/icefs/.etc/sb to ^sbfile"
  os sudo dd if=/mnt/icefs/.etc/sb.prm of=^{sbfile}.prm bs=4096
  os sudo dd if=/mnt/icefs/.etc/sb.det of=^{sbfile}.det bs=4096

elseif function eqs "RESTORE" then
  if sbfile eqs "SBX" set sbfile "/var/preserve/sb"
  if sbfile fexists then
    info "Restoring IceFS iNode block on  /mnt/icefs/.etc/ ^sbfile"
    os sudo dd bs=4096 if=^{sbfile}.prm of=/mnt/icefs/.etc/sb.prm 
    os sudo dd bs=4096 if=^{sbfile}.det of=/mnt/icefs/.etc/sb.det 
    info "Restore IceFS complete"
  else
    error "IceFS SuperBlock file=^sbfile not found"
  endif

elseif function eqs "DUMPLSB" then
  info "Dumping Linux Super Block for dev=^p1"
  if p1 "ENDS" "p1" then
    call mklsb
    call rdlsb p1
    data/hex /var/tmp/ifsisb
  else
    os sudo od -A x -x -N 8192 -w32 /dev/^p1
  endif

elseif function eqs "REHOST" then
  if p1 eqs "" then
    say "REHOST requires the device name of the new root drive"
    stop
  endif
  call mklsb
  call rdlsb p1
  status /var/tmp/ifsisb.tmp size=sok
  if sok neq 1 then stop
  file open/b/w isb /var/tmp/ifsisb.tmp
  switch DEVLIST list get "NONE"
  if list eqs "NONE" then
    sedit isb.data(0,LST1) list "APPEND" isb.data(0,LST2) "STRIM"
    say "Current device list on ^p1 is ^list"
    say "Use /DEVLIST=\"a,b,c,\" to specify new list"
    file close isb
  else
    call explist
    if list nends "," sedit list list APPEND ","
    say "New device list on ^p1 is ^list"
    sedit list isb.data(0,LST1) range 0 127
    sedit list isb.data(0,LST2) range 128 256
    file close isb
    ask ans "Ok to write new list Y/[N]? "
    if ans eqss "Y" then call wrlsb p1
  endif

elseif function eqs "MOUNT" then
  if sbfile eqs "DEF" then
    set dev "iceblk0n1p1"
    set mnt "^defpath"
  else
    keyword sbfile get "DEVICE" dev
    keyword sbfile get "MOUNT" mnt
  endif
  files/f=ftmp "/dev/^dev"
  if file(ftmp).size eq 1 then
    say "Mounting ^mnt on ^dev"
    os sudo mount -t icefs /dev/^dev ^mnt
    if sbfile neqs "DEF" say "Add to /etc/fstab: /dev/^dev ^mnt icefs defaults,nofail 0 0"
  else
    say "Mount device ^dev does not exist"
  endif
  erase ftmp

elseif function eqs "UMOUNT" then
  if sbfile eqs "DEF" then
    set mnt defpath
  else
    keyword sbfile get "MOUNT" mnt
  endif
  os sudo umount ^mnt

elseif function eqs "STATS" then
  keyword sbfile get "MOUNT" mnt
  sedit mnt mnt APPEND "/"
  system disk disks
  foreach disk intable/v disks
    if disk eqs "NULL" then continue 
    if disk.path eqs mnt then res/all disk
  endfor

elseif function eqs "TESTP" then
  info "Creating test ramfile"
  pic create ramfile ci 256M 250e9 ramp
  pic create chkfile ci 256M 250e9 zero
  erase/warn=n ^defpath/testfile

elseif function eqs "TESTW" then
  info "Testing disk write speed from ramfile"
  switch wloop nloop get 1
  do nn 1 nloop
    icecopy/verbose ramfile ^defpath/testfile /replay=10
  enddo

elseif function eqs "TESTR" then
  info "Testing disk read speed to ramfile"
  switch rloop nloop get 1
  do nn 1 nloop
    icecopy/verbose ^defpath/testfile chkfile /osize=256M
  enddo

elseif function eqs "TESTC" then
  info "Checking disk read data"
  icediff chkfile ramfile 

elseif function eqs "TEST" then
  icefs testp
  icefs testw
  icefs testr
  icefs testc
  erase/warn=n ^defpath/testfile
  erase ramfile chkfile

elseif function eqs "WARMUP" then
  if "^defpath/.etc" dexists then
    info "Warming up NVME drives"
    icefs test /wloop=3
  else
    info "No NVME drives to warm up"
  endif

elseif function eqs "KEYS" then
  data/k sbfile

else
  warn "Unsupported ICEFS function: ^function
endif

endmacro

procedure explist
set listy list
if "[" subs list
  if "/SPLIT=" subs list
    sedit list l:split trim "=" ","
  else
    set l:split 0
  endif
  sedit list str0 trim "" "["
  sedit list str1 trim "[" "-"
  sedit list str2 trim "-" "]"
  sedit list str3 trim "]" ","
  set list ""
  do ii ^str1 ^str2
    sedit list list "APPEND" "^{str0}^{ii}^{str3},"
    if split gt 0 then
      set l:jj ii+split
      sedit list list "APPEND" "^{str0}^{jj}^{str3},"
    endif
  enddo
  say "Expanded ^listy to ^list"
endif
return

procedure parseDeviceList
set cfg.devices 0
set cfg.devtype 0
set list cfg.devlist
call explist
foreach devname inlist list
  os/stdout=lso ls -al /dev/^devname
 if lso eqss "brw" then
  sedit lso devtype "PARSE" 1 "RANGE" 0 0
  sedit lso l:devmaj "PARSE" 5
  sedit lso l:devmin "PARSE" 6
  if devtype eqs "C" set cfg.devtype 1
  if devtype eqs "B" set cfg.devtype 2
  say "Device name=^devname type=^devtype major=^devmaj minor=^devmin"
  set l:cfg.devices cfg.devices+1
  if cfg.devices eq 1 set devtest devname
  if cfg.device nrexists set cfg.device devname
 else
  error "Device /dev/^devname does not exist"
 endif
endfor
return

procedure mklsb
headermod/create /var/tmp/ifsisb.tmp detached=1 size=1 &
 SR=(MAGI/SL,SOFF/SL,SKEY/SL,SMAP/SL,DEVT/SL,DEVS/SL,BS/SL,SS/SL,NAME/2A,UUID/4L,LST1/TA,LST2/TA,MAGX/SL)
return

procedure rdlsb s:devname
file open/n/t isfi "/var/tmp/ifsinit.sh"
file write isfi "dd bs=512 of=/var/tmp/ifsisb.det if=/dev/^devname seek=0 count=1"
file close isfi
os/stderr=str sudo bash /var/tmp/ifsinit.sh
if "No such file" subs str then 
  warn "Device /dev/^devname does not exists"
  header /var/tmp/ifsisb.tmp size=0
endif
return

procedure wrlsb s:devname
file open/n/t isfi "/var/tmp/ifsinit.sh"
file write isfi "dd bs=512 if=/var/tmp/ifsisb.det of=/dev/^devname seek=0 count=1"
file close isfi
os/stderr=str sudo bash /var/tmp/ifsinit.sh
if "No such file" subs str then 
  warn "Device /dev/^devname does not exists"
  header /var/tmp/ifsisb.tmp size=0
endif
return
