startmacro s:inp cs:outp s:time1 u:dur

  ! erase the temporary files that are going to create
  erase/quiet/warn=n tmpoutminmax.pkt
  erase/quiet/warn=n tmpoutbeg.pkt
  erase/quiet/warn=n tmpoutend.pkt

  ! setup the packet name
  res inPkt "^{inp}.PKT"
  if ( inPkt fexists ) isfalse then
    error "^inp does not have valid timecode"
    stop
  endif

  ! get information about the waveform
  status inp xd=xDelta

  ! find the min/max
  icetc/selmode=minmax/delta=xDelta func=select in=inPkt out=tmpoutminmax.pkt time=time1

  ! calculate the valid indices and times in the file
  res tblminmax FILE(tmpoutminmax.pkt).getDataTable(0)
  res frameSize tblminmax.elem
  res validBeg tblminmax.cnt
  res tcoTmp tblminmax.tco
  res tcwsTmp tblminmax.tcws
  calc fileTimeBeg -tcoTmp xDelta * tcwsTmp + 
  timex fileTimeBeg strTimeBeg
  res tblminmax FILE(tmpoutminmax.pkt).getDataTable(1)
  res tcoTmp tblminmax.tco
  res tcwsTmp tblminmax.tcws
  calc fileTimeEnd -tcoTmp xDelta * tcwsTmp + 
  timex fileTimeEnd strTimeEnd

  ! determine if they only want the time
  if outp EQS ""
    say "************************************************"
    say "** Valid Start Time: ^strTimeBeg"
    say "** Valid End Time  : ^strTimeEnd"
    say "************************************************"
    ! erase the temporary files that we created
    erase/quiet/warn=n tmpoutminmax.pkt
    stop
  endif
  
  switch pass passw GET ""
  switch user uname GET ""
  set fname "^outp"
  call parseOutputFile fname ^uname host ftpdir
  
  ! determine if the user only specified the day
  set secDay 86400
  ! get the date from the file
  timex fileTimeBeg fileDate /fmt="yyyy:MM:dd"
  timex fileDate d:secDate /infmt="yyyy:MM:dd"

  timex time1 d:secBeg  
  if secBeg LT secDay   
    calc secBeg secBeg secDate +
  endif

  ! make sure the time is valid
  if secBeg LT fileTimeBeg or secBeg GT fileTimeEnd
    say "******************************************************************************"
    say "** Warning! File times: ^strTimeBeg -> ^strTimeEnd
    say "** Start time is being adjusted!"
    say "******************************************************************************"
    set secBeg fileTimeBeg
  endif

  set d:secEnd 0
  call parseTime "^dur" secDate secBeg d:secEnd

  ! make sure the time is valid
  if secEnd GT fileTimeEnd or secEnd LT secBeg 
    say "******************************************************************************"
    say "** Warning! File times: ^strTimeBeg -> ^strTimeEnd! 
    say "** End time is being adjusted!"
    say "******************************************************************************"
    set secEnd fileTimeEnd
  endif

  ! now stringify it
  timex secBeg time1
  timex secEnd time2
  
  ! now calculate the 2 indices
  icetc/selmode=nearle/delta=xDelta func=select in=inPkt out=tmpoutbeg.pkt time=time1
  icetc/selmode=nearge/delta=xDelta func=select in=inPkt out=tmpoutend.pkt time=time2

  ! grab the indices
  res indBeg FILE(tmpoutbeg.pkt).getDataTable(0).cnt
  res indEnd FILE(tmpoutend.pkt).getDataTable(0).cnt

  ! determine the valid end size in the data file
  status inp{fs=frameSize} size=validEnd

  if validEnd LT indEnd
    say "**************************************************************************"
    say "** Warning! Timestamps in Data and Packet files do not match!
    say "** Setting trim indices to valid ranges...."
    say "**************************************************************************"
  endif
  ! make sure our trimming indices are valid
  calc indEnd indEnd validEnd min  
  calc indBeg indBeg validBeg max indEnd min

  ! now translate into indices the data file understands
  calc indTrimBeg indBeg frameSize * floor
  calc indTrimEnd indEnd frameSize * floor
  
  status inp(indTrimBeg:indTrimEnd) size=nElem 
  calc fileSize nElem 1M /
  timex now l:transBeg

  ! now transfer
  say "Sending ^inp (^{fileSize}M) to ^host"  
  sourceice/pkthdr=copy inp(indTrimBeg:indTrimEnd) ftp:^host/^{fname}.tmp{user="^uname",pass="^passw",ftpdir="^ftpdir"}
  timex now l:transEnd
  calc transDelta transEnd transBeg -
  calc megSec fileSize transDelta /
  say "transferred ^inp (^{fileSize}M) to ^host in ^transDelta seconds"  

  ! erase the temporary files that we created
  erase/quiet/warn=n tmpoutminmax.pkt
  erase/quiet/warn=n tmpoutbeg.pkt
  erase/quiet/warn=n tmpoutend.pkt

endmacro

procedure parseTime u:durStr d:secDate d:secBeg d:secEnd
  sedit durStr ind "BSEARCH" ":"

  if ind GT 0
    ! convert it to timex
    timex s:durStr secEnd

    if secEnd LT 86400
      calc secEnd secEnd secDate +
   endif
  else 
    calc secEnd durStr secBeg +
  endif
return

procedure parseOutputFile s:fname cs:uname u:host u:ftpdir
  ! get the user name
  sedit fname ind "BSEARCH" "@"
  if ind GT 0
    sedit fname uname "BETWEEN" 0 ind-1
    sedit fname fname "BETWEEN" ind+1 ^fname.length
  endif
  ! peel off the ftp and throw it away if it exists
  sedit fname ind "BSEARCH" "ftp://"
  if ind GT -1
    sedit fname fname "BETWEEN" ind+6 ^fname.length
  endif
  ! get the host
  sedit fname ind "SEARCH" "/"
  if ind GT 0
    sedit fname host "BETWEEN" 0 ind-1
    sedit fname fname "BETWEEN" ind+1 ^fname.length
  else
    set host ""
  endif
  ! get the directory
  sedit fname ind "BSEARCH" "/"
  if ind GT 0
    sedit fname ftpdir "BETWEEN" 0 ind-1
    set ftpdir "/^ftpdir"
    sedit fname fname "BETWEEN" ind+1 ^fname.length
  else
    set ftpdir ""
    sedit fname fname "BETWEEN" 0 ^fname.length
  endif
  ! remove leading "/" if it exists
  sedit fname ind "BSEARCH" "/"
  if ind GT -1
    sedit fname fname "BETWEEN" 1 ^fname.length
  endif
return

