!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!
! ICE - Utility macro for ICE software/hardware development
!
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
startmacro 

global/readall 

  picd/stat=pics numdev 
  set/global "T:HWALIAS" {}

  set HWALIAS.PICS pics
  set l:niop 0
  if "/var/etc/network.conf" fexists then
    table niot load/t /var/etc/network.conf
  elseif "/etc/network.conf" fexists then
    table niot load/t /etc/network.conf
  else
    table niot create {hostaddr=^{env.hostaddr}}
  endif
  set niox niot.hostaddr
  sedit niox net1 "ELEMENT" 1 "."
  sedit niox net2 "ELEMENT" 2 "."
  sedit niox net3 "ELEMENT" 3 "."
  sedit niox net4 "ELEMENT" 4 "."
  if niot.qsfpaddr nrexists set niot.qsfpaddr "^{net1}.^{net2}.X.^{net4}"
  if niot.qsfpmask nrexists set niot.qsfpmask "255.255.0.0"
  if niot.qsfpgate nrexists set niot.qsfpgate "^{net1}.^{net2}.X.254"
  do n 1 pics
    set l:devno n-1
    set "HWALIAS.PIC" "ICEPIC,DEVNO=^devno,IOM=NONE,PM=NONE,"
    picd get "PIC" "CONFIG" "ALIAS"
    set HWALIAS.PIC "^alias"
    picd get "PIC" "NIOP" nio
    if nio gt 0 then
      if niot.qsfpaddr rexists then set niox "^niot.qsfpaddr"
      if niot.qsfpaddrx rexists then set niox "^niot.qsfpaddrx"
      if niot.pic^{n}addrx rexists then set niox "^niot.pic^{n}addrx"
      sedit alias alias append "SIOP=^niop,IPADDRX=^niox,"
      set l:niop niop+nio
    endif
    if /aflags pexists then
      switch "AFLAGS" aflags get 
      sedit alias alias "APPEND" aflags "APPEND" ","
    endif
    set HWALIAS.PIC^{n}AUTO "^alias"
    sedit alias alias "TRIM" "ICEPIC,"
    set t:HWALIAS.PIC^{n} {^alias}
    rem "HWALIAS.PIC"
  enddo

  ! parse ethernet adapters ip addr output
  os/stdout=devall/stderr=sterr ip addr
  set l:nn 1 t:ntab {}
  ! tag the numbered entries with __ for parsing with TRIM
  sedit devall devall "PREPEND" "\n" 
  do l:nn 1 20    ! only up to 20 entries
    sedit devall devall "SUBS" "\n^{nn}: " "\n__^{nn}: " 
  enddo
  ! parse individual entries 
  do l:nn 1 20    ! only up to 20 entries
    if "__^nn: " nsubs devall continue	! no # entry found
    sedit devall val "TRIM" "__^{nn}: " "__" "GSUBS" "\n" " "
    ! the SUBS are to have the SORT prioritize the adapter types
    sedit val key "TRIM" "" ":" "SUBS" "eth" "1_" "SUBS" "eno" "2_" "SUBS" "ens" "3_" "SUBS" "enp" "4_" "SUBS" "enx" "5_"
    if "_" subs key and "UP>" subs val and "inet" subs val then set ntab.^key val
  enddo
  table ntab sort/k

  set l:nics 0
  set HWALIAS.NICS nics
  do n 0 9
    set hwaddr "?" addr "?" mask "?" mtu "?" gate "?" route "default" 
    if n eq 0 set addr env.hostaddr
  if n gt 0 and n le niop
    iceutil "IPX2IP" niox n addr
    iceutil "IPX2IP" niot.qsfpmask n mask
    iceutil "IPX2IP" niot.qsfpgate n gate
    set mtu "9000"
    set route "icepic0"
    iceutil "STR2IP" addr ,, hwaddr
  elseif /nonet isfalse
    if n gt ntab.getsize break
    iceutil "KVI" ntab n stout
    sedit stout route "TRIM" "" ":"
    if "ether" subs stout then sedit stout hwaddr trim "ether " " "
    if "inet" subs stout then sedit stout addr trim "inet " " " trim "" "/"
    if "inet" subs stout then sedit stout mask trim "inet " " " trim "/" " "
    if mask eqs "8" set mask "255.0.0.0"
    if mask eqs "16" set mask "255.255.0.0"
    if mask eqs "24" set mask "255.255.255.0"
    if "mtu" subs stout then sedit stout mtu trim "mtu " " "
  endif
  if addr neqs "?" then
    set hwalias.nic^{n}auto "NIC=^n,ADDR=^addr,MASK=^mask,GATE=^gate,MTU=^mtu,DEV=^route,HWADDR=^hwaddr"
    set t:hwalias.nic^{n} {ADDR=^addr,PORT=^addr:901^n,PORTA=^addr:902^n,PORTS=^addr:9^{n}##,&
				MASK=^mask,GATE=^gate,MTU=^mtu,DEV="^route",HWADDR="^hwaddr"}
    set l:nics nics+1
  endif
  enddo
  set HWALIAS.NICS nics
  fname afn "home" "iceauto" "tbl" "aux"
  table hwalias save afn

  fname afn "home" "iceauto" "key" "aux"
  file open/t/n hwcf afn
  file write hwcf "COMMENT=Hardware Configuration for ICE Development"
  file write hwcf "TAG==ALIAS"
  do nn 1 hwalias.pics
    set l:ii nn-1
    file write hwcf "PIC^nn==ICEPIC,DEVNO=^ii,IOM=NONE,PM=NONE"
  enddo
  foreach key intable hwalias
    if "AUTO" subs key
      file write hwcf "^key==^{hwalias.^key}"
    endif
  endfor
  file write hwcf "TAG==ICEPIC"
  file write hwcf "TAG==ICENIC"
  file write hwcf "TAG==END_OF_TAGS"
  file close hwcf

  fname afn home iceauto prm aux
  header/create afn sr=(IN/2A,OUT/2A)
  key afn fset

endmacro
