startmacro s:func cs:arch d:top d:dur cs:event cs:file

global/parent gpw ! progress widget from parent
switch "SERVER" server get "NONE" "localhost:9000"

if func eqs "EXP" then
  explain icearchive

elseif func eqs "LIST" and server eqs "NONE" then
  if server eqs "NONE" then
    datalist "^{arch}_toc"
  else
    datalist "http://^server/Archive/^{arch}_toc"
  endif

elseif func eqs "GETLIST" then
  icenet file server file "^{arch}_toc"

elseif func eqs "IMPORT" then
  icenet import server file "^{arch}?MULTI=-1&EVENT=^event"

elseif func eqs "EXPORT" then
  icenet export server file "^{arch}?MULTI=-1&TOP=^top&DUR=^dur&EVENT=^event"

elseif func eqs "START" and server neqs "NONE" then
  icenet set server {ACTION=REC/PB}

elseif func eqs "STOP" and server neqs "NONE" then
  icenet set server {ACTION=STOP}

elseif func eqs "SELECT" and server neqs "NONE" then
  icenet set server {ATCT=^top}
  icenet msg server {NAME=ATCL,DATA=^dur}	! non-standard treatment of ATCL widget

elseif func eqs "DESELECT" and server neqs "NONE" then
  icenet set server {ATCT=0,ATCL=0}

elseif server neqs "NONE" then
  icenet msg server {NAME=ARCHIVE,DATA={FUNC=^func,ARCHIVE="^arch",TOP=^top,DUR=^dur,EVENT=^event,FILE=^file}}

elseif func eqs "UNPACK" then
  icecopy arch file /unpack=12 /gpw /top=top /dur=dur 

elseif func eqs "DEMUX" then
  icecopy arch file /arch={FUNC=ICEDEMUX,MULTI=16}

elseif func eqs "ERASE" then
  if ^{arch}_toc nfexists then 
    warn "Archive file ^{arch}_toc not found"
    stop
  endif
  file open/d fn ^{arch}_toc
  if fn nrexists then 
    error "Archive file ^{arch}_toc not opened as Midas file"
    stop
  endif
  set lines fn.keyword("LINES")
  if lines neq 0 then
    foreach ii insize fn.size
      set dt fn.datatable(ii)
      erase/quiet=n ^{arch}_^dt.key
    endfor
  else
    erase/quiet=n ^{arch}
  endif
  file close fn
  erase/quiet=n ^{arch}_psd
  erase/quiet=n ^{arch}_toc

elseif func eqs "GETPSD" then
  say "Get PSD ^arch ^file"
  key ^{arch}_toc get "LINES" l:lines "CUROFFSET" l:ckey	! prev to current
  if ckey eq 0 then set l:ckey lines	! wrap around
  status ^{arch}_^ckey time=tcur len=tper
  calc l:skey ckey dur/tper - 1 max
  status ^{arch}_^skey time=tstr 
  thin ^{arch}_psd file skey-1 ckey 
  header file time=tstr ys=0 yd=tper

elseif func eqs "EXTRACT" then
  switch "TBL" t:tbl get
  say "Extracting from ^arch with table ^tbl"
  call extract 

elseif server eqs "NONE" then
  invoke nxm.ice.lib.Archiver.doFunc(reg.shell.m,func,arch,top,dur,event,file)

else
  error "Unsupported ARCHIVE function=^func with server=^server"
endif

endmacro


procedure extract 

if tbl nisnull
  set file tbl.FILENAME
  set top tbl.START
  set dur tbl.LENGTH
  set tcf tbl.CF
  set tbw tbl.BW
  set kws tbl.keywords
  set psd tbl.psd
  set svfn tbl.svfn
  set tgain 30
else
  set t:kws {}
  switch "PSD" l:psd get 0 2K
  switch "CF" d:tcf get 0
  switch "BW" d:tbw get 1e6
  switch "SFVN" svfn get "NONE"
  set tgain -6
endif
switch "CARD" card get "NONE"
switch "GAIN" tgain get tgain
switch "RFFREQ" d:rffreq get 0
calc tcf tcf rffreq*1e6 -
set ifmt "CI"
set ofmt "CI"
set l:xfer 128K

invoke fins=nxm.ice.lib.Archiver.getFileAt(reg.shell.m,arch,top,dur,xfer)
if ":" subs fins then 
  sedit fins finsx "TRIM" "" ":" "APPEND" ":)"
else
  set finsx fins
endif
status finsx rate=irate time=itime xs=itoff
invoke itime.addSec(itoff)
say "EXTRACT fins=^fins rffreq=^rffreq tcf=^tcf tbw=^tbw irate=^irate"

if psd gt 0 then
  set psdfile file
  set tunfile "NULL"
  set nfft psd
  set skip 8
else
  set psdfile "/tmp/psdfile"
  set tunfile file
  set nfft 4k
  set skip 8
endif
erase/warn=n file ! make sure output is truncated for follow on streamer that doesn't read the header

timer set
if card eqs "NONE" or card eqs "CPU" then
  pipe on
 if tbw lt 0 
  sinkice/id=tfd arch _tfd{ps=1m,packet=none} /archsf /archtop=top /archdur=dur /archtl=xfer /gpwr=gpw
 else
  icecore/id=tfd fins _tfd{ps=1m,packet=none} "DDC;ICE" FS=irate FREQ=tcf BW=tbw GAIN=tgain AGC=1 /ifmt=ifmt /ofmt=ofmt /gpwr=gpw
 endif
  if psd le 0 noop/id=nop/tl=64k _tfd tunfile
  if psd gt 0 spectra/log/id=psd _tfd psdfile nfft hann over=-skip
  pipe waitfor tfd
  pipe off
else
  calc rtf 250e6/irate	! real timer factor
  calc clen 0.2*rtf	! ram buffer size
  calc dec irate/tbw 4 / fix 1 max 2 *
  calc orate irate/dec/2
  calc odone orate*dur/nfft/skip
  set flgs "IOC=T1|MUXCLK=N|MBITS=-16|PMFPGA=tq|VERBOSE=0"
  picd/round=1M create iceextract_in ifmt clen*irate irate
  picd/round=1M create iceextract_out ofmt clen*orate orate
  picd reset card /flags=flgs
  pipe on
  sourcepic/id=tfd/flags=flgs iceextract_out{fs=nfft} _tfd{ps=1m} card dec tcf tgain &
	/port=tuner1 /maxout=odone /tl=1 /skip=skip /archtl=64k /arch=tunfile /gpwr=gpw /tc=ztc /tcoff=itime
  sinkpic/id=pb/flags=flgs arch iceextract_in card /throttle=ondemand /port=module2 /archsf /archtop=top /archtl=xfer
  if psd gt 0 spectra/log/id=psd _tfd{fs=0} psdfile nfft hann
  pipe waitfor tfd
  pipe off
  erase iceextract_in iceextract_out
endif
timer elapse

! get state vectors
if svfn neqs "NONE" and svfn fexists then
  status svfn size=nn
  convert svfn(nn-1:nn){rf=ecr} "GEODETIC" tmpsvg
  set fgeo file(tmpsvg).data(0,POS)
  convert svfn(nn-1:nn){rf=ecr} "CARTESIAN" tmpsvc
  set fcar file(tmpsvc).data(0,POS)
  if kws.USE_SV_KEYWORDS rexists and kws.USE_SV_KEYWORDS eq 1
    set kws.FEED_ALT fgeo(0) kws.FEED_LAT fgeo(1) kws.FEED_LON fgeo(2)
    set kws.ETIM1 top kws.POSX1 fcar(0) kws.POSY1 fcar(1) kws.POSZ1 fcar(2) 
    set kws.VELX1 0 kws.VELY1 0 kws.VELZ1 0 kws.ACCX1 0 kws.ACCY1 0 kws.ACCZ1 0
  endif
endif

! add specific keywords 
if kws contains "FS" then set kws.FS irate
!keyword file "TPUT" kws	! post nxm411
iceutil "TPUT" kws file		! pre nxm411

if /plot then plot file

return
