package nxm.sys.libg;

import nxm.sys.inc.*;
import nxm.sys.lib.*;
import java.awt.Color;
import nxm.sys.prim.plot;

/**
  A class to hold and plot a Protocol Analyzer data layer.

  @author Jeff Schoen
  @version $Id: LayerPA.java,v 1.57 2019/6/26 15:31:13 jgs Exp $
*/
public class LayerPA extends Layer1D {

  public static String protoList = "Raw,USB2,USB3,PCIE,TGBE";
  private static int P_RAW=1, P_USB2=2, P_USB3=3, P_PCIE=4, P_TGBE=5;
  private int proto = P_RAW;

  /** Default constructor. */
  public LayerPA () {
    super();
  }

  @Override
  public boolean setFile (PlotFile pf, Table tab, Args MA) {
    setFile(pf);
    setXAxis( pf.getXStart(), pf.getXDelta() );
    int ts=(int)Math.min(pf.getSize(),10.0e6);
    int fs=MA.getL("/FS",Math.min(ts,32768));
    setFrame(fs);
    int lps=MA.getL("/LPS",1);
    setSize(lps);
    setData (pf.getDataBuffer(fs*lps));
    isPaged = !realtime && (fs*lps)<ts;
    xIsTime = (pf.getXUnits()==Units.TIME);
    setTimeAlign(MA.getState("/TIMEALIGN",false));  // added for Bug 2419 in 3.1.2
    return true;
  }

  public void setProto (String protocol) {
    proto = Parser.find(protoList,protocol,0);
  }
  public String getProto() { return Parser.get(protoList,proto); }

  @Override
  public void process () {
    ndata = 0; if (data==null) return;
    ndata = data.size*data.ape;
    fbuf = data2fa (data,ndata,fbuf,0,MP.mode);
  }

  public String getReadOut (Position mp) {
    int iy = (int)mp.y;
    int ix = (int)(mp.x/xdelta);
    String tmp = " PA ()";
    return tmp;
  }

}


