#define UDP_NUM_PRG_BITS                    16
#define SDDS_NUM_PRG_BITS                   16
#define SDDS_CLK_INPUT_RATE           66000000
#define SDDS_DEFAULT_MODULE_IP_ADDR 0x02000081  /* Default Module IP Address = 129.0.0.2 */
#define SDDS_DEFAULT_VLAN                    3  /* Default VLAN For Joins/Leaves         */
#define NOLINKBIT                       0x0004  /* No Link Bit Value                     */  

/* Config Logic DP Addresses */
#define  SDDS_RXDP_OP       0x0000     /* 00 Encode In Bits 15..14          */
#define  SDDS_TXDP_OP       0x4000     /* 01 Encode In Bits 15..14          */
#define  SDDS_CFGDP_OP      0x8000     /* 10 Encode In Bits 15..14          */
#define  SDDS_CFGREG_OP     0xC000     /* 11 Encode In Bits 15..14          */    

/* Config DP Op Definitions  */
#define CFGDP_FINISHED_OP   0x0040
#define CFGDP_AUTONEG_OP    0x0020
#define CFGDP_WAITCNT_OP    0x0010
#define CFGDP_REGRD_OP      0x0008
#define CFGDP_REGWR_OP      0x0004
#define CFGDP_LDADR_OP      0x0002
#define CFGDP_SIGREG_OP     0x0001

/* Config DP Reg Definitions */
#define CFGREG_INPUTEN_BIT  0x0002
#define CFGREG_RESETRMV_BIT 0x0001

/* Rx DP/Logic Config Defs   */
/*---------------------------*/
/* Rx DP/Logic Cfg Addresses */
#define RX_CFGREGADDR          0x0100 /* Configuration For Rx Logic Cfg Reg  */
#define RX_CPUWRADDR           0x0200 /* Configuration For Rx CPU DP Ram     */
#define RX_NREGADDR            0x0400 /* Trottle Count Reg For ICE SDDS Mode */
#define RX_STRICTADDR          0x0800 /* Address Offset For Strict Adr Regs  */
#define RX_ENREGADDR           0x1000 /* Address Offset For Dis/Enable Reg   */
#define RX_FFWMREGADDR         0x2000 /* Address Offset For Fifo Watermark   */

/* Rx DP/Logic Config Data   */
#define RX_RAWBURST_VALUE      0x0001 /* Enable Fastest Rx w/NO Tx Replies To Rx Packets         */
#define RX_RAWDATA_VALUE       0x0002 /* Bring In Every And All Packet Data/Headers              */ 
#define RX_RAWSDDS_VALUE       0x0004 /* Bring In Only SDDS Packet Header & Data, NO UDP,IP Hdrs */
#define RX_ICESDDS_VALUE       0x0008 /* Bring In SDDS Packet Header & Data, and ICE Header      */ 
#define RX_STRICT_VALUE        0x0010 /* Allow Only 1 MC Data Source--Don't Trust Routers        */ 
#define RX_DATCTRL_VALUE       0x0020 /* Enable IOC To Control Data Flow Using OCLK              */
#define RX_NSPKTEN_VALUE       0x0040 /* Allow Non-Standard Pkt Acq In ICESDDS Mode              */      
#define RX_PRYPKTEN_VALUE      0x0080 /* Allow Parity Pkt Acq In ICESDDS Mode                    */  
#define RX_TCBSWAP_VALUE       0x0100 /* Swap Bit 3 & Bit 0 TC Bits-For RXSDDSDATA Only          */ 
#define RX_DEBUGMOD_VALUE      0x0200 /* Turn On Clock Always, Zero Non-Valid Data-DEBUG ONLY    */ 
#define RX_SEQCHECK_VALUE      0x0400 /* Turn On Packet Sequence Checking                        */
#define RX_IPGCHECK_VALUE      0x0800 /* Turn On IPG Counter Insertion                           */
#define RX_RAWBITS_VALUE       0x1000 /* Bring In Raw Line Data-8b/10b Decoded                   */
#define RX_MEMBUFF_VALUE       0x2000 /* Bring In Data Thru Memory Buffer                        */

/* Tx DP/Logic Config Defs   */
/*---------------------------*/
#define  TX_CPUWRADDR          0x0100  /* Address Nibble Bit Encode To Write Tx CPU DP RAM-BitWise OR W/SDDS_TXDP_OP            */
#define  TX_DATWRADDR          0x0200  /* Address Nibble Bit Encode To Write Tx Data DP RAM-BitWise OR W/SDDS_TXDP_OP           */
#define  TX_DATRDADDR          0x0400  /* Address Nibble Bit Encode To Write Tx DP Size & Address Reg-BitWise OR W/SDDS_TXDP_OP */
#define  TX_CFGREGADDR         0x0800  /* Address Nibble Bit Encode To Write Tx Config Reg                                      */

#define  IGMP_PACKET_ADDRESS   0x0020  /* IGMP Packet Located At Address 0x0080 In Tx Data DP Ram */
#define  IGMP_PACKET_SIZE      0x0020  /* IGMP Packet Size Is 32 16-Bit Words                     */
#define  ARP_PACKET_ADDRESS    0x0040  /* ARP  Packet Located At Address 0x0040 In Tx Data DP Ram */
#define  ARP_PACKET_SIZE       0x0020  /* ARP  Packet Size Is 32 16-Bit Words                     */
#define  TXGEN_PACKET_ADDRESS  0x0060  /* For Generic Pkt Send                                    */
#define  TXGEN_PACKET_SIZE     0x0020  /* Size For Generice Pkt Send                              */ 

#define  TXLOVLAN_RESTRICT     100
#define  TXHIVLAN_RESTRICT     200   
/*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/
/*&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&*/
/*--------------------------------------------------------------*/
int_4 sdds_vlan (PICSTRUCT *p,int_4 mport)
  {
    int_4  vlan=0; /* mport=3 means either 1 or 2 */
    vlan = findintflag("IPVLAN1",p->config); if (mport!=2 && vlan>=0) return vlan;
    vlan = findintflag("IPVLAN2",p->config); if (mport!=1 && vlan>=0) return vlan;
    vlan = findintflag("IPVLAN",p->config);  if (vlan>=0) return vlan;
    return -1;
  } 
/*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/
/*&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&*/
/*--------------------------------------------------------------*/
int_4 sdds_enable(PICSTRUCT *p,int_4 mport,int_4 dis_enable)
  {
    int ii;
    vprint("SDDS Enable port=%d enable=%d\n",mport,dis_enable);
    
    if (dis_enable == 0)                                                       /* dis_enable == 0 Disables Rx Data To ICE Card */   
      {        
                   
        pic_wmodreg(p,mport,0,SDDS_RXDP_OP | RX_ENREGADDR,SDDS_NUM_PRG_BITS);  /* Wrtie Down Adr Of Dis_Enable Reg             */ 
        pic_wmodreg(p,mport,0,0,SDDS_NUM_PRG_BITS);                            /* Write Down 0 To Disable                      */  

        if (p->mtype[mport-1] == IOMT_SDDSXD)
          {  
           /* Leave All Joined Addresses-Do Twice To Be Sure Router Gets Info */
            for (ii=0;ii<2;ii++)
              {     
                pic_wmodreg(p,mport,0,SDDS_TXDP_OP+TX_DATRDADDR+0x00AF,SDDS_NUM_PRG_BITS);  /* Write Address To Leave ALL           */           
                pic_wmodreg(p,mport,0,32,SDDS_NUM_PRG_BITS);                                /* Write Tx Size Of Transfer            */
                udelay(10000);
              }
          }               
      }
    else
      { 
        

       /* Be Sure Module Disabled First-Then Enable */  
        pic_wmodreg(p,mport,0,SDDS_RXDP_OP | RX_ENREGADDR,SDDS_NUM_PRG_BITS);  /* Wrtie Down Adr Of Dis_Enable Reg             */ 
        pic_wmodreg(p,mport,0,0,SDDS_NUM_PRG_BITS);                            /* Write Down 0 To Disable                      */ 

        pic_wmodreg(p,mport,0,SDDS_CFGREG_OP,SDDS_NUM_PRG_BITS);  
        pic_wmodreg(p,mport,0,0,SDDS_NUM_PRG_BITS);                            /* Write Down 0 To Disable                      */   


        pic_wmodreg(p,mport,0,SDDS_RXDP_OP | RX_ENREGADDR,SDDS_NUM_PRG_BITS);  /* Wrtie Down Adr Of Dis_Enable Reg             */ 
        pic_wmodreg(p,mport,0,1,SDDS_NUM_PRG_BITS);                            /* Write Down 1 To Enable                       */ 

        pic_wmodreg(p,mport,0,SDDS_CFGREG_OP,SDDS_NUM_PRG_BITS);
        pic_wmodreg(p,mport,0,0x0001,SDDS_NUM_PRG_BITS);                       /* Remove Reset-Enable                          */ 
         
      }
    return(0);
  }
/*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/
/*&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&*/
/*--------------------------------------------------------------*/
void pic_sdds_sendpkt (PICSTRUCT *p,int_4 mport,int_4 offset,int_4 sizepacket,int_u2 *data,int running)
{
    int ii; 
  
    for(ii=0;ii<sizepacket;ii++)
      {
        pic_wmodreg(p,mport,0,SDDS_TXDP_OP+TX_DATWRADDR+offset+ii,SDDS_NUM_PRG_BITS);  /* Fill Packet Data             */           
        pic_wmodreg(p,mport,0,*(data+ii),SDDS_NUM_PRG_BITS); 
        udelay(100);  
      }

    pic_wmodreg(p,mport,0,SDDS_TXDP_OP+TX_DATRDADDR+offset,SDDS_NUM_PRG_BITS);         /* Write Address & Size         */            
    pic_wmodreg(p,mport,0,sizepacket,SDDS_NUM_PRG_BITS);                               /* Write Of Tx Size Begins Trans*/

 udelay(1000);
    
} 
/*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/
/*&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&*/
/*--------------------------------------------------------------*/
int_u2 sdds_compute_checksum (int sizeregion,int_u2 *data)
{
  int_u4 chksum = 0;
  int ii;
 
  for(ii=0;ii<sizeregion;ii++)
    chksum = chksum + *(data+ii);
   
  chksum = chksum + (chksum >> 16);

  return((int_u2)(~chksum));  /* Ones Complement Of Ones Complement Sum */  
} 
/*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/
/*&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&*/
/*--------------------------------------------------------------*/
int_u4 numeric_ip (char *s, int_u4 *addr, int_u4 *port)
{
  int_u4 i,value,ip=0,maxlen=16;
  *addr = 0; *port = 0;
  /* parse address */
  for (i=0,value=0; s[i]>='0' && s[i]<='9' && i<maxlen; i++) value = value*10 + (s[i]-48);
  ip = value<<0; if (s[i]!='.') return 0; 
  for (i++,value=0; s[i]>='0' && s[i]<='9' && i<maxlen; i++) value = value*10 + (s[i]-48);
  ip |= value<<8; if (s[i]!='.') return 0; 
  for (i++,value=0; s[i]>='0' && s[i]<='9' && i<maxlen; i++) value = value*10 + (s[i]-48);
  ip |= value<<16; if (s[i]!='.') return 0; 
  for (i++,value=0; s[i]>='0' && s[i]<='9' && i<maxlen; i++) value = value*10 + (s[i]-48);
  ip |= value<<24;
  if (i>=maxlen) return 0;
  *addr = ip;
  if (s[i]!=':') return 1;
  /* parse port */
  maxlen = i+6;
  for (i++,value=0; s[i]>='0' && s[i]<='9' && i<maxlen; i++) value = value*10 + (s[i]-48);
  *port = value;
  return 2;
} 
/*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/
/*&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&*/
/*--------------------------------------------------------------*/
int_u4 convert_ip_addr2 (char *flagstr, char *flagstr2, char *cfgstr) 
{
  int_u4 status;
  status = convert_ip_addr (flagstr,cfgstr);
  if (status==0) status = convert_ip_addr (flagstr2,cfgstr);
  return status;
}
/*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/
/*&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&*/
/*--------------------------------------------------------------*/
int_u4 convert_ip_addr (char *flagstr, char *cfgstr) 
{
  int_u4 addr,port;
  int_4 jj = findflag(flagstr,cfgstr);
  if (jj<0) return 0;
  jj = numeric_ip(cfgstr+jj+strlen(flagstr)+1, &addr, &port);
  if (jj==0) return 0;
  return addr;
}
/*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/
/*&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&*/
/*--------------------------------------------------------------*/
int_u4 convert_ip_port (char *flagstr, char *cfgstr) 
{
  int_u4 addr,port;
  int_4 jj = findflag(flagstr,cfgstr);
  if (jj<0) return 0;
  jj = numeric_ip(cfgstr+jj+strlen(flagstr)+1, &addr, &port);
  if (jj<=1) return 0;
  return port;
}
/*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/
/*&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&*/
/*--------------------------------------------------------------*/
int_4 pic_str2ip (PICSTRUCT *p, char *s) 
{
  int_u4 addr,port;
  int jj = numeric_ip(s, &addr, &port);
  if (jj==0) return 0;
  return addr;
}
/*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/
/*&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&*/
/*--------------------------------------------------------------*/
void send_ping(PICSTRUCT *p, int_4 mport,int_u4 destip_addr, int_u4 modip_addr,int_u2 vlan) {
   int_u2 tx_offset = 0;
   int_u2 arp_packet[32] = {0xFFFF,0xFFFF,0xFFFF,0x0000,0x0000,0x0000,0x0608,0x0100,
                            0x0008,0x0406,0x0100,0x0000,0x0000,0x0000,0x0000,0x0000,
                            0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
                            0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x3736};

   arp_packet[3]            = 0x6000;
   arp_packet[4]            = (int_u2) modip_addr;
   arp_packet[5]            = (int_u2) (modip_addr >> 16);
   
  if (sdds_vlan(p,mport) != -1)                             
    {
      memmove(arp_packet+8,arp_packet+6,24*sizeof(int_u2));        /* Make Room For VLAN Fields */
      vlan = ((vlan << 8) & 0xFF00) | ((vlan >> 8) & 0x00FF);      /* Convert Little E To Big E */
      arp_packet[6] = 0x0081;                                      /* 802.1Q Protocol */
      arp_packet[7] = vlan;                                        /* Set VLAN ID     */
      tx_offset     = 2;               
    }
   
   arp_packet[11+tx_offset] = 0x6000;
   arp_packet[12+tx_offset] = (int_u2) modip_addr;
   arp_packet[13+tx_offset] = (int_u2) (modip_addr >> 16);
   arp_packet[14+tx_offset] = (int_u2) modip_addr;
   arp_packet[15+tx_offset] = (int_u2) (modip_addr >> 16);

   arp_packet[19+tx_offset] = (int_u2) destip_addr;
   arp_packet[20+tx_offset] = (int_u2) (destip_addr >> 16);

   pic_sdds_sendpkt(p,mport,ARP_PACKET_ADDRESS,ARP_PACKET_SIZE,arp_packet,0);    
 } 
/*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/
/*&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&*/
/*--------------------------------------------------------------*/
int_4 sdds_set_active_vlan(PICSTRUCT *p,int_4 mport,int_u2 vlan)
 {
   if (p->isY)
     pic_wmodreg(p,mport,0x00100002,vlan,SDDS_NUM_PRG_BITS);   

   vlan = ((vlan << 8) & 0xFF00) | ((vlan >> 8) & 0x00FF);                       /* Convert Little E To Big E               */
     
   pic_wmodreg(p,mport,0,SDDS_TXDP_OP+TX_DATWRADDR+0x00AC,SDDS_NUM_PRG_BITS);    /* Write Address Adr Of VLAN Register      */    
   pic_wmodreg(p,mport,0,vlan,SDDS_NUM_PRG_BITS);                                /* Write VLAN To Earlier Specified Address */

   return(0);
 }  
/*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/
/*&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&*/
/*--------------------------------------------------------------*/
int_u1 calchash(int_u4 mcadr)
{
  int crc_poly[]  = {1,1,1,0,1,1,0,1,
                     1,0,1,1,1,0,0,0,
                     1,0,0,0,0,0,1,1,
                     0,0,1,0,0,0,0,0},CRC[33];
  unsigned char hash_index;
  unsigned char inaddr[6] = {0x01,0x00,0x5E,0x07,0x08,0x09};
  unsigned char hashindex,addrbyte;
  int Byte,Bit,j,dbit;

  inaddr[5] = (mcadr >> 24) & 0x000000FF;
  inaddr[4] = (mcadr >> 16) & 0x000000FF;
  inaddr[3] = (mcadr >>  8) & 0x000000FF;

  for (j=0;j<32;j++)
    CRC[j] = 1;
  for (Byte=0;Byte<6;Byte++)
    {
      addrbyte = inaddr[Byte];
      for (Bit=0;Bit<8;Bit++)
        {
          dbit = (addrbyte >> Bit) & 1;
          for(j=32;j>0;j--)
            CRC[j] = CRC[j-1];

          CRC[0] = 0;

          if ((dbit ^ CRC[32]) == 1)
            {
              for(j=0;j<32;j++)
                CRC[j] = CRC[j] ^ crc_poly[j]; 
            }
         }
    }
   hashindex = 0;
   for(Bit=0,hashindex=0;Bit<6;Bit++)
     hashindex = (hashindex << 1) + CRC[Bit];

   return(hashindex);
} 
/*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/
/*&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&*/
/*--------------------------------------------------------------*/  
int_4 xsdds_join_leave_group (PICSTRUCT *p, int_4 mport, int_4 joinleave, int_u4 groupaddr, int_u2 running)
{  
   int_u2 txadr_offset = 0x00AE;  /* Join Address Offset */
   int ii;
     
   if (joinleave < 0)  /* Leave */
     {
       txadr_offset = 0x00B0;  /* Leave Address Offset */  
       if (findflag("SDDSGENLV",p->config) < 0)   /* If Flag Not Preset, Cut Off Flow For ANY Leave Address */
         { 
           /* Write Down Strict Mode Addr MS Word */
            pic_wmodreg(p,mport,0,SDDS_RXDP_OP | RX_STRICTADDR,SDDS_NUM_PRG_BITS);        
            pic_wmodreg(p,mport,0,((int_u2)0),SDDS_NUM_PRG_BITS); 
            udelay(100);
      
           /* Write Down Strict Mode Addr LS Word */
            pic_wmodreg(p,mport,0,SDDS_RXDP_OP | RX_STRICTADDR,SDDS_NUM_PRG_BITS);        
            pic_wmodreg(p,mport,0,((int_u2)0),SDDS_NUM_PRG_BITS); 
            udelay(100);
         }
     }
   else
     {
       pic_wmodreg(p,mport,0,SDDS_RXDP_OP | RX_STRICTADDR,SDDS_NUM_PRG_BITS);        
       pic_wmodreg(p,mport,0,((int_u2)groupaddr),SDDS_NUM_PRG_BITS);         /* Write Down Strict Mode Addr MS Word */
       udelay(100);

       pic_wmodreg(p,mport,0,SDDS_RXDP_OP | RX_STRICTADDR,SDDS_NUM_PRG_BITS);        
       pic_wmodreg(p,mport,0,((int_u2)(groupaddr >> 16)),SDDS_NUM_PRG_BITS); /* Write Down Strict Mode Addr LS Word */
       udelay(100);       
     }   
   vprint("JOIN/LEAVE mport=%d dir=%d addr=%08x\n",mport,joinleave,groupaddr);
 
    /* If Dest IP Adr = Multicast, Setup Multicast HW Adr */ 
     if (((groupaddr & 0x000000ff) > 223) && ((groupaddr & 0x000000ff) < 240))
       {         
        for (ii=0;ii<1;ii++)   /* Send Out Leave/Join  */
          {   
           /* High-Write Address Adr Of Tx Data DP Buffer  */ 
           /* High-Write Data To Earlier Specified Address */     
            pic_wmodreg(p,mport,0,SDDS_TXDP_OP+TX_DATWRADDR+0x00AA,SDDS_NUM_PRG_BITS);      
            pic_wmodreg(p,mport,0,((int_u2) groupaddr),SDDS_NUM_PRG_BITS);              
            udelay(100);
           /* Low-Write Address Adr Of Tx Data DP Buffer   */
           /* Low-Write Data To Earlier Specified Address  */
            pic_wmodreg(p,mport,0,SDDS_TXDP_OP+TX_DATWRADDR+0x00AB,SDDS_NUM_PRG_BITS);               
            pic_wmodreg(p,mport,0,((int_u2) (groupaddr >> 16)),SDDS_NUM_PRG_BITS);               
            udelay(100);
           /* Write Address To Begin Transfer */ 
           /* Write Tx Size Of Transfer       */
            pic_wmodreg(p,mport,0,SDDS_TXDP_OP+TX_DATRDADDR+txadr_offset,SDDS_NUM_PRG_BITS);               
            pic_wmodreg(p,mport,0,32,SDDS_NUM_PRG_BITS);                                         
            udelay(10000);
          }
       }
     else
       {
         printf("Multicast Address %d.%d.%d.%d ",(int_u1)groupaddr,(int_u1)(groupaddr>>8),(int_u1)(groupaddr>>16),(int_u1)(groupaddr>>24));
         printf("Is Out Of Range Of 224.0.0.0 To 239.255.255.255\n"); 
       }   

 /*
   if (running==1)
    {   
      pic_wmodreg(p,mport,0,SDDS_CFGREG_OP,SDDS_NUM_PRG_BITS);
      pic_wmodreg(p,mport,0,0x0000,SDDS_NUM_PRG_BITS);         
      udelay(100);
      pic_wmodreg(p,mport,0,SDDS_CFGREG_OP,SDDS_NUM_PRG_BITS);
      pic_wmodreg(p,mport,0,0x0001,SDDS_NUM_PRG_BITS);          
    }
 */ 
   return(0);    
} 

/*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/
/*&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&*/
/*--------------------------------------------------------------*/
int_4 set_module_HW_IP_addr (PICSTRUCT *p, int_4 mport, int_u4 ip_addr, int_u2 vlan) 
{
  int_u2 vlan_offset = 0;



  /* In Case Of Ping After Reset */
  /****************************************************************/
  udelay(50000);
  pic_wmodreg(p,mport,0,SDDS_CFGREG_OP,SDDS_NUM_PRG_BITS); 
  pic_wmodreg(p,mport,0,0,SDDS_NUM_PRG_BITS); 

  pic_wmodreg(p,mport,0,SDDS_CFGDP_OP|0x004C,SDDS_NUM_PRG_BITS);  
  pic_wmodreg(p,mport,0,0x0002,SDDS_NUM_PRG_BITS);               

  pic_wmodreg(p,mport,0,SDDS_CFGDP_OP|0x004E,SDDS_NUM_PRG_BITS);  
  pic_wmodreg(p,mport,0,0x0003,SDDS_NUM_PRG_BITS);               
 
  /****************************************************************/

   if (sdds_vlan(p,mport) != -1)        
    {
      vlan_offset = 2;
      vlan = ((vlan << 8) & 0xFF00) | ((vlan >> 8) & 0x00FF); /* Convert Little E To Big E */
      
      pic_wmodreg(p,mport,0,SDDS_TXDP_OP|TX_DATWRADDR|0x0007,SDDS_NUM_PRG_BITS); /* Generic Pkt VLan */
      pic_wmodreg(p,mport,0,vlan,SDDS_NUM_PRG_BITS);

      pic_wmodreg(p,mport,0,SDDS_TXDP_OP|TX_DATWRADDR|0x0047,SDDS_NUM_PRG_BITS); /* ARP Pkt VLan     */
      pic_wmodreg(p,mport,0,vlan,SDDS_NUM_PRG_BITS);

      pic_wmodreg(p,mport,0,SDDS_TXDP_OP|TX_DATWRADDR|0x0067,SDDS_NUM_PRG_BITS); /* RARP Pkt VLan    */
      pic_wmodreg(p,mport,0,vlan,SDDS_NUM_PRG_BITS);

      pic_wmodreg(p,mport,0,SDDS_TXDP_OP|TX_DATWRADDR|0x0087,SDDS_NUM_PRG_BITS); /* IGMP Pkt VLan    */
      pic_wmodreg(p,mport,0,vlan,SDDS_NUM_PRG_BITS);

      pic_wmodreg(p,mport,0,SDDS_TXDP_OP|TX_DATWRADDR|0x00C7,SDDS_NUM_PRG_BITS); /* ICMP Pkt VLan    */
      pic_wmodreg(p,mport,0,vlan,SDDS_NUM_PRG_BITS);

      pic_wmodreg(p,mport,0,SDDS_TXDP_OP|TX_DATWRADDR|0x00AC,SDDS_NUM_PRG_BITS); /* Active VLan      */
      pic_wmodreg(p,mport,0,vlan,SDDS_NUM_PRG_BITS);

    }
      
 /* Set Tx IP Addresses    */
 /* SDDS Packet HW Address */
  pic_wmodreg(p,mport,0,SDDS_TXDP_OP|TX_DATWRADDR|0x0003,SDDS_NUM_PRG_BITS); /* Hi  Word */
  pic_wmodreg(p,mport,0,0x6000,SDDS_NUM_PRG_BITS);
  pic_wmodreg(p,mport,0,SDDS_TXDP_OP|TX_DATWRADDR|0x0004,SDDS_NUM_PRG_BITS); /* Mid Word */
  pic_wmodreg(p,mport,0,ip_addr,SDDS_NUM_PRG_BITS);  
  pic_wmodreg(p,mport,0,SDDS_TXDP_OP|TX_DATWRADDR|0x0005,SDDS_NUM_PRG_BITS); /* Low Word */
  pic_wmodreg(p,mport,0,(ip_addr >> 16),SDDS_NUM_PRG_BITS);
 /* SDDS Packet IP Address */ 
  pic_wmodreg(p,mport,0,(SDDS_TXDP_OP|TX_DATWRADDR|0x000D) + vlan_offset,SDDS_NUM_PRG_BITS); /* Hi  Word */
  pic_wmodreg(p,mport,0,ip_addr,SDDS_NUM_PRG_BITS);  
  pic_wmodreg(p,mport,0,(SDDS_TXDP_OP|TX_DATWRADDR|0x000E) + vlan_offset,SDDS_NUM_PRG_BITS); /* Low Word */
  pic_wmodreg(p,mport,0,(ip_addr >> 16),SDDS_NUM_PRG_BITS);

 /*  ARP Packet HW Address */
  pic_wmodreg(p,mport,0,SDDS_TXDP_OP|TX_DATWRADDR|0x0043,SDDS_NUM_PRG_BITS); /* Hi  Word */
  pic_wmodreg(p,mport,0,0x6000,SDDS_NUM_PRG_BITS);
  pic_wmodreg(p,mport,0,SDDS_TXDP_OP|TX_DATWRADDR|0x0044,SDDS_NUM_PRG_BITS); /* Mid Word */
  pic_wmodreg(p,mport,0,ip_addr,SDDS_NUM_PRG_BITS);  
  pic_wmodreg(p,mport,0,SDDS_TXDP_OP|TX_DATWRADDR|0x0045,SDDS_NUM_PRG_BITS); /* Low Word */
  pic_wmodreg(p,mport,0,(ip_addr >> 16),SDDS_NUM_PRG_BITS);
 /* ARP Packet HW Address  */
  pic_wmodreg(p,mport,0,(SDDS_TXDP_OP|TX_DATWRADDR|0x004B) + vlan_offset,SDDS_NUM_PRG_BITS); /* Hi  Word */
  pic_wmodreg(p,mport,0,0x6000,SDDS_NUM_PRG_BITS);
  pic_wmodreg(p,mport,0,(SDDS_TXDP_OP|TX_DATWRADDR|0x004C) + vlan_offset,SDDS_NUM_PRG_BITS); /* Mid Word */
  pic_wmodreg(p,mport,0,ip_addr,SDDS_NUM_PRG_BITS);  
  pic_wmodreg(p,mport,0,(SDDS_TXDP_OP|TX_DATWRADDR|0x004D) + vlan_offset,SDDS_NUM_PRG_BITS); /* Low Word */
  pic_wmodreg(p,mport,0,(ip_addr >> 16),SDDS_NUM_PRG_BITS);
 /* ARP Packet IP Address  */
  pic_wmodreg(p,mport,0,(SDDS_TXDP_OP|TX_DATWRADDR|0x004E) + vlan_offset,SDDS_NUM_PRG_BITS); /* Hi  Word */
  pic_wmodreg(p,mport,0,ip_addr,SDDS_NUM_PRG_BITS);  
  pic_wmodreg(p,mport,0,(SDDS_TXDP_OP|TX_DATWRADDR|0x004F) + vlan_offset,SDDS_NUM_PRG_BITS); /* Low Word */
  pic_wmodreg(p,mport,0,(ip_addr >> 16),SDDS_NUM_PRG_BITS);

 /* RARP Packet HW Address */
  pic_wmodreg(p,mport,0,SDDS_TXDP_OP|TX_DATWRADDR|0x0063,SDDS_NUM_PRG_BITS); /* Hi  Word */
  pic_wmodreg(p,mport,0,0x6000,SDDS_NUM_PRG_BITS);
  pic_wmodreg(p,mport,0,SDDS_TXDP_OP|TX_DATWRADDR|0x0064,SDDS_NUM_PRG_BITS); /* Mid Word */
  pic_wmodreg(p,mport,0,ip_addr,SDDS_NUM_PRG_BITS);  
  pic_wmodreg(p,mport,0,SDDS_TXDP_OP|TX_DATWRADDR|0x0065,SDDS_NUM_PRG_BITS); /* Low Word */
  pic_wmodreg(p,mport,0,(ip_addr >> 16),SDDS_NUM_PRG_BITS);
 /* RARP Packet HW Address */
  pic_wmodreg(p,mport,0,(SDDS_TXDP_OP|TX_DATWRADDR|0x006B) + vlan_offset,SDDS_NUM_PRG_BITS); /* Hi  Word */
  pic_wmodreg(p,mport,0,0x6000,SDDS_NUM_PRG_BITS);
  pic_wmodreg(p,mport,0,(SDDS_TXDP_OP|TX_DATWRADDR|0x006C) + vlan_offset,SDDS_NUM_PRG_BITS); /* Mid Word */
  pic_wmodreg(p,mport,0,ip_addr,SDDS_NUM_PRG_BITS);  
  pic_wmodreg(p,mport,0,(SDDS_TXDP_OP|TX_DATWRADDR|0x006D) + vlan_offset,SDDS_NUM_PRG_BITS); /* Low Word */
  pic_wmodreg(p,mport,0,(ip_addr >> 16),SDDS_NUM_PRG_BITS); 
 /* RARP Packet IP Address */
  pic_wmodreg(p,mport,0,(SDDS_TXDP_OP|TX_DATWRADDR|0x006E) + vlan_offset,SDDS_NUM_PRG_BITS); /* Hi  Word */
  pic_wmodreg(p,mport,0,ip_addr,SDDS_NUM_PRG_BITS);  
  pic_wmodreg(p,mport,0,(SDDS_TXDP_OP|TX_DATWRADDR|0x006F) + vlan_offset,SDDS_NUM_PRG_BITS); /* Low Word */
  pic_wmodreg(p,mport,0,(ip_addr >> 16),SDDS_NUM_PRG_BITS);

 /* IGMP Packet HW Address */
  pic_wmodreg(p,mport,0,SDDS_TXDP_OP|TX_DATWRADDR|0x0083,SDDS_NUM_PRG_BITS); /* Hi  Word */
  pic_wmodreg(p,mport,0,0x6000,SDDS_NUM_PRG_BITS);
  pic_wmodreg(p,mport,0,SDDS_TXDP_OP|TX_DATWRADDR|0x0084,SDDS_NUM_PRG_BITS); /* Mid Word */
  pic_wmodreg(p,mport,0,ip_addr,SDDS_NUM_PRG_BITS);  
  pic_wmodreg(p,mport,0,SDDS_TXDP_OP|TX_DATWRADDR|0x0085,SDDS_NUM_PRG_BITS); /* Low Word */
  pic_wmodreg(p,mport,0,(ip_addr >> 16),SDDS_NUM_PRG_BITS); 
 /* IGMP Packet IP Address */
  pic_wmodreg(p,mport,0,(SDDS_TXDP_OP|TX_DATWRADDR|0x008D) + vlan_offset,SDDS_NUM_PRG_BITS); /* Hi  Word */
  pic_wmodreg(p,mport,0,ip_addr,SDDS_NUM_PRG_BITS);  
  pic_wmodreg(p,mport,0,(SDDS_TXDP_OP|TX_DATWRADDR|0x008E) + vlan_offset,SDDS_NUM_PRG_BITS); /* Low Word */
  pic_wmodreg(p,mport,0,(ip_addr >> 16),SDDS_NUM_PRG_BITS);

 /* ICMP Packet HW Address */
  pic_wmodreg(p,mport,0,SDDS_TXDP_OP|TX_DATWRADDR|0x00C3,SDDS_NUM_PRG_BITS); /* Hi  Word */
  pic_wmodreg(p,mport,0,0x6000,SDDS_NUM_PRG_BITS);
  pic_wmodreg(p,mport,0,SDDS_TXDP_OP|TX_DATWRADDR|0x00C4,SDDS_NUM_PRG_BITS); /* Mid Word */
  pic_wmodreg(p,mport,0,ip_addr,SDDS_NUM_PRG_BITS);  
  pic_wmodreg(p,mport,0,SDDS_TXDP_OP|TX_DATWRADDR|0x00C5,SDDS_NUM_PRG_BITS); /* Low Word */
  pic_wmodreg(p,mport,0,(ip_addr >> 16),SDDS_NUM_PRG_BITS);
 /* ICMP Packet IP Address */
  pic_wmodreg(p,mport,0,(SDDS_TXDP_OP|TX_DATWRADDR|0x00CD) + vlan_offset,SDDS_NUM_PRG_BITS); /* Hi  Word */
  pic_wmodreg(p,mport,0,ip_addr,SDDS_NUM_PRG_BITS);  
  pic_wmodreg(p,mport,0,(SDDS_TXDP_OP|TX_DATWRADDR|0x00CE) + vlan_offset,SDDS_NUM_PRG_BITS); /* Low Word */
  pic_wmodreg(p,mport,0,(ip_addr >> 16),SDDS_NUM_PRG_BITS);
      
 /* Set Rx IP Addresses   */
 /* ARP Rx IP Address     */ 
  pic_wmodreg(p,mport,0,SDDS_RXDP_OP|RX_CPUWRADDR|0x0004,SDDS_NUM_PRG_BITS); /* Hi  Word */
  pic_wmodreg(p,mport,0,ip_addr,SDDS_NUM_PRG_BITS);
  pic_wmodreg(p,mport,0,SDDS_RXDP_OP|RX_CPUWRADDR|0x0007,SDDS_NUM_PRG_BITS); /* Low  Word */
  pic_wmodreg(p,mport,0,(ip_addr >> 16),SDDS_NUM_PRG_BITS);

 /* ICMP Rx IP Address    */
  pic_wmodreg(p,mport,0,SDDS_RXDP_OP|RX_CPUWRADDR|0x0047,SDDS_NUM_PRG_BITS); /* Hi  Word */
  pic_wmodreg(p,mport,0,ip_addr,SDDS_NUM_PRG_BITS);

  pic_wmodreg(p,mport,0,SDDS_RXDP_OP|RX_CPUWRADDR|0x004A,SDDS_NUM_PRG_BITS); /* Low  Word */
  pic_wmodreg(p,mport,0,(ip_addr >> 16),SDDS_NUM_PRG_BITS);  

  return 0;
 }
/*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/
/*&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&*/
/*--------------------------------------------------------------*/
int_4 pic_setup_udp (PICSTRUCT *p, int_4 mport, int_4 dir,int_4 rate, int_4 gain) 
{
   int_u4 udp_cfg_bits = 0;
   int_u4 cfg_bits     = 0;
  
   vprint("Setup UDP port=%d cfgbits=%d\n",mport,0x00000001);

   pic_wmodreg(p,mport,0,SDDS_CFGREG_OP,UDP_NUM_PRG_BITS);
   pic_wmodreg(p,mport,0,0x0000,UDP_NUM_PRG_BITS); /* Put In Reset */
   udelay(10);

   /* Add Preamble And/Or CRC Code */ 
   if (findflag("RXPREAMBEN",p->config) >= 0) 
     cfg_bits = cfg_bits | 0x0010;
   if (findflag("RXCRCEN",p->config) >= 0) 
     cfg_bits = cfg_bits | 0x0008;  
 
   pic_wmodreg(p,mport,0,SDDS_CFGDP_OP|0x0027,UDP_NUM_PRG_BITS); /* Write To Reg 7-Preamble Enable         */
   pic_wmodreg(p,mport,0,0x6FE3|cfg_bits,UDP_NUM_PRG_BITS);      /* Enable Preamble/CRC To Come With Packet */
   
   
/*******************************************************/ 
   if (findflag("RXRAWBURST",p->config) >= 0)
      udp_cfg_bits = udp_cfg_bits | RX_RAWBURST_VALUE;
   else 
     udp_cfg_bits = udp_cfg_bits | RX_RAWDATA_VALUE;

   pic_wmodreg(p,mport,0,SDDS_RXDP_OP | RX_CFGREGADDR,UDP_NUM_PRG_BITS);        
   pic_wmodreg(p,mport,0,udp_cfg_bits,UDP_NUM_PRG_BITS); /* Write down Rx DP Cfg Reg Data Value */
   udelay(10);
/*******************************************************/      
   if (findflag("NOLINK",p->config) >= 0){
     pic_wmodreg(p,mport,0,SDDS_CFGDP_OP|0x00F4,SDDS_NUM_PRG_BITS);
     pic_wmodreg(p,mport,0,0x0002,SDDS_NUM_PRG_BITS); /* Jump Instruction */

     pic_wmodreg(p,mport,0,SDDS_CFGDP_OP|0x00F5,SDDS_NUM_PRG_BITS);
     pic_wmodreg(p,mport,0,0x004F,SDDS_NUM_PRG_BITS); /* Address Beyond Auto-Neg*/

     pic_wmodreg(p,mport,0,SDDS_CFGREG_OP,UDP_NUM_PRG_BITS);
     pic_wmodreg(p,mport,0,0x0005,UDP_NUM_PRG_BITS); /* Remove Reset & Set NOLINK Bit*/
    }
   else {
     pic_wmodreg(p,mport,0,SDDS_CFGREG_OP,UDP_NUM_PRG_BITS);
     pic_wmodreg(p,mport,0,0x0001,UDP_NUM_PRG_BITS); /* Remove Reset */
   }

   vprint("Setup UDP port=%d cfgbits=%d\n",mport,udp_cfg_bits);
   return 0;
}

/*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/
/*&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&*/
/*--------------------------------------------------------------*/
int_4 pic_reset_sdds (PICSTRUCT *p, int_4 mport) 
{
 /* Put Module In Reset */ 
   pic_wmodreg(p,mport,0,SDDS_CFGREG_OP,SDDS_NUM_PRG_BITS); 
   pic_wmodreg(p,mport,0,0x0000,SDDS_NUM_PRG_BITS); 
   return 0;
} 

/*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/
/*&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&*/
/*--------------------------------------------------------------*/
int_4 pic_set_sddstxtcoffset(PICSTRUCT *p, int_4 mport, int_8 tcoffset)
{  
  if (p->mrev[mport-1] >= 5)
    {
      pic_wmodreg(p,mport,0,SDDS_CFGDP_OP|0x0100,SDDS_NUM_PRG_BITS);
      pic_wmodreg(p,mport,0,(int_u2)(tcoffset >> 48),SDDS_NUM_PRG_BITS);
      
      pic_wmodreg(p,mport,0,SDDS_CFGDP_OP|0x0100,SDDS_NUM_PRG_BITS);
      pic_wmodreg(p,mport,0,(int_u2)(tcoffset >> 32),SDDS_NUM_PRG_BITS);

      pic_wmodreg(p,mport,0,SDDS_CFGDP_OP|0x0100,SDDS_NUM_PRG_BITS);
      pic_wmodreg(p,mport,0,(int_u2)(tcoffset >> 16),SDDS_NUM_PRG_BITS);
  
      pic_wmodreg(p,mport,0,SDDS_CFGDP_OP|0x0100,SDDS_NUM_PRG_BITS);
      pic_wmodreg(p,mport,0,(int_u2)(tcoffset),SDDS_NUM_PRG_BITS);
    }

  return 0;

}
/*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/
/*&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&*/
/*--------------------------------------------------------------*/
int_4 pic_setup_sdds (PICSTRUCT *p, int_4 mport, int_4 dir,int_4 rate, int_4 bits) 
{
   
   int_u4 sdds_cfg_bits=0;
   int_u4 modaddr,ip_addr,initialjoin_addr;
   int_4 flagoffset,i,leak,ii;
   int_u2 portnum;
   int_4  modvlan; 
   int_u2 tx_offset = 2;     /* 2 Extra 16 Bit Words For VLAN Support */
   int_u2 ip_hdr[10]   = {0x0045, 0x5404, 0x0000, 0x0080, 0x1140, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000};
   int_u2 txsin[18]    = {0xFCAD, 0x00BE, 0xF063, 0xFABD, 0x9101, 0xFAAD, 0x9302, 0xFABA, 0x8F02,
                          0xFD63, 0xF0B2, 0xFAAA, 0xAD02, 0xF081, 0x0000, 0x0000, 0x0000, 0x0000};

   int_u2 txnsin[18]   = {0xECAA, 0x00B0, 0xF05E, 0xFCAB, 0x00B1, 0xF081, 0xECAA, 0x00B3, 0xF064,
                          0xFCAB, 0x00B4, 0xF081, 0xECAA, 0x00B6, 0xF06A, 0xFCAB, 0x00B7, 0xF081};

   int_u2 txvlsin[27]  = {0xFCAD, 0x00BE, 0xF058, 0xFAAF, 0x8701, 0xFABD, 0x9301, 0xFABA, 0x9102,
                          0xFAAD, 0x9502, 0xFD58, 0xF0BC, 0xFAAA, 0xAD03, 0xF07D, 0x0000, 0x0000, 
                          0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}; 

   int_u2 txvlnsin[27] = {0xECAA, 0x00B0, 0xF054, 0xECAB, 0x00B1, 0xF054, 0xFCAC, 0x00B2, 0xF07D,  
                          0xECAA, 0x00B3, 0xF05D, 0xECAB, 0x00B4, 0xF05D, 0xFCAC, 0x00B5, 0xF07D, 
                          0xECAA, 0x00B6, 0xF066, 0xECAB, 0x00B7, 0xF066, 0xFCAC, 0x00B8, 0xF07D};

   int_u2 ntransffaf  = 0;
   int_u2 ntransffae  = 0;
   int_u2 watermark   = 0x7F;
   int_u1 shortcrc;
   char flgname[20];
   int_u1 def = 1;
   int_u2 fifowmstart = 12; /* Valid Values 1 to 15, 8 Is Half Full, 15 Is Almost Full */      
   int_u4 pktperiod;      
   double txtcoffset;

   if (p->isY) pic_rmodreg (p,mport,0x00100000,&initialjoin_addr,SDDS_NUM_PRG_BITS); /* force resync */
      
  /* Put Module In Reset */ 
   pic_wmodreg(p,mport,0,SDDS_CFGREG_OP,SDDS_NUM_PRG_BITS); 
   pic_wmodreg(p,mport,0,0x0000,SDDS_NUM_PRG_BITS); 


  /* Clear 4 Group Join Addresses */
   for(i=0;i<4;i++)   /* Write Default Clear Values */
     {
       pic_wmodreg(p,mport,0,SDDS_TXDP_OP+TX_DATWRADDR + 0x00AD +(i*3),SDDS_NUM_PRG_BITS); 
       pic_wmodreg(p,mport,0,0xFFFF,SDDS_NUM_PRG_BITS);  

       pic_wmodreg(p,mport,0,SDDS_TXDP_OP+TX_DATWRADDR + 0x00AE +(i*3),SDDS_NUM_PRG_BITS); 
       pic_wmodreg(p,mport,0,0xFFFF,SDDS_NUM_PRG_BITS);


       pic_wmodreg(p,mport,0,SDDS_TXDP_OP+TX_DATWRADDR + 0x00AF +(i*3),SDDS_NUM_PRG_BITS); 
       pic_wmodreg(p,mport,0,0x0000,SDDS_NUM_PRG_BITS);
     }  
   
   /* IP Address Configuration   */
   if (mport == 1)   
     modaddr = convert_ip_addr2("IPADDR1","IPADDR",p->config);
   else    
     modaddr = convert_ip_addr2("IPADDR2","IPADDR",p->config);
   
   if (modaddr == 0) modaddr = SDDS_DEFAULT_MODULE_IP_ADDR;

   /* Check If VLAN Mode Enabled */
   modvlan = sdds_vlan(p,mport);

   if (modvlan == -1)         
    { /* VLAN Not Present */    
     tx_offset = 0;
     
     /* Write Non_VLAN, Non-Strict Instructs To Tx CPU */
     for (ii=0x58;ii<0x6A;ii++)
       {
         pic_wmodreg(p,mport,0,SDDS_TXDP_OP+TX_CPUWRADDR+ii,SDDS_NUM_PRG_BITS); 
         pic_wmodreg(p,mport,0,txnsin[ii-0x58],SDDS_NUM_PRG_BITS); 
         udelay(100);    
       }
      if (p->isY)
        pic_wmodreg(p,mport,0x00100002,0,SDDS_NUM_PRG_BITS); 
    }
   else
    {      
  
     /* Write VLAN, Non-Strict Instructs To Tx CPU */
      for (ii=0x4B;ii<0x66;ii++)
       {          
         pic_wmodreg(p,mport,0,SDDS_TXDP_OP+TX_CPUWRADDR+ii,SDDS_NUM_PRG_BITS); /* Change Tx Instructs  */
         pic_wmodreg(p,mport,0,txvlnsin[ii-0x4B],SDDS_NUM_PRG_BITS); 
         udelay(100);    
       }
       if (p->isY)
         pic_wmodreg(p,mport,0x00100002,modvlan,SDDS_NUM_PRG_BITS);
    }  
   
   set_module_HW_IP_addr(p,mport,modaddr,(int_u2)modvlan);
   
  /* Disable Rx Operation */ 
   pic_wmodreg(p,mport,0,SDDS_RXDP_OP | RX_ENREGADDR,SDDS_NUM_PRG_BITS);  /* Wrtie Down Adr Of Dis_Enable Reg             */ 
   pic_wmodreg(p,mport,0,0,SDDS_NUM_PRG_BITS);                            /* Write Down 1 To Enable                       */  

  /* Check For Desired GigExD Communications */
  /*  if(gigexd_coms(p,mport,modvlan) < 0) return(-1); */
  
   sdds_cfg_bits = 0;
   /* Rx Logic Configuration Code */ 
   if (dir <= 0) {
             
       pic_wmodreg(p,mport,0,SDDS_CFGDP_OP|0x004C,UDP_NUM_PRG_BITS);  /* Write To Reg 0x40-Input Enable  w/Reset */
       pic_wmodreg(p,mport,0,0x0002,SDDS_NUM_PRG_BITS);               /* Enable Input Of Module                  */

       pic_wmodreg(p,mport,0,SDDS_CFGDP_OP|0x004E,UDP_NUM_PRG_BITS);  /* Write To Reg 0x42-Input Enable wo/Reset */
       pic_wmodreg(p,mport,0,0x0003,SDDS_NUM_PRG_BITS);               /* Enable Input Of Module                  */

       if (findflag("MODDEBUG",p->config) >= 0)        /* Turn On Module Debug Clock & Debug Zero Non-Valid Data */                              
         sdds_cfg_bits |= RX_DEBUGMOD_VALUE;

       if (findflag("RXRAWBITS",p->config) >= 0 )      /* Bring 8b/10b Encoded Data            */
         sdds_cfg_bits |= RX_RAWBITS_VALUE;            /* Fastest Acquire Possible             */
      
       else if (findflag("RXRAWBURST",p->config) >= 0) /* Bring In All Packet wout/Tx Response */
         sdds_cfg_bits |= RX_RAWBURST_VALUE;          

       else if (findflag("RXRAWDATA",p->config) >= 0)  /* Bring In All Packets w/Tx Response   */
         sdds_cfg_bits |= RX_RAWDATA_VALUE;

       else if (findflag("RXRAWSDDS",p->config) >= 0)  /* Bring In SDDS Packet w/Hdr           */
         sdds_cfg_bits |= RX_RAWSDDS_VALUE;

       else if (findflag("RXPKTSDDS",p->config) >= 0)  /* Bring In SDDS Packet w/Hdr           */
         {
           sdds_cfg_bits |= (RX_ICESDDS_VALUE | RX_RAWSDDS_VALUE | RX_NSPKTEN_VALUE | RX_PRYPKTEN_VALUE);
           if (findflag("RXIPGDBG",p->config) >= 0)
             sdds_cfg_bits |= RX_IPGCHECK_VALUE;
         }

       else if (findflag("RXSDDSDATA",p->config) >= 0) 
         {
           if (findflag("RXTCBSWAP",p->config) >= 0)  /* Swap TC Bit 3 & Bit 0 For DCR Data   */
             sdds_cfg_bits |= RX_TCBSWAP_VALUE;
         

           if ((leak = findflag("SDDSLEAK",p->config)) >= 0)
             {           
              /* rate = 120 * 512/(53+16(n+32)) */
              if (leak<=8) leak=1; else leak=2; /* leak is now bps */
              leak = (int)( ((120.0e6 * 512) / ((double)rate*leak) - 53 -16*32)/16);
              vprint("Set SDDS leak cycle to %d every 32\n",leak);
              ntransffae = max(4,leak-2-3);  /* 2 extra pipeline delays in hardware, error fast */
              ntransffaf = 4;                /* Almost FULL  Set To Highest Possible Throttle Rate, Approx. 100MB/Sec */  
             }
         }
       else    /* Bring In SDDS Packet w/ICE Hdr-If No Flags Present Or RXICESDDS Present     */
         { 
           sdds_cfg_bits |= (RX_ICESDDS_VALUE | RX_RAWSDDS_VALUE | RX_DATCTRL_VALUE | RX_STRICT_VALUE);  

           if (findflag("RXNOSEQFILL",p->config) < 0)     /* Check Pkt Sequence, Insert 0s For Dropped Pkt */
             sdds_cfg_bits |= RX_SEQCHECK_VALUE; 
            
           if (findflag("RXALLOWPRYPKT",p->config) >= 0) /* Allow Acquisition Of SDDS Parity Pkts         */
              sdds_cfg_bits |= RX_PRYPKTEN_VALUE;

           if (findflag("RXALLOWNSPKT",p->config) >= 0)  /* Allow Acquisition Of Non-Standard SDDS Pkts   */
              sdds_cfg_bits |= RX_NSPKTEN_VALUE;

           if (findflag("RXIPGDBG",p->config) >= 0)      /* Turn On IPG Debug Counter Insertion           */     
             sdds_cfg_bits |= RX_IPGCHECK_VALUE;

           if (findflag("RXSTRICTOFF",p->config) >= 0)   /* Allow Multiple MC Joins                       */
              sdds_cfg_bits &= ~(RX_STRICT_VALUE);
           else
             {         
               if (findflag("RXNOMEMBUF",p->config) < 0) /* Bring Data Through DDR2 Memory-Default        */
                 sdds_cfg_bits |= RX_MEMBUFF_VALUE; 
     
              /* Initialize Strict Mode To Filter All Packets Except Module's Own IP Address */
               pic_wmodreg(p,mport,0,SDDS_RXDP_OP | RX_STRICTADDR,SDDS_NUM_PRG_BITS);        
               pic_wmodreg(p,mport,0,modaddr,SDDS_NUM_PRG_BITS);         /* Write Down Strict Mode Addr MS Word */

               pic_wmodreg(p,mport,0,SDDS_RXDP_OP | RX_STRICTADDR,SDDS_NUM_PRG_BITS);        
               pic_wmodreg(p,mport,0,(modaddr >> 16),SDDS_NUM_PRG_BITS); /* Write Down Strict Mode Addr LS Word */
                
               if (tx_offset==0)
                 {/* VLAN Not Present */
                  /* Write Non_VLAN, Strict Instructs To Tx CPU */
                   for (ii=0x58;ii<0x6A;ii++)
                     {
                       pic_wmodreg(p,mport,0,SDDS_TXDP_OP+TX_CPUWRADDR+ii,SDDS_NUM_PRG_BITS); /* Change Tx Instructs  */
                       pic_wmodreg(p,mport,0,txsin[ii-0x58],SDDS_NUM_PRG_BITS); 
                       udelay(100);    
                     } 
                 }
               else
                 {
                  /* Write VLAN, Strict Instructs To Tx CPU */
                   for (ii=0x4B;ii<0x66;ii++)
                     {                       
                       pic_wmodreg(p,mport,0,SDDS_TXDP_OP+TX_CPUWRADDR+ii,SDDS_NUM_PRG_BITS); /* Change Tx Instructs  */
                       pic_wmodreg(p,mport,0,txvlsin[ii-0x4B],SDDS_NUM_PRG_BITS); 
                       udelay(100);    
                     }
                 }  
             }  
            

            /* Set watermark,ntransffaf,& ntransffae According To Calculations */
            /* Watermark Samples = x * 64 Bytes, FIFO is 16K Bytes             */
            watermark = 0x7F;   
                           
         
            if ((leak = findflag("SDDSLEAK",p->config)) >= 0)
              {
              /* rate = 120 * 512/(53+16(n+32)) */
              if (leak<=8) leak=1; else leak=2; /* leak is now bps */
              leak = (int)( ((120.0e6 * 512) / ((double)rate*leak) - 53 -16*32)/16);
              vprint("Set SDDS leak cycle to %d every 32\n",leak);
              ntransffae = max(4,leak-2);  /* Almost EMPTY 2 extra pipeline delays in hardware, error exact         */
              ntransffaf = 4;              /* Almost FULL  Set To Highest Possible Throttle Rate, Approx. 100MB/Sec */  
              }


         /* Write New Watermark To MAC Chip */ 
          pic_wmodreg(p,mport,0,SDDS_CFGDP_OP|0x003F,SDDS_NUM_PRG_BITS);                /* Reset Watermarks To Half Full    */
          pic_wmodreg(p,mport,0,(watermark<<8)|0x007F,SDDS_NUM_PRG_BITS);
        }                                                       

       
      if ((ii = findintflag("RXFFWM",p->config)) >= 0)  /* &JEFF */
        {
          if ((ii <1) || (ii>15))
            {
              printf("ERR: FLAG RXFFWM Out of Range!\n");
              printf("Valid Range 1 to 15\n");
              return(-1); 
            }
          fifowmstart = ii;           
        }

      /* Write FIFO Start Transfer Size */
       pic_wmodreg(p,mport,0,SDDS_RXDP_OP | RX_FFWMREGADDR,SDDS_NUM_PRG_BITS);
       pic_wmodreg(p,mport,0,fifowmstart,SDDS_NUM_PRG_BITS); /* Set Large FIFO Transfer Start,1-Low,8-Half,15 High */

       /* Write Down Rx DP Cfg Reg Address and Cfg Operation */
       pic_wmodreg(p,mport,0,SDDS_RXDP_OP | RX_CFGREGADDR,SDDS_NUM_PRG_BITS);        
       pic_wmodreg(p,mport,0,sdds_cfg_bits,SDDS_NUM_PRG_BITS); /* Write Down Rx DP Cfg Reg Data Value */
       udelay(10);

       
       /* Write Down N Delay Values For ICESDDS Mode */ 
       pic_wmodreg(p,mport,0,SDDS_RXDP_OP | RX_NREGADDR,SDDS_NUM_PRG_BITS);        
       pic_wmodreg(p,mport,0,ntransffaf,SDDS_NUM_PRG_BITS);                     /* Write Down FFAF Wait Value */
       pic_wmodreg(p,mport,0,SDDS_RXDP_OP | RX_NREGADDR,SDDS_NUM_PRG_BITS);        
       pic_wmodreg(p,mport,0,ntransffae,SDDS_NUM_PRG_BITS);                     /* Write Down FFAF Wait Value */  

       /* Module Reset, Join Will Occur When Reset Removed   */        
       /* Look For Initial Join Address                      */             
       if ((mport==1) && ((findflag("IPCONN1",p->config) >=0) || (findflag("JOIN1",p->config) >=0)))           
         sdds_join_leave_group(p,mport,1,convert_ip_addr2("IPCONN1","JOIN1",p->config),0);
       else if ((mport==2) && ((findflag("IPCONN2",p->config) >=0) || (findflag("JOIN2",p->config) >=0)))           
         sdds_join_leave_group(p,mport,1,convert_ip_addr2("IPCONN2","JOIN2",p->config),0);
       else if ((findflag("IPCONN",p->config) >=0) || (findflag("JOIN",p->config) >=0))           
         sdds_join_leave_group(p,mport,1,convert_ip_addr2("IPCONN","JOIN",p->config),0);
  
     }
   else
    {
       if (((modvlan >= TXLOVLAN_RESTRICT) &&  (modvlan <= TXHIVLAN_RESTRICT)) && (findflag("TXVLANOVRIDE",p->config) < 0))
         {
           printf("Tx Of SDDS To VLANs In The Range Of %d To %d Disabled For",TXLOVLAN_RESTRICT,TXHIVLAN_RESTRICT);
           printf("SDDS Fabric(Network) Protection \n");
           printf("Flag TXVLANOVRIDE Overrides This Protection-Use Cautiously And Avoid Transmission Onto Actual SDDS Network\n");
           return(-1);
         }         

       /* Tx Logic Configuration Code                         */
       pic_wmodreg(p,mport,0,SDDS_CFGDP_OP|0x004C,UDP_NUM_PRG_BITS); /* Write To Reg 0x4C-Input Enable  w/Reset */
       pic_wmodreg(p,mport,0,0x0000,UDP_NUM_PRG_BITS);               /* Disable Input Of Module-Output Mode     */

       pic_wmodreg(p,mport,0,SDDS_CFGDP_OP|0x004E,UDP_NUM_PRG_BITS); /* Write To Reg 0x4E-Input Enable wo/Reset */
       pic_wmodreg(p,mport,0,0x0001,UDP_NUM_PRG_BITS);               /* Disable Input Of Module                 */

       /* Write down Rx DP Cfg Reg Address and Cfg Operation  */
       pic_wmodreg(p,mport,0,SDDS_RXDP_OP | RX_CFGREGADDR,SDDS_NUM_PRG_BITS);        
       pic_wmodreg(p,mport,0,RX_RAWDATA_VALUE,SDDS_NUM_PRG_BITS);    /* Write down Rx DP Cfg Reg Data Value     */ 

       /* Enable Rx Port Operation */
       /*  sdds_enable(p,mport,1); */ 

       /* Non Full Pakcet Header Data Configuration Output            */
       if (findflag("TXPKTSDDS",p->config) < 0) 
        { 

         sprintf (flgname,"TXDESTIP%d",mport);
         if (findflag(flgname,p->config) < 0) sprintf (flgname,"IPDEST%d",mport);
         if (findflag(flgname,p->config) < 0) {
           printf("For Raw Output, Flag %s Must Be Set To Dest IP Address\n",flgname);
           return(-1);
         }
         ip_addr = convert_ip_addr(flgname,p->config);  /* Find Address From Cfg String-Network Byte Ordered */
         portnum = convert_ip_port(flgname,p->config);  /* Find Port From Cfg String-Network Byte Ordered */
         if (portnum>0) {
            i       = portnum & 0x00FF;
            portnum = (int_u2) (((portnum >> 8) & 0x00FF) | ((i << 8) & 0x0000FF00));
            pic_wmodreg(p,mport,0,SDDS_TXDP_OP+TX_DATWRADDR+tx_offset+0x0012,SDDS_NUM_PRG_BITS); 
            pic_wmodreg(p,mport,0,portnum,SDDS_NUM_PRG_BITS);
         }

         ip_hdr[6]     = (int_u2) modaddr;
         ip_hdr[7]     = (int_u2) (modaddr >> 16);
         ip_hdr[8]     = (int_u2) ip_addr;
         ip_hdr[9]     = (int_u2) (ip_addr >> 16);
         ip_hdr[5]     = sdds_compute_checksum(10,ip_hdr);
          
         for(i=0;i<10;i++)   /* Write Down IP Header */
          {
            pic_wmodreg(p,mport,0,SDDS_TXDP_OP+TX_DATWRADDR+0x0007+tx_offset+i,SDDS_NUM_PRG_BITS); 
            pic_wmodreg(p,mport,0,ip_hdr[i],SDDS_NUM_PRG_BITS);
          }
         
         /* If Dest IP Adr = Multicast, Setup Multicast HW Adr */ 
         if (((ip_addr & 0x000000ff) > 223) && ((ip_addr & 0x000000ff) < 240))
           {
             pic_wmodreg(p,mport,0,SDDS_TXDP_OP+TX_DATWRADDR+0x0000,SDDS_NUM_PRG_BITS); 
             pic_wmodreg(p,mport,0,0x0001,SDDS_NUM_PRG_BITS);

             pic_wmodreg(p,mport,0,SDDS_TXDP_OP+TX_DATWRADDR+0x0001,SDDS_NUM_PRG_BITS); 
             pic_wmodreg(p,mport,0,(int_u2) ((ip_addr & 0x7f00)|0x005E),SDDS_NUM_PRG_BITS);
                
             pic_wmodreg(p,mport,0,SDDS_TXDP_OP+TX_DATWRADDR+0x0002,SDDS_NUM_PRG_BITS); 
             pic_wmodreg(p,mport,0,(int_u2) (int_u2) (ip_addr >> 16),SDDS_NUM_PRG_BITS);
           }
         else    
           send_ping(p,mport,ip_addr,modaddr,(int_u2)modvlan);  /* Not Multicast Adr, Need Ping To Get HW Adr */
        
        } /* !TXPKTSDDS */
  
       /* Set Data Size For Output 16 Bit Packing */   
        if (bits == 16)
          sdds_cfg_bits = sdds_cfg_bits | (3 << 1);
        else
          sdds_cfg_bits = sdds_cfg_bits | ((bits/4) << 1);

        sdds_cfg_bits = sdds_cfg_bits | 0x01; /* Set Tx Op For Non-ICE Data Mode */
              
       
        if (findflag("TXRAWDATA",p->config) >= 0)      /* Send Out SDDS Packet Without SDDS Hdr    */
         {
          /* This Mode Has ALWAYS Been 16 Bit Data */
           if (p->isX && bits != 16)
             {
               printf("TXRAWDATA mode requires 16 bit output data!\n");
               return(-1);
             }  

          /* Turn Off Pkt Count Add */ 
           pic_wmodreg(p,mport,0,SDDS_TXDP_OP+TX_CPUWRADDR+0x0002,SDDS_NUM_PRG_BITS); /* Address Of Hdr Move                  */
           pic_wmodreg(p,mport,0,0xE500,SDDS_NUM_PRG_BITS);

           pic_wmodreg(p,mport,0,SDDS_TXDP_OP+TX_CPUWRADDR+0x0003,SDDS_NUM_PRG_BITS); /* Change Data Transfer Size = 512/4 -1  */
           pic_wmodreg(p,mport,0,0xF600,SDDS_NUM_PRG_BITS);         

           pic_wmodreg(p,mport,0,SDDS_TXDP_OP+TX_CPUWRADDR+0x0004,SDDS_NUM_PRG_BITS); /* Change Data Transfer Size = 540/4 -1 */
           pic_wmodreg(p,mport,0,0x0086,SDDS_NUM_PRG_BITS);   

           pic_wmodreg(p,mport,0,SDDS_TXDP_OP+TX_CPUWRADDR+0x0005,SDDS_NUM_PRG_BITS); /* Change Data Transfer Size = 512/4 -1  */
           pic_wmodreg(p,mport,0,0xF0FF,SDDS_NUM_PRG_BITS);        

           sdds_cfg_bits = sdds_cfg_bits | (((int_u2) ((0x0015+tx_offset) & 0xFE)) << 2);    /* Header Trans Size-No SDDS Hdr */
         }
        else if (findflag("TXPKTSDDS",p->config) >= 0)
         {         
           if (p->isX && bits != 16)
             {
               printf("TXPKTSDDS mode requires 16 bit output data!\n");
               return(-1);
             }

           pic_wmodreg(p,mport,0,SDDS_TXDP_OP+TX_CPUWRADDR+0x0002,SDDS_NUM_PRG_BITS); 
           pic_wmodreg(p,mport,0,0xA600,SDDS_NUM_PRG_BITS); 

           pic_wmodreg(p,mport,0,SDDS_TXDP_OP+TX_CPUWRADDR+0x0003,SDDS_NUM_PRG_BITS); 
           pic_wmodreg(p,mport,0,0x0031+tx_offset,SDDS_NUM_PRG_BITS); 
      
           pic_wmodreg(p,mport,0,SDDS_TXDP_OP+TX_CPUWRADDR+0x0004,SDDS_NUM_PRG_BITS); /* Change Data Transfer Size = 512/4 -1  */
           pic_wmodreg(p,mport,0,0xF600,SDDS_NUM_PRG_BITS);  
       
           pic_wmodreg(p,mport,0,SDDS_TXDP_OP+TX_CPUWRADDR+0x0005,SDDS_NUM_PRG_BITS); /* Change Data Transfer Size = 512/4 -1  */
           pic_wmodreg(p,mport,0,0x007F,SDDS_NUM_PRG_BITS); 

           pic_wmodreg(p,mport,0,SDDS_TXDP_OP+TX_CPUWRADDR+0x0006,SDDS_NUM_PRG_BITS); /* Change Data Transfer Size = 512/4 -1  */
           pic_wmodreg(p,mport,0,0xF0FF,SDDS_NUM_PRG_BITS);   
 
            sdds_cfg_bits = sdds_cfg_bits | (((int_u2) ((0x0015+tx_offset) & 0xFE)) << 2);  /* Set For No-Endian Convert Of 16 Bit Data */
         } 
        else if (findflag("TXRAWSDDS",p->config) >= 0 || def)  /* Send Out In SDDS Packet w/SDDS Hdr       */
         {
          /* Turn On Pkt Count Add  */ 
           pic_wmodreg(p,mport,0,SDDS_TXDP_OP+TX_CPUWRADDR+0x0002,SDDS_NUM_PRG_BITS);   /* Address Of Hdr Move                  */
           pic_wmodreg(p,mport,0,0xC500,SDDS_NUM_PRG_BITS);                             
    
           pic_wmodreg(p,mport,0,SDDS_TXDP_OP+TX_CPUWRADDR+0x0003,SDDS_NUM_PRG_BITS); /* Change Data Transfer Size = 512/4 -1  */
           pic_wmodreg(p,mport,0,0xF600,SDDS_NUM_PRG_BITS);  
       
           pic_wmodreg(p,mport,0,SDDS_TXDP_OP+TX_CPUWRADDR+0x0004,SDDS_NUM_PRG_BITS); /* Change Data Transfer Size = 512/4 -1  */
           pic_wmodreg(p,mport,0,0x007F,SDDS_NUM_PRG_BITS); 

           pic_wmodreg(p,mport,0,SDDS_TXDP_OP+TX_CPUWRADDR+0x0005,SDDS_NUM_PRG_BITS); /* Change Data Transfer Size = 512/4 -1  */
           pic_wmodreg(p,mport,0,0xF0FF,SDDS_NUM_PRG_BITS);   

          /* Set Up Format Identifier Field */
           i = (bits << 8);
           if (bits ==  8) i = i | 0x0001;
           if (bits == 16) i = i | 0x0002;  
           i = i | 0x0080;                /* Set Standard SDDS Bit */
           pic_wmodreg(p,mport,0,SDDS_TXDP_OP+TX_DATWRADDR+0x0015+tx_offset,SDDS_NUM_PRG_BITS); 
           pic_wmodreg(p,mport,0,(int_u2)i,SDDS_NUM_PRG_BITS);


          /* SDDS Nibble & Byte Swap Mux Select Bits */
          /*************************************************/            
           if ((bits == 4) &&  (findintflag("BIGEND",p->config) < 0))
             sdds_cfg_bits = sdds_cfg_bits | 0x0100;      /* Set Nibble Swap Bit For Module Output Mux */
           
           if ((bits == 16) && (findintflag("BIGEND",p->config) >= 0))         
             sdds_cfg_bits = sdds_cfg_bits | 0x0200;      /* Set Byte   Swap Bit For Module Output Mux */
          /*************************************************/  

           sdds_cfg_bits = sdds_cfg_bits | (((int_u2) ((0x0031+tx_offset) & 0x00FE)) << 2);    /* Header Trans Size- With SDDS Hdr */
         }
     
      /* &BILL For Testing */
       txtcoffset = finddblflag("TXTCOFFSET",p->config);                                      /* User Start Timecode Offset        */
       if (txtcoffset != -1)
         pic_set_sddstxtcoffset(p,mport,(int_8)txtcoffset); 
         

      /* Compute Pkt Period */
       pktperiod = (int_u4) ((double)(4000000000.0/((double)rate)) * ((double)(8192/bits)));   /* # of 250pS Increments Per Packet */

      /* Write Down Pkt Rate For TC Insertion */ 
       pic_wmodreg(p,mport,0,SDDS_TXDP_OP | TX_CFGREGADDR,SDDS_NUM_PRG_BITS);
       pic_wmodreg(p,mport,0,(int_u2)(pktperiod>>16),SDDS_NUM_PRG_BITS);        
       pic_wmodreg(p,mport,0,SDDS_TXDP_OP | TX_CFGREGADDR,SDDS_NUM_PRG_BITS);
       pic_wmodreg(p,mport,0,(int_u2)pktperiod,SDDS_NUM_PRG_BITS); 

      /* Write down Tx DP Cfg Reg Data Value */
       pic_wmodreg(p,mport,0,SDDS_TXDP_OP | TX_CFGREGADDR,SDDS_NUM_PRG_BITS);
       pic_wmodreg(p,mport,0,sdds_cfg_bits,SDDS_NUM_PRG_BITS);  
   }  

   if (findflag("NOLINK",p->config) >= 0)
    { 
      printf("NOLINK******************************\n");

      pic_wmodreg(p,mport,0,SDDS_CFGDP_OP|0x00F4,SDDS_NUM_PRG_BITS);
      pic_wmodreg(p,mport,0,0x0002,SDDS_NUM_PRG_BITS);           

      pic_wmodreg(p,mport,0,SDDS_CFGDP_OP|0x00F5,SDDS_NUM_PRG_BITS);
      pic_wmodreg(p,mport,0,0x004F,SDDS_NUM_PRG_BITS);           /* Address Beyond Auto-Neg       */
     
      udelay(10);
      pic_wmodreg(p,mport,0,SDDS_CFGREG_OP,SDDS_NUM_PRG_BITS);
      pic_wmodreg(p,mport,0,0x0001|NOLINKBIT,SDDS_NUM_PRG_BITS); /* Remove Reset, Set NOLINK Bit  */
    
    }
 
  
   if(dir > 0)       /* If Module Is Output(Tx), Wait For Possible Ping Reply                     */ 
     udelay(100000); 

   vprint("Setup SDDS port=%d vlan=%d cfgbits=%d\n",mport,modvlan,0x0001);
   return 0;
}

/*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/
/*&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&*/
/*--------------------------------------------------------------*/
static int_4 pic_sdds_dump (PICSTRUCT *p, int_4 mport, int_4 flag)
{
   int_u4 mjtrdval,ipaddr;

  /* pic_wmodreg(p,mport,0x00100000,0xAAAAAAAA,SDDS_NUM_PRG_BITS);  */
  /* pic_wmodreg(p,mport,0x00100001,data,SDDS_NUM_PRG_BITS);        */

   printf("SDDS IOM Port=%d Debug Dump\n",mport);

   pic_rmodreg (p,mport,0x00000000,&mjtrdval,SDDS_NUM_PRG_BITS);
   printf(" CFG Instrs=%08x  0|Cnt|LastU|LastL\n",mjtrdval);

   pic_rmodreg (p,mport,0x00200000,&mjtrdval,SDDS_NUM_PRG_BITS);
   printf(" RX  Counts=%08x  Other|Data|Query|ARP\n",mjtrdval);

   pic_rmodreg (p,mport,0x00300000,&mjtrdval,SDDS_NUM_PRG_BITS);
   printf(" RX  Counts=%08x  0|0|SeqErr|CPUInt\n",mjtrdval);

   pic_rmodreg (p,mport,0x00400000,&mjtrdval,SDDS_NUM_PRG_BITS);
   printf(" TX  Counts=%08x  Cfg|RX|MCReply|Data\n",mjtrdval);

   pic_rmodreg (p,mport,0x00500000,&mjtrdval,SDDS_NUM_PRG_BITS);
   printf(" TX  Counts=%08x  0|0|0|CPUInt\n",mjtrdval);

   pic_rmodreg (p,mport,0x00100000,&mjtrdval,SDDS_NUM_PRG_BITS); ipaddr = (mjtrdval&0xFFFF);
   pic_rmodreg (p,mport,0x00100001,&mjtrdval,SDDS_NUM_PRG_BITS); ipaddr |= (mjtrdval<<16);
   pic_rmodreg (p,mport,0x00100002,&mjtrdval,SDDS_NUM_PRG_BITS);
   printf(" Last Join VLAN=%d ADDR=%08x\n",mjtrdval,ipaddr);

   return(0);

}

