/*
  Libraries shared between X-Midas & NeXtMidas for auto ramdisk configuration 
*/
typedef struct {
  int_4 ram_alloc;
  int_4 ram_start;
  int_4 ram_sized;
  int_4 ram_sizem;
  int_4 ram_page;
} RAMSTRUCT;

RAMSTRUCT RS={-1,-1,-1,-1};

RAMSTRUCT *getramstruct() {
  FILE *fp; int n;
  if (RS.ram_alloc>=0) return &RS;
  RS.ram_alloc=0; /* default */
  fp=fopen("/proc/driver/icepic","r");
  if (fp==NULL) { printf("Err opening /proc/driver/icepic. Defaulting to Manual RAM allocation."); return &RS; }
  n=fscanf(fp,"RamStart  : %d Mby\nRamDisk   : %d Mby\nRamMapped : %d Mby\nRamPage   : %d Kby\nRamAlloc  : %d\n",
         &RS.ram_start,&RS.ram_sized,&RS.ram_sizem,&RS.ram_page,&RS.ram_alloc);
  if (n!=5) { printf("Err parsing /proc/driver/icepic. Defaulting to Manual RAM allocation."); }
  fclose(fp);
  return &RS;
}

/*
  diffs for xm-4_8_2/xm/lib/xmidas/blockio.cc 

  IceBox> diff blockio.cc blockio.cc.orig
  894d893
  < #include "ramlib.c"
  966,970d964
  <       if (iiot->type==RAM && iiot->diskaddr<=0) {
  <         RAMSTRUCT *rs = getramstruct();
  <         iiot->diskaddr = (off_t)rs->ram_start*0x100000L;
  <         iiot->disksize = (off_t)rs->ram_sized*0x100000L;
  <       }
  IceBox> 

*/

