
/* AGX Temperature Functions */
static int_4 rst_mbx (PICSTRUCT *p);
static int_4 wr_mbx (PICSTRUCT *p, int_4 addr, int_4 data);
static int_4 rd_mbx (PICSTRUCT *p, int_4 addr);
static int_4 part_pic9 (PICSTRUCT *p, int_4 part, int_4 func, int_4 addr, int_4 data);

int_4 rst_mbx (PICSTRUCT *p)
{
  int_4 i, wadr, data;
  
  wadr = 0x120300;
  data = 0;
  for(i=0;i<8;i++) { 
    WR(REG_IOC, REG_IOC_ADDR|0x0700|i);
    if (i>3) {
      //printf("CMDADR: %d, 0x%02x\n",i,(wadr&(0xFF<<((i-4)*8)))>>((i-4)*8));
      WR(REG_IOC,(wadr&(0xFF<<((i-4)*8)))>>((i-4)*8));
    }  
    else {
      //printf("CMDDAT: %d, 0x%02x\n",i,(int_u4)(data&(0xFF<<(i*8)))>>(i*8));
      WR(REG_IOC, (int_u4)(data&(0xFF<<(i*8)))>>(i*8));
    }
  }

  return(0);
}

int_4 wr_mbx (PICSTRUCT *p, int_4 addr, int_4 data)
{
  int_4 i,j,wadr;
  
  for(j=0;j<2;j++) {
    wadr = 0x120000|(j<<8)|(addr&0xFF);
    v2print("JJB: WR wadr = 0x%x\n",wadr);
    for(i=0;i<8;i++) { 
      WR(REG_IOC, REG_IOC_ADDR|0x0700|i);
      if (i>3) {
        v2print("CMDADR: %d, 0x%02x\n",i,(wadr&(0xFF<<((i-4)*8)))>>((i-4)*8));
        WR(REG_IOC,(wadr&(0xFF<<((i-4)*8)))>>((i-4)*8));
      }  
      else {
        v2print("CMDDAT: %d, 0x%02x\n",i,(int_u4)(data&(0xFF<<(i*8)))>>(i*8));
        WR(REG_IOC, (int_u4)(data&(0xFF<<(i*8)))>>(i*8));
      }
    }
  }
  v2print("\n");
  return(0);
}

int_4 rd_mbx (PICSTRUCT *p, int_4 addr)
{
  int_4 i,j,wadr,data;
  
  for(j=0;j<2;j++) {
    wadr = (j==1)? 0x120200|(addr&0xFF) : 0x120000|(addr&0xFF);
    /*printf("JJB: RD wadr = 0x%x\n",wadr);*/
    for(i=0;i<8;i++) { 
      WR(REG_IOC, REG_IOC_ADDR|0x0700|i);
      if (i>3) {
        /*printf("CMDADR: %d, 0x%02x\n",i,(wadr&(0xFF<<((i-4)*8)))>>((i-4)*8));*/
        WR(REG_IOC,(wadr&(0xFF<<((i-4)*8)))>>((i-4)*8));
      }  
      else {
        /*printf("CMDDAT: %d, 0x%02x\n",i,(int_u4)(data&(0xFF<<(i*8)))>>(i*8));*/
        WR(REG_IOC, 0x0);
      }
    }
  }

  data = 0;
  for(i=0;i<4;i++) {
    WR(REG_IOC, REG_IOC_ADDR|0x0700|i);
    udelay(100);
    RD(REG_IOC, j);
    data = data|((j&0xFF)<<(i*8));
  }
  /*printf("CMDSTAT = 0x%x\n",data);*/

  data = 0;
  for(i=0;i<4;i++) {
    WR(REG_IOC, REG_IOC_ADDR|0x0700|(i+4));
    udelay(100);
    RD(REG_IOC, j);
    data = data|((j&0xFF)<<(i*8));
  }
  /*printf("CMDDAT = 0x%x\n",data);*/

  return(data);
}

int_4 part_pic9 (PICSTRUCT *p, int_4 part, int_4 func, int_4 addr, int_4 data)
{
  int_4 i,j,wadr;
  
  wadr = (part<<20)|(func<<16)|(addr&(0xFFFF));
  for(i=0;i<8;i++) { 
    WR(REG_IOC, REG_IOC_ADDR|0x0700|i);
    if (i>3) {
      v2print("CMDADR: %d, 0x%02x\n",i,(wadr&(0xFF<<((i-4)*8)))>>((i-4)*8));
      WR(REG_IOC,(wadr&(0xFF<<((i-4)*8)))>>((i-4)*8));
    }  
    else {
      v2print("CMDDAT: %d, 0x%02x\n",i,(int_u4)(data&(0xFF<<(i*8)))>>(i*8));
      WR(REG_IOC, (int_u4)(data&(0xFF<<(i*8)))>>(i*8));
    }
  }

  data = 0;
  if(func == 1 || func==3) {
    for(i=0;i<4;i++) {
      WR(REG_IOC, REG_IOC_ADDR|0x0700|i);
      udelay(100);
      RD(REG_IOC, j);
      data = data|((j&0xFF)<<(i*8));
    }
    printf("CMDSTAT = 0x%x\n",data);
  
    data = 0;
    for(i=0;i<4;i++) {
      WR(REG_IOC, REG_IOC_ADDR|0x0700|(i+4));
      udelay(100);
      RD(REG_IOC, j);
      data = data|((j&0xFF)<<(i*8));
    }
    printf("CMDDAT = 0x%x\n",data);
  }
  return(data);
}

