/*****************************************************************************/
/*                                                                           */
/* part_state.h - Generic register part that holds the current state of a    */
/*                module. It is up to the module_xyz.h file to define the    */
/*                register and pin contents for this part.                   */
/*                                                                           */ 
/*                                                                           */
/*****************************************************************************/
#ifndef _PART_STATE_H
#define _PART_STATE_H

#include "part_common.h"

/* STATE unique part identifier  */
enum STATE_PART_ID {
  PTID_STATE = FPGA_PTID_MODTYPE 
};

#ifdef BOGUS
#define PT_STATE_MAX_RG 64    /* 64 total registers of 32-bits each        */
#endif


#define PT_STATE_MAX_RG 24    /* 64 total registers of 32-bits each        */
                              /*   Only 61 available as upper 3 used (CRC) */

/* STATE Pin control Masks must be defined by the module type */

/* STATE Register ID's are defined by the module           */
/*       The generic handles are defined here.             */
enum STATE_RG_ID {
  STATE_RG_FCN      = (PT_STATE_MAX_RG-3), /* Function list to execute reg   */
  STATE_RG_PIN      = (PT_STATE_MAX_RG-2), /* Mirrors the PIN state in reg   */
  STATE_RG_CRC      = (PT_STATE_MAX_RG-1)  /* CRC quickly detects changes    */
};

typedef union {
  int32_t  i32[PT_STATE_MAX_RG];
  uint32_t u32[PT_STATE_MAX_RG];
} PT_STATE_Obj;

/* STATE Register Masks must be defined by the module type */

#endif  /* _PART_STATE_H */
