/*
 * Si5344 Rev D Configuration Register Export Header File
 *
 * This file represents a series of Silicon Labs Si5344 Rev D 
 * register writes that can be performed to load a single configuration 
 * on a device. It was created by a Silicon Labs ClockBuilder Pro
 * export tool.
 *
 * Part:		                                       Si5344 Rev D
 * Design ID:                                          x
 * Includes Pre/Post Download Control Register Writes: Yes
 * Created By:                                         ClockBuilder Pro v2.12.1 [2016-12-15]
 * Timestamp:                                          2017-03-03 16:18:24 GMT+00:00
 *
 * A complete design report corresponding to this export is included at the end 
 * of this header file.
 *
 */

#ifndef SI5344_REVD_REG_CONFIG_HEADER
#define SI5344_REVD_REG_CONFIG_HEADER

PT_SI5344_REG const si5344_d2awgm3_reg_defaults[SI5344_MAX_CFG_RG] =
{
	{ 0x0B, 0x24, 0xC0 },	{ 0x0B, 0x25, 0x00 },	{ 0x00, 0x0B, 0x68 },	{ 0x00, 0x16, 0x02 },
	{ 0x00, 0x17, 0xFC },	{ 0x00, 0x18, 0x11 },	{ 0x00, 0x19, 0xDD },	{ 0x00, 0x1A, 0xDF },
	{ 0x00, 0x2B, 0x0A },	{ 0x00, 0x2C, 0x0E },	{ 0x00, 0x2D, 0x00 },	{ 0x00, 0x2E, 0x00 },
	{ 0x00, 0x2F, 0x00 },	{ 0x00, 0x30, 0x39 },	{ 0x00, 0x31, 0x00 },	{ 0x00, 0x32, 0x39 },
	{ 0x00, 0x33, 0x00 },	{ 0x00, 0x34, 0x39 },	{ 0x00, 0x35, 0x00 },	{ 0x00, 0x36, 0x00 },
	{ 0x00, 0x37, 0x00 },	{ 0x00, 0x38, 0x39 },	{ 0x00, 0x39, 0x00 },	{ 0x00, 0x3A, 0x39 },
	{ 0x00, 0x3B, 0x00 },	{ 0x00, 0x3C, 0x39 },	{ 0x00, 0x3D, 0x00 },	{ 0x00, 0x3F, 0xEE },
	{ 0x00, 0x40, 0x04 },	{ 0x00, 0x41, 0x00 },	{ 0x00, 0x42, 0x0A },	{ 0x00, 0x43, 0x0A },
	{ 0x00, 0x44, 0x0A },	{ 0x00, 0x45, 0x0B },	{ 0x00, 0x46, 0x00 },	{ 0x00, 0x47, 0x96 },
	{ 0x00, 0x48, 0x96 },	{ 0x00, 0x49, 0x32 },	{ 0x00, 0x4A, 0x00 },	{ 0x00, 0x4B, 0x96 },
	{ 0x00, 0x4C, 0x96 },	{ 0x00, 0x4D, 0x32 },	{ 0x00, 0x4E, 0x50 },	{ 0x00, 0x4F, 0x55 },
	{ 0x00, 0x51, 0x00 },	{ 0x00, 0x52, 0x03 },	{ 0x00, 0x53, 0x03 },	{ 0x00, 0x54, 0x03 },
	{ 0x00, 0x55, 0x00 },	{ 0x00, 0x56, 0x03 },	{ 0x00, 0x57, 0x03 },	{ 0x00, 0x58, 0x03 },
	{ 0x00, 0x59, 0x54 },	{ 0x00, 0x5A, 0x00 },	{ 0x00, 0x5B, 0x00 },	{ 0x00, 0x5C, 0x00 },
	{ 0x00, 0x5D, 0x00 },	{ 0x00, 0x5E, 0x7C },	{ 0x00, 0x5F, 0x33 },	{ 0x00, 0x60, 0xB3 },
	{ 0x00, 0x61, 0x00 },	{ 0x00, 0x62, 0x7C },	{ 0x00, 0x63, 0x33 },	{ 0x00, 0x64, 0xB3 },
	{ 0x00, 0x65, 0x00 },	{ 0x00, 0x66, 0x7C },	{ 0x00, 0x67, 0x33 },	{ 0x00, 0x68, 0xB3 },
	{ 0x00, 0x69, 0x00 },	{ 0x00, 0x92, 0x02 },	{ 0x00, 0x93, 0xA0 },	{ 0x00, 0x95, 0x00 },
	{ 0x00, 0x96, 0xA0 },	{ 0x00, 0x98, 0xA0 },	{ 0x00, 0x9A, 0x02 },	{ 0x00, 0x9B, 0x70 },
	{ 0x00, 0x9D, 0x0C },	{ 0x00, 0x9E, 0x80 },	{ 0x00, 0xA0, 0x60 },	{ 0x00, 0xA2, 0x00 },
	{ 0x00, 0xA9, 0xE9 },	{ 0x00, 0xAA, 0xA3 },	{ 0x00, 0xAB, 0x00 },	{ 0x00, 0xAC, 0x00 },
	{ 0x00, 0xE5, 0x21 },	{ 0x00, 0xEA, 0x99 },	{ 0x00, 0xEB, 0xA2 },	{ 0x00, 0xEC, 0x00 },
	{ 0x00, 0xED, 0x00 },	{ 0x01, 0x02, 0x01 },	{ 0x01, 0x12, 0x01 },	{ 0x01, 0x13, 0x09 },
	{ 0x01, 0x14, 0x3B },	{ 0x01, 0x15, 0x28 },	{ 0x01, 0x17, 0x02 },	{ 0x01, 0x18, 0x09 },
	{ 0x01, 0x19, 0x3B },	{ 0x01, 0x1A, 0x28 },	{ 0x01, 0x26, 0x02 },	{ 0x01, 0x27, 0x09 },
	{ 0x01, 0x28, 0x3B },	{ 0x01, 0x29, 0x28 },	{ 0x01, 0x2B, 0x02 },	{ 0x01, 0x2C, 0x09 },
	{ 0x01, 0x2D, 0x3B },	{ 0x01, 0x2E, 0x28 },	{ 0x01, 0x3F, 0x00 },	{ 0x01, 0x40, 0x01 },
	{ 0x01, 0x41, 0x40 },	{ 0x01, 0x42, 0xFF },	{ 0x02, 0x06, 0x02 },	{ 0x02, 0x08, 0x00 },
	{ 0x02, 0x09, 0x00 },	{ 0x02, 0x0A, 0x00 },	{ 0x02, 0x0B, 0x00 },	{ 0x02, 0x0C, 0x00 },
	{ 0x02, 0x0D, 0x00 },	{ 0x02, 0x0E, 0x00 },	{ 0x02, 0x0F, 0x00 },	{ 0x02, 0x10, 0x00 },
	{ 0x02, 0x11, 0x00 },	{ 0x02, 0x12, 0x05 },	{ 0x02, 0x13, 0x00 },	{ 0x02, 0x14, 0x00 },
	{ 0x02, 0x15, 0x00 },	{ 0x02, 0x16, 0x00 },	{ 0x02, 0x17, 0x00 },	{ 0x02, 0x18, 0x01 },
	{ 0x02, 0x19, 0x00 },	{ 0x02, 0x1A, 0x00 },	{ 0x02, 0x1B, 0x00 },	{ 0x02, 0x1C, 0x05 },
	{ 0x02, 0x1D, 0x00 },	{ 0x02, 0x1E, 0x00 },	{ 0x02, 0x1F, 0x00 },	{ 0x02, 0x20, 0x00 },
	{ 0x02, 0x21, 0x00 },	{ 0x02, 0x22, 0x01 },	{ 0x02, 0x23, 0x00 },	{ 0x02, 0x24, 0x00 },
	{ 0x02, 0x25, 0x00 },	{ 0x02, 0x26, 0x05 },	{ 0x02, 0x27, 0x00 },	{ 0x02, 0x28, 0x00 },
	{ 0x02, 0x29, 0x00 },	{ 0x02, 0x2A, 0x00 },	{ 0x02, 0x2B, 0x00 },	{ 0x02, 0x2C, 0x01 },
	{ 0x02, 0x2D, 0x00 },	{ 0x02, 0x2E, 0x00 },	{ 0x02, 0x2F, 0x00 },	{ 0x02, 0x31, 0x0B },
	{ 0x02, 0x32, 0x0B },	{ 0x02, 0x33, 0x0B },	{ 0x02, 0x34, 0x0B },	{ 0x02, 0x35, 0x00 },
	{ 0x02, 0x36, 0x00 },	{ 0x02, 0x37, 0x00 },	{ 0x02, 0x38, 0xC0 },	{ 0x02, 0x39, 0x57 },
	{ 0x02, 0x3A, 0x01 },	{ 0x02, 0x3B, 0x00 },	{ 0x02, 0x3C, 0x00 },	{ 0x02, 0x3D, 0x92 },
	{ 0x02, 0x3E, 0xB2 },	{ 0x02, 0x50, 0x00 },	{ 0x02, 0x51, 0x00 },	{ 0x02, 0x52, 0x00 },
	{ 0x02, 0x53, 0x01 },	{ 0x02, 0x54, 0x00 },	{ 0x02, 0x55, 0x00 },	{ 0x02, 0x5C, 0x01 },
	{ 0x02, 0x5D, 0x00 },	{ 0x02, 0x5E, 0x00 },	{ 0x02, 0x5F, 0x3F },	{ 0x02, 0x60, 0x00 },
	{ 0x02, 0x61, 0x00 },	{ 0x02, 0x6B, 0x78 },	{ 0x02, 0x6C, 0x00 },	{ 0x02, 0x6D, 0x00 },
	{ 0x02, 0x6E, 0x00 },	{ 0x02, 0x6F, 0x00 },	{ 0x02, 0x70, 0x00 },	{ 0x02, 0x71, 0x00 },
	{ 0x02, 0x72, 0x00 },	{ 0x02, 0x94, 0xB0 },	{ 0x02, 0x96, 0x02 },	{ 0x02, 0x97, 0x02 },
	{ 0x02, 0x99, 0x02 },	{ 0x02, 0x9D, 0xD0 },	{ 0x02, 0x9E, 0x01 },	{ 0x02, 0x9F, 0x00 },
	{ 0x02, 0xA9, 0xCC },	{ 0x02, 0xAA, 0x04 },	{ 0x02, 0xAB, 0x00 },	{ 0x02, 0xB7, 0xFF },
	{ 0x03, 0x02, 0x00 },	{ 0x03, 0x03, 0x00 },	{ 0x03, 0x04, 0x00 },	{ 0x03, 0x05, 0x80 },
	{ 0x03, 0x06, 0x05 },	{ 0x03, 0x07, 0x00 },	{ 0x03, 0x08, 0x00 },	{ 0x03, 0x09, 0x00 },
	{ 0x03, 0x0A, 0x00 },	{ 0x03, 0x0B, 0x80 },	{ 0x03, 0x0C, 0x00 },	{ 0x03, 0x0D, 0x00 },
	{ 0x03, 0x0E, 0x00 },	{ 0x03, 0x0F, 0x00 },	{ 0x03, 0x10, 0x00 },	{ 0x03, 0x11, 0x00 },
	{ 0x03, 0x12, 0x00 },	{ 0x03, 0x13, 0x00 },	{ 0x03, 0x14, 0x00 },	{ 0x03, 0x15, 0x00 },
	{ 0x03, 0x16, 0x00 },	{ 0x03, 0x17, 0x00 },	{ 0x03, 0x18, 0x00 },	{ 0x03, 0x19, 0x00 },
	{ 0x03, 0x1A, 0x00 },	{ 0x03, 0x1B, 0x00 },	{ 0x03, 0x1C, 0x00 },	{ 0x03, 0x1D, 0x00 },
	{ 0x03, 0x1E, 0x00 },	{ 0x03, 0x1F, 0x00 },	{ 0x03, 0x20, 0x00 },	{ 0x03, 0x21, 0x00 },
	{ 0x03, 0x22, 0x00 },	{ 0x03, 0x23, 0x00 },	{ 0x03, 0x24, 0x00 },	{ 0x03, 0x25, 0x00 },
	{ 0x03, 0x26, 0x00 },	{ 0x03, 0x27, 0x00 },	{ 0x03, 0x28, 0x00 },	{ 0x03, 0x29, 0x00 },
	{ 0x03, 0x2A, 0x00 },	{ 0x03, 0x2B, 0x00 },	{ 0x03, 0x2C, 0x00 },	{ 0x03, 0x2D, 0x00 },
	{ 0x03, 0x38, 0x00 },	{ 0x03, 0x39, 0x1F },	{ 0x03, 0x3B, 0x00 },	{ 0x03, 0x3C, 0x00 },
	{ 0x03, 0x3D, 0x00 },	{ 0x03, 0x3E, 0x00 },	{ 0x03, 0x3F, 0x00 },	{ 0x03, 0x40, 0x00 },
	{ 0x03, 0x41, 0x00 },	{ 0x03, 0x42, 0x00 },	{ 0x03, 0x43, 0x00 },	{ 0x03, 0x44, 0x00 },
	{ 0x03, 0x45, 0x00 },	{ 0x03, 0x46, 0x00 },	{ 0x03, 0x47, 0x00 },	{ 0x03, 0x48, 0x00 },
	{ 0x03, 0x49, 0x00 },	{ 0x03, 0x4A, 0x00 },	{ 0x03, 0x4B, 0x00 },	{ 0x03, 0x4C, 0x00 },
	{ 0x03, 0x4D, 0x00 },	{ 0x03, 0x4E, 0x00 },	{ 0x03, 0x4F, 0x00 },	{ 0x03, 0x50, 0x00 },
	{ 0x03, 0x51, 0x00 },	{ 0x03, 0x52, 0x00 },	{ 0x03, 0x59, 0x00 },	{ 0x03, 0x5A, 0x00 },
	{ 0x03, 0x5B, 0x00 },	{ 0x03, 0x5C, 0x00 },	{ 0x03, 0x5D, 0x00 },	{ 0x03, 0x5E, 0x00 },
	{ 0x03, 0x5F, 0x00 },	{ 0x03, 0x60, 0x00 },	{ 0x04, 0x87, 0x03 },	{ 0x05, 0x02, 0x01 },
	{ 0x05, 0x08, 0x15 },	{ 0x05, 0x09, 0x24 },	{ 0x05, 0x0A, 0x0C },	{ 0x05, 0x0B, 0x0B },
	{ 0x05, 0x0C, 0x03 },	{ 0x05, 0x0D, 0x3F },	{ 0x05, 0x0E, 0x18 },	{ 0x05, 0x0F, 0x2C },
	{ 0x05, 0x10, 0x09 },	{ 0x05, 0x11, 0x08 },	{ 0x05, 0x12, 0x03 },	{ 0x05, 0x13, 0x3F },
	{ 0x05, 0x15, 0x00 },	{ 0x05, 0x16, 0x00 },	{ 0x05, 0x17, 0x00 },	{ 0x05, 0x18, 0x00 },
	{ 0x05, 0x19, 0xC0 },	{ 0x05, 0x1A, 0x02 },	{ 0x05, 0x1B, 0x00 },	{ 0x05, 0x1C, 0x00 },
	{ 0x05, 0x1D, 0x00 },	{ 0x05, 0x1E, 0x00 },	{ 0x05, 0x1F, 0x80 },	{ 0x05, 0x21, 0x2B },
	{ 0x05, 0x2A, 0x03 },	{ 0x05, 0x2B, 0x01 },	{ 0x05, 0x2C, 0x87 },	{ 0x05, 0x2D, 0x03 },
	{ 0x05, 0x2E, 0x19 },	{ 0x05, 0x2F, 0x19 },	{ 0x05, 0x31, 0x00 },	{ 0x05, 0x32, 0x42 },
	{ 0x05, 0x33, 0x03 },	{ 0x05, 0x34, 0x00 },	{ 0x05, 0x35, 0x00 },	{ 0x05, 0x36, 0x00 },
	{ 0x05, 0x37, 0x00 },	{ 0x05, 0x38, 0x00 },	{ 0x05, 0x39, 0x00 },	{ 0x05, 0x3A, 0x02 },
	{ 0x05, 0x3B, 0x03 },	{ 0x05, 0x3C, 0x00 },	{ 0x05, 0x3D, 0x11 },	{ 0x05, 0x3E, 0x06 },
	{ 0x05, 0x89, 0x0D },	{ 0x05, 0x8A, 0x00 },	{ 0x05, 0x9B, 0xD8 },	{ 0x05, 0x9D, 0x15 },
	{ 0x05, 0x9E, 0x26 },	{ 0x05, 0x9F, 0x0C },	{ 0x05, 0xA0, 0x0B },	{ 0x05, 0xA1, 0x03 },
	{ 0x05, 0xA2, 0x3F },	{ 0x05, 0xA6, 0x0B },	{ 0x08, 0x02, 0x35 },	{ 0x08, 0x03, 0x05 },
	{ 0x08, 0x04, 0x00 },	{ 0x08, 0x05, 0x00 },	{ 0x08, 0x06, 0x00 },	{ 0x08, 0x07, 0x00 },
	{ 0x08, 0x08, 0x00 },	{ 0x08, 0x09, 0x00 },	{ 0x08, 0x0A, 0x00 },	{ 0x08, 0x0B, 0x00 },
	{ 0x08, 0x0C, 0x00 },	{ 0x08, 0x0D, 0x00 },	{ 0x08, 0x0E, 0x00 },	{ 0x08, 0x0F, 0x00 },
	{ 0x08, 0x10, 0x00 },	{ 0x08, 0x11, 0x00 },	{ 0x08, 0x12, 0x00 },	{ 0x08, 0x13, 0x00 },
	{ 0x08, 0x14, 0x00 },	{ 0x08, 0x15, 0x00 },	{ 0x08, 0x16, 0x00 },	{ 0x08, 0x17, 0x00 },
	{ 0x08, 0x18, 0x00 },	{ 0x08, 0x19, 0x00 },	{ 0x08, 0x1A, 0x00 },	{ 0x08, 0x1B, 0x00 },
	{ 0x08, 0x1C, 0x00 },	{ 0x08, 0x1D, 0x00 },	{ 0x08, 0x1E, 0x00 },	{ 0x08, 0x1F, 0x00 },
	{ 0x08, 0x20, 0x00 },	{ 0x08, 0x21, 0x00 },	{ 0x08, 0x22, 0x00 },	{ 0x08, 0x23, 0x00 },
	{ 0x08, 0x24, 0x00 },	{ 0x08, 0x25, 0x00 },	{ 0x08, 0x26, 0x00 },	{ 0x08, 0x27, 0x00 },
	{ 0x08, 0x28, 0x00 },	{ 0x08, 0x29, 0x00 },	{ 0x08, 0x2A, 0x00 },	{ 0x08, 0x2B, 0x00 },
	{ 0x08, 0x2C, 0x00 },	{ 0x08, 0x2D, 0x00 },	{ 0x08, 0x2E, 0x00 },	{ 0x08, 0x2F, 0x00 },
	{ 0x08, 0x30, 0x00 },	{ 0x08, 0x31, 0x00 },	{ 0x08, 0x32, 0x00 },	{ 0x08, 0x33, 0x00 },
	{ 0x08, 0x34, 0x00 },	{ 0x08, 0x35, 0x00 },	{ 0x08, 0x36, 0x00 },	{ 0x08, 0x37, 0x00 },
	{ 0x08, 0x38, 0x00 },	{ 0x08, 0x39, 0x00 },	{ 0x08, 0x3A, 0x00 },	{ 0x08, 0x3B, 0x00 },
	{ 0x08, 0x3C, 0x00 },	{ 0x08, 0x3D, 0x00 },	{ 0x08, 0x3E, 0x00 },	{ 0x08, 0x3F, 0x00 },
	{ 0x08, 0x40, 0x00 },	{ 0x08, 0x41, 0x00 },	{ 0x08, 0x42, 0x00 },	{ 0x08, 0x43, 0x00 },
	{ 0x08, 0x44, 0x00 },	{ 0x08, 0x45, 0x00 },	{ 0x08, 0x46, 0x00 },	{ 0x08, 0x47, 0x00 },
	{ 0x08, 0x48, 0x00 },	{ 0x08, 0x49, 0x00 },	{ 0x08, 0x4A, 0x00 },	{ 0x08, 0x4B, 0x00 },
	{ 0x08, 0x4C, 0x00 },	{ 0x08, 0x4D, 0x00 },	{ 0x08, 0x4E, 0x00 },	{ 0x08, 0x4F, 0x00 },
	{ 0x08, 0x50, 0x00 },	{ 0x08, 0x51, 0x00 },	{ 0x08, 0x52, 0x00 },	{ 0x08, 0x53, 0x00 },
	{ 0x08, 0x54, 0x00 },	{ 0x08, 0x55, 0x00 },	{ 0x08, 0x56, 0x00 },	{ 0x08, 0x57, 0x00 },
	{ 0x08, 0x58, 0x00 },	{ 0x08, 0x59, 0x00 },	{ 0x08, 0x5A, 0x00 },	{ 0x08, 0x5B, 0x00 },
	{ 0x08, 0x5C, 0x00 },	{ 0x08, 0x5D, 0x00 },	{ 0x08, 0x5E, 0x00 },	{ 0x08, 0x5F, 0x00 },
	{ 0x08, 0x60, 0x00 },	{ 0x08, 0x61, 0x00 },	{ 0x09, 0x0E, 0x03 },	{ 0x09, 0x43, 0x01 },
	{ 0x09, 0x49, 0x0E },	{ 0x09, 0x4A, 0x0E },	{ 0x09, 0x4E, 0x49 },	{ 0x09, 0x4F, 0x02 },
	{ 0x09, 0x5E, 0x00 },	{ 0x0A, 0x02, 0x00 },	{ 0x0A, 0x03, 0x01 },	{ 0x0A, 0x04, 0x01 },
	{ 0x0A, 0x05, 0x01 },	{ 0x0B, 0x44, 0x2F },	{ 0x0B, 0x46, 0x00 },	{ 0x0B, 0x47, 0x00 },
	{ 0x0B, 0x48, 0x01 },	{ 0x0B, 0x4A, 0x0E },	{ 0x0B, 0x57, 0xC5 },	{ 0x0B, 0x58, 0x01 },
	{ 0x05, 0x14, 0x01 },	{ 0x00, 0x1C, 0x01 },	{ 0x0B, 0x24, 0xC3 },	{ 0x0B, 0x25, 0x02 },

};

/*
 * Design Report
 *
 * Overview
 * ========
 * Part:         Si5344 Rev D
 * Design ID:    x
 * Created By:   ClockBuilder Pro v2.12.1 [2016-12-15]
 * Timestamp:    2017-03-03 16:18:23 GMT+00:00
 * 
 * Design Rule Check
 * =================
 * Errors:
 * - No errors
 * 
 * Warnings:
 * - No warnings
 * 
 * Device Grade
 * ============
 * Maximum Output Frequency: 320 MHz
 * Frequency Synthesis Mode: Integer
 * Frequency Plan Grade:     D
 * Minimum Base OPN:         Si5344D*
 * 
 * Base       Output Clock         Supported Frequency Synthesis Modes
 * OPN Grade  Frequency Range      (Typical Jitter)
 * ---------  -------------------  --------------------------------------------
 * Si5344A    100 Hz to 1.028 GHz  Integer (< 100 fs) and fractional (< 150 fs)
 * Si5344B    100 Hz to 350 MHz    "
 * Si5344C    100 Hz to 1.028 GHz  Integer only (< 100 fs)
 * Si5344D*   100 Hz to 350 MHz    "
 * 
 * * Based on your calculated frequency plan, a Si5344D grade device is
 * sufficient for your design. For more in-system configuration flexibility
 * (higher frequencies and/or to enable fractional synthesis), consider
 * selecting device grade Si5344A when specifying an ordering part number (OPN)
 * for your application. See the datasheet Ordering Guide for more information.
 * 
 * Design
 * ======
 * Host Interface:
 *    I/O Power Supply: VDDA (3.3V)
 *    SPI Mode: 3-Wire
 *    I2C Address Range: 104d to 107d / 0x68 to 0x6B (selected via A0/A1 pins)
 * 
 * XA/XB:
 *    28.57125 MHz [ 28 + 457/800 MHz ] (XO - External Oscillator)
 *    [ 114.285/4 MHz ]
 * 
 * Inputs:
 *     IN0: Unused
 *     IN1: 10 MHz
 *          Standard
 *     IN2: 10 MHz
 *          Standard
 *     IN3: ZDM - 10 MHz
 *          Standard
 * 
 * Outputs:
 *    OUT0: Unused
 *    OUT1: 320 MHz
 *          Enabled, LVDS 2.5 V
 *    OUT2: 320 MHz
 *          Enabled, LVDS 2.5 V
 *    OUT3: ZDM - 10 MHz
 *          Enabled, LVDS 2.5 V
 * 
 * Frequency Plan
 * ==============
 * Fvco = 14.08 GHz [ 14 + 2/25 GHz ]
 * Fpfd = 2 MHz
 * Fms0 = 1.28 GHz [ 1 + 7/25 GHz ]
 * 
 * P dividers:
 *    P0  = Unused
 *    P1  = 5
 *    P2  = 5
 *    P3  = 5
 *    Pxaxb = 1
 * 
 * MXAXB = 492.8030800192501203... [ 492 + 18356/22857 ]
 * M = 1408
 * N dividers:
 *    N0 (Zero Delay):
 *       Value: 11
 *       Skew:  0.000 s
 *       OUT1: 320 MHz
 *       OUT2: 320 MHz
 *       OUT3: 10 MHz
 *    N1:
 *       Unused
 *    N2:
 *       Unused
 *    N3:
 *       Unused
 * 
 * R dividers:
 *    R0 = Unused
 *    R1 = 4
 *    R2 = 4
 *    R3 = 128
 * 
 * Nominal Bandwidth:
 *   Desired: 100.000 Hz
 *   Actual:  104.245 Hz
 *   Coefficients:
 *      BW0:  21
 *      BW1:  36
 *      BW2:  12
 *      BW3:  11
 *      BW4:  3
 *      BW5:  63
 * Fastlock Bandwidth:
 *   Desired: 1.000 kHz
 *   Actual:  834.913 Hz
 *   Coefficients:
 *      BW0:  24
 *      BW1:  44
 *      BW2:  9
 *      BW3:  8
 *      BW4:  3
 *      BW5:  63
 * Holdover Bandwidth:
 *   Desired: 100.000 Hz
 *   Actual:  104.245 Hz
 *   Coefficients:
 *      BW0:  21
 *      BW1:  38
 *      BW2:  12
 *      BW3:  11
 *      BW4:  3
 *      BW5:  63
 * 
 * Dividers listed above show effective values. These values are translated to register settings by ClockBuilder Pro. For the actual register values, see below. Refer to the Family Reference Manual for information on registers related to frequency plan.
 * 
 * Digitally Controlled Oscillator (DCO)
 * =====================================
 * Mode: Register Direct Write
 * 
 * N0: DCO Disabled
 * 
 * N1: DCO Disabled
 * 
 * N2: DCO Disabled
 * 
 * N3: DCO Disabled
 * 
 * Estimated Power & Junction Temperature
 * ======================================
 * Assumptions:
 * 
 * Revision: D
 * VDD:      1.8 V
 * Ta:       70 C
 * Airflow:  None
 * 
 * Total Power: 684 mW, On Chip Power: 666 mW, Tj: 85 C
 * 
 *         Frequency  Format   Voltage   Current     Power
 *         ---------  ------  --------  --------  --------
 * VDD                           1.8 V   96.8 mA    174 mW
 * VDDA                          3.3 V  117.4 mA    387 mW
 * VDDO0      Unused                                      
 * VDDO1     320 MHz  LVDS       2.5 V   17.0 mA     43 mW
 * VDDO2     320 MHz  LVDS       2.5 V   17.0 mA     43 mW
 * VDDO3      10 MHz  LVDS       2.5 V   15.0 mA     37 mW
 *                                      --------  --------
 *                               Total  263.2 mA    684 mW
 * 
 * Note:
 * 
 * -Total power includes on- and off-chip power. This is a typical value and estimate only.
 * -Use an EVB for a more exact power measurement
 * -On-chip power excludes power dissipated in external terminations.
 * -Tj is junction temperature. Tj must be less than 125 C (on Si5344 Revision D) for device to comply with datasheet specifications.
 * 
 * Settings
 * ========
 * 
 * Location      Setting Name           Decimal Value  Hex Value       
 * ------------  ---------------------  -------------  ----------------
 * 0x000B[6:0]   I2C_ADDR               104            0x68            
 * 0x0016[1]     LOL_ON_HOLD            1              0x1             
 * 0x0017[0]     SYSINCAL_INTR_MSK      0              0x0             
 * 0x0017[1]     LOSXAXB_INTR_MSK       0              0x0             
 * 0x0017[5]     SMB_TMOUT_INTR_MSK     1              0x1             
 * 0x0018[3:0]   LOS_INTR_MSK           1              0x1             
 * 0x0018[7:4]   OOF_INTR_MSK           1              0x1             
 * 0x0019[1]     LOL_INTR_MSK           0              0x0             
 * 0x0019[5]     HOLD_INTR_MSK          0              0x0             
 * 0x001A[5]     CAL_INTR_MSK           0              0x0             
 * 0x002B[3]     SPI_3WIRE              1              0x1             
 * 0x002B[5]     AUTO_NDIV_UPDATE       0              0x0             
 * 0x002C[3:0]   LOS_EN                 14             0xE             
 * 0x002C[4]     LOSXAXB_DIS            0              0x0             
 * 0x002D[1:0]   LOS0_VAL_TIME          0              0x0             
 * 0x002D[3:2]   LOS1_VAL_TIME          0              0x0             
 * 0x002D[5:4]   LOS2_VAL_TIME          0              0x0             
 * 0x002D[7:6]   LOS3_VAL_TIME          0              0x0             
 * 0x002E[15:0]  LOS0_TRG_THR           0              0x0000          
 * 0x0030[15:0]  LOS1_TRG_THR           57             0x0039          
 * 0x0032[15:0]  LOS2_TRG_THR           57             0x0039          
 * 0x0034[15:0]  LOS3_TRG_THR           57             0x0039          
 * 0x0036[15:0]  LOS0_CLR_THR           0              0x0000          
 * 0x0038[15:0]  LOS1_CLR_THR           57             0x0039          
 * 0x003A[15:0]  LOS2_CLR_THR           57             0x0039          
 * 0x003C[15:0]  LOS3_CLR_THR           57             0x0039          
 * 0x003F[3:0]   OOF_EN                 14             0xE             
 * 0x003F[7:4]   FAST_OOF_EN            14             0xE             
 * 0x0040[2:0]   OOF_REF_SEL            4              0x4             
 * 0x0041[4:0]   OOF0_DIV_SEL           0              0x00            
 * 0x0042[4:0]   OOF1_DIV_SEL           10             0x0A            
 * 0x0043[4:0]   OOF2_DIV_SEL           10             0x0A            
 * 0x0044[4:0]   OOF3_DIV_SEL           10             0x0A            
 * 0x0045[4:0]   OOFXO_DIV_SEL          11             0x0B            
 * 0x0046[7:0]   OOF0_SET_THR           0              0x00            
 * 0x0047[7:0]   OOF1_SET_THR           150            0x96            
 * 0x0048[7:0]   OOF2_SET_THR           150            0x96            
 * 0x0049[7:0]   OOF3_SET_THR           50             0x32            
 * 0x004A[7:0]   OOF0_CLR_THR           0              0x00            
 * 0x004B[7:0]   OOF1_CLR_THR           150            0x96            
 * 0x004C[7:0]   OOF2_CLR_THR           150            0x96            
 * 0x004D[7:0]   OOF3_CLR_THR           50             0x32            
 * 0x004E[2:0]   OOF0_DETWIN_SEL        0              0x0             
 * 0x004E[6:4]   OOF1_DETWIN_SEL        5              0x5             
 * 0x004F[2:0]   OOF2_DETWIN_SEL        5              0x5             
 * 0x004F[6:4]   OOF3_DETWIN_SEL        5              0x5             
 * 0x0051[3:0]   FAST_OOF0_SET_THR      0              0x0             
 * 0x0052[3:0]   FAST_OOF1_SET_THR      3              0x3             
 * 0x0053[3:0]   FAST_OOF2_SET_THR      3              0x3             
 * 0x0054[3:0]   FAST_OOF3_SET_THR      3              0x3             
 * 0x0055[3:0]   FAST_OOF0_CLR_THR      0              0x0             
 * 0x0056[3:0]   FAST_OOF1_CLR_THR      3              0x3             
 * 0x0057[3:0]   FAST_OOF2_CLR_THR      3              0x3             
 * 0x0058[3:0]   FAST_OOF3_CLR_THR      3              0x3             
 * 0x0059[1:0]   FAST_OOF0_DETWIN_SEL   0              0x0             
 * 0x0059[3:2]   FAST_OOF1_DETWIN_SEL   1              0x1             
 * 0x0059[5:4]   FAST_OOF2_DETWIN_SEL   1              0x1             
 * 0x0059[7:6]   FAST_OOF3_DETWIN_SEL   1              0x1             
 * 0x005A[25:0]  OOF0_RATIO_REF         0              0x0000000       
 * 0x005E[25:0]  OOF1_RATIO_REF         11744124       0x0B3337C       
 * 0x0062[25:0]  OOF2_RATIO_REF         11744124       0x0B3337C       
 * 0x0066[25:0]  OOF3_RATIO_REF         11744124       0x0B3337C       
 * 0x0092[1]     LOL_FST_EN             1              0x1             
 * 0x0093[7:4]   LOL_FST_DETWIN_SEL     10             0xA             
 * 0x0095[3:2]   LOL_FST_VALWIN_SEL     0              0x0             
 * 0x0096[7:4]   LOL_FST_SET_THR_SEL    10             0xA             
 * 0x0098[7:4]   LOL_FST_CLR_THR_SEL    10             0xA             
 * 0x009A[1]     LOL_SLOW_EN_PLL        1              0x1             
 * 0x009B[7:4]   LOL_SLW_DETWIN_SEL     7              0x7             
 * 0x009D[3:2]   LOL_SLW_VALWIN_SEL     3              0x3             
 * 0x009E[7:4]   LOL_SLW_SET_THR        8              0x8             
 * 0x00A0[7:4]   LOL_SLW_CLR_THR        6              0x6             
 * 0x00A2[1]     LOL_TIMER_EN           0              0x0             
 * 0x00A9[28:0]  LOL_CLR_DELAY_DIV256   41961          0x0000A3E9      
 * 0x00E5[5]     FASTLOCK_EXTEND_EN     1              0x1             
 * 0x00EA[28:0]  FASTLOCK_EXTEND        41625          0x0000A299      
 * 0x0102[0]     OUTALL_DISABLE_LOW     1              0x1             
 * 0x0112[0]     OUT0_PDN               1              0x1             
 * 0x0112[1]     OUT0_OE                0              0x0             
 * 0x0112[2]     OUT0_RDIV_FORCE2       0              0x0             
 * 0x0113[2:0]   OUT0_FORMAT            1              0x1             
 * 0x0113[3]     OUT0_SYNC_EN           1              0x1             
 * 0x0113[5:4]   OUT0_DIS_STATE         0              0x0             
 * 0x0113[7:6]   OUT0_CMOS_DRV          0              0x0             
 * 0x0114[3:0]   OUT0_CM                11             0xB             
 * 0x0114[6:4]   OUT0_AMPL              3              0x3             
 * 0x0115[2:0]   OUT0_MUX_SEL           0              0x0             
 * 0x0115[5:4]   OUT0_VDD_SEL           2              0x2             
 * 0x0115[3]     OUT0_VDD_SEL_EN        1              0x1             
 * 0x0115[7:6]   OUT0_INV               0              0x0             
 * 0x0117[0]     OUT1_PDN               0              0x0             
 * 0x0117[1]     OUT1_OE                1              0x1             
 * 0x0117[2]     OUT1_RDIV_FORCE2       0              0x0             
 * 0x0118[2:0]   OUT1_FORMAT            1              0x1             
 * 0x0118[3]     OUT1_SYNC_EN           1              0x1             
 * 0x0118[5:4]   OUT1_DIS_STATE         0              0x0             
 * 0x0118[7:6]   OUT1_CMOS_DRV          0              0x0             
 * 0x0119[3:0]   OUT1_CM                11             0xB             
 * 0x0119[6:4]   OUT1_AMPL              3              0x3             
 * 0x011A[2:0]   OUT1_MUX_SEL           0              0x0             
 * 0x011A[5:4]   OUT1_VDD_SEL           2              0x2             
 * 0x011A[3]     OUT1_VDD_SEL_EN        1              0x1             
 * 0x011A[7:6]   OUT1_INV               0              0x0             
 * 0x0126[0]     OUT2_PDN               0              0x0             
 * 0x0126[1]     OUT2_OE                1              0x1             
 * 0x0126[2]     OUT2_RDIV_FORCE2       0              0x0             
 * 0x0127[2:0]   OUT2_FORMAT            1              0x1             
 * 0x0127[3]     OUT2_SYNC_EN           1              0x1             
 * 0x0127[5:4]   OUT2_DIS_STATE         0              0x0             
 * 0x0127[7:6]   OUT2_CMOS_DRV          0              0x0             
 * 0x0128[3:0]   OUT2_CM                11             0xB             
 * 0x0128[6:4]   OUT2_AMPL              3              0x3             
 * 0x0129[2:0]   OUT2_MUX_SEL           0              0x0             
 * 0x0129[5:4]   OUT2_VDD_SEL           2              0x2             
 * 0x0129[3]     OUT2_VDD_SEL_EN        1              0x1             
 * 0x0129[7:6]   OUT2_INV               0              0x0             
 * 0x012B[0]     OUT3_PDN               0              0x0             
 * 0x012B[1]     OUT3_OE                1              0x1             
 * 0x012B[2]     OUT3_RDIV_FORCE2       0              0x0             
 * 0x012C[2:0]   OUT3_FORMAT            1              0x1             
 * 0x012C[3]     OUT3_SYNC_EN           1              0x1             
 * 0x012C[5:4]   OUT3_DIS_STATE         0              0x0             
 * 0x012C[7:6]   OUT3_CMOS_DRV          0              0x0             
 * 0x012D[3:0]   OUT3_CM                11             0xB             
 * 0x012D[6:4]   OUT3_AMPL              3              0x3             
 * 0x012E[2:0]   OUT3_MUX_SEL           0              0x0             
 * 0x012E[5:4]   OUT3_VDD_SEL           2              0x2             
 * 0x012E[3]     OUT3_VDD_SEL_EN        1              0x1             
 * 0x012E[7:6]   OUT3_INV               0              0x0             
 * 0x013F[11:0]  OUTX_ALWAYS_ON         256            0x100           
 * 0x0141[1]     OUT_DIS_MSK            0              0x0             
 * 0x0141[5]     OUT_DIS_LOL_MSK        0              0x0             
 * 0x0141[6]     OUT_DIS_LOSXAXB_MSK    1              0x1             
 * 0x0141[7]     OUT_DIS_MSK_LOS_PFD    0              0x0             
 * 0x0142[1]     OUT_DIS_MSK_LOL        1              0x1             
 * 0x0142[5]     OUT_DIS_MSK_HOLD       1              0x1             
 * 0x0206[1:0]   PXAXB                  0              0x0             
 * 0x0208[47:0]  P0_NUM                 0              0x000000000000  
 * 0x020E[31:0]  P0_DEN                 0              0x00000000      
 * 0x0212[47:0]  P1_NUM                 5              0x000000000005  
 * 0x0218[31:0]  P1_DEN                 1              0x00000001      
 * 0x021C[47:0]  P2_NUM                 5              0x000000000005  
 * 0x0222[31:0]  P2_DEN                 1              0x00000001      
 * 0x0226[47:0]  P3_NUM                 5              0x000000000005  
 * 0x022C[31:0]  P3_DEN                 1              0x00000001      
 * 0x0231[3:0]   P0_FRACN_MODE          11             0xB             
 * 0x0231[4]     P0_FRACN_EN            0              0x0             
 * 0x0232[3:0]   P1_FRACN_MODE          11             0xB             
 * 0x0232[4]     P1_FRACN_EN            0              0x0             
 * 0x0233[3:0]   P2_FRACN_MODE          11             0xB             
 * 0x0233[4]     P2_FRACN_EN            0              0x0             
 * 0x0234[3:0]   P3_FRACN_MODE          11             0xB             
 * 0x0234[4]     P3_FRACN_EN            0              0x0             
 * 0x0235[43:0]  MXAXB_NUM              1476395008000  0x157C0000000   
 * 0x023B[31:0]  MXAXB_DEN              2995912704     0xB2920000      
 * 0x0250[23:0]  R0_REG                 0              0x000000        
 * 0x0253[23:0]  R1_REG                 1              0x000001        
 * 0x025C[23:0]  R2_REG                 1              0x000001        
 * 0x025F[23:0]  R3_REG                 63             0x00003F        
 * 0x026B[7:0]   DESIGN_ID0             120            0x78            
 * 0x026C[7:0]   DESIGN_ID1             0              0x00            
 * 0x026D[7:0]   DESIGN_ID2             0              0x00            
 * 0x026E[7:0]   DESIGN_ID3             0              0x00            
 * 0x026F[7:0]   DESIGN_ID4             0              0x00            
 * 0x0270[7:0]   DESIGN_ID5             0              0x00            
 * 0x0271[7:0]   DESIGN_ID6             0              0x00            
 * 0x0272[7:0]   DESIGN_ID7             0              0x00            
 * 0x0294[7:4]   FASTLOCK_EXTEND_SCL    11             0xB             
 * 0x0296[1]     LOL_SLW_VALWIN_SELX    1              0x1             
 * 0x0297[1]     FASTLOCK_DLY_ONSW_EN   1              0x1             
 * 0x0299[1]     FASTLOCK_DLY_ONLOL_EN  1              0x1             
 * 0x029D[19:0]  FASTLOCK_DLY_ONLOL     464            0x001D0         
 * 0x02A9[19:0]  FASTLOCK_DLY_ONSW      1228           0x004CC         
 * 0x02B7[3:2]   LOL_NOSIG_TIME         3              0x3             
 * 0x0302[43:0]  N0_NUM                 23622320128    0x00580000000   
 * 0x0308[31:0]  N0_DEN                 2147483648     0x80000000      
 * 0x030C[0]     N0_UPDATE              0              0x0             
 * 0x030D[43:0]  N1_NUM                 0              0x00000000000   
 * 0x0313[31:0]  N1_DEN                 0              0x00000000      
 * 0x0317[0]     N1_UPDATE              0              0x0             
 * 0x0318[43:0]  N2_NUM                 0              0x00000000000   
 * 0x031E[31:0]  N2_DEN                 0              0x00000000      
 * 0x0322[0]     N2_UPDATE              0              0x0             
 * 0x0323[43:0]  N3_NUM                 0              0x00000000000   
 * 0x0329[31:0]  N3_DEN                 0              0x00000000      
 * 0x032D[0]     N3_UPDATE              0              0x0             
 * 0x0338[1]     N_UPDATE               0              0x0             
 * 0x0339[4:0]   N_FSTEP_MSK            31             0x1F            
 * 0x033B[43:0]  N0_FSTEPW              0              0x00000000000   
 * 0x0341[43:0]  N1_FSTEPW              0              0x00000000000   
 * 0x0347[43:0]  N2_FSTEPW              0              0x00000000000   
 * 0x034D[43:0]  N3_FSTEPW              0              0x00000000000   
 * 0x0359[15:0]  N0_DELAY               0              0x0000          
 * 0x035B[15:0]  N1_DELAY               0              0x0000          
 * 0x035D[15:0]  N2_DELAY               0              0x0000          
 * 0x035F[15:0]  N3_DELAY               0              0x0000          
 * 0x0487[0]     ZDM_EN                 1              0x1             
 * 0x0487[2:1]   ZDM_IN_SEL             1              0x1             
 * 0x0487[4]     ZDM_AUTOSW_EN          0              0x0             
 * 0x0502[4]     ADD_DIV256             0              0x0             
 * 0x0508[5:0]   BW0_PLL                21             0x15            
 * 0x0509[5:0]   BW1_PLL                36             0x24            
 * 0x050A[5:0]   BW2_PLL                12             0x0C            
 * 0x050B[5:0]   BW3_PLL                11             0x0B            
 * 0x050C[5:0]   BW4_PLL                3              0x03            
 * 0x050D[5:0]   BW5_PLL                63             0x3F            
 * 0x050E[5:0]   FASTLOCK_BW0_PLL       24             0x18            
 * 0x050F[5:0]   FASTLOCK_BW1_PLL       44             0x2C            
 * 0x0510[5:0]   FASTLOCK_BW2_PLL       9              0x09            
 * 0x0511[5:0]   FASTLOCK_BW3_PLL       8              0x08            
 * 0x0512[5:0]   FASTLOCK_BW4_PLL       3              0x03            
 * 0x0513[5:0]   FASTLOCK_BW5_PLL       63             0x3F            
 * 0x0515[55:0]  M_NUM                  3023656976384  0x0002C000000000
 * 0x051C[31:0]  M_DEN                  2147483648     0x80000000      
 * 0x0521[3:0]   M_FRAC_MODE            11             0xB             
 * 0x0521[4]     M_FRAC_EN              0              0x0             
 * 0x0521[5]     PLL_OUT_RATE_SEL       1              0x1             
 * 0x052A[0]     IN_SEL_REGCTRL         1              0x1             
 * 0x052A[3:1]   IN_SEL                 1              0x1             
 * 0x052B[0]     FASTLOCK_AUTO_EN       1              0x1             
 * 0x052B[1]     FASTLOCK_MAN           0              0x0             
 * 0x052C[0]     HOLD_EN                1              0x1             
 * 0x052C[3]     HOLD_RAMP_BYP          0              0x0             
 * 0x052C[4]     HOLDEXIT_BW_SEL1       0              0x0             
 * 0x052C[7:5]   RAMP_STEP_INTERVAL     4              0x4             
 * 0x052D[1]     HOLD_RAMPBYP_NOHIST    1              0x1             
 * 0x052E[4:0]   HOLD_HIST_LEN          25             0x19            
 * 0x052F[4:0]   HOLD_HIST_DELAY        25             0x19            
 * 0x0531[4:0]   HOLD_REF_COUNT_FRC     0              0x00            
 * 0x0532[23:0]  HOLD_15M_CYC_COUNT     834            0x000342        
 * 0x0535[0]     FORCE_HOLD             0              0x0             
 * 0x0536[1:0]   CLK_SWITCH_MODE        0              0x0             
 * 0x0536[2]     HSW_EN                 0              0x0             
 * 0x0537[3:0]   IN_LOS_MSK             0              0x0             
 * 0x0537[7:4]   IN_OOF_MSK             0              0x0             
 * 0x0538[2:0]   IN0_PRIORITY           0              0x0             
 * 0x0538[6:4]   IN1_PRIORITY           0              0x0             
 * 0x0539[2:0]   IN2_PRIORITY           0              0x0             
 * 0x0539[6:4]   IN3_PRIORITY           0              0x0             
 * 0x053A[1:0]   HSW_MODE               2              0x2             
 * 0x053A[3:2]   HSW_PHMEAS_CTRL        0              0x0             
 * 0x053B[9:0]   HSW_PHMEAS_THR         3              0x003           
 * 0x053D[4:0]   HSW_COARSE_PM_LEN      17             0x11            
 * 0x053E[4:0]   HSW_COARSE_PM_DLY      6              0x06            
 * 0x0589[12:0]  PFD_EN_DELAY           13             0x000D          
 * 0x059B[6]     HOLDEXIT_BW_SEL0       1              0x1             
 * 0x059B[7]     HOLDEXIT_STD_BO        1              0x1             
 * 0x059D[5:0]   HOLDEXIT_BW0           21             0x15            
 * 0x059E[5:0]   HOLDEXIT_BW1           38             0x26            
 * 0x059F[5:0]   HOLDEXIT_BW2           12             0x0C            
 * 0x05A0[5:0]   HOLDEXIT_BW3           11             0x0B            
 * 0x05A1[5:0]   HOLDEXIT_BW4           3              0x03            
 * 0x05A2[5:0]   HOLDEXIT_BW5           63             0x3F            
 * 0x05A6[2:0]   RAMP_STEP_SIZE         3              0x3             
 * 0x05A6[3]     RAMP_SWITCH_EN         1              0x1             
 * 0x0802[15:0]  FIXREGSA0              1333           0x0535          
 * 0x0804[7:0]   FIXREGSD0              0              0x00            
 * 0x0805[15:0]  FIXREGSA1              0              0x0000          
 * 0x0807[7:0]   FIXREGSD1              0              0x00            
 * 0x0808[15:0]  FIXREGSA2              0              0x0000          
 * 0x080A[7:0]   FIXREGSD2              0              0x00            
 * 0x080B[15:0]  FIXREGSA3              0              0x0000          
 * 0x080D[7:0]   FIXREGSD3              0              0x00            
 * 0x080E[15:0]  FIXREGSA4              0              0x0000          
 * 0x0810[7:0]   FIXREGSD4              0              0x00            
 * 0x0811[15:0]  FIXREGSA5              0              0x0000          
 * 0x0813[7:0]   FIXREGSD5              0              0x00            
 * 0x0814[15:0]  FIXREGSA6              0              0x0000          
 * 0x0816[7:0]   FIXREGSD6              0              0x00            
 * 0x0817[15:0]  FIXREGSA7              0              0x0000          
 * 0x0819[7:0]   FIXREGSD7              0              0x00            
 * 0x081A[15:0]  FIXREGSA8              0              0x0000          
 * 0x081C[7:0]   FIXREGSD8              0              0x00            
 * 0x081D[15:0]  FIXREGSA9              0              0x0000          
 * 0x081F[7:0]   FIXREGSD9              0              0x00            
 * 0x0820[15:0]  FIXREGSA10             0              0x0000          
 * 0x0822[7:0]   FIXREGSD10             0              0x00            
 * 0x0823[15:0]  FIXREGSA11             0              0x0000          
 * 0x0825[7:0]   FIXREGSD11             0              0x00            
 * 0x0826[15:0]  FIXREGSA12             0              0x0000          
 * 0x0828[7:0]   FIXREGSD12             0              0x00            
 * 0x0829[15:0]  FIXREGSA13             0              0x0000          
 * 0x082B[7:0]   FIXREGSD13             0              0x00            
 * 0x082C[15:0]  FIXREGSA14             0              0x0000          
 * 0x082E[7:0]   FIXREGSD14             0              0x00            
 * 0x082F[15:0]  FIXREGSA15             0              0x0000          
 * 0x0831[7:0]   FIXREGSD15             0              0x00            
 * 0x0832[15:0]  FIXREGSA16             0              0x0000          
 * 0x0834[7:0]   FIXREGSD16             0              0x00            
 * 0x0835[15:0]  FIXREGSA17             0              0x0000          
 * 0x0837[7:0]   FIXREGSD17             0              0x00            
 * 0x0838[15:0]  FIXREGSA18             0              0x0000          
 * 0x083A[7:0]   FIXREGSD18             0              0x00            
 * 0x083B[15:0]  FIXREGSA19             0              0x0000          
 * 0x083D[7:0]   FIXREGSD19             0              0x00            
 * 0x083E[15:0]  FIXREGSA20             0              0x0000          
 * 0x0840[7:0]   FIXREGSD20             0              0x00            
 * 0x0841[15:0]  FIXREGSA21             0              0x0000          
 * 0x0843[7:0]   FIXREGSD21             0              0x00            
 * 0x0844[15:0]  FIXREGSA22             0              0x0000          
 * 0x0846[7:0]   FIXREGSD22             0              0x00            
 * 0x0847[15:0]  FIXREGSA23             0              0x0000          
 * 0x0849[7:0]   FIXREGSD23             0              0x00            
 * 0x084A[15:0]  FIXREGSA24             0              0x0000          
 * 0x084C[7:0]   FIXREGSD24             0              0x00            
 * 0x084D[15:0]  FIXREGSA25             0              0x0000          
 * 0x084F[7:0]   FIXREGSD25             0              0x00            
 * 0x0850[15:0]  FIXREGSA26             0              0x0000          
 * 0x0852[7:0]   FIXREGSD26             0              0x00            
 * 0x0853[15:0]  FIXREGSA27             0              0x0000          
 * 0x0855[7:0]   FIXREGSD27             0              0x00            
 * 0x0856[15:0]  FIXREGSA28             0              0x0000          
 * 0x0858[7:0]   FIXREGSD28             0              0x00            
 * 0x0859[15:0]  FIXREGSA29             0              0x0000          
 * 0x085B[7:0]   FIXREGSD29             0              0x00            
 * 0x085C[15:0]  FIXREGSA30             0              0x0000          
 * 0x085E[7:0]   FIXREGSD30             0              0x00            
 * 0x085F[15:0]  FIXREGSA31             0              0x0000          
 * 0x0861[7:0]   FIXREGSD31             0              0x00            
 * 0x090E[0]     XAXB_EXTCLK_EN         1              0x1             
 * 0x0943[0]     IO_VDD_SEL             1              0x1             
 * 0x0949[3:0]   IN_EN                  14             0xE             
 * 0x0949[7:4]   IN_PULSED_CMOS_EN      0              0x0             
 * 0x094A[3:0]   INX_TO_PFD_EN          14             0xE             
 * 0x094E[11:0]  REFCLK_HYS_SEL         585            0x249           
 * 0x095E[0]     MXAXB_INTEGER          0              0x0             
 * 0x0A02[4:0]   N_ADD_0P5              0              0x00            
 * 0x0A03[4:0]   N_CLK_TO_OUTX_EN       1              0x01            
 * 0x0A04[4:0]   N_PIBYP                1              0x01            
 * 0x0A05[4:0]   N_PDNB                 1              0x01            
 * 0x0B44[3:0]   PDIV_FRACN_CLK_DIS     15             0xF             
 * 0x0B44[5]     FRACN_CLK_DIS_PLL      1              0x1             
 * 0x0B46[3:0]   LOS_CLK_DIS            0              0x0             
 * 0x0B47[4:0]   OOF_CLK_DIS            0              0x00            
 * 0x0B48[4:0]   OOF_DIV_CLK_DIS        1              0x01            
 * 0x0B4A[4:0]   N_CLK_DIS              14             0x0E            
 * 0x0B57[11:0]  VCO_RESET_CALCODE      453            0x1C5
 * 
 *
 */

#endif
