/*****************************************************************************/
/*                                                                           */
/* part_si5344.h                                                             */
/*                                                                           */
/*****************************************************************************/
#ifndef _PART_SI5344_H
#define _PART_SI5344_H

#include "part_common.h"

/* SI5344 unique part identifier  */
enum SI5344_PART_ID {
  PTID_SI5344 = FPGA_PTID_SI5344 
};

/* SI5344 Pin control Masks */
enum SI5344_PIN_MASK {
  SI5344_PIN_RESET = 0x00000001   /* Hardware reset pin */
};

enum SI5344_RG_ID {
  SI5344_RG_PAGE = 0x01,  /* Page Select */
};

enum SI5344_PARAMS {
  SI5344_MAX_CFG_RG = 448
};

typedef struct {
  uint8_t rp;    /* Register page       */
  uint8_t ra;    /* Register address    */
  uint8_t rv;    /* Register value      */
} PT_SI5344_REG;


/*---------------------------------------------------------------------------*/
/* Public function prototypes from part_si5344.c */

EXTERN_CDEFINE int32_t pt_si5344_rgc_default(PT_SI5344_REG *R, int32_t modid);

/*
EXTERN_CDEFINE int32_t pt_si5344_rgc_setbits(PT_SI5344_REG *R, uint8_t rgaddr, 
                                uint8_t rgmask, uint8_t rgval, uint8_t pgnum);
*/

/*---------------------------------------------------------------------------*/
/* Custom configuration selections from "ClockBuilder" software              */

#include "part_si5344_d2awgm3_defaults.h"

#endif  /* _PART_SI5344_H */
