/*****************************************************************************/
/*                                                                           */
/* part_si5338.h                                                             */
/*                                                                           */
/*****************************************************************************/
#ifndef _PART_SI5338_H
#define _PART_SI5338_H

#include "part_common.h"

/* SI5338 unique part identifier  */
enum SI5338_PART_ID {
  PTID_SI5338 = FPGA_PTID_SI5338 
};

/* SI5338 Pin control Masks */
enum SI5338_PIN_MASK {
  SI5338_PIN_RESET = 0x00000001   /* Hardware reset pin */
};

/* SI5338 Register ID's */
enum SI5338_RG_ID {
  SI5338_RG_000 =   0,  /* Chip revision                       */
  SI5338_RG_006 =   6,  /* LOS Indicator masks                 */
  SI5338_RG_027 =  27,  /* I2C configuration                   */
  SI5338_RG_029 =  29,  /* PFD input configuration             */
  SI5338_RG_347 = 347   /* Last freaking register on part!     */
};


/* SI5338 Register Keys and Masks */
enum SI5338_RG_MASK {
  SI5338_RGM_000_REVID      = 0x03,  /* Chip revision     */
  SI5338_RGM_006_LOS        = 0x04,  /* LOS Clkin mask    */
  SI5338_RGM_027_I2C        = 0x80,  /* I2C 1P8 Selection */
  SI5338_RGM_028_XTAL_FREQ  = 0x03,  /* Input reference freq selection   */
  SI5338_RGM_028_P1DIV_IN20 = 0x1C,  /* LSB's of P1 Divider Input Select */
  SI5338_RGM_029_P1DIV_IN43 = 0x18,  /* MSB's of P1 Divider Input Select */
  SI5338_RGM_029_P1DIV      = 0x07,  /* P1 Divider selection */
  SI5338_RGM_029_PFD_IN_REF = 0xE0,  /* PFD input reference selection */
  SI5338_RGM_030_PFD_IN_FB  = 0xE0,  /* PFD feedback input selection  */
  SI5338_RGM_028_P2DIV_IN00 = 0x20,  /* LSB's of P2 Divider input select */
  SI5338_RGM_030_P2DIV_IN21 = 0x18   /* MSB's of P2 Divider input select */
};


enum SI5338_PARAMS {
  SI5338_MAX_CFG_RG    = 351, /* Maximum configuration registers in part */
  SI5338_MAX_CFG_RG_PG = 256, /* Maximum registers in a "page"           */
  SI5338_MSX_NUM       = 5,   /* Four MSx outputs and feedback output    */
  SI5338_VCO_CHK_FREQ  = 512, /* Possible VCO freqs to check per MSx     */
  SI5338_MSX_FRACTION  = 8388608  /* Fractional component = 2^(30-7)     */
};

typedef struct {
  uint8_t ra;    /* Register address    */
  uint8_t rv;    /* Register value      */
  uint8_t rm;    /* Register mask       */
} PT_SI5338_REG;


typedef struct {
  int32_t   dbglvl;          /* Debug output level */
  int32_t   ms_critical;     /* ID {0,4} of MSx output with ZERO error */
  float64_t inp_ref_frq;     /* Input reference frequency (MHz) */
  float64_t pfd_frq;         /* Phase detector frequency  (MHz) */
  float64_t vco_frq;         /* VCO operating  frequency  (MHz) */
  float64_t clk_frq_des[5];  /* CLKx desired frequency (MHz)     */
  float64_t clk_frq_act[5];  /* CLKx calculated frequency (MHz)  */
  float64_t ms_frq_des[5];   /* MSx desired frequency (MHz)    (MSN=4) */
  float64_t ms_frq_act[5];   /* MSx calculated frequency (MHz) (MSN=4) */
  uint32_t  ms_rdividx[5];   /* Rx divider on MSx output           */
  uint32_t  ms_a[5];         /* MSx "a" coefficient     */
  uint32_t  ms_b[5];         /* MSx "b" coefficient     */
  uint32_t  ms_c[5];         /* MSx "c" coefficient     */
  uint32_t  ms_p1[5];        /* MSx P1 register (MSN=4) */
  uint32_t  ms_p2[5];        /* MSx P2 register (MSN=4) */
  uint32_t  ms_p3[5];        /* MSx P3 register (MSN=4) */
  uint8_t   p1dividx;        /* P1 Divider register value {0,5} */
  uint8_t   p2dividx;        /* P2 Divider register value {0,5} */
  float64_t k;               /* PLL parameter                   */
  float64_t q;               /* PLL parameter                   */
  uint8_t   pll_kphi;        /* PLL parameter                   */
  uint8_t   rsel;            /* PLL parameter                   */
  uint8_t   bwsel;           /* PLL parameter                   */
  uint8_t   vco_gain;        /* PLL parameter                   */
  uint8_t   mscal;           /* PLL parameter                   */
  uint8_t   ms_pec;          /* PLL parameter                   */
} PT_SI5338_MSCFG;


/*---------------------------------------------------------------------------*/
/* Public function prototypes from part_si5338.c */

EXTERN_CDEFINE int32_t pt_si5338_rgc_default(PT_SI5338_REG *R, int32_t modid);

EXTERN_CDEFINE int32_t pt_si5338_rgc_setbits(PT_SI5338_REG *R, uint8_t rgaddr, 
                                uint8_t rgmask, uint8_t rgval, uint8_t pgnum);

EXTERN_CDEFINE int32_t pt_si5338_msx_soln(PT_SI5338_REG *R, PT_SI5338_MSCFG *M);


/*---------------------------------------------------------------------------*/
/* Custom configuration selections from "ClockBuilder" software              */

#include "part_si5338_lb2dm3_defaults.h"
#include "part_si5338_d2rf_defaults.h"
#include "part_si5338_d2awgm3_defaults.h"

#endif  /* _PART_SI5338_H */
