/*****************************************************************************/
/*                                                                           */
/* part_pe43204.h                                                           */
/*                                                                           */
/*****************************************************************************/
#ifndef _PART_PE43204_H
#define _PART_PE43204_H

#include "part_common.h"

/* PE43204 unique part identifier  */
enum PE43204_PART_ID {
  PTID_PE43204 = FPGA_PTID_PE43204 
};

/* PE43204 Pin control Masks */
enum PE43204_PIN_MASK {
  PE43204_PIN_00DB = 0x00000000,  /*  0 dB Attenuation */
  PE43204_PIN_06DB = 0x00000001,  /*  6 dB Attenuation */
  PE43204_PIN_12DB = 0x00000002   /* 12 dB Attenuation */
};

enum PE43204_ATTN {
  PE43204_ATTN_00DB = PE43204_PIN_00DB,
  PE43204_ATTN_06DB = PE43204_PIN_06DB,
  PE43204_ATTN_12DB = PE43204_PIN_12DB,
  PE43204_ATTN_18DB = PE43204_PIN_06DB|PE43204_PIN_12DB 
};


/*---------------------------------------------------------------------------*/
/* Public function prototypes from part_pe43204.c */


#endif  /* _PART_PE43204_H */
