/****************************************************************************/
/*                                                                          */
/*  part_adc12d.c                                                          */
/*                                                                          */
/****************************************************************************/

#include "part_adc12d.h"

/* Sane defaults for ADC12D registers                             */
/*                                                                 */
int32_t pt_adc12d_rgc_default(PT_ADC12D_REG *R)
{
  static const PT_ADC12D_REG adc12d_reg_defaults = {
    {0x2010,0x2AE0,0x0000,0x4000,
     0xDF4B,0x0000,0x1C20,0x8140,
     0x0000,0x0000,0x0000,0x4000,
     0x0004,0x0000,0x0003,0x0018, 0x0000} };

  int32_t i;
  for (i=0; i<ADC12D_NUM_RG; i++){
    R->rg[i] = adc12d_reg_defaults.rg[i];
  }
  return (0);
}

int32_t pt_adc12d_cfg(PT_ADC12D_REG *S, UDB *rate)
{
  /* Define the sample rate in Hz */
  float64_t frate = (rate->f64[0])*1000000.0;

  /* Set output format to 2's compliment */
  S->rg[ADC12D_RG_CONFIG1] = u32_setbits(S->rg[ADC12D_RG_CONFIG1],ADC12D_RGM_CONFIG1_2SC,0x01);

  /* Set FSR for both channels */
  S->rg[ADC12D_RG_I_FS_ADJ] = u32_setbits(S->rg[ADC12D_RG_I_FS_ADJ],ADC12D_RGM_I_FS_ADJ_FM,0x7FFF);
  S->rg[ADC12D_RG_Q_FS_ADJ] = u32_setbits(S->rg[ADC12D_RG_Q_FS_ADJ],ADC12D_RGM_Q_FS_ADJ_FM,0x7FFF);

  /* Set LFS bit based on sample rate */
  if (frate <= 300000000.0) 
    S->rg[ADC12D_RG_CONFIG1] = u32_setbits(S->rg[ADC12D_RG_CONFIG1],ADC12D_RGM_CONFIG1_LFS,0x01);

  /* Configure for Non-Demux Mode {0=Demux, 1=No Demux } */ 
  S->rg[ADC12D_RG_PIN] = u32_setbits(S->rg[ADC12D_RG_PIN],ADC12D_PNM_NDM,0x00);

  return (0);
}

