/*****************************************************************************/
/*                                                                           */
/* c3_target_core.h                                                          */
/*                                                                           */
/*****************************************************************************/
#ifndef _C3_TARGET_CORE_H
#define _C3_TARGET_CORE_H

#include "part_common.h"

/* Target, transport configuration (ICEPIC,ICEQIC,GIGEXD,etc) */
enum C3_TGT_DEV_TYPE {
  C3_TGT_DEV_NULL   = 0,
  C3_TGT_DEV_ICEPIC = 1,
  C3_TGT_DEV_ICEQIC = 2,
  C3_TGT_DEV_GIGEXD = 3 
};

/* Necessary info to communicate using ICEPIC transport */
typedef struct {
  int32_t    mport;
  void       *pdev;
} TGT_Config_ICEPIC;

/* Necessary info to communicate using ICEQIC transport */
typedef struct {
  int32_t ipversion;
  int32_t ip[6];
  int32_t netmask[6];
} TGT_Config_ICEQIC;

/* Necessary info to communicate using GIGEXD transport */
typedef struct {
  int32_t ipversion;
  int32_t ip[6];
  int32_t netmask[6];
} TGT_Config_GIGEXD;

typedef struct {
  int32_t tgtid;
  TGT_Config_ICEPIC icepic;
  TGT_Config_ICEQIC iceqic;
  TGT_Config_GIGEXD gigexd;
} TGT_Config_Obj;

#endif  /* _C3_TARGET_CORE_H */
