/****************************************************************************/
/*                                                                          */
/*   iomlib_lb2dm3.h - LB2DM3 library wrappers for ICEPIC device            */
/*                                                                          */
/****************************************************************************/
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <math.h>
#include <fcntl.h>
#include <string.h>
#include <errno.h>
#include <sys/types.h>
#include <sys/stat.h>
#include "icelib.h"

#define LB2DM3_ROOT_ADDR       0
#define LB2DM3_JVM_ADDR        1
#define LB2DM3_TMP112_ADDR     2
#define LB2DM3_SKY13384_ADDR_0 3
#define LB2DM3_SKY13384_ADDR_1 4
#define LB2DM3_PE43204_ADDR    5
#define LB2DM3_LTC2362_ADDR    6
#define LB2DM3_STV6111_ADDR    7
#define LB2DM3_LTC2630_ADDR    8
#define LB2DM3_ADS42B49_ADDR   9
#define LB2DM3_VMMK2103_ADDR   10
#define LB2DM3_LTC6957_ADDR    11
#define LB2DM3_OSC_ADDR        12
#define LB2DM3_SI5338_ADDR     13
#define LB2DM3_FXLH42245_ADDR  14
#define LB2DM3_HBDECFIR_ADDR_0 15
#define LB2DM3_HBDECFIR_ADDR_1 16
#define LB2DM3_ADCLM_ADDR      17
#define LB2DM3_AIS_ADDR        18
#define LB2DM3_DCS_ADDR        19
#define LB2DM3_STATIS_ADDR     20
#define LB2DM3_FIR_ADDR_0      21
#define LB2DM3_FIR_ADDR_1      22
#define LB2DM3_DELAY_ADDR      23
#define LB2DM3_MTGO_ADDR       24
#define LB2DM3_MODULE_ADDR     25
#define LB2DM3_CMD_ADDR        26

/* Define pin controls specific to the state (module) part for the LB2DM3 */
/*   NOTE: These must match the verilog firmware !!!                      */
enum LB2DM3_PIN_MASK {
  LB2DM3_PIN_NULL    =  0x00000000,      /* No PINs active                 */
  LB2DM3_PIN_RSEL    =  (0x00000001<<0), /* Ramp output selection          */
  LB2DM3_PIN_IMP     =  (0x00000001<<1), /* IMP selection                  */
  LB2DM3_PIN_ABSWAP  =  (0x00000001<<2), /* AB Swap selection              */
  LB2DM3_PIN_IMPP    =  (0x00000001<<3), /* Description?                   */
  LB2DM3_PIN_CXRB    =  (0x00000001<<4), /* Description?                   */
  LB2DM3_PIN_HBFBYP  =  (0x00000001<<5), /* Digital halfband filter bypass */
  LB2DM3_PIN_PPSTAG  =  (0x00000001<<6), /* Tag output samples with PPS    */
  LB2DM3_PIN_LSBP    =  (0x00000001<<7),  /* Put PPS in LSB of data         */
  LB2DM3_PIN_MTGO    =  (0x00000001<<8)  /* ADC triggered on PPS Port      */
};

/* Define module specific state register mapping */
enum LB2DM3_RG_ID {
  LB2DM3_RG_CLK      =  0,  /* Master clock configuration settings */
  LB2DM3_RG_VCOREFW  =  1,  /* RF VCO Reference (Whole MHz)        */
  LB2DM3_RG_VCOREFF  =  2,  /* RF VCO Reference (Frac  MHz)        */
  LB2DM3_RG_RFFREQW  =  3,  /* RF Tuned Frequency (Whole MHz)      */
  LB2DM3_RG_RFFREQF  =  4,  /* RF Tuned Frequency (Frac  MHz)      */
  LB2DM3_RG_SRATEW   =  5,  /* ADC Sample Rate (Whole MHz)         */
  LB2DM3_RG_SRATEF   =  6,  /* ADC Sample Rate (Frac  MHz)         */
  LB2DM3_RG_RFBWW    =  7,  /* RF BW (Whole MHz)                   */
  LB2DM3_RG_RFBWF    =  8,  /* RF BW (Frac MHz)                    */
  LB2DM3_RG_RFGAINW  =  9,  /* RF Gain in dB (Whole dB)            */
  LB2DM3_RG_RFGAINF  =  10, /* RF Gain in dB (Frac dB)             */
  LB2DM3_RG_PRESEL   =  11, /* RF Preselector configuration        */
  LB2DM3_RG_ADCLM    =  12, /* ADC Loading value                   */
  LB2DM3_RG_RFPWR    =  13, /* RF input power meter                */
  LB2DM3_RG_MTGOOFF  =  14, /* MTGO offset register                */
  LB2DM3_RG_FCN      =  STATE_RG_FCN, /* Module Functions to execute          */
  LB2DM3_RG_TGLSS    =  STATE_RG_PIN, /* Register to hold toggle switch state */
  LB2DM3_RG_CRC      =  STATE_RG_CRC  /* CRC over all registers             */
};

/* Define module specific register masks */
enum LB2DM3_RG_MASK {
  LB2DM3_RGM_CLK_EXTREF  = (0x00000001<<0), /* Use external 10MHz ref   */
  LB2DM3_RGM_CLK_MTGO    = (0x00000001<<1)  /* Use triggered go output  */
};

/* Toggle Switches State is stored in LB2DM3_RG_TGLSS */
/*   NOTE: These switches do not control anything directly, they only */
/*         retain the current operating state of the toggle.          */
enum LB2DM3_TGLSS_MASK {
  LB2DM3_TGLSS_NULL    =  0x00000000,      /* Clear control pin              */
  LB2DM3_TGLSS_RSTFPGA = (0x00000001<<0),  /* FPGA reset pin                 */
  LB2DM3_TGLSS_DF      = (0x00000001<<1),  /* Dataflow cntrl (enable/disable) */
  LB2DM3_TGLSS_LNA     = (0x00000001<<2),  /* LNA control (enable/disable)   */
  LB2DM3_TGLSS_DCS     = (0x00000001<<3),  /* DCS control (enable/disable)   */
  LB2DM3_TGLSS_AIS     = (0x00000001<<4),  /* AIS control (enable/disable)   */
  LB2DM3_TGLSS_PPSTAG  = (0x00000001<<5),  /* PPSTAG data (enable/disable)   */
  LB2DM3_TGLSS_HBF     = (0x00000001<<6),  /* HBF control (enable/bypass)    */
  LB2DM3_TGLSS_RAMP    = (0x00000001<<7),  /* Ramp output (enable/bypass)    */
  LB2DM3_TGLSS_SPINV   = (0x00000001<<8),  /* IQ swap     (enable/bypass)    */
  LB2DM3_TGLSS_EXTREF  = (0x00000001<<9),  /* External Ref (enable/disable)  */
  LB2DM3_TGLSS_PRESEL  = (0x00000001<<10), /* RF Preselector (enable/bypass) */
  LB2DM3_TGLSS_AGC     = (0x00000001<<11), /* RF AGC (enable/bypass) */
  LB2DM3_TGLSS_MTGO    = (0x00000001<<12), /* Module trigger Go (ena/dis) */
  LB2DM3_TGLSS_LSBP    = (0x00000001<<13), /* PPS in LSB (ena/dis) */
  LB2DM3_TGLSS_EQ      = (0x00000001<<14)  /* Equalizer Control (enable/bypass) */
};


/* Define module specfic state keys for change updates */
enum LB2DM3_FCN_LIST {
  LB2DM3_FCN_FWLOAD       = 0x01, /* FW download to module */
  LB2DM3_FCN_MASTER_RESET = 0x02, /* Full module reset  */
  LB2DM3_FCN_DATAFLOW     = 0x03, /* Dataflow control   */ 
  LB2DM3_FCN_RFPWR        = 0x04, /* RF input pwr meter */
  LB2DM3_FCN_TEMPSENS     = 0x05, /* Temperature sensor */
  LB2DM3_FCN_INPREF       = 0x06, /* Input reference source */
  LB2DM3_FCN_SAMPRATE     = 0x07, /* ADC sample rate */ 
  LB2DM3_FCN_RFFREQ       = 0x08, /* RF tuner frequency */ 
  LB2DM3_FCN_RFGAIN       = 0x09, /* RF gain */
  LB2DM3_FCN_RFBW         = 0x0A, /* RF tuner bandwidth */
  LB2DM3_FCN_PRESEL       = 0x0B, /* RF preselector */ 
  LB2DM3_FCN_RFLNA        = 0x0C, /* RF LNA */ 
  LB2DM3_FCN_DCS          = 0x0D, /* DC suppression */  
  LB2DM3_FCN_AIS          = 0x0E, /* Adaptive Image Compensation */
  LB2DM3_FCN_ADCLM        = 0x0F, /* ADC loading monitor */
  LB2DM3_FCN_HBF          = 0x10, /* Halfband Filter  */    
  LB2DM3_FCN_STATE        = 0x11, /* STATE part configuration */
  LB2DM3_FCN_TGLSW        = 0x12, /* Toggle switches register */
  LB2DM3_FCN_HHRESET      = 0x13, /* ICE-PIC HH LVDS reset/retrain */

  LB2DM3_FCN_BYPASS       = (0x00000001<<27), /* Bypass a function root  */
  LB2DM3_FCN_DISABLE      = (0x00000001<<28), /* Disable a function root */
  LB2DM3_FCN_ENABLE       = (0x00000001<<29), /* Enable a function root */
  LB2DM3_FCN_GET          = (0x00000001<<30), /* Get value of a function root */
  LB2DM3_FCN_SET          = (0x00000001<<31), /* Set value of a function root */
  LB2DM3_FCN_NULL         = 0x00000000        /* Null function */
};


/*---------------------------------------------------------------------------*/
/* Public Function Prototypes */

EXTERN_CDEFINE int32_t module_fcn_lb2dm3(Module_Config_Obj *M, uint32_t flags, UDB *buf);

EXTERN_CDEFINE int32_t module_gen_qcmd_lb2dm3(Module_Config_Obj *M, uint32_t flags);

EXTERN_CDEFINE int32_t module_dec_qsta_lb2dm3(Module_Config_Obj *M, uint32_t flags);

