/****************************************************************************/
/*                                                                          */
/*   iomlib_d2rf.h: includes for D2RF library interfaces                */
/*                                                                          */
/****************************************************************************/
#ifndef _IOMLIB_D2RF_H
#define _IOMLIB_D2RF_H

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <math.h>   
#include <fcntl.h>
#include <string.h>
#include <errno.h>
#include <sys/types.h>
#include <sys/stat.h>
#include "icelib.h" 

#define D2RF_ROOT_ADDR       0
#define D2RF_JVM_ADDR        1
#define D2RF_PE42423_ADDR    2
#define D2RF_VMMK2103_ADDR_0 3
#define D2RF_VMMK2103_ADDR_1 4
#define D2RF_PE43204_ADDR    5
#define D2RF_SKY13317_ADDR   6
#define D2RF_AD9361_ADDR     7
#define D2RF_LTC6957_ADDR    8
#define D2RF_OSC_ADDR        9
#define D2RF_SI5338_ADDR     10
#define D2RF_MTGO_ADDR_0     11
#define D2RF_MTGO_ADDR_1     12
#define D2RF_HBINTFIR_ADDR   13
#define D2RF_DELAY_ADDR      14
#define D2RF_MEM_ADDR        15
#define D2RF_MEM_ADDR_1      16
#define D2RF_MODULE_ADDR     17
#define D2RF_CMD_ADDR        18

#define REFCLK_FREQ 40000000

#define D2RF_PI 3.14159265
#define TXQC_OFF_DEF 20
#define TXQC_ATTN_DEF 0

/* D2RF module control register */
#define D2RF_SYSREG       0x0000  /* 8-bit system register interface              */

/* D2RF Object */
#define D2RF_ID        0x46FC /* 16-bit unique module identifier */
#define D2RF_RG_MAXCNT 1

#define HBINT_BYP1       0x00000001
#define HBINT_BYP2       0x00000004
#define HBINT_BYROT      0x00000002

#define AD9361_RESETB    0x80000000
#define AD9361_TXFRAME   0x40000000
#define AD9361_ENAGC     0x20000000
#define AD9361_TXNRX     0x10000000
#define AD9361_SPI_WR    0x00080000
#define AD9361_SPI_DATA  0x000000FF

#define AD9361_REG_SPI_CONF                        0x000
#define AD9361_REG_TX_ENABLE_FILTER_CTRL           0x002
#define AD9361_REG_RX_ENABLE_FILTER_CTRL           0x003
#define AD9361_REG_INPUT_SELECT                    0x004

/* D2RF module control register */
#define D2RF_SYSREG       0x0000  /* 8-bit system register interface              */

/* D2RF Object */
#define D2RF_ID        0x46FC /* 16-bit unique module identifier */
#define D2RF_RG_MAXCNT 1

#define AD9361_RESETB    0x80000000
#define AD9361_TXFRAME   0x40000000
#define AD9361_ENAGC     0x20000000
#define AD9361_TXNRX     0x10000000
#define AD9361_SPI_WR    0x00080000
#define AD9361_SPI_DATA  0x000000FF

#define AD9361_REG_SPI_CONF                        0x000
#define AD9361_REG_TX_ENABLE_FILTER_CTRL           0x002
#define AD9361_REG_RX_ENABLE_FILTER_CTRL           0x003
#define AD9361_REG_INPUT_SELECT                    0x004
#define AD9361_REG_RFPLL_DIVIDERS                  0x005
#define AD9361_REG_RX_CLOCK_DATA_DELAY             0x006
#define AD9361_REG_TX_CLOCK_DATA_DELAY             0x007
#define AD9361_REG_CLOCK_ENABLE                    0x009
#define AD9361_REG_BBPLL                           0x00A
#define AD9361_REG_TEMP_START_READ                 0x00C
#define AD9361_REG_TEMP                            0x00E
#define AD9361_REG_PARALLEL_PORT_CONF_1            0x010
#define AD9361_REG_PARALLEL_PORT_CONF_2            0x011
#define AD9361_REG_PARALLEL_PORT_CONF_3            0x012
#define AD9361_REG_CH_1_OVERFLOW                   0x05E
#define AD9361_REG_ENSM_MODE                       0x013
#define AD9361_REG_ENSM_CONFIG_1                   0x014
#define AD9361_REG_ENSM_CONFIG_2                   0x015
#define AD9361_REG_CAL_CONTROL                     0x016
#define AD9361_REG_STATE                           0x017
#define AD9361_REG_REFERENCE_CLOCK_CYCLES          0x03A
#define AD9361_REG_DIGITAL_IO_CTRL                 0x03B
#define AD9361_REG_LVDS_BIAS_CTRL                  0x03C
#define AD9361_REG_LVDS_INVERT_CTRL1               0x03D
#define AD9361_REG_LVDS_INVERT_CTRL2               0x03E
#define AD9361_REG_SDM_CONTROL_1                   0x03F
#define AD9361_REG_SDM_CONTROL_2                   0x040
#define AD9361_REG_FRAC_BB_FREQ_WORD_1             0x041
#define AD9361_REG_FRAC_BB_FREQ_WORD_2             0x042
#define AD9361_REG_FRAC_BB_FREQ_WORD_3             0x043
#define AD9361_REG_INTEGER_BB_FREQ_WORD            0x044
#define AD9361_REG_CP_CURRENT                      0x046
#define AD9361_REG_LOOP_FILTER_1                   0x048
#define AD9361_REG_LOOP_FILTER_2                   0x049
#define AD9361_REG_LOOP_FILTER_3                   0x04A
#define AD9361_REG_VCO_CONTROL                     0x04B
#define AD9361_REG_VCO_PROGRAM_1                   0x04C
#define AD9361_REG_VCO_PROGRAM_2                   0x04D
#define AD9361_REG_SDM_CONTROL                     0x04E
#define AD9361_REG_RX_SYNTH_PD_OVERRIDE            0x050
#define AD9361_REG_TX_SYNTH_PD_OVERRIDE            0x051
#define AD9361_REG_TX_ANALOG_PD_OVERRIDE           0x056
#define AD9361_REG_ANALOG_PD_OVERRIDE              0x057
#define AD9361_REG_TX_FIR_ADDR                     0x060
#define AD9361_REG_TX_FIR_DATAL                    0x061
#define AD9361_REG_TX_FIR_DATAH                    0x062
#define AD9361_REG_TX_FIR_DUMWR                    0x064
#define AD9361_REG_TX_FIR_CONFIG                   0x065
#define AD9361_REG_TX1_ATTN_0                      0x073
#define AD9361_REG_TX1_ATTN_1                      0x074
#define AD9361_REG_TX_ATTN_OFFSET                  0x077
#define AD9361_REG_TX2_DIG_ATTN                    0x07C
#define AD9361_REG_TX_SYMBOL_ATTN_CONFIG           0x081
#define AD9361_REG_TX1_OUT1_PHASE_CORR             0x08E
#define AD9361_REG_TX1_OUT1_GAIN_CORR              0x08F
#define AD9361_REG_TX1_OUT1_OFFSET_I               0x092
#define AD9361_REG_TX1_OUT1_OFFSET_Q               0x093
#define AD9361_REG_TXQC_FORCE_BITS                 0x09F
#define AD9361_REG_QUAD_CAL_NCO_FREQ_PHASE_OFFSET  0x0A0
#define AD9361_REG_QUAD_CAL_CONTROL                0x0A1
#define AD9361_REG_QUAD_KEXP1                      0x0A2
#define AD9361_REG_QUAD_KEXP2                      0x0A3
#define AD9361_REG_QUAD_SETTLE_COUNT               0x0A4
#define AD9361_REG_QUAD_MAG_FTEST_THRES1           0x0A5
#define AD9361_REG_QUAD_MAG_FTEST_THRES2           0x0A6
#define AD9361_REG_QUAD_CAL_STATUS                 0x0A7
#define AD9361_REG_QUAD_CAL_COUNT                  0x0A9
#define AD9361_REG_TX_QUAD_FULL_LMT_GAIN           0x0AA
#define AD9361_REG_SQUARER_CONFIG                  0x0AB
#define AD9361_REG_TX_QUAD_CAL_ATTN                0x0AC
#define AD9361_REG_TX_QUAD_THRES_ACCUM             0x0AD
#define AD9361_REG_TX_QUAD_LPF_GAIN                0x0AE
#define AD9361_REG_TX_TUNE_CTRL                    0x0CA
#define AD9361_REG_CONFIG0                         0x0D0
#define AD9361_REG_RESISTOR                        0x0D1
#define AD9361_REG_CAPACITOR                       0x0D2
#define AD9361_REG_TX_BBF_TUNE_DIVIDE              0x0D6
#define AD9361_REG_TX_BBF_TUNE_MODE                0x0D7
#define AD9361_REG_AGC_CONFIG_1                    0x0FA
#define AD9361_REG_RX2_MANUAL_GAIN                 0x10C
#define AD9361_REG_GAIN_TABLE_ADDRESS              0x130
#define AD9361_REG_GAIN_TABLE_WRITE_DATA1          0x131
#define AD9361_REG_GAIN_TABLE_WRITE_DATA2          0x132
#define AD9361_REG_GAIN_TABLE_WRITE_DATA3          0x133
#define AD9361_REG_GAIN_TABLE_READ_DATA1           0x134
#define AD9361_REG_GAIN_TABLE_READ_DATA2           0x135
#define AD9361_REG_GAIN_TABLE_READ_DATA3           0x136
#define AD9361_REG_GAIN_TABLE_CONFIG               0x137
#define AD9361_REG_GM_SUB_TABLE_ADDRESS            0x138
#define AD9361_REG_GM_SUB_TABLE_GAIN_WRITE         0x139
#define AD9361_REG_GM_SUB_TABLE_BIAS_WRITE         0x13A
#define AD9361_REG_GM_SUB_TABLE_CTRL_WRITE         0x13B
#define AD9361_REG_GM_SUB_TABLE_GAIN_READ          0x13C
#define AD9361_REG_GM_SUB_TABLE_BIAS_READ          0x13D
#define AD9361_REG_GM_SUB_TABLE_CTRL_READ          0x13E
#define AD9361_REG_GM_SUB_TABLE_CONFIG             0x13F
#define AD9361_REG_RX_TIA_CONFIG                   0x1DB
#define AD9361_REG_TIA1_C_LSB                      0x1DC
#define AD9361_REG_TIA1_C_MSB                      0x1DD
#define AD9361_REG_TIA2_C_LSB                      0x1DE
#define AD9361_REG_TIA2_C_MSB                      0x1DF
#define AD9361_REG_CALIBRATION_CONFIG_1            0x169
#define AD9361_REG_CALIBRATION_CONFIG_2            0x16A
#define AD9361_REG_CALIBRATION_CONFIG_3            0x16B
#define AD9361_REG_WAIT_CNT                        0x185
#define AD9361_REG_DC_OFFSET_CNT                   0x186
#define AD9361_REG_DC_OFFSET_CONFIG_1              0x187
#define AD9361_REG_DC_OFFSET_ATTN                  0x188
#define AD9361_REG_DC_OFFSET_CONFIG_2              0x18B
#define AD9361_REG_BB_DC_OFFSET_SHIFT              0x190
#define AD9361_REG_BB_DC_OFFSET_COUNT              0x193
#define AD9361_REG_BB_DC_OFFSET_ATTN               0x194
#define AD9361_REG_RX_MIX_GM_CONFIG                0x1C0
#define AD9361_REG_RX_MIX_LO_CM                    0x1D5
#define AD9361_REG_RX1_TUNE_CTRL                   0x1E2
#define AD9361_REG_RX2_TUNE_CTRL                   0x1E3
#define AD9361_REG_RX_BBF_R2346                    0x1E6
#define AD9361_REG_RX_BBF_C3_MSB                   0x1EB
#define AD9361_REG_RX_BBF_C3_LSB                   0x1EC
#define AD9361_REG_RX_BBF_TUNE_DIVIDE              0x1F8
#define AD9361_REG_RX_BBF_TUNE_CONFIG              0x1F9
#define AD9361_REG_RX_BBBW_MHZ                     0x1FB
#define AD9361_REG_RX_BBBW_KHZ                     0x1FC
#define AD9361_REG_RX_INTEGER_BYTE_0               0x231
#define AD9361_REG_RX_INTEGER_BYTE_1               0x232
#define AD9361_REG_RX_FRACT_BYTE_0                 0x233
#define AD9361_REG_RX_FRACT_BYTE_1                 0x234
#define AD9361_REG_RX_FRACT_BYTE_2                 0x235
#define AD9361_REG_RX_FORCE_ALC                    0x236
#define AD9361_REG_RX_FORCE_VCO_TUNE_1             0x238
#define AD9361_REG_RX_ALC_VARACTOR                 0x239
#define AD9361_REG_RX_VCO_OUTPUT                   0x23A
#define AD9361_REG_RX_CP_CURRENT                   0x23B
#define AD9361_REG_RX_CP_OFFSET                    0x23C
#define AD9361_REG_RX_CP_CONFIG                    0x23D
#define AD9361_REG_RX_LOOP_FILTER_1                0x23E
#define AD9361_REG_RX_LOOP_FILTER_2                0x23F
#define AD9361_REG_RX_LOOP_FILTER_3                0x240
#define AD9361_REG_RX_VCO_BIAS_1                   0x242
#define AD9361_REG_RX_CAL_STATUS                   0x244
#define AD9361_REG_RX_VCO_CAL_REF                  0x245
#define AD9361_REG_RX_VCO_PD_OVERRIDES             0x246
#define AD9361_REG_RX_CP_OVR_VCO_LOCK              0x247
#define AD9361_REG_RX_VCO_LDO                      0x248
#define AD9361_REG_RX_VCO_CAL                      0x249
#define AD9361_REG_RX_VCO_VARACTOR_CTRL_0          0x250
#define AD9361_REG_RX_VCO_VARACTOR_CTRL_1          0x251
#define AD9361_REG_RX_LO_GEN_POWER_MODE            0x261
#define AD9361_REG_TX_INTEGER_BYTE_0               0x271
#define AD9361_REG_TX_INTEGER_BYTE_1               0x272
#define AD9361_REG_TX_FRACT_BYTE_0                 0x273
#define AD9361_REG_TX_FRACT_BYTE_1                 0x274
#define AD9361_REG_TX_FRACT_BYTE_2                 0x275
#define AD9361_REG_TX_FORCE_ALC                    0x276
#define AD9361_REG_TX_FORCE_VCO_TUNE_1             0x278
#define AD9361_REG_TX_ALC_VARACTOR                 0x279
#define AD9361_REG_TX_VCO_OUTPUT                   0x27A
#define AD9361_REG_TX_CP_CURRENT                   0x27B
#define AD9361_REG_TX_LOOP_FILTER_1                0x27E
#define AD9361_REG_TX_LOOP_FILTER_2                0x27F
#define AD9361_REG_TX_LOOP_FILTER_3                0x280
#define AD9361_REG_TX_VCO_BIAS_1                   0x282
#define AD9361_REG_TX_VCO_BIAS_2                   0x283
#define AD9361_REG_TX_VCO_CAL_REF                  0x285
#define AD9361_REG_TX_CP_OVR_VCO_LOCK              0x287
#define AD9361_REG_TX_VCO_VARACTOR_CTRL_0          0x290
#define AD9361_REG_TX_VCO_VARACTOR_CTRL_1          0x291
#define AD9361_REG_BANDGAP_CONFIG0                 0x2A6
#define AD9361_REG_BANDGAP_CONFIG1                 0x2A8
#define AD9361_REG_REF_DIVIDE_CONFIG_1             0x2AB
#define AD9361_REG_REF_DIVIDE_CONFIG_2             0x2AC
#define AD9361_REG_CTRL                            0x3DF
#define AD9361_REG_BIST_CONFIG                     0x3F4
#define AD9361_REG_OBSERVE_CONFIG                  0x3F5
#define AD9361_REG_BIST_DATA_PORT_CONFIG           0x3F6

#ifdef BOGUS
typedef struct {
    int_u4   chksum;     /* 32 bit checksum over packet ensures integrity  */
    int_u2   id;         /* Unique 16-bit module ID                        */
    int_u1   mtrev;      /* Module type / revision                         */
    int_1    debuglevel; /* Module debug level {0,127}                     */
    int_u1   sysreg;     /* System Register                                */
    int_1    opts;       /* Options Register                               */
    int_1    bits;       /* Module output bits {-16,-8,8,16}               */
    int_1    pga;     /* Chan1 programmable gain amplifier {-100,28}    */
    int_1    test;       /* A2D test waveform                              */
    int_1    ovsr;       /* Oversample ratio {1,127}                       */
    int_1    pad[3];     /* Pad structure size to multiple of 4 bytes      */
    int_4    foffset;    /* complex rotation in output mode                */
    int_4    refclk;     /* Reference clock rate in Hz                     */
    real_8   samprate;   /* A/D sample rate in Hz                          */
    ADF4350_Reg_Obj SYN;  /* Clock synthesizer part */
    PE4302_Reg_Obj  ATN1; /* Analog attenuator I/O Module 1, 1st stage   */
    PE4302_Reg_Obj  ATN2; /* Analog attenuator I/O Module 1, 2nd stage   */
    PE4302_Reg_Obj  ATN3; /* Analog attenuator I/O Module 2, 1st stage   */
    PE4302_Reg_Obj  ATN4; /* Analog attenuator I/O Module 2, 2nd stage   */
} D2RF_State_Obj;

/*                                                             */
/* !!!IMPORTANT!!! - sizeof(D2RF_State_Obj) MUST BE AN EVEN  */
/*                   MULTIPLE OF 4 BYTES FOR iom_set_state     */
/*                   TO WORK PROPERLY                          */
/*                                                             */
#define D2RF_State_Obj_Bytes sizeof(A2DM1X_State_Obj)
#define D2RF_STATE_MAX_BYTES 256 /* Max possible bytes in A2DM1X_State_Obj */
#endif

/* #define SI5338_PART_ADDR   0x09 */ /* Part 9 is the Si5338 Clock Synthesizer Chip */

/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~ AD9361 Transceiver Configuration ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */ 
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
#define MIN_BBPLL_FREQ                  715000000UL /* 715 MHz */
#define MAX_BBPLL_FREQ                  1430000000UL /* 1430 MHz */
#define MAX_BBPLL_DIV                   64
#define MIN_BBPLL_DIV                   2

#define PORB_VCO_LOGIC                       (1 << 6) /* PORb VCO Logic */
#define VCO_OUTPUT_LEVEL(x)                  (((x) & 0xF) << 0) /* VCO Output Level<3:0> */
#define VCO_VARACTOR(x)                      (((x) & 0xF) << 0) /* VCO Varactor<3:0> */
#define VCO_CAL_OFFSET(x)                    (((x) & 0xF) << 3) /* VCO Cal Offset<3:0> */
#define VCO_BIAS_TCF(x)                      (((x) & 0x3) << 3) /* VCO Bias Tcf<1:0> */
#define VCO_BIAS_REF(x)                      (((x) & 0x7) << 0) /* VCO Bias Ref<2:0> */
#define CHARGE_PUMP_CURRENT(x)               (((x) & 0x3F) << 0) /* Charge Pump Current<5:0> */
#define VCO_VARACTOR_REFERENCE_TCF(x)        (((x) & 0x7) << 4) /* VCO Varactor Reference Tcf<2:0> */
#define VCO_VARACTOR_OFFSET(x)               (((x) & 0xF) << 0) /* VCO Varactor Offset<3:0> */
#define VCO_VARACTOR_REFERENCE(x)            (((x) & 0xF) << 0) /* VCO Varactor Reference<3:0> */
#define VCO_CAL_REF_TCF(x)                   (((x) & 0x7) << 0) /* VCO Cal Ref Tcf<2:0> */
#define LOOP_FILTER_C2(x)                    (((x) & 0xF) << 4) /* Loop Filter C2<3:0> */
#define LOOP_FILTER_C1(x)                    (((x) & 0xF) << 0) /* Loop Filter C1<3:0> */
#define LOOP_FILTER_R1(x)                    (((x) & 0xF) << 4) /* Loop Filter R1<3:0> */
#define LOOP_FILTER_C3(x)                    (((x) & 0xF) << 0) /* Loop Filter C3<3:0> */
#define LOOP_FILTER_R3(x)                    (((x) & 0xF) << 0) /* Loop Filter R3<3:0> */
#define TX_VCO_DIVIDER(x)                    (((x) & 0xF) << 4) /* TX VCO  Divider<3:0> */
#define RX_VCO_DIVIDER(x)                    (((x) & 0xF) << 0) /* RX VCO  Divider<3:0> */
#define K_EXP_PHASE(x)                       (((x) & 0x1F) << 0) /* K exp Phase<4:0> */
#define K_EXP_AMPLITUDE(x)                   (((x) & 0x1F) << 0) /* K exp Amplitude<4:0> */
#define RX_MIX_LO_CM(x)                      (((x) & 0x3F) << 0) /* Rx Mix LO CM<5:0> */
#define RX_MIX_GM_PLOAD(x)                   (((x) & 0x3) << 0) /* Rx Mix Gm pload <1:0> */
#define TX_FIR_NUMTAPS(x)                    (((x) & 0x07) << 5)
#define TX_FIR_SEL(x)                        (((x) & 0x03) << 3)
#define TX_FIR_WRTX(x)                       (((x) & 0x01) << 2)
#define TX_FIR_TXCLK(x)                      (((x) & 0x01) << 1)
#define TX_FIR_GAIN(x)                       (((x) & 0x01) << 0)

#define SIZE_TXATN_TBL 11
static const int_4 tx_attn_tbl[SIZE_TXATN_TBL][3] = {
  {500 , 21, -1},
  {1100, 18, -1},
  {1800, 16, 25},
  {2000, 14, 21},
  {2100, 13, -1},
  {2600, 10, 15},
  {3700, 9 , 15},
  {4400, 10, 10},
  {4800, 7 ,  5},
  {5000, 6 , -1},
  {6000, 0 , -1}
};

static const int16_t quad_cal_table[2][6] =
{ {0xFFFC,0xFFF5,0x000E,0xFFFD,0x000F,0x0014},
  {0x0000,0x0000,0x0000,0x0000,0x0000,0x0000}
};

/*
int_4 hbfir_coefs [] = {
  -9,-36,-52,-27,19,24,-14,-25,13,28,-13,-34,13,40,-13,
  -48,12,57,-10,-67,8,79,-5,-91,1,105,5,-120,-11,137,19,-155,
  -29,175,41,-198,-55,222,72,-250,-92,280,115,-315,-144,354,
  178,-399,-220,453,272,-518,-338,599,425,-704,-543,850,715,
  -1067,-988,1435,1500,-2211,-2820,5030,14629,14629,5030,-2820,
  -2211,1500,1435,-988,-1067,715,850,-543,-704,425,599,-338,-518,272,
  453,-220,-399,178,354,-144,-315,115,280,-92,-250,72,222,-55,
  -198,41,175,-29,-155,19,137,-11,-120,5,105,1,-91,-5,79,8,-67,
  -10,57,12,-48,-13,40,13,-34,-13,28,13,-25,-14,24,19,-27,-52,-36,-9
};
*/


int_4 hbfir_coefs1 [] = {
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0    ,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0    ,0,0,0,0,0,0,0,0,0,0,0,
  0,0,32767,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0    ,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0    ,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0    ,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0    ,0    ,0
};

int_4 hbfir_coefs2 [] = {
  -1,0,2,0,-3,0,5,0,-8,0,12,0,-17,0,23,0,-31,0,41,
  0,-54,0,69,0,-87,0,109,0,-135,0,165,0,-201,0,242,
  0,-291,0,347,0,-413,0,489,0,-579,0,684,0,-810,0,963,
  0,-1153,0,1394,0,-1715,0,2168,0,-2862,0,4087,0,-6902,
  0,20844,32767,20844,0,-6902,0,4087,0,-2862,0,2168,0,-1715,
  0,1394,0,-1153,0,963,0,-810,0,684,0,-579,0,489,0,-413,
  0,347,0,-291,0,242,0,-201,0,165,0,-135,0,109,0,-87,
  0,69,0,-54,0,41,0,-31,0,23,0,-17,0,12,0,-8,0,5,
  0,-3,0,2,0,0,0
};

int_4 hbfir_coefs0 [] = {
  -1,2,-3,5,-8,12,-17,23,
  -31,41,-54,69,-87,109,-135,165,
  -201,242,-291,347,-413,489,-579,684,
  -810,963,-1153,1394,-1715,2168,-2862,4087,
  -6902,20844
};

int_4 hbpfir_coefs [] = {
  -1,-3,-8,-17,-31,-54,-87,-135,
  -201,-291,-413,-579,-810,-1153,-1715,-2862,
  -6902,20844,4087,2168,1394,963,684,489,
  347,242,165,109,69,41,23,12,
  5,2
};

int_4 txprog_coefsx [] = {
  2,-2,-4,9,1,-19,11,26,
  -38,-20,75,-17,-106,93,101,-200,
  -23,302,-152,-335,418,217,-718,132,
  943,-777,-916,1803,310,-3630,2394,14819,
  14819,2394,-3630,310,1803,-916,-777,943,
  132,-718,217,418,-335,-152,302,-23,
  -200,101,93,-106,-17,75,-20,-38,
  26,11,-19,1,9,-4,-2,2
};

int_4 txprog_coefs [] = {
  -2,55,85,10,-78,-13,106,25,
  -142,-45,187,73,-241,-111,307,162,
  -386,-230,485,321,-611,-448,779,632,
  -1022,-923,1417,1458,-2228,-2814,5111,14819,
  14819,5111,-2814,-2228,1458,1417,-923,-1022,
  632,779,-448,-611,321,485,-230,-386,
  162,307,-111,-241,73,187,-45,-142,
  25,106,-13,-78,10,85,55,-2
};

int_4 txprog_coefs_128 [] = {
  -30,-59,37,14,-20,-26,28,30,
  -32,-35,38,41,-44,-47,51,54,
  -58,-62,67,71,-76,-81,86,92,
  -97,-103,110,117,-124,-131,139,148,
  -157,-166,176,187,-198,-210,223,237,
  -252,-268,286,305,-326,-348,374,402,
  -433,-468,509,555,-609,-673,750,844,
  -962,-1116,1325,1626,-2097,-2943,4913,14749,
  14749,4913,-2943,-2097,1626,1325,-1116,-962,
  844,750,-673,-609,555,509,-468,-433,
  402,374,-348,-326,305,286,-268,-252,
  237,223,-210,-198,187,176,-166,-157,
  148,139,-131,-124,117,110,-103,-97,
  92,86,-81,-76,71,67,-62,-58,
  54,51,-47,-44,41,38,-35,-32,
  30,28,-26,-20,14,37,-59,-30
};

int_4 txprog_coefs_64 [] = {
  17,29,-20,-110,-107,23,83,-48,
  -135,35,180,-25,-243,1,318,35,
  -409,-90,521,171,-660,-288,842,465,
  -1097,-751,1502,1280,-2315,-2621,5169,14458,
  14458,5169,-2621,-2315,1280,1502,-751,-1097,
  465,842,-288,-660,171,521,-90,-409,
  35,318,1,-243,-25,180,35,-135,
  -48,83,23,-107,-110,-20,29,17
};

int_4 txprog_coefs_64_fs4 [] = {
  166,131,103,6,-145,-301,-400,-389,
  -252,-30,193,316,271,58,-241,-488,
  -547,-349,58,517,807,745,278,-466,
  -1189,-1515,-1134,73,1952,4100,5973,7062,
  7062,5973,4100,1952,73,-1134,-1515,-1189,
  -466,278,745,807,517,58,-349,-547,
  -488,-241,58,271,316,193,-30,-252,
  -389,-400,-301,-145,6,103,131,166
};

#define max_t(type, x, y)                                               (type)max((type)(x), (type)(y))
#define min_t(type, x, y)                                               (type)min((type)(x), (type)(y))
#define DIV_ROUND_UP(x, y)                                              (((x) + (y) - 1) / (y))
#define DIV_ROUND_CLOSEST(x, divisor)                   (((x) + (divisor) / 2) / (divisor))
#define clamp(val, min_val, max_val)                    (max(min((val), (max_val)), (min_val)))
#define clamp_t(type, val, min_val, max_val)    (type)clamp((type)(val), (type)(min_val), (type)(max_val))

/* Mixer GM Sub-table */
const uint8_t gm_gain[16] = { 0x78, 0x74, 0x70, 0x6C, 0x68, 0x64, 0x60, 0x5C, 0x58, 0x54, 0x50, 0x4C, 0x48, 0x30, 0x18, 0x0 };
const uint8_t gm_ctrl[16] = { 0x0, 0xD, 0x15, 0x1B, 0x21, 0x25, 0x29, 0x2C, 0x2F, 0x31, 0x33, 0x34, 0x35, 0x3A, 0x3D, 0x3E };

struct RFPLL_LOOP_LUT {
        int_u2 VCO_MHz;
        int_u1 VCO_Output_Level;
        int_u1 VCO_Varactor;
        int_u1 VCO_Bias_Ref;
        int_u1 VCO_Bias_Tcf;
        int_u1 VCO_Cal_Offset;
        int_u1 VCO_Varactor_Reference;
        int_u1 Charge_Pump_Current;
        int_u1 LF_C2;
        int_u1 LF_C1;
        int_u1 LF_R1;
        int_u1 LF_C3;
        int_u1 LF_R3;
};
#define SYNTH_LUT_SIZE  53

static const struct RFPLL_LOOP_LUT rfpll_loop_table[SYNTH_LUT_SIZE] = 
{
  { 12605, 10, 0, 4, 0, 15, 8, 8, 12, 3, 14, 15, 11 }, /* 40 MHz */
  { 12245, 10, 0, 4, 0, 15, 8, 9, 12, 3, 14, 15, 11 },
  { 11906, 10, 0, 4, 0, 15, 8, 9, 12, 3, 14, 15, 11 },
  { 11588, 10, 0, 4, 0, 15, 8, 10, 12, 3, 14, 15, 11 },
  { 11288, 10, 0, 4, 0, 15, 8, 11, 12, 3, 14, 15, 11 },
  { 11007, 10, 0, 4, 0, 15, 8, 11, 12, 3, 14, 15, 11 },
  { 10742, 10, 0, 4, 0, 14, 8, 12, 12, 3, 14, 15, 11 },
  { 10492, 10, 0, 5, 1, 14, 9, 13, 12, 3, 14, 15, 11 },
  { 10258, 10, 0, 5, 1, 14, 9, 13, 12, 3, 14, 15, 11 },
  { 10036, 10, 0, 5, 1, 14, 9, 14, 12, 3, 14, 15, 11 },
  { 9827, 10, 0, 5, 1, 14, 9, 15, 12, 3, 14, 15, 11 },
  { 9631, 10, 0, 5, 1, 14, 9, 15, 12, 3, 14, 15, 11 },
  { 9445, 10, 0, 5, 1, 14, 9, 16, 12, 3, 14, 15, 11 },
  { 9269, 10, 0, 5, 1, 14, 9, 17, 12, 3, 14, 15, 11 },
  { 9103, 10, 0, 5, 1, 14, 9, 17, 12, 3, 14, 15, 11 },
  { 8946, 10, 0, 5, 1, 14, 9, 18, 12, 3, 14, 15, 11 },
  { 8797, 10, 1, 6, 1, 15, 11, 13, 12, 3, 14, 15, 11 },
  { 8655, 10, 1, 6, 1, 15, 11, 14, 12, 3, 14, 15, 11 },
  { 8520, 10, 1, 6, 1, 15, 11, 14, 12, 3, 14, 15, 11 },
  { 8392, 10, 1, 6, 1, 15, 11, 15, 12, 3, 14, 15, 11 },
  { 8269, 10, 1, 6, 1, 15, 11, 15, 12, 3, 14, 15, 11 },
  { 8153, 10, 1, 6, 1, 15, 11, 16, 12, 3, 14, 15, 11 },
  { 8041, 10, 1, 6, 1, 15, 11, 16, 12, 3, 14, 15, 11 },
  { 7934, 10, 1, 6, 1, 15, 11, 17, 12, 3, 14, 15, 11 }, 
  { 7831, 10, 1, 6, 1, 15, 11, 17, 12, 3, 14, 15, 11 },
  { 7733, 10, 1, 6, 1, 15, 11, 17, 12, 3, 14, 15, 11 },
  { 7638, 10, 1, 6, 1, 15, 11, 18, 12, 3, 14, 15, 11 },
  { 7547, 10, 1, 6, 1, 15, 11, 18, 12, 3, 14, 15, 11 },
  { 7459, 10, 1, 6, 1, 15, 11, 19, 12, 3, 14, 15, 11 },
  { 7374, 10, 1, 7, 2, 15, 12, 19, 12, 3, 14, 15, 11 },
  { 7291, 10, 1, 7, 2, 15, 12, 20, 12, 3, 14, 15, 11 },
  { 7212, 10, 1, 7, 2, 15, 12, 20, 12, 3, 14, 15, 11 },
  { 7135, 10, 1, 7, 2, 15, 14, 21, 12, 3, 14, 15, 11 },
  { 7061, 10, 1, 7, 2, 15, 14, 21, 12, 3, 14, 15, 11 },
  { 6988, 10, 1, 7, 2, 15, 14, 22, 12, 3, 14, 15, 11 },
  { 6918, 10, 1, 7, 2, 15, 14, 22, 12, 3, 14, 15, 11 },
  { 6850, 10, 1, 7, 2, 15, 14, 23, 12, 3, 14, 15, 11 },
  { 6784, 10, 1, 7, 2, 15, 14, 23, 12, 3, 14, 15, 11 },
  { 6720, 10, 1, 7, 2, 15, 14, 24, 12, 3, 14, 15, 11 },
  { 6658, 10, 1, 7, 2, 15, 14, 24, 12, 3, 14, 15, 11 },
  { 6597, 10, 1, 7, 2, 15, 14, 25, 12, 3, 14, 15, 11 },
  { 6539, 10, 1, 7, 2, 15, 14, 25, 12, 3, 14, 15, 11 },
  { 6482, 10, 1, 7, 2, 15, 14, 26, 12, 3, 14, 15, 11 },
  { 6427, 10, 1, 7, 2, 15, 14, 26, 12, 3, 14, 15, 11 },
  { 6373, 10, 3, 7, 3, 15, 12, 17, 12, 3, 14, 15, 11 },
  { 6321, 10, 3, 7, 3, 15, 12, 17, 12, 3, 14, 15, 11 },
  { 6270, 10, 3, 7, 3, 15, 12, 17, 12, 3, 14, 15, 11 },
  { 6222, 10, 3, 7, 3, 15, 12, 18, 12, 3, 14, 15, 11 },
  { 6174, 10, 3, 7, 3, 15, 12, 18, 12, 3, 14, 15, 11 },
  { 6128, 10, 3, 7, 3, 15, 12, 18, 12, 3, 14, 15, 11 },
  { 6083, 10, 3, 7, 3, 15, 12, 18, 12, 3, 14, 15, 11 },
  { 6040, 10, 3, 7, 3, 15, 12, 19, 12, 3, 14, 15, 11 },
  { 5997, 10, 3, 7, 3, 15, 12, 19, 12, 3, 14, 15, 11 },
};

#define SIZE_FULL_TABLE         77

static const uint8_t full_gain_table[3][SIZE_FULL_TABLE][3] =
{ {  /* 800 MHz */
        { 0x00, 0x00, 0x20 }, { 0x00, 0x00, 0x00 }, { 0x00, 0x00, 0x00 },
        { 0x00, 0x01, 0x00 }, { 0x00, 0x02, 0x00 }, { 0x00, 0x03, 0x00 },
        { 0x00, 0x04, 0x00 }, { 0x00, 0x05, 0x00 }, { 0x01, 0x03, 0x20 },
        { 0x01, 0x04, 0x00 }, { 0x01, 0x05, 0x00 }, { 0x01, 0x06, 0x00 },
        { 0x01, 0x07, 0x00 }, { 0x01, 0x08, 0x00 }, { 0x01, 0x09, 0x00 },
        { 0x01, 0x0A, 0x00 }, { 0x01, 0x0B, 0x00 }, { 0x01, 0x0C, 0x00 },
        { 0x01, 0x0D, 0x00 }, { 0x01, 0x0E, 0x00 }, { 0x02, 0x09, 0x20 },
        { 0x02, 0x0A, 0x00 }, { 0x02, 0x0B, 0x00 }, { 0x02, 0x0C, 0x00 },
        { 0x02, 0x0D, 0x00 }, { 0x02, 0x0E, 0x00 }, { 0x02, 0x0F, 0x00 },
        { 0x02, 0x10, 0x00 }, { 0x02, 0x2B, 0x20 }, { 0x02, 0x2C, 0x00 },
        { 0x04, 0x28, 0x20 }, { 0x04, 0x29, 0x00 }, { 0x04, 0x2A, 0x00 },
        { 0x04, 0x2B, 0x00 }, { 0x24, 0x20, 0x20 }, { 0x24, 0x21, 0x00 },
        { 0x44, 0x20, 0x20 }, { 0x44, 0x21, 0x00 }, { 0x44, 0x22, 0x00 },
        { 0x44, 0x23, 0x00 }, { 0x44, 0x24, 0x00 }, { 0x44, 0x25, 0x00 },
        { 0x44, 0x26, 0x00 }, { 0x44, 0x27, 0x00 }, { 0x44, 0x28, 0x00 },
        { 0x44, 0x29, 0x00 }, { 0x44, 0x2A, 0x00 }, { 0x44, 0x2B, 0x00 },
        { 0x44, 0x2C, 0x00 }, { 0x44, 0x2D, 0x00 }, { 0x44, 0x2E, 0x00 },
        { 0x44, 0x2F, 0x00 }, { 0x44, 0x30, 0x00 }, { 0x44, 0x31, 0x00 },
        { 0x44, 0x32, 0x00 }, { 0x64, 0x2E, 0x20 }, { 0x64, 0x2F, 0x00 },
        { 0x64, 0x30, 0x00 }, { 0x64, 0x31, 0x00 }, { 0x64, 0x32, 0x00 },
        { 0x64, 0x33, 0x00 }, { 0x64, 0x34, 0x00 }, { 0x64, 0x35, 0x00 },
        { 0x64, 0x36, 0x00 }, { 0x64, 0x37, 0x00 }, { 0x64, 0x38, 0x00 },
        { 0x65, 0x38, 0x20 }, { 0x66, 0x38, 0x20 }, { 0x67, 0x38, 0x20 },
        { 0x68, 0x38, 0x20 }, { 0x69, 0x38, 0x20 }, { 0x6A, 0x38, 0x20 },
        { 0x6B, 0x38, 0x20 }, { 0x6C, 0x38, 0x20 }, { 0x6D, 0x38, 0x20 },
        { 0x6E, 0x38, 0x20 }, { 0x6F, 0x38, 0x20 }
}, {  /* 2300 MHz */
        { 0x00, 0x00, 0x20 }, { 0x00, 0x00, 0x00 }, { 0x00, 0x00, 0x00 },
        { 0x00, 0x01, 0x00 }, { 0x00, 0x02, 0x00 }, { 0x00, 0x03, 0x00 },
        { 0x00, 0x04, 0x00 }, { 0x00, 0x05, 0x00 }, { 0x01, 0x03, 0x20 },
        { 0x01, 0x04, 0x00 }, { 0x01, 0x05, 0x00 }, { 0x01, 0x06, 0x00 },
        { 0x01, 0x07, 0x00 }, { 0x01, 0x08, 0x00 }, { 0x01, 0x09, 0x00 },
        { 0x01, 0x0A, 0x00 }, { 0x01, 0x0B, 0x00 }, { 0x01, 0x0C, 0x00 },
        { 0x01, 0x0D, 0x00 }, { 0x01, 0x0E, 0x00 }, { 0x02, 0x09, 0x20 },
        { 0x02, 0x0A, 0x00 }, { 0x02, 0x0B, 0x00 }, { 0x02, 0x0C, 0x00 },
        { 0x02, 0x0D, 0x00 }, { 0x02, 0x0E, 0x00 }, { 0x02, 0x0F, 0x00 },
        { 0x02, 0x10, 0x00 }, { 0x02, 0x2B, 0x20 }, { 0x02, 0x2C, 0x00 },
        { 0x04, 0x27, 0x20 }, { 0x04, 0x28, 0x00 }, { 0x04, 0x29, 0x00 },
        { 0x04, 0x2A, 0x00 }, { 0x04, 0x2B, 0x00 }, { 0x24, 0x21, 0x20 },
        { 0x24, 0x22, 0x00 }, { 0x44, 0x20, 0x20 }, { 0x44, 0x21, 0x00 },
        { 0x44, 0x22, 0x00 }, { 0x44, 0x23, 0x00 }, { 0x44, 0x24, 0x00 },
        { 0x44, 0x25, 0x00 }, { 0x44, 0x26, 0x00 }, { 0x44, 0x27, 0x00 },
        { 0x44, 0x28, 0x00 }, { 0x44, 0x29, 0x00 }, { 0x44, 0x2A, 0x00 },
        { 0x44, 0x2B, 0x00 }, { 0x44, 0x2C, 0x00 }, { 0x44, 0x2D, 0x00 },
        { 0x44, 0x2E, 0x00 }, { 0x44, 0x2F, 0x00 }, { 0x44, 0x30, 0x00 },
        { 0x44, 0x31, 0x00 }, { 0x64, 0x2E, 0x20 }, { 0x64, 0x2F, 0x00 },
        { 0x64, 0x30, 0x00 }, { 0x64, 0x31, 0x00 }, { 0x64, 0x32, 0x00 },
        { 0x64, 0x33, 0x00 }, { 0x64, 0x34, 0x00 }, { 0x64, 0x35, 0x00 },
        { 0x64, 0x36, 0x00 }, { 0x64, 0x37, 0x00 }, { 0x64, 0x38, 0x00 },
        { 0x65, 0x38, 0x20 }, { 0x66, 0x38, 0x20 }, { 0x67, 0x38, 0x20 },
        { 0x68, 0x38, 0x20 }, { 0x69, 0x38, 0x20 }, { 0x6A, 0x38, 0x20 },
        { 0x6B, 0x38, 0x20 }, { 0x6C, 0x38, 0x20 }, { 0x6D, 0x38, 0x20 },
        { 0x6E, 0x38, 0x20 }, { 0x6F, 0x38, 0x20 },
}, {  /* 5500 MHz */
        { 0x00, 0x00, 0x20 }, { 0x00, 0x00, 0x00 }, { 0x00, 0x00, 0x00 },
        { 0x00, 0x00, 0x00 }, { 0x00, 0x00, 0x00 }, { 0x00, 0x01, 0x00 },
        { 0x00, 0x02, 0x00 }, { 0x00, 0x03, 0x00 }, { 0x01, 0x01, 0x20 },
        { 0x01, 0x02, 0x00 }, { 0x01, 0x03, 0x00 }, { 0x01, 0x04, 0x20 },
        { 0x01, 0x05, 0x00 }, { 0x01, 0x06, 0x00 }, { 0x01, 0x07, 0x00 },
        { 0x01, 0x08, 0x00 }, { 0x01, 0x09, 0x00 }, { 0x01, 0x0A, 0x00 },
        { 0x01, 0x0B, 0x00 }, { 0x01, 0x0C, 0x00 }, { 0x02, 0x08, 0x20 },
        { 0x02, 0x09, 0x00 }, { 0x02, 0x0A, 0x00 }, { 0x02, 0x0B, 0x20 },
        { 0x02, 0x0C, 0x00 }, { 0x02, 0x0D, 0x00 }, { 0x02, 0x0E, 0x00 },
        { 0x02, 0x0F, 0x00 }, { 0x02, 0x2A, 0x20 }, { 0x02, 0x2B, 0x00 },
        { 0x04, 0x27, 0x20 }, { 0x04, 0x28, 0x00 }, { 0x04, 0x29, 0x00 },
        { 0x04, 0x2A, 0x00 }, { 0x04, 0x2B, 0x00 }, { 0x04, 0x2C, 0x00 },
        { 0x04, 0x2D, 0x00 }, { 0x24, 0x20, 0x20 }, { 0x24, 0x21, 0x00 },
        { 0x24, 0x22, 0x00 }, { 0x44, 0x20, 0x20 }, { 0x44, 0x21, 0x00 },
        { 0x44, 0x22, 0x00 }, { 0x44, 0x23, 0x00 }, { 0x44, 0x24, 0x00 },
        { 0x44, 0x25, 0x00 }, { 0x44, 0x26, 0x00 }, { 0x44, 0x27, 0x00 },
        { 0x44, 0x28, 0x00 }, { 0x44, 0x29, 0x00 }, { 0x44, 0x2A, 0x00 },
        { 0x44, 0x2B, 0x00 }, { 0x44, 0x2C, 0x00 }, { 0x44, 0x2D, 0x00 },
        { 0x44, 0x2E, 0x00 }, { 0x64, 0x2E, 0x20 }, { 0x64, 0x2F, 0x00 },
        { 0x64, 0x30, 0x00 }, { 0x64, 0x31, 0x00 }, { 0x64, 0x32, 0x00 },
        { 0x64, 0x33, 0x00 }, { 0x64, 0x34, 0x00 }, { 0x64, 0x35, 0x00 },
        { 0x64, 0x36, 0x00 }, { 0x64, 0x37, 0x00 }, { 0x64, 0x38, 0x00 },
        { 0x65, 0x38, 0x20 }, { 0x66, 0x38, 0x20 }, { 0x67, 0x38, 0x20 },
        { 0x68, 0x38, 0x20 }, { 0x69, 0x38, 0x20 }, { 0x6A, 0x38, 0x20 },
        { 0x6B, 0x38, 0x20 }, { 0x6C, 0x38, 0x20 }, { 0x6D, 0x38, 0x20 },
        { 0x6E, 0x38, 0x20 }, { 0x6F, 0x38, 0x20 }
} };

#endif /* _IOMLIB_D2RF_H */
