#include <jni.h>
#include <string.h>
#include "nxm_ice_lib_NetIO.h"
#include "native.h"

#include "icedefs.h"
#include "niolib.h"
#include "niolib.c"

JNIEXPORT jint JNICALL Java_nxm_ice_lib_NetIO_nioOpen (JNIEnv *env, jobject obj, jstring str, jint chans, jint flags) {
  jint status;
  const char *ctext = GetString(str);
  status = nioOpen ((char *)ctext,chans,flags);
  ReleaseString(str,ctext);
  return status;
}

JNIEXPORT jint JNICALL Java_nxm_ice_lib_NetIO_nioClose (JNIEnv *env, jobject obj,
	jint sock) {
  return nioClose (sock);
}

JNIEXPORT jlong JNICALL Java_nxm_ice_lib_NetIO_nioAlloc (JNIEnv *env, jobject obj,
	jint bytes) {
  return (jlong)(jpointer)nioAlloc (bytes);
}

JNIEXPORT jint JNICALL Java_nxm_ice_lib_NetIO_nioFree (JNIEnv *env, jobject obj,
	jlong pdata) {
  return nioFree ((void*)(jpointer)pdata);
}

JNIEXPORT jint JNICALL Java_nxm_ice_lib_NetIO_nioSendBank (JNIEnv *env, jobject obj,
	jint sock, jint chns, jint ncpa, jlong haddr, jint hlen, jint dlen, jlong vaddr, jint bytes, jint flags) {
  return nioSendBank (sock,chns,ncpa,(void*)(jpointer)haddr,hlen,dlen,(void*)(jpointer)vaddr,bytes,flags);
}

JNIEXPORT jint JNICALL Java_nxm_ice_lib_NetIO_nioSend (JNIEnv *env, jobject obj,
	jint sock, jint chan, jlong vaddr, jint bytes, jint flags) {
  return nioSend (sock,chan,(void*)(jpointer)vaddr,bytes,flags);
}

JNIEXPORT jint JNICALL Java_nxm_ice_lib_NetIO_nioRecv (JNIEnv *env, jobject obj,
	jint sock, jint chan, jlong vaddr, jint bytes, jint flags) {
  return nioRecv (sock,chan,(void*)(jpointer)vaddr,bytes,flags);
}

JNIEXPORT jint JNICALL Java_nxm_ice_lib_NetIO_nioSendB (JNIEnv *env, jobject obj,
	jint sock, jint chan, jobject array, jint off, jint bytes, jint flags) {
  jbyte *bbuf = GetArray (array);
  jint status =  nioSend (sock,chan,(void*)bbuf+off,bytes,flags);
  ReleaseArray(array,bbuf);
  return status;
}

JNIEXPORT jint JNICALL Java_nxm_ice_lib_NetIO_nioRecvB (JNIEnv *env, jobject obj,
	jint sock, jint chan, jobject array, jint off, jint bytes, jint flags) {
  jbyte *bbuf = GetArray (array);
  jint status = nioRecv (sock,chan,(void*)bbuf+off,bytes,flags);
  ReleaseArray(array,bbuf);
  return status;
}

JNIEXPORT jint JNICALL Java_nxm_ice_lib_NetIO_nioMsg (JNIEnv *env, jobject obj,
	jint sock, jint chan, jint func, jobject array, jint bytes, jint flags) {
  jbyte *bbuf = GetArray (array);
  jint status =  nioMsg (sock,chan,func,(void*)bbuf,bytes,flags);
  ReleaseArray(array,bbuf);
  return status;
}

JNIEXPORT jint JNICALL Java_nxm_ice_lib_NetIO_nioFile (JNIEnv *env, jobject obj,
	jint sock, jobject fname, jobject aname, jint flags) {
  const char *fstr = GetString(fname);
  const char *astr = GetString(aname);
  jint status =  nioFile (sock,(char*)fstr,(char*)astr,flags);
  ReleaseString(fname,fstr);
  ReleaseString(aname,astr);
  return status;
}

JNIEXPORT jint JNICALL Java_nxm_ice_lib_NetIO_swap2 (JNIEnv *env, jclass clazz,
	jlong pbuf1, jlong pbuf2, jint bytes) {
  jint i; int_1 b, *buf1 = (int_1*)(jpointer)pbuf1, *buf2 = (int_1*)(jpointer)pbuf2;
  for (i=0; i<bytes; i+=2) {
    b = buf1[i];
    buf2[i] = buf1[i+1];
    buf2[i+1] = b;
  }
  return bytes;
}

JNIEXPORT jint JNICALL Java_nxm_ice_lib_NetIO_cvt12to16 (JNIEnv *env, jclass clazz,
	jlong pbuf1, jlong pbuf2, jint bytes) {
  jint i,j; int_1 *buf1 = (int_1*)(jpointer)pbuf1; int_4 b, *buf2 = (int_4*)(jpointer)pbuf2;
  for (i=j=0; i<bytes>>2; i++) {
    b  = buf1[j++]<<4;
    b |= (buf2[j]<<16)&0xF00000;
    b |= (buf2[j++]<<12)&0xF000;
    b |= buf2[j++]<<24;
    buf1[i] = b;
  }
  return i<<2;
}
JNIEXPORT jint JNICALL Java_nxm_ice_lib_NetIO_cvt16to12 (JNIEnv *env, jclass clazz,
	jlong pbuf1, jlong pbuf2, jint bytes) {
  jint i,j; int_4 b, *buf1 = (int_4*)(jpointer)pbuf1; int_1 *buf2 = (int_1*)(jpointer)pbuf2;
  for (i=j=0; i<(bytes>>2); i++) {
    b = buf1[i];
    buf2[j++] = (b>>4)&0xFF;
    buf2[j++] = ((b>>12)&0x0F) | ((b>>16)&0xF0);
    buf2[j++] = (b>>24)&0xFF;
  }
  return j;
}
  
