package nxm.ice.lib;

import nxm.sys.inc.*;
import nxm.sys.lib.*;

/**
  A class to analyze and modify ICE system configuration

  @author Jeff Schoen
  @version %I%, %G%

*/
public class IceSys {

  public static Table config;
  public static Midas M;
  public static boolean isLoaded=load();

  /** get new device alias from implicit call to getConfig */
  public IceSys () {
    load();
  }

  public static boolean load() {
    M = Shell.getMidasContext();
    String file = M.io.name("HOME","iceauto","tbl","AUX");
    config = Convert.o2t(file,M);
    return true;
  }

  public static void query (String uri) {
    int i,j,k=0;
    String list=null;
    int maxitems=32;
    Object obj = config;
    Query q = new Query(obj,list,maxitems);

    int ls = uri.length();
    int le = uri.indexOf("=");
    if (le<0) le=ls;
    // walk the chain
    for (j=0; (k=uri.indexOf("/",j)) > j; j=k) {
      k++; i = uri.indexOf("/",k);
      if (i<0) i=le;
      String key = uri.substring(k,i);
      System.out.println("Key="+key);
      q.parse();
      obj = q.getObject(key);
      q = new Query(obj,list,maxitems);
    }
    if (k<0) k=0;
    String key = uri.substring(k,le);
    q.parse();
    obj = q.getObject(key);
    System.out.println(uri.substring(0,le)+"="+obj);
  }

  public static Table getNICs() {
    Table t = new Table();
    int n = config.getL("NICS");
    t.put("NICS",n);
    for (int i=0; i<n; i++) {
      String key = "NIC"+i+"AUTO";
      String value = config.getS(key);
      Table tp = new Table("{"+value+"}");
      t.put(key,tp);
    }
    return t;
  }
  public static Table getPICs() {
    Table t = new Table();
    int n = config.getL("PICS");
    t.put("PICS",n);
    for (int i=1; i<=n; i++) {
      String key = "PIC"+i+"AUTO";
      String value = config.getS(key);
      MDevIce pic = new MDevIce (M,value);
      while (value.endsWith(",")) value = value.substring(0,value.length()-1);
      pic.open();
      int act = pic.getKeyL(0,pic.KEY_ACTIVE);
      int temp = -1;
      int[] temps = {-1,-1,-1,-1,-1};
      if (act>=0) {
        temp = temps[0] = (int)pic.getKeyD(0,pic.KEY_TEMP);
        if (pic.getKeyL(0,pic.KEY_MTYPE1)!=0)  { temps[1] = (int)pic.getKeyD(1,pic.KEY_TEMP);  if (temps[1]>temp) temp=temps[1]; }
        if (pic.getKeyL(0,pic.KEY_MTYPE2)!=0)  { temps[2] = (int)pic.getKeyD(2,pic.KEY_TEMP);  if (temps[2]>temp) temp=temps[2]; }
        if (pic.getKeyL(0,pic.KEY_PMTYPE1)!=0) { temps[3] = (int)pic.getKeyD(11,pic.KEY_TEMP); if (temps[3]>temp) temp=temps[3]; }
        if (pic.getKeyL(0,pic.KEY_PMTYPE2)!=0) { temps[4] = (int)pic.getKeyD(12,pic.KEY_TEMP); if (temps[4]>temp) temp=temps[4]; }
      }
      int flags = (act>=0)? pic.getKeyL(0,pic.KEY_DRVFLG) : 0;
      pic.close();
      value = value.replace("ICEPIC","ACTIVE="+act+",TEMP="+temp+",FLAGS="+Convert.l2x(flags));
      value += ",COMPTEMP=("+temps[0]+","+temps[1]+","+temps[2]+","+temps[3]+","+temps[4]+")";
      Table tp = new Table("{"+value+"}");
      t.put(key,tp);
    }
    return t;
  }
  public static Table getQICs() {
    Table t = new Table();
    int n = config.getL("QICS");
    t.put("QICS",n);
    return t;
  }
  public static Table getDisks() {
    Table t = new Table();
    String list = M.results.getS("AUX.READ");
    String[] auxes = StringUtil.cleanSplit(list, "|");
    for (int i=0; i<auxes.length; i++) {
      String aux = auxes[i];
      String path = M.io.getAuxPath(aux);
      Table tab = OS.getStatFS(path);
      t.put(aux,tab);
    }
    return t;
  }
  public static Table getFS() {
    return null;
  }

  // replace with OS.runCommand in later NXM trees
  public static int runCommand (String cmd, int flags, byte[] buf) {
    int state,boff=0,bytes,timeout=20;
    try {
      Runtime runtime = java.lang.Runtime.getRuntime();
      Process osProcess = runtime.exec(cmd);
      java.io.OutputStream osInput = osProcess.getOutputStream();
      java.io.InputStream osOutput = osProcess.getInputStream();
      for (state=0; state>=0 && timeout!=0 && boff<buf.length;) {
        if ((bytes=osOutput.available()) > 0) {
          bytes = Math.min(bytes,buf.length-boff);
          bytes = osOutput.read(buf,boff,bytes);
          if (bytes>0) boff+=bytes;
          state=1;
        }
        try {
          int status = osProcess.exitValue();
          // check for any output left in buffer after exit
          if (osOutput.available()>0) state=0; else state=-1;
        } catch (IllegalThreadStateException e) {
          if (state==0) { Time.sleep(0.1); timeout--; }
          else state=0;
        }
      }
      osInput.close();
      osOutput.close();
    } catch (Exception e) {
      Shell.printStackTrace("Error running OS cmd", e);
    }
    return boff;
  }

}
