package nxm.ice.lib;

import nxm.ice.lib.IceHW;

public class IcePM extends IceJVM {

  public final static int CF_SLOTS=0x04020008;    // Command Fifo slots address from HA
  public final static int CF_SNIFF=0x04020000;    // Command Fifo sniff address
  public final static int CF_XFER =0x04020010;    // Command Fifo read address
  public final static int CF_RESET=0x04020008;    // Command Fifo reset address

  // normal static vars
  public static int runMode;
  public static int dcfgA,dcfgB;
  public static int delayA,delayB;

  public static int dbg1,dbg2,dbg3;

  public static void run() {
    int slots,cmd,beat=0x01CE0123;
    awMem(HBT,beat);
    reset();
    resetCmdFifo(1);		// ignore cmd bus at startup until init
    for (;;beat=beat+1) {
      processMessages();
      if (runMode==ALG_PROCESS) processAlgorithm();
      slots = arBusSync(CF_SLOTS) & 0xFFF;
      if (slots>0) {		// command FIFO
        cmd = arBus(CF_SNIFF);
        if ((cmd&0xFFF00000)!=0x1CE00000) cleanupCmdFifo();
        else if (slots>=(cmd&0xF)) processCmdFifo();
      }
      awMem(HBT,beat);
    }
  }

  public static void wdbg() {
    awMem(0x300,dbg1);
    awMem(0x304,dbg2);
    awMem(0x308,dbg3);
  }

  public static void resetCmdFifo (int mode) {
    awBus(CF_RESET,(mode<0)?1:mode);
    awBus(CF_RESET,(mode<0)?0:mode);
  }

  public static void cleanupCmdFifo () {
    dbg2 = arBus(CF_SLOTS);
    int cmd = arBus(CF_XFER);   // just read off top for now
    dbg3 = cmd;
    wdbg();
  }

  public static void processCmdFifo () {
    int cmd,len,addr,data;
    cmd  = arBus(CF_XFER);
    addr = rBus();
    if (cmd==0x1ce10004) {		// write
      len  = rBus();
      data = rBus();
      if (len<4 || len>256) { cleanupCmdFifo(); return; }
      aBus(addr); 
      awBus(addr,data); 
      for (;len>4;len-=4) {
        while ((arBusSync(CF_SLOTS)&0xFFF)==0);
        awBus(addr,arBus(CF_XFER)); 
      }
    }
    else if (cmd==0x1ce20002) {	// read
      aBus(addr); 
      data = arBus(addr); 
      awBus(CF_XFER,0x1ce30002);	// response
      awBus(CF_XFER,data);
    }
  }

  public static void processWRB (int key) {
    maddr = MSG+4;
    saddr = mdata;
    int size = (key>>8) & 0xFFFF;
    for (;size>0;size-=4) sdata = mdata;
    maddr = MSG;
    mdata = 0xAA0000AA;
  }

  public static void processMessages() {
    maddr = MSG;
    int key = mdata;
    if ((key>>24)!=0x55) return;
    if ((key&0xFF)==0x77) { processWRB(key); return; }
    int node = mdata;
    int head = mdata;
    int addr = mdata;
    int func = head & 0x3F;
    int olen = head >> 16;
    int size = olen >> 2;
    int data = MSG+16;
    switch (func) {
    case 1: busr (addr,data,size); break;
    case 2: busw (addr,data,size); olen=0; break;
    case 3: memr (addr,data,size); break;
    case 4: memw (addr,data,size); olen=0; break;
    case 6: initAlgorithm(); if (addr==-1) resetCmdFifo(-1); break;
    case 7: modifyAlgorithm(data,size); break;
    case 8: case 9:
      int port = addr & 0xFFFF;
      int type = addr>>16;
      int route = mdata;
      int dcfg  = mdata;
      int delay = mdata;
      if (dcfg!=0) setupDelay (dcfg,delay);
      if (func==8) openAlgorithm(port,type,route);
      else        closeAlgorithm(port,type,route);
      break;
    case 14: busrwm (addr,data,size); break;
    case 15: memi (data,size); olen=0; break;
    }
    maddr = MSG;
    mdata = 0xAA0000AA | (olen<<8);
  }

  public static void initAlgorithm () {
    resetDMA();
    runMode = ALG_INIT;
    dcfgA = 0;
    dcfgB = 0;
  }

  public static void openAlgorithm (int port, int type, int route) {
    awBus(DMAC_ROUTE_SET,route);
  }

  public static void processDelays () {
    if (dcfgA!=0) processDelay(dcfgA,delayA);
    if (dcfgB!=0) processDelay(dcfgB,delayB);
  }

  public static void setupDelay (int dcfg, int delay) {
    int i = (dcfg>> 8)&0x0F;
    int j = (dcfg>>12)&0x0F;
    int k =  dcfg     &0xFF;
    if ((i&0x1)==0) {
      dcfgA = dcfg;
      delayA = delay;
      k |= 0x08000000;
    } else {
      dcfgB = dcfg;
      delayB = delay;
    }
    setupDMAo (i,k,-1);
    setupDMAi (j,k,-1);
  }

  public static void processDelay (int dcfg, int delay) {
    int oc = (dcfg>>8)&0xF;
    int ic = (dcfg>>12)&0xF;
    int route = 0x1<<(ic+24);
    int croute = arBus(DMAC_STATUS);
    if ((croute&route)!=0) return;
    int ooff = arMemSync(DMA_XO+(oc<<3));
    int ioff = arMemSync(DMA_XI+(ic<<3));
    int diff = ooff-ioff; if (diff<0) diff = diff + 0x08000000;
    diff = diff - delay;
    if (diff>0x1000) {
      ioff = (ioff&0x08000000) | ((ioff+0x1000)&0x07FFFFFF);
      awMem(DMA_XI+(ic<<3)+4,ioff);
      awBus(DMAC_ROUTE_SET,route);
    }
  }

  public static void processAlgorithm () {
  }

  public static void closeAlgorithm (int port, int type, int route) {
    awBus(DMAC_ROUTE_CLR,route);
    if (arBus(DMAC_CTL)==0) resetDMA();
  }

  public static void modifyAlgorithm (int data, int size) {
    
  }

  protected static void reset () {
    resetDMA();
    runMode=0;
    awMem(MSG,0);
  }

  protected static void resetDMA () {
    awBus(DMAC_ROUTE_RST,-1);
    udelay(20);
    awBus(DMAC_ROUTE_RST,-1);
    for (int i=0; i<8;  i++) setupDMAi(i, 0, 0);
    for (int i=0; i<8;  i++) setupDMAo(i, 0, 0);
    for (int i=0; i<32; i++) setupDMAt(i, 0);
    awBus(DMAC_ROUTE_FLG,ROUTF_HXFDP);
    setupDMAo(PM_HYPA,0x0002,-1);
    setupDMAo(PM_HYPB,0x0002,-1);
  }
    
  // sets up DMA outof block into RAM
  static void setupDMAno (int i, int cur_addr, int cfg_addr) {
    maddr = DMA_NO + (i<<3);
    mdata = cur_addr; 
    mdata = cfg_addr; 
  }

  // sets up DMA outof block into RAM
  static void setupDMAo (int i, int cur_addr, int cfg_addr) {
    maddr = DMA_XO + (i<<3);
    mdata = cur_addr; 
    mdata = cfg_addr; 
  }

  // sets up DMA into block from RAM
  static void setupDMAi (int i, int cur_addr, int cfg_addr) {
    maddr = DMA_XI + (i<<3);
    mdata = cur_addr; 
    mdata = cfg_addr; 
  }
  
  // sets up DMA out of tuner/mcore into RAM
  static void setupDMAt (int i, int cur_addr) {
    maddr = DMA_TO + (i<<2);
    mdata = cur_addr; 
  }

  // compare of synchronous current and config DMA registers
  protected static int dmaSync (int addr) {
    maddr = addr;
    int data = mdata;
    data -= mdata;
    return data;
  }

  public static int wait4route (int mask) {
    for (int i=0;i<0xFF0;i++) {
      if ((arBus(DMAC_STATUS)&mask)==0) return i;
      if (i>0x100) udelay(10);
    }
    awBus(DMAC_ROUTE_CLR,mask);
    return -1;
  }
}
