package nxm.ice.lib;

public interface IceHW {

  public final static int REG_AMDAU=0x02000044, REG_AMCSR=0x02000048, REG_AMDAR=0x02000058, REG_AMDTC=0x0200005C; 
  public final static int REG_AIMB1=0x02000060, REG_AIMB2=0x02000064, REG_AIMB3=0x02000068, REG_AIMB4=0x0200006C;
  public final static int REG_AOMB1=0x02000070, REG_AOMB2=0x02000074, REG_AOMB3=0x02000078, REG_AOMB4=0x0200007C; 
  public final static int REG_AFIFO=0x02000000, REG_AHIRX=0x02000080, REG_AHAR0=0x02000080; // special address map

  public final static int MCSR_OMB1F=0x00010000, MCSR_IMB1F=0x00100000, MCSR_IFIFO_FULL=0x10000000, MCSR_OFIFO_EMPTY=0x08000000; 
  public final static int MCSR_RFIFO=0x00000004, MCSR_MENA=0x00000010, MCSR_MDIR=0x00000020, MCSR_TEST=0x00000080,  MCSR_QSTAT=0x00000100;
  public final static int MCSR_MASTER_WR=0x00000030, MCSR_MASTER_RD=0x00000010, MCSR_MASTER_RDM=0x00001010, MCSR_MASTER_DAC=0x00000800;

  public final static int PM_PROC=0;
  public final static int PM_HOST=1;
  public final static int PM_HYPA=2;
  public final static int PM_HYPB=3;
  public final static int PM_CORA=4;
  public final static int PM_CORB=5;
  public final static int PM_TUNA=6;
  public final static int PM_TUNB=7;

  public final static int HYPA_CTL=0x04000000, HYPB_CTL=0x08000000;
  public final static int CORA_CTL=0x10000000, CORB_CTL=0x20000000;
  public final static int TUNA_CTL=0x40000000, TUNB_CTL=0x80000000, TUNC_CTL=0x80490000;
  public final static int PMA_CTL =0x40000000, PMB_CTL =0x80000000;
  public final static int GCFPGA_FREQ=(6<<2);
  public final static int GCFPGA_POFF=(7<<2);

  public final static int ICAP7_BASE=0x00080000;
  public final static int ICAP_BASE=0x00700000;

  public final static int DSG_PIC=0, DSG_PAC=1, DSG_SPAC=2, DSG_NPAC=3, DSG_CPAC=4, DSG_PIC8Q=5, DSG_TRAY=6;

  public final static int JTAG_BASE=0x00800000, JTAG_TMS=0x00800000, JTAG_TDI=0x00800004, JTAG_ENA=0x00800008, JTAG_STAT=0x0080000C;
  public final static int JTAG_TMS_CMD=0x380000DF,    JTAG_MSK_CMD=0x0000000F; 
  public final static int JTAG_TMS_RST=0x000000FF,    JTAG_MSK_RST=0x00000001; 
  public final static int JTAG_TMS_SET8R=0x0000FF80,  JTAG_MSK_SET8R=0x00000003; 
  public final static int JTAG_TMS_SET16X=0x00000000, JTAG_MSK_SET16X=0x00000003; 
  public final static int JTAG_TMS_SET32X=0x00000000, JTAG_MSK_SET32X=0x0000000F; 
  public final static int JTAG_TMS_GET16X=0x00000000, JTAG_MSK_GET16X=0x00000303; 
  public final static int JTAG_TMS_GET32X=0x00000000, JTAG_MSK_GET32X=0x00000F0F; 
  public final static int JTAG_TMS_WMOD32=0xFFFFFFFE, JTAG_MSK_WMOD32=0x0000000F; 
  public final static int JTAG_TMS_RMOD32=0xFFFFFFFE, JTAG_MSK_RMOD32=0x00000F0F; 
  public final static int JTAG_CMD_USER2=0x3FC3,      JTAG_STXCMD_USER0=0x3FC0C, JTAG_STXCMD_USER1=0x3FC0E;

  public final static int BADDR_WR=0x4, BADDR_RD=0xC, BDATA=0x0, BADDR_DSOCM=0x0; 

  public final static int DMAC_CLOCK=0x01004000;
  public final static int DMAC_CLOCK_RMEM=0x0010;

  public final static int DMAC_STATUS   =0x01008000;
  public final static int DMAC_CTL      =0x01008000;
  public final static int DMAC_ROUTE    =0x01008000;
  public final static int DMAC_ROUTE_RST=0x01008000;
  public final static int DMAC_ROUTE_FLG=0x01008004;
  public final static int DMAC_ROUTE_SET=0x01008008;
  public final static int DMAC_ROUTE_CLR=0x0100800C;
  public final static int DMAC_HPCNT    =0x01008010;
  public final static int DMAC_ROUTE_SPD=0x01008014;
  public final static int DMAC_ROUTE_NIO=0x01008018;
  public final static int DMAC_ONDEM_EN =0x01008019;
  public final static int DMAC_ONDEM_UP =0x0100801A;
  public final static int DMAC_ROUTE_FDP=0x0100801C;

  public final static int ROUTE_CA2HA=0x00000001, ROUTE_CB2HA=0x00000002, ROUTE_CA2HB=0x00000004, ROUTE_CB2HB=0x00000008;
  public final static int ROUTE_HA2CA=0x00000010, ROUTE_HB2CA=0x00000020, ROUTE_HA2CB=0x00000040, ROUTE_HB2CB=0x00000080;
  public final static int ROUTE_TA2HA=0x00000100, ROUTE_CA2TA=0x00000200, ROUTE_CB2TB=0x00000400, ROUTE_TB2HB=0x00000800;
  public final static int ROUTE_HA2TA=0x00001000, ROUTE_HB2TA=0x00002000, ROUTE_HA2TB=0x00004000, ROUTE_HB2TB=0x00008000;


  public final static int ROUTE_PR2R =0x00010000, ROUTE_HP2R =0x00020000, ROUTE_HA2R =0x00040000, ROUTE_HB2R =0x00080000;
  public final static int ROUTE_CA2R =0x00100000, ROUTE_CB2R =0x00200000, ROUTE_TA2R =0x00400000, ROUTE_TB2R =0x00800000;
  public final static int ROUTE_R2PR =0x01000000, ROUTE_R2HP =0x02000000, ROUTE_R2HA =0x04000000, ROUTE_R2HB =0x08000000;
  public final static int ROUTE_R2CA =0x10000000, ROUTE_R2CB =0x20000000, ROUTE_R2TA =0x40000000, ROUTE_R2TB =0x80000000;
  public final static int ROUTE_R2X =0xFF000000, ROUTE_X2R =0x00FF0000;

  public final static int ROUTE_CA2TB=0x00000100, ROUTE_CB2TA=0x00000800; 
  public final static int ROUTE_TA2CA=0x00000002, ROUTE_TB2CB=0x00000004;

  public final static int ROUTE_HAANY =(ROUTE_HA2R);
  public final static int ROUTE_HBANY =(ROUTE_HB2R);
  public final static int ROUTE_TAANY =(ROUTE_TA2R);
  public final static int ROUTE_TBANY =(ROUTE_TB2R);
  public final static int ROUTE_XAANY =(ROUTE_HA2R|ROUTE_TA2R|ROUTE_R2HA|ROUTE_R2TA);
  public final static int ROUTE_XBANY =(ROUTE_HB2R|ROUTE_TB2R|ROUTE_R2HB|ROUTE_R2TB);
  public final static int ROUTE_HXANY =(ROUTE_HA2R|ROUTE_HB2R|ROUTE_R2HA|ROUTE_R2HB);
  public final static int ROUTE_TXANY =(ROUTE_TA2R|ROUTE_TB2R|ROUTE_R2TA|ROUTE_R2TB);
  public final static int ROUTE_XA2TA =(ROUTE_HA2TA|ROUTE_CA2TA);
  public final static int ROUTE_XB2TA =(ROUTE_HB2TA|ROUTE_CB2TA);
  public final static int ROUTE_XA2TB =(ROUTE_HA2TB|ROUTE_CA2TB);
  public final static int ROUTE_XB2TB =(ROUTE_HB2TB|ROUTE_CB2TB);
  public final static int ROUTE_X2TA  =(ROUTE_HA2TA|ROUTE_HB2TA|ROUTE_R2TA|ROUTE_CA2TA|ROUTE_CB2TA);
  public final static int ROUTE_X2TB  =(ROUTE_HA2TB|ROUTE_HB2TB|ROUTE_R2TB|ROUTE_CA2TB|ROUTE_CB2TB);
  public final static int ROUTE_Y2TA  =(ROUTE_HA2TA|ROUTE_R2TA|ROUTE_CA2TA);
  public final static int ROUTE_Y2TB  =(ROUTE_HA2TB|ROUTE_R2TB|ROUTE_CB2TB);
  public final static int ROUTE_TA2X  =(ROUTE_TA2HA|ROUTE_TA2R);
  public final static int ROUTE_TB2X  =(ROUTE_TB2HB|ROUTE_TB2R);
  public final static int ROUTE_HX2R  =(ROUTE_HA2R|ROUTE_HB2R);
  public final static int ROUTE_HX2TX =(ROUTE_HA2TA|ROUTE_HA2TB|ROUTE_HB2TA|ROUTE_HB2TB);
  public final static int ROUTE_HA2X  =(ROUTE_HA2CA|ROUTE_HA2CB|ROUTE_HA2TA|ROUTE_HA2TB|ROUTE_HA2R);
  public final static int ROUTE_HB2X  =(ROUTE_HB2CA|ROUTE_HB2CB|ROUTE_HB2TA|ROUTE_HB2TB|ROUTE_HB2R);
  public final static int ROUTE_HX2X  =(ROUTE_HA2X|ROUTE_HB2X);
  public final static int ROUTE_X2PR  =(ROUTE_R2PR);
  public final static int ROUTE_X2HP  =(ROUTE_R2HP);
  public final static int ROUTE_X2HA  =(ROUTE_CA2HA|ROUTE_CB2HA|ROUTE_TA2HA|ROUTE_R2HA);
  public final static int ROUTE_X2HB  =(ROUTE_CA2HB|ROUTE_CB2HB|ROUTE_TB2HB|ROUTE_R2HB);
  public final static int ROUTE_X2HX  =(ROUTE_X2HA|ROUTE_X2HB);
  public final static int ROUTE_X2CA  =(ROUTE_HA2CA|ROUTE_HB2CA|ROUTE_R2CA);
  public final static int ROUTE_X2CB  =(ROUTE_HA2CB|ROUTE_HB2CB|ROUTE_R2CB);
  public final static int ROUTE_X2CX  =(ROUTE_X2CA|ROUTE_X2CB);
  public final static int ROUTE_HX2CX =(ROUTE_HA2CA|ROUTE_HB2CB);
  public final static int ROUTE_CX2HX =(ROUTE_CA2HA|ROUTE_CB2HB);

  public final static int ROUTF_HPFDP= 0x00000010, ROUTF_HXFDP= 0x00000020, ROUTF_CXFDP=0x00000040, ROUTF_TXFDP=0x00000080;
  public final static int ROUTF_TX2HX= 0x00001000, ROUTF_CX2HX= 0x00002000, ROUTF_CXAOB=0x00008000, ROUTF_TXAOB=0x00020000; 
  public final static int ROUTF_TA2HX= 0x00040000, ROUTF_TB2HX= 0x00080000, ROUTF_DIO2P=0x00100000, ROUTF_P2DIO=0x00200000;
  public final static int ROUTF_NIO2M= 0x01000000, ROUTF_M2NIO= 0x02000000, ROUTF_NV2M= 0x04000000, ROUTF_M2NV= 0x08000000; 
  public final static int ROUTF_NIO2HX=0x10000000, ROUTF_HX2NIO=0x20000000, ROUTF_NV2HX=0x40000000, ROUTF_HX2NV=0x80000000; 

  public final static int DMA_TO=0xFD800000;
  public final static int DMA_XI=0xFD803F00;
  public final static int DMA_XO=0xFD803F40;
  public final static int DMA_TX=0xFD803F70;
  public final static int DMA_NI=0xFD803F80;
  public final static int DMA_AO=0xFD803F80;
  public final static int DMA_NO=0xFD803FC0;
  public final static int DMA_DIO=0xFD804000;

  public final static int DMA_XI_HYPA=0xFD803F20;
  public final static int DMA_XI_HYPB=0xFD803F28;
  public final static int DMA_XI_TUNA=0xFD803F30;
  public final static int DMA_XI_TUNB=0xFD803F38;

  public final static int IMS=0xFD000000;
  public final static int MSG=0xFD000000;
  public final static int FAT=0xFD00FFF8;
  public final static int HBT=0xFD00FFFC;

  public final static int CFG_CMD=0xFD000400;
  public final static int CFG_PAR=0xFD000404;
  public final static int CFG_RET=0xFD000408;
  public final static int CFG_BUF=0xFD000410;

  public final static int DMA_HPQL=IMS|(0x7F7D<<2);
  public final static int DMA_HPQI=IMS|(0x7F7E<<2);
  public final static int DMA_STK=IMS|(0x7000<<2);
  public final static int DMA_QUE=IMS|(0x7F80<<2);
  public final static int DMA_SEP=48;
  public final static int DMA_CHNS=76;

  public final static int DMA_NVM1        =IMS|(0x7E00<<2);
  public final static int DMA_NVM2        =IMS|(0x7E40<<2);

  public final static int DMA_TMP         =IMS|(0x7FD0<<2);

  public final static int DMA_ROUTD       =IMS|(0x7FEB<<2);
  public final static int DMA_OVSR        =IMS|(0x7FEC<<2);
  public final static int DMA_ROUTF       =IMS|(0x7FED<<2);
  public final static int DMA_IOPCFG      =IMS|(0x7FEE<<2);
  public final static int DMA_JRWIOB      =IMS|(0x7FEF<<2);
  public final static int DMA_TCDAT       =IMS|(0x7FF0<<2);           /* TimeCode Return area */
  public final static int DMA_GPASS       =IMS|(0x7FF9<<2);
  public final static int DMA_GSTAT       =IMS|(0x7FFA<<2);
  public final static int DMA_MTAP        =IMS|(0x7FFB<<2);
  public final static int DMA_GMCFG       =IMS|(0x7FFC<<2);

  public final static int IOM_SSB1        =IMS|(0x7900<<2);
  public final static int IOM_SSB2        =IMS|(0x7940<<2);

  public final static int TCM_SDDS  = 7;
  public final static int IOC_STAT  = 0x00;
  public final static int IOC_RAM   = 0x20;
  public final static int IOC_PKTHDR= 0x80;

  public final static int IOC_STAT_ENA   =0x01;
  public final static int IOC_STAT_ENB   =0x02;
  public final static int IOC_STAT_ERR   =0x04;
  public final static int IOC_STAT_SEN   =0x08;
  public final static int IOC_STAT_TNCLK =0x10;
  public final static int IOC_STAT_TDC   =0x20;
  public final static int IOC_STAT_TCYC  =0x40;
  public final static int IOC_STAT_TVAL  =0x80;

  public final static int IOC_ADDR=0x00400000;
  public final static int HYP_SHF=(PM_HYPA+24);

  public final static int IOCTL_RD=0x10000;
  public final static int IOCTL_WR=0x20000;

  public final static int ALG_INIT=0;
  public final static int ALG_OPEN=1;
  public final static int ALG_PROCESS=2;
  public final static int ALG_CLOSE=3;
  public final static int ALG_DONE=0;

  public final static int IOPT_NONE=0;
  public final static int IOPT_TUNER=4;
  public final static int IOPT_CORE=7;
  public final static int IOPT_MCORE=8;
  public final static int IOPT_TBANK=9;
  public final static int IOPT_CBANK=10;

  public final static int[] sbus=null;
  public final static int[] mbus=null;

  public final static int NBANK=16;

  public final static int FTT_LOC=0x480, FTT_SIZEOF=0x180;
  public final static int ALG_LOC=0x600;
  public final static int FTT_LOC2=0x600;

  public final static int FTT_STAGES=0x0,  FTT_ACTIVE=0x4,   FTT_CSTAGE=0x8, FTT_LSTAGE=0xC;
  public final static int FTT_BUSY =0x10,  FTT_CHANTOP=0x14, FTT_BITS=0x18,  FTT_SPEED=0x1C;
  public final static int FTT_TADDR=0x20,  FTT_TB0=0x60,     FTT_TB1=0xB0,   FTT_TB2=0x100;
  public final static int FTT_OMODA=0x150, FTT_OMODB=0x154,  FTT_DCA0=0x158, FTT_DCA1=0x15C;
  public final static int FTT_TBCTL=0x160, FTT_BASE=0x164,   FTT_ADDR=0x168;

  public final static int TB_SIZEOF=80;

  public final static int TB_MCHAN=0x00,  TB_NCHAN=0x04,   TB_DEC=0x08,    TB_CPC=0x0C;
  public final static int TB_XFER=0x10,   TB_CONS=0x14,    TB_PROD=0x18,   TB_CHAN=0x1C;
  public final static int TB_INDEX=0x20,  TB_PCFG=0x24,    TB_PSTRT=0x28,  TB_PSIZE=0x2C;
  public final static int TB_PMASK=0x30,  TB_PINDX=0x34,   TB_PHINC=0x38,  TB_DPHINC=0x3C;
  public final static int TB_TPHINC=0x40, TB_TDPHINC=0x44, TB_TPHASE=0x48, TB_TDPHASE=0x4C;

  public final static int IOM_MUX=0x00200000, IOM_BMUX=0x80000000;

  public final static int FLG_DUAL=0x00020000, FLG_NIO=0x80000000, FLG_SGO=0x00100000,FLG_NVME=0x10000000;

  public final static int ADON_RDBDB=0x41, ADON_WRBDB=0x42; 

  public final static int 
	DMA_LOOPNSPIN=-23, DMA_ENABLE=-20, DMA_LOADNSPIN=-19, DMA_STATUS_W64=-18, DMA_ONDEMAND=-17,
        DMA_BURY=-16, DMA_KILL=-15,  DMA_LOOP=-14, DMA_POLL=-13, DMA_ACTIVE=-12, DMA_RESHOT=-11,
        DMA_LOST=-10, DMA_CANCEL=-9, DMA_RESET=-8, DMA_LOAD=-7,  DMA_CYCLE=-5,   DMA_STATUS=-4,
        DMA_WAIT=-3,  DMA_CONTINUOUS=-2, DMA_SPIN=-1, DMA_STOP=0, DMA_ONESHOT=1;

  public class Message {
    public int key, node, head, addr;
    public int[] data;
  }

  public class DMAStruct {
    public int haddr, hsize, hindex, hcycle;
    public int caddr, csize, cindex, ccycle;
    public int stat,  dir,   todo,   block;
    public int cntrl, tcbp,  reg,    mcsr;
    public int enb,   enbx,  mcfg,   mcfgx;
    public int err,   miss,  iper,   multi;
    public int hxfer, hxfes, cxfer,  cxfes;
    public int cindp, hindp, cind,   hind;
    public int type,  port,  bits,   dec;
    public int rate,  gain,  fcny,   frame;
    public int master,slave, feed,   tcoff;
    public int alg,   appp,  chain,  flags;
  } 
    
  public class DMAChannel {
    public int cur,cfg;
  }

  public class TBStruct {
    public int mchan,  nchan,   dec,    cpc;
    public int xfer,   cons,    prod,   chan;
    public int index,  pcfg,    pstrt,  psize;
    public int pmask,  pindx,   phinc,  dphinc;
    public int tphinc, tdphinc, tphase, tdphase;
  }

  public class FTTStruct {
    public int stages, active, cstage, lstage;
    public int busy, chantop, bits, speed;
    public int[] taddr;
    public TBStruct[] tb;
    public int omoda,omodb;
    public DMAChannel dca0,dca1;
    public int tbctl,base,addr;
  }

}
