/**
  Template Java/C wrapper code for an CoreNative Library.

  @author Jeff Schoen
  @version $Id: CoreNative.h,v 1.5 2011/07/27 18:45:15 ntn Exp $
*/
#include "native.h"
#include "CoreDefs.h"

#define PTR (void*)
#define CPTR (void*)(jpointer)
#define LPTR (int_4*)(jpointer)
#define FPTR (real_4*)(jpointer)
#define PPTR (HALO*)(jpointer)
#define SPTR (Stream*)(jpointer)

FILE *fpi,*fpo,*fdi,*fdo;

JNIEXPORT jlong JNICALL Java_nxm_ice_lib_CoreNative_alloc (JNIEnv *env, jobject obj, jstring config) {
  return imin(0,imax(0,0)); /* must be over-ridden */
}

JNIEXPORT jint  JNICALL Java_nxm_ice_lib_CoreNative_config (JNIEnv *env, jobject obj, jlong handle,
		jint key, jint value) {
  HALO *pt = PPTR handle;
  return Core_config(CPTR handle,key,value);
}

JNIEXPORT jint  JNICALL Java_nxm_ice_lib_CoreNative_setkey (JNIEnv *env, jobject obj, jlong handle,
		jstring key, jbyte type, jobject buffer, jint off, jint len) {
  HALO *pt = PPTR handle;
  char *ckey = (char*)GetString(key);
  jbyte *buf = GetArray(buffer), *bufp = buf+off;
  Value data;
  jint status, i, needpad = (ckey[0]=='S' && ckey[1]==':') || type=='S';
  if (needpad) { bufp=malloc(len+1); for (i=0;i<len&&buf[i]!=' ';i++) bufp[i]=buf[i]; bufp[i]=0; len=i; }
  data.b=bufp; data.len=len; data.type=type;
  if (strcmp(ckey,"NAME")==0||strcmp(ckey,"S:NAME")==0) status=0;
  else status = (*pt->set) (CPTR handle,ckey,&data);
  if (needpad) free(bufp);
  ReleaseArray(buffer,buf);
  ReleaseString(key,ckey);
  return status;
}

JNIEXPORT jint  JNICALL Java_nxm_ice_lib_CoreNative_getkey (JNIEnv *env, jobject obj, jlong handle,
		jstring key, jbyte type, jobject buffer, jint off, jint len) {
  HALO *pt = PPTR handle;
  char *ckey = (char*)GetString(key);
  jbyte *buf = GetArray(buffer);
  Value data; data.b=buf+off; data.len=len; data.type=type;
  jint status;
  status = (*pt->get) (CPTR handle,ckey,&data); if (status>=0) status=data.len; 
  ReleaseArray(buffer,buf);
  ReleaseString(key,ckey);
  return status;
}

JNIEXPORT jint  JNICALL Java_nxm_ice_lib_CoreNative_init (JNIEnv *env, jobject obj, jlong handle) {
  HALO *pt = PPTR handle; jint status=0;
  if (pt->init!=NULL) status = (*pt->init) (CPTR handle);
  return status;
}

JNIEXPORT jint  JNICALL Java_nxm_ice_lib_CoreNative_open (JNIEnv *env, jobject obj, jlong handle) {
  HALO *pt = PPTR handle; jint status=0;
  char *tfn=getenv("ICECORE_TFN"), tmp[256];
  status = (*pt->open) (CPTR handle);
  if (tfn!=NULL) {
    sprintf(tmp,"%s_pin" ,tfn); fpi = fopen(tmp,"wb");
    sprintf(tmp,"%s_pout",tfn); fpo = fopen(tmp,"wb");
    sprintf(tmp,"%s_din" ,tfn); fdi = fopen(tmp,"wb");
    sprintf(tmp,"%s_dout",tfn); fdo = fopen(tmp,"wb");
  } else {
    fpi = fpo = fdi = fdo = NULL;
  }
  return status;
}

JNIEXPORT jint  JNICALL Java_nxm_ice_lib_CoreNative_work (JNIEnv *env, jobject obj, jlong handle,
		jlong si, jlong sip, jlong so, jlong sop) { 
  HALO *pt = PPTR handle; jint status=0;
  int_4 ptvs = sizeof(HALO) - sizeof(pt->config)*6 + pt->psize; /* plan test vector size */
  int_4 hbw = 32;
  Stream *Si=(Stream*)(jpointer)si, *Sip=(Stream*)(jpointer)sip;
  Stream *So=(Stream*)(jpointer)so, *Sop=(Stream*)(jpointer)sop;
  if (fpi!=NULL) fwrite((void*)&pt->func,ptvs,1,fpi);
/* printf("OK impl=%d flow=%d sip=%d sop=%d\n",pt->impl,pt->flow,Si->woff,So->roff); */
  if (pt->impl>4)       status = (*pt->work)     (CPTR handle, Si, Sip, So, Sop, hbw); /* hardware dataflow method */
  else if (pt->flow==4) status = (*pt->process4) (CPTR handle, Si, Sip, So, Sop); /* with packets */
  else             	status = (*pt->process)  (CPTR handle, Si, So);	/* direct call to process method */
  if (fpo!=NULL) fwrite((void*)&pt->func,ptvs,1,fpo);
  if (fdo!=NULL && status>0) fwrite((void*)pt->bo1,status,1,fdo);
  return status;
}

JNIEXPORT jint  JNICALL Java_nxm_ice_lib_CoreNative_free (JNIEnv *env, jobject obj, jlong handle) {
  HALO *pt = PPTR handle; jint status=0;
  if (pt->flow!=0) status = (*pt->close) (CPTR handle);
  status = (*pt->free) (CPTR handle);
  if (fpi!=NULL) fclose(fpi);
  if (fpo!=NULL) fclose(fpo);
  if (fdi!=NULL) fclose(fdi);
  if (fdo!=NULL) fclose(fdo);
  return status;
}

JNIEXPORT jint  JNICALL Java_nxm_ice_lib_CoreNative_sysrd (JNIEnv *env, jobject obj, jlong handle,
		jint addr) {
  HALO *pt = PPTR handle; 
  if (pt->flow==0) return 0;
  jint data = (*pt->sysrd) (CPTR handle, addr);
  return data;
}
JNIEXPORT jint  JNICALL Java_nxm_ice_lib_CoreNative_syswr (JNIEnv *env, jobject obj, jlong handle,
		jint addr, jint data) {
  HALO *pt = PPTR handle; 
  if (pt->flow==0) return 0;
  data = (*pt->syswr) (CPTR handle, addr, data);
  return data;
}
JNIEXPORT jint  JNICALL Java_nxm_ice_lib_CoreNative_poll (JNIEnv *env, jobject obj, jlong handle) {
  HALO *pt = PPTR handle; jint status;
  if (pt->poll==0) return -1;
  status = (*pt->poll) (CPTR handle);
  return status;
}
JNIEXPORT jint  JNICALL Java_nxm_ice_lib_CoreNative_upload (JNIEnv *env, jobject obj, jlong handle) {
  HALO *pt = PPTR handle;
  return (*pt->upload) (CPTR handle);
}

void fp2fptx (real_4 *fp, int_4 *fptx, int_4 n) { int_4 i; for (i=0; i<n; i++) fptx[i] = (int_4)(fp[i]*65536.0); }
void fptx2fp (int_4 *fptx, real_4 *fp, int_4 n) { int_4 i; for (i=0; i<n; i++) fp[i] = (real_4)(fptx[i]*(1.0/65536)); }

JNIEXPORT void  JNICALL Java_nxm_ice_lib_CoreNative_fp2fptx (JNIEnv *env, jobject obj, jlong lbuf, jint bytes) { fp2fptx(FPTR lbuf,LPTR lbuf,bytes/4); }
JNIEXPORT void  JNICALL Java_nxm_ice_lib_CoreNative_fptx2fp (JNIEnv *env, jobject obj, jlong lbuf, jint bytes) { fptx2fp(LPTR lbuf,FPTR lbuf,bytes/4); }

JNIEXPORT jlong JNICALL Java_nxm_ice_lib_CoreNative_newStream (JNIEnv *env, jclass jclazz, jint size, jint IBW, jint OBW) { return (jlong)(jpointer)Stream_new(size,IBW,OBW); }
JNIEXPORT void  JNICALL Java_nxm_ice_lib_CoreNative_freeStream (JNIEnv *env, jclass jclazz, jlong handle) { free ((void*)(jpointer)handle); }
JNIEXPORT jlong JNICALL Java_nxm_ice_lib_CoreNative_loadStreamBuffer (JNIEnv *env, jclass jclazz, jlong handle) { return Stream_loadBuffer( SPTR handle); }
JNIEXPORT jint  JNICALL Java_nxm_ice_lib_CoreNative_loadStreamAvail (JNIEnv *env, jclass jclazz, jlong handle) { return Stream_loadAvail( SPTR handle); }
JNIEXPORT jint  JNICALL Java_nxm_ice_lib_CoreNative_loadStreamStatus (JNIEnv *env, jclass jclazz, jlong handle, jint n) { return Stream_loadStatus( SPTR handle,n); }
JNIEXPORT jlong JNICALL Java_nxm_ice_lib_CoreNative_unloadStreamBuffer (JNIEnv *env, jclass jclazz, jlong handle) { return Stream_unloadBuffer( SPTR handle); }
JNIEXPORT jint  JNICALL Java_nxm_ice_lib_CoreNative_unloadStreamAvail (JNIEnv *env, jclass jclazz, jlong handle) { return Stream_unloadAvail( SPTR handle); }
JNIEXPORT jint  JNICALL Java_nxm_ice_lib_CoreNative_unloadStreamStatus (JNIEnv *env, jclass jclazz, jlong handle, jint n) { return Stream_unloadStatus( SPTR handle,n); }

JNIEXPORT jint  JNICALL Java_nxm_ice_lib_CoreNative_xgetL (JNIEnv *env, jobject obj, jlong handle, jint off) { Stream *s = SPTR handle; return *(int*)(s->b+((s->woff+off)&s->mask)); }
JNIEXPORT void  JNICALL Java_nxm_ice_lib_CoreNative_xwrL (JNIEnv *env, jobject obj, jlong handle, jint x) { Stream *s = SPTR handle; Stream_wrL(s,x); }
