#!/bin/sh
if [ ! -n "$JAVAHOME" ]; then
  echo "Could not perform jre/icebld.sh for embedded NeXtMidas. No JAVAHOME environment found."
  exit
fi
alias jar=${JAVAHOME}/bin/jar
if [ "$1" = "nxm" -o "$1" = "all" ]; then
  cd $NMROOT
  echo "Creating JARs for HWC/DSP/SYS"
  jar -cf $ICEROOT/jre/nxm-hwc.jar nxm/hwc/*/*.class
  jar -cf $ICEROOT/jre/nxm-dsp.jar nxm/dsp/*/*.class
  jar -cf $ICEROOT/jre/nxm-sys.jar nxm/sys/*/*.class tools/BuildProps*.class  
  jar -cf $ICEROOT/jre/nxm-all-local.jar nxm/sys/cfg/build.props nxm/sys/inc/cdefs.h nxm/sys/inc/native.h nxm/sys/inc/libnmfft.h \
          nxm/sys/cfg/* nxm/sys/mcr/* nxm/sys/exp/*.exp nxm/sys/hlp/* \
          nxm/hwc/cfg/* nxm/hwc/mcr/* nxm/hwc/exp/*.exp \
          nxm/dsp/cfg/* nxm/dsp/mcr/* nxm/dsp/exp/*.exp \
          nxm/sys/dat/sv*.prm nxm/sys/dat/site.prm nxm/sys/dat/world.* nxm/sys/dat/apenny.prm \
          nxm/sys/lib/*.c nxm/sys/lib/*.h nxm/sys/libm/*.c nxm/sys/libm/*.h nxm/sys/docs/style.css
fi
if [ "$1" = "ice" -o "$1" = "all" ]; then
  cd $ICEROOT
  echo "Creating JARs for ICE"
  jar -cf $ICEROOT/jre/nxm-ice.jar nxm/ice/*/*.class nxm/ice/lib/nxm_ice_*.h 
  cp $JAVAHOME/include/jni.h $JAVAHOME/include/linux/jni_md.h lib/nxm_ice_*.h $ICEROOT/jre/inc/
  rm -rf nxm/sys nxm/hwc nxm/dsp
fi
if [ "$1" = "unpack" -o "$1" = "all" ]; then
  cd $ICEROOT
  $JAVAHOME/bin/jar -xf jre/nxm-all-local.jar
  cp net/style.css nxm/sys/docs
  ln -sfn ".." nxm/ice
  ln -sfn docs htdocs
  flags="-O1 -D_UNIX -D_LINX -D_EEEI -D_LARGEFILE_SOURCE -D_FILE_OFFSET_BITS=64 "
  list="nxm/sys/lib/Native nxm/sys/lib/NTerminal nxm/sys/libm/Fft"
  if [ -n "$NMROOT" ]; then
    ln -sfn $NMROOT/htdocs/help nxm/sys/docs/help
  else
    list="$list nxm/ice/lib/DevIce nxm/ice/lib/NetIO nxm/ice/lib/FileIO nxm/ice/lib/CoreNative"
  fi
  for file in $list
  do
    echo "Compiling embedded NeXtMidas library $file"
    cc -pthread -shared -fPIC $flags -o ${file}_lin64.so ${file}.c -Iinc/ -Ijre/inc -Inxm/sys/inc/ -lm -ldl
  done
  echo "Make sure network is properly setup before running 'ice sh' or java will hang."
fi
