/***********************************************************************
  Description:	SHARC definitions for ICE-PIC cards
  Author: 	Jeff Schoen - Innovative Computer Engineering
  Date:		1/97
************************************************************************/

#define MSGR0  0x08        /* Message register 0                        */
#define MSGR1  0x09        /* Message register 1                        */
#define MSGR2  0x0a        /* Message register 2                        */
#define MSGR3  0x0b        /* Message register 3                        */
#define MSGR4  0x0c        /* Message register 4                        */
#define MSGR5  0x0d        /* Message register 5                        */
#define MSGR6  0x0e        /* Message register 6                        */
#define MSGR7  0x0f        /* Message register 7                        */

#define STCTL0  0xe0 /*Serial Port 0 Transmit Control Register          */
#define SRCTL0  0xe1 /*Serial Port 0 Receive  Control Register          */
#define TX0     0xe2 /*Serial Port 0 Transmit Data Buffer               */
#define RX0     0xe3 /*Serial Port 0 Receive Data Buffer                */
#define TDIV0   0xe4 /*Serial Port 0 Transmit Divisor                   */
#define TCNT0   0xe5 /*Serial Port 0 Transmit Count Reg                 */
#define RDIV0   0xe6 /*Serial Port 0 Receive Divisor                    */
#define RCNT0   0xe7 /*Serial Port 0 Receive Count Reg                  */
#define MTCS0   0xe8 /*Serial Port 0 Mulitchannel Transmit Selector     */
#define MRCS0   0xe9 /*Serial Port 0 Mulitchannel Receive Selector      */
#define MTCCS0  0xea /*Serial Port 0 Mulitchannel Transmit Selector     */
#define MRCCS0  0xeb /*Serial Port 0 Mulitchannel Receive Selector      */
#define SPATH0  0xee /*Serial Port 0 Path Length (Mesh Multiprocessing) */
#define SPCNT0  0xef /*Serial Port 0 Path Counter (Mesh Multiprocessing)*/

#define STCTL1  0xf0 /*Serial Port 1 Transmit Control Register          */
#define SRCTL1  0xf1 /*Serial Port 1 Receive  Control Register          */
#define TX1     0xf2 /*Serial Port 1 Transmit Data Buffer               */
#define RX1     0xf3 /*Serial Port 1 Receive Data Buffer                */
#define TDIV1   0xf4 /*Serial Port 1 Transmit Divisor                   */
#define TCNT1   0xf5 /*Serial Port 1 Transmit Count Reg                 */
#define RDIV1   0xf6 /*Serial Port 1 Receive Divisor                    */
#define RCNT1   0xf7 /*Serial Port 1 Receive Count Reg                  */
#define MTCS1   0xf8 /*Serial Port 1 Mulitchannel Transmit Selector     */
#define MRCS1   0xf9 /*Serial Port 1 Mulitchannel Receive Selector      */
#define MTCCS1  0xfa /*Serial Port 1 Mulitchannel Transmit Selector     */
#define MRCCS1  0xfb /*Serial Port 1 Mulitchannel Receive Selector      */
#define SPATH1  0xfe /*Serial Port 1 Path Length (Mesh Multiprocessing) */
#define SPCNT1  0xff /*Serial Port 1 Path Counter (Mesh Multiprocessing)*/

