/**
  Common defines for processing COREs

  CORE_AREA is the java native package location
  CORE_NAME is the Library Function Name
  CORE_TYPE is the Processor Type Java,CPU,GPU,VHS,MLS,ICE

  @author Jeff Schoen
  @version $Id: CoreDefs.h,v 1.1 2011/04/27 13:09:47 jgs Exp $
*/

#ifndef _CoreStream_
#define _CoreStream_

typedef struct {
  int_4 len,bib,woff,roff,wboff,rboff,wbpe,rbpe,wper,rper,wok,rok,mtl,mask,usenative,chn,cvt;
  int_1 *b;
} Buffer;

/* make sure this matches the struct in VCoreDefs.h AND fpgalib.c AND corelib.h AND Buffer above */
typedef struct {
  int_4 len,bib,woff,roff,wboff,rboff,wbpe,rbpe,wper,rper,wok,rok,mtl,mask,usenative,chn,cvt;
  int_1 *b;
} Stream;

#endif

#ifdef NEED_STREAM_HANDLERS

Stream* Stream_new (int_4 len, int_4 IBW, int_4 OBW) {
  int_4 sStr = sizeof(Stream);
  int_1* ptr = (int_1*)calloc(1,len+sStr);
  Stream* str = (Stream*)ptr;
  str->len=len;
  str->mtl=len/2;
  str->mask=len-1;
  str->wok=1;
  str->rper = str->rbpe = (IBW/8);
  str->wper = str->wbpe = (OBW/8);
  str->b=ptr+sStr;
  return str;
}

void Stream_update (Stream *str, int_4 xfer) {
  str->bib += xfer;
  if (xfer>0) {
    str->woff += xfer;
    if (str->woff >= str->len) str->woff -= str->len;
  } else {
    str->roff -= xfer;
    if (str->roff >= str->len) str->roff -= str->len;
  }
  str->rok = (str->bib >= str->rper);
  str->wok = (str->len-str->bib >= str->wper);
}

Stream* core_getbuffer (int_4 tl, int_4 bpa) { return Stream_new (tl*bpa,bpa*8,bpa*8); }

int_8 Stream_loadBuffer (Stream *str) { return (int_8)(str->b + str->woff); }
int_4 Stream_loadStatus (Stream *str, int_4 n) { if (n>0) Stream_update (str,n); return n; }
int_4 Stream_loadAvail (Stream *str) {
  int_4 n,avail = str->roff-str->woff;
  if (avail<0 || str->bib==0) avail = str->len-str->woff;
  if (avail>str->mtl) avail = str->mtl;
  return avail;
}
int_8 Stream_unloadBuffer (Stream *str) { return (int_8)(str->b + str->roff); }
int_4 Stream_unloadStatus (Stream *str, int_4 n) { if (n>0) Stream_update (str,-n); return n; }
int_4 Stream_unloadAvail (Stream *str) {
  int_4 n, avail = str->woff-str->roff;
  if (avail<0 || str->bib==str->len) avail = str->len-str->roff;
  return avail;
}

#endif

