/**
  Common prototypes for processing COREs

  CORE_AREA is the java native package location
  CORE_NAME is the Library Function Name
  CORE_TYPE is the Processor Type Java,CPU,GPU,MLS,VHS,ICE

  @author Jeff Schoen
  @version $Id: CoreProtos.h,v 1.1 2011/04/27 13:09:47 jgs Exp $
*/

#ifdef CORE_AREA
#define CEXPORT static
#else
#define CEXPORT
#endif

#ifdef CORE_NAME

#define BMETHOD(A,B) A##_##B
#define CMETHOD(A,B) BMETHOD(A,B)

CEXPORT CORE_NAME* CMETHOD(CORE_NAME,plan)();

void* CMETHOD(CORE_NAME,alloc)  (char* config);
int_4 CMETHOD(CORE_NAME,init)   (CORE_NAME* halo);
int_4 CMETHOD(CORE_NAME,set)    (CORE_NAME* halo, String* key, Value* data);
int_4 CMETHOD(CORE_NAME,get)    (CORE_NAME* halo, String* key, Value* data);
int_4 CMETHOD(CORE_NAME,poll)   (CORE_NAME* halo);
int_4 CMETHOD(CORE_NAME,open)   (CORE_NAME* halo);
int_4 CMETHOD(CORE_NAME,free)   (CORE_NAME* halo);

#endif
