//************
//  Description: Generic midas driver for an ICECORE library
//
//  Author:	Jeff Schoen	3/13
//
//  $Revision:	$
//  $Modtime:	$
//
//************
#include <stdio.h>
#include <primitive.h>
#include <fintrinsics.h>
#include "qmessages.h"
#include "corelib.h"
#define MARGS 64

void mainroutine () 
{
  CORE *core;
  CPHEADER hi, ho;
  Stream *si,*so;
  void *buf;

  int_4 i,n,id,lval,lm,ls,xfer,stat,stats,np,ilen,olen,ibpa,obpa,itl,otl;
  int_4 wid[MARGS];
  real_8 dval,xdio,xsio,oxd,oxs,wdval[MARGS];
  real_4 fval;
  string iform,oform,ifmt,ofmt,sval,cname,cimp,cdev,wtkey[MARGS];
  char mwbuf[256],*s,*ss;

  // open input file
  m_init (hi, m_apick(1), "1000,2000","S#,C#", 0);
  m_open (hi, HCBF_INPUT+HCBF_OPTIONAL);
  iform = hi.format;

  // create an instance of the core by name
  cname = m_apick(3);
  i = m_get_uswitch("CORE",cimp); if (i<0) cimp="C";
  i = m_get_uswitch("COREDEV",cdev); if (i<0) cdev="PIC1AUTO:11";
  core = (CORE*)core_alloc_xm ((char*)cname.c_str(),(char*)cimp.c_str(),(char*)cdev.c_str());
  core_init(core);

  // determine formats
  i = m_get_uswitch("IFMT",ifmt);
  if (i<0) ifmt = iform;
  i = m_get_uswitch("OFMT",ofmt);
  if (i<0) ofmt = ifmt;
  core_setfmt(core,(char*)ifmt.c_str(),(char*)ofmt.c_str());

  // other options
  i = m_get_switch("MCID");
  if (i>0) core_setmcid(core,i);
  ilen = m_get_switch("ILEN");
  olen = m_get_switch("OLEN");
  oxd  = m_get_dswitch("OXD");
  oxs  = m_get_dswitch("OXS");
  ibpa = m_bpa(ifmt);
  obpa = m_bpa(ofmt);

  // parse and set the parameters 
  for (np=0; np<MARGS && m_ppick(np+4); np++) {
    string arg = m_upick(np+4);
    if ((i=arg.find('='))<0) m_error("All extra parameters must be key=value not "+arg);
    string key=arg.substr(0,i), val=arg.substr(i+1), kt="L";
    stat = m_a2d(val.c_str(),dval); 
    if (stat<0) dval=0.0; fval=dval; lval=dval;
    kt = (stat<0)? 'S' : (dval==round(dval))? 'L' : 'D';
    if (key[1]==':') { kt=key[0]; key=key.substr(2); }
    string tkey = kt+":"+key;
    id=0;
    if (kt=="D") {
      id=m_dwinit(key,dval,1.0,-1.0,1.0);
      if (core_setkey(core,tkey.c_str(),(void*)&dval,8)<0) m_error("Setting "+tkey+" from "+arg);
    }
    else if (kt=="F") {
      id=m_fwinit(key,fval,1.0,-1.0,1.0);
      if (core_setkey(core,tkey.c_str(),(void*)&fval,8)<0) m_error("Setting "+tkey+" from "+arg);
    }
    else if (kt=="L") {
      id=m_lwinit(key,lval,1,-1,1);
      if (core_setkey(core,tkey.c_str(),(void*)&lval,4)<0) m_error("Setting "+tkey+" from "+arg);
    } 
    else if (kt=="A" || kt=="S") {
      ls = strlen(val.c_str());
      if (core_setkey(core,tkey.c_str(),(void*)val.c_str(),ls)<0) m_error("Setting "+tkey+" from "+arg);
      string mkey = tkey+"LIST?";
      lm = core_getkey(core,mkey.c_str(),(void*)mwbuf,256);
      if (lm>=0) {
	tkey = "L:"+key;
        core_getkey(core,tkey.c_str(),(void*)&lval,4);
        id=m_mwinit(key,lval,mwbuf);
      }
    }
    else {
      m_error ("Unsupported parameter type="+kt);
    }
    wid  [np] = id;
    wtkey[np] = tkey;
    wdval[np] = dval;
  }

  // open the core
  stat = core_open (core);

  // open output file
  m_propagate (hi, ho);
  ho.file_name = m_apick(2);
  ho.format = ofmt;
  if (oxd>0) ho.xdelta = oxd;
  if (oxs>0) ho.xstart = oxs;
  sval="XDIO?"; i = core_getkey(core,sval.c_str(),&xdio,8);
  if (i>0) ho.xdelta = hi.xdelta*xdio;
  sval="XSIO?"; i = core_getkey(core,sval.c_str(),&xsio,8);
  if (i>0) ho.xstart = hi.xstart+xsio;
  if (olen>0) ho.size = olen;
  m_open (ho, HCBF_OUTPUT+HCBF_OPTIONAL);
  oform = ho.format;

  // prepare the data buffer
  xfer = m_get_switch_def("TL",4096);
  itl = m_get_switch_def("ITL",xfer);
  otl = m_get_switch_def("OTL",xfer);
  si = core_getbuffer(itl,ibpa);
  so = core_getbuffer(otl,obpa);

  m_sync();

  while (!Mc->break_) {

    stats=0;

    // check for real-time parameter changes
    for (n=0; n<np; n++) {
      id = wid[n];
      if (id==0);
      else if (wtkey[n][0]=='D') {
        dval = wdval[n];
        if (m_dwget(id,dval)>0) core_setkey (core,wtkey[n].c_str(),(void*)&dval,8);
        wdval[n] = dval;
      } 
      else if (wtkey[n][0]=='F') {
        fval = wdval[n];
        if (m_fwget(id,fval)>0) core_setkey (core,wtkey[n].c_str(),(void*)&fval,4);
        wdval[n] = lval;
      } 
      else if (wtkey[n][0]=='L') {
        lval = wdval[n];
        if (m_lwget(id,lval)>0) core_setkey (core,wtkey[n].c_str(),(void*)&lval,4);
        wdval[n] = lval;
      }
    }

    // check for messages
    if (Mu->id>0 && m_get_msg(MQH,MQD,0.0,0)>0) {
      if (MQH.name == "SETKEYS") {
	ss = (char *)(&MQD);
	s = strchr(ss,'}'); if (s!=NULL) s[1]=0;
	core_setkeytable(core,ss);
      }
    }

    // input data 
    if (hi.open) {
      hi.xfer_len = Stream_loadAvail(si)/ibpa;
      buf = (void*)Stream_loadBuffer(si);
      m_grabx (hi,buf,stat); if (stat<=0) break;
      Stream_loadStatus(si,stat*ibpa);
      stats += stat;
    } 

    // process algorithm
    stat = core_process (core, si, NULL, so, NULL);
    if (stat<0) break;

    // process and output data
    if (ho.open) {
      stat = Stream_unloadAvail(so);
      buf = (void*)Stream_unloadBuffer(so);
      m_filad (ho,buf,stat/obpa);
      Stream_unloadStatus(so,stat);
      stats += stat;
    }

    if (ilen>0 && hi.offset>=ilen) break;
    if (olen>0 && ho.offset>=olen) break;
    if (stats<=0) m_pause(Mc->pause);
  }

  // close all resources
  core_close (core);
  if (si!=NULL) free(si);
  if (so!=NULL) free(so);
  m_close(hi);
  m_close(ho);
}
