startmacro t:tbl_rx t:tbl_tx
  set vmods "a2dm14,a2dr11,a2dr13,d2awgr2,sonet,udp"
  set amod ^tbl_rx.module
  set dmod ^tbl_tx.module
  set test ^tbl_rx.test

  switch "PLOTSON" po get "plotsoff" "plotson"

  ! determine if a reset is required
  if ^tbl_rx.card eqs ^tbl_tx.card then
    set rst noreset
  else
    set rst reset
  endif
 
  ! check for valid modules
  if ((amod subs vmods) AND (dmod subs vmods)) isfalse then 
    say "Invalid module! Valid modules are: ^vmods"
    stop
  endif

  ! set valid tests!
  if amod subs a2dr11 then
    set vtests "atten,nosig,smse,snpr,stwo,timecode,tone,trig"
  elseif amod subs a2dr13 then
    set vtests "atten,cmse,cnpr,ctwo,nosig,ramp,smse,snpr,stwo,timecode,tone,trig"
  elseif amod subs a2dm14 then
    set vtests "atten,cmse,cnpr,ctwo,nosig,ramp,smse,snpr,stwo,timecode,tone,trans,trig"
  elseif amod subs sonet then 
    set vtests "sonet,timecode"
  elseif amod subs udp then 
    set vtests "trig,udp"
  endif

  ! check for valid test
  if (test subs vtests) isfalse then
    say "invalid test! valid tests for ^amod are: ^vtests"
    stop
  endif

  ! display text
  say "^{tbl_rx.text}"

  ! no signal test
  if nosig subs test then
    ! start zero-izing
    %daczeros tbl_tx
    ! grab the signal
    %adcnosig/^rst/^po tbl_rx
    ! stop the source 
    %dacstop tbl_tx
  endif

  ! trans test
  if trans subs test then
    ! start zero-izing
    %daczeros tbl_tx
    ! grab the signal
    %adcnosig/^rst/^po tbl_rx
    ! stop the source 
    %dacstop tbl_tx
  endif

  ! tone test
  if tone subs test then
    %dactone tbl_tx
    ! acquire
    %adctone/^po/^rst tbl_rx
    ! stop the source 
    %dacstop tbl_tx
  endif

  ! scalar two tone test
  if stwo subs test then
    calc rate ^tbl_tx.rate 1e6 *
    %gentones si_tones rate 4m 8 5k 4 5k 64 f1 f2
    %dacplay tbl_tx si_tones
    %adctwotone/^po/^rst tbl_rx f1 f2
    %dacstop tbl_tx
  endif

  ! complex two tone test
  if ctwo subs test then
    calc rate ^tbl_tx.rate 1e6 *
    %gentones/cmplx ci_tones rate 4m -1 10k 2 10k 64 f1 f2
    %dacplay tbl_tx ci_tones
    %adctwotone/^po/^rst tbl_rx f1 f2
    %dacstop tbl_tx
  endif

  ! TODO replace with perfect template???
  ! scalar mse test
  if smse subs test then
    set wstr "aux=^tbl_tx.aux"
    calc rate ^tbl_tx.rate 1e6 *
    %gennpr si_npr ^tbl_tx.amp ^tbl_tx.fsize rate ^tbl_tx.f1 ^tbl_tx.f2 ^tbl_tx.gap ^tbl_tx.ntaps wstr
    %dacplay tbl_tx si_npr
    %adcmse/^rst/^po tbl_rx si_npr
    %dacstop tbl_tx
    erase/warn=n si_npr
  endif

  ! TODO replace with perfect template???
  ! complex mse test
  if cmse subs test then
    set wstr "aux=^tbl_tx.aux"
    calc rate ^tbl_tx.rate 1e6 *
    %gennpr/cmplx ci_npr ^tbl_tx.amp ^tbl_tx.fsize rate ^tbl_tx.f1 ^tbl_tx.f2 ^tbl_tx.gap ^tbl_tx.ntaps wstr
    %dacplay tbl_tx ci_npr
    %adcmse/^rst/^po tbl_rx ci_npr
    %dacstop tbl_tx
    erase/warn=n ci_npr
  endif

  ! scalar npr test
  if snpr subs test then
    set wstr "aux=^tbl_tx.aux"
    calc rate ^tbl_tx.rate 1e6 *
    %gennpr si_npr ^tbl_tx.amp ^tbl_tx.fsize rate ^tbl_tx.f1 ^tbl_tx.f2 ^tbl_tx.gap ^tbl_tx.ntaps wstr
    %dacplay tbl_tx si_npr
    %adcnpr/^rst/^po tbl_rx ^tbl_tx.f1 ^tbl_tx.f2 ^tbl_tx.gap
    %dacstop tbl_tx
    erase/warn=n si_npr
  endif

  ! complex npr test
  if cnpr subs test then
    set wstr "aux=^tbl_tx.aux"
    calc rate ^tbl_tx.rate 1e6 *
    %gennpr/cmplx ci_npr ^tbl_tx.amp ^tbl_tx.fsize rate ^tbl_tx.f1 ^tbl_tx.f2 ^tbl_tx.gap ^tbl_tx.ntaps wstr
    %dacplay tbl_tx ci_npr
    %adcnpr/^rst/^po tbl_rx ^tbl_tx.f1 ^tbl_tx.f2 ^tbl_tx.gap
    %dacstop tbl_tx
    erase/warn=n ci_npr
  endif

  ! a2d ramp test
  if ramp subs test then
    %dactone tbl_tx
    ! acquire the data 
    %adcramp/^rst/^po tbl_rx
    %dacstop tbl_tx
  endif

  ! d2a atten test
  if atten subs test then
    %dacatten/^rst/^po tbl_rx tbl_tx
    %dacstop tbl_tx
  endif

  ! trigger test
  if trig subs test then
    if amod subs udp then 
      %udp/^po tbl_rx tbl_tx
    else 
      %dactrigger tbl_tx
      ! do a basic energy test!
      %adctone/^po/^rst/tone tbl_rx
      %dacstop tbl_tx
    endif
  endif

  if sonet subs test then
    %sonet/^po tbl_rx tbl_tx
  endif

  if udp subs test then
    %udp/^po tbl_rx tbl_tx
  endif

endmacro
