startmacro t:tbl f:cl
  set flags "^tbl.flags|^tbl.aflags|rffreq=^tbl.cardfreq|rfbw=^tbl.cardbw"
  set wstr "aux=^tbl.aux"
  calc rate ^tbl.rate 1e6 *
  set failure 0

  ! clean out playground
  pic/batch clean
  call cleanFiles
  ! create the file
  file open/d/n tag2 temp{sr=(GAIN/SD,PEAK/SD,SNR/SD,SFDR/SD,THRESH/SD)}

  ! for awgtone
  pic create fileo ^tbl.format ^tbl.fsize rate
  set mingain 99999
  set maxgain -99999

  ! figure out where the signal will sit
  calc freq ^tbl.sigfreq ^tbl.cardfreq - 1e6 *
  calc fbw ^tbl.cardbw 1e6 * rate /

  if ^tbl.format eqs SI then
    ! headermod scalar
    calc delt rate tbl.nfft /
    calc rate rate 2 /
    calc fbeg -rate 2 /
  endif

  ! reset the card
  picd/flags=force|^flags reset ^tbl.card
  ! loop
  do gain ^tbl.gbeg ^tbl.gend ^tbl.gstep
    set failure 0
    ! acquire
    picd/replay=^tbl.replay/port=^tbl.port/flags=^flags|rfgain=^gain acquire ^tbl.card fileo
    picd/flags=^flags/port=^tbl.port get ^tbl.card rfpwr rxpow
    fft/mag fileo ftmp{^wstr} ^tbl.nfft navg=^tbl.aves win=bh92
    if ^tbl.format eqs SI then
      ! headermod scalar
      headermod ftmp xd=^delt xs=^fbeg
    endif

    icemeasure char flist{^wstr} ftmp rate fbw ^tbl.threshdb freq
    
    call procResults flist mtab ^gain again ^tbl.snr ^tbl.sfdr ^tbl.thresh

    ! two seperate conditionals in case the max or min is 1st
    if ^again lt mingain
      set mingain ^again
    endif
    if ^again gt maxgain
      set maxgain ^again
    endif
    invoke ,, tag2.insertData(-1,mtab)

    if /plotson or ( failure eq 1 ) then 
      fcalc fplot{^wstr} ftmp log 10 *
      pipe on
        panel/setup
        plot/id=plot1 fileo
        plot/id=plot2 fplot
        plot/id=plot3 fplot type=line
      pipe off
    endif
  enddo

  ! close the file
  invoke ,, tag2.flush() 
  file close tag2
  ! make sure the gain was acceptable
  calc/nform=".00" gdelta maxgain mingain 2 ^tbl.gthresh * + - 
  assert/text="Testing Gain Ramp (Meas: ^gdelta, Thresh: 0)" ^gdelta le 0
  if /plotson or ( gdelta gt 0 ) then 
    list temp
  endif
  call cleanFiles
endmacro

procedure cleanFiles
  erase/warn=n temp filei fileo ftmp flist fmax fplot fplot2
return

procedure procResults hi tab gain again f:vsnr f:vsfdr f:vthresh
  status hi size=sze
  file open/d tag hi
  calc/nform=".00" snr tag.getDataTable(0).snr
  calc/nform=".00" sfdr tag.getDataTable(0).sfdr
  calc/nform=".00" thresh tag.getDataTable(0).thresh
  calc/nform=".00" accum 10 tag.getDataTable(0).sig 20 / ** sze /

  do ind 1 sze-1 1
    res tmp tag.getDataTable(ind)
    if snr gt tmp.snr
      calc/nform=".00" snr tmp.snr
    endif
    if sfdr gt tmp.sfdr
      calc/nform=".00" sfdr tmp.sfdr
    endif
    if thresh lt tmp.thresh
      calc/nform=".00" thresh tmp.thresh
    endif
    calc/nform=".00" accum 10 tag.getDataTable(0).sig 20 / ** sze / accum +
  enddo

  calc/nform=".00" peak accum log 20 *
  file close tag
  ! build table
  res ^tab {GAIN=^gain,PEAK=^peak,SNR=^snr,SFDR=^sfdr,THRESH=^thresh}
  res ^again ^peak-^gain
  ! test thresholds here
  assert/text="Signal-to-Noise Gain=^gain dB (Meas: ^snr, Thresh: ^vsnr)" snr gt vsnr
  assert/text="Spur Free Dynamic Range Gain=^gain dB (Meas: ^sfdr, Thresh: ^vsfdr)" sfdr gt vsfdr
  assert/text="Median Noise Threshold Gain=^gain dB (Meas: ^thresh, Thres: ^vthresh)" thresh lt vthresh
  if ( snr le vsnr ) or ( sfdr le vsfdr ) or ( thresh ge vthresh ) then
    set failure 1
  endif
return

