startmacro t:tbl
  set flags "^tbl.flags|^tbl.aflags|rffreq=^tbl.cardfreq|rfbw=^tbl.cardbw|rfgain=^tbl.gain"
  set wstr "aux=^tbl.aux"
  calc rate ^tbl.rate 1e6 *
  set failure 0

  call cleanFiles
  picd/flags=force|^flags reset ^tbl.card
  ! create the output file
  pic create fileo ^tbl.format ^tbl.fsize rate

  ! acquire
  picd/replay=^tbl.replay/port=^tbl.port/flags=^flags acquire ^tbl.card fileo
  fft/mag fileo ftmp{^wstr} ^tbl.nfft navg=^tbl.aves win=bh92
  calc fbw ^tbl.cardbw 1e6 * rate /
  icemeasure noise flist1{^wstr} ftmp rate fbw ^tbl.threshdb
  icemeasure band flist2{^wstr} ftmp rate fbw ^tbl.threshdb

  call procResults1 flist1 ^tbl.nf ^tbl.spur ^tbl.thresh
  call procResults2 flist2 ^tbl.inb ^tbl.outb

  if /plotson or (failure eq 1) then 
    fcalc fplot{^wstr} ftmp log 10 *
    pipe on
      panel/setup
      plot/id=plot1 fplot
      plot/id=plot2 fplot type=line
      list/id=plot3 flist1
      list/id=plot4 flist2
    pipe off
  endif
  call cleanFiles
endmacro

procedure cleanFiles
  erase/warn=n ftmp flist1 flist2 fplot fileo
return

procedure procResults1 hi f:vnf f:vspur f:vthresh
 status hi size=sze
  file open/d tag hi
  calc/nform=".00" nf tag.getDataTable(0).nf
  calc/nform=".00" spur tag.getDataTable(0).maxspur
  calc/nform=".00" thresh tag.getDataTable(0).thresh

  do ind 1 sze-1 1
    res tmp tag.getDataTable(ind)
    if nf gt tmp.nf
      calc/nform=".00" nf tmp.nf
    endif
    if spur gt tmp.maxspur
      calc/nform=".00" spur tmp.maxspur
    endif
    if thresh lt tmp.thresh
      calc/nform=".00" thresh tmp.thresh
    endif
  enddo

  file close tag
  ! test thresholds here
  assert/text="Noise Floor (Meas: ^nf, Thresh: ^vnf)" nf lt vnf
  assert/text="Maximum spur (Meas: ^spur, Thresh: ^vspur)" spur lt vspur
  assert/text="Median Noise (Meas: ^thresh, Thresh: ^vthresh)" thresh lt vthresh
  if ( nf ge vnf ) or ( spur ge vspur ) or ( thresh ge vthresh ) then 
    set failure 1
  endif

return 

procedure procResults2 hi f:vin f:vout
 status hi size=sze
  file open/d tag hi
  calc/nform=".00" in tag.getDataTable(0).in
  calc/nform=".00" out tag.getDataTable(0).out

  do ind 1 sze-1 1
    res tmp tag.getDataTable(ind)
    if in gt tmp.in
      calc/nform=".00" in tmp.in
    endif
    if out gt tmp.out
      calc/nform=".00" out tmp.out
    endif
  enddo

  file close tag
  ! test thresholds here
  assert/text="In-Band Threshold (Meas: ^in, Thresh: ^vin)" in lt vin
  assert/text="Out-of-Band Threshold (Meas: ^out, Thresh: ^vout)" out lt vout

  if ( in ge vin ) or ( out ge vout ) then 
    set failure 1
  endif
return 
