startmacro t:tbl
  set wstr "aux=^tbl.aux,det=1"
  set failure 0

  ! reset cards
  call cleanFiles

  ! create input and output files
  wave mfile{^wstr} ^tbl.format ^tbl.nels white ^tbl.amp

  ! parse for cardnum
  sedit/legacy=false ^tbl.card cardnum betw -1 -1

  ! run test
  icemeas flash lfile mfile "^tbl.alias" ^cardnum

  ! process results
  call procResults lfile

  if /plotson or ( failure eq 1 ) then
    list lfile
  endif

  call cleanFiles

endmacro

procedure cleanFiles
  erase/warn=n mfile lfile
return

procedure procResults hi 
  status hi size=sze
  if ( sze lt 1 ) then 
    return
  endif
  file open/d tag hi
  set err tag.getDataTable(0).error
  set sha1 tag.getDataTable(0).sha1
  set sha2 tag.getDataTable(0).sha2

  file close tag
  assert/text="Differences (Meas: ^err, Thresh: 0)" err eq 0
  assert/text="Checksums " sha1 eqs sha2
  if ( err neq 0 ) or ( sha1 neqs sha2 ) then 
    set failure 1
  endif
return

