startmacro t:tbl f:f1 f:f2 f:gap
  set flags "^tbl.flags|^tbl.aflags"
  set wstr "aux=^tbl.aux"
  calc rate ^tbl.rate 1e6 *
  set failure 0 

  set buf .015
  calc pad 1 f1 f2 gap + + - 2 /
  calc s1 pad buf +
  calc s2 pad f1 gap buf + + +
  calc sn pad f1 buf + +     
  calc w1 f1 buf 2 * -
  calc w2 f2 buf 2 * -
  calc wn gap buf 2 * -

  ! check if a reset is required
  if /noreset isnull then
    call cleanFiles
    picd/flags=force|^flags reset ^tbl.card
  endif
  pic create fileo ^tbl.format ^tbl.fsize rate
  picd/replay=^tbl.replay/port=^tbl.port/flags=^flags acquire ^tbl.card fileo
  fft/mag fileo ftmp{^wstr} ^tbl.nfft win=bh92 navg=^tbl.aves
  icemeasure npr flist{^wstr} ftmp s1 w1 s2 w2 sn wn

  ! now validate the results
  call procResults flist ^tbl.p2p ^tbl.p2n

  if /plotson or ( failure eq 1 ) then 
    fcalc fplot{^wstr} ftmp log 10 *
    pipe on
      panel/setup
      plot/id=plot1 fileo
      plot/id=plot2 fplot
      plot/id=plot3 fplot type=line
      list/id=plot4 flist
    pipe off
  endif 
  call cleanFiles
endmacro

procedure cleanFiles
  erase/warn=n fileo ftmp fplot flist
return

procedure procResults hi f:vp2p f:vp2n
  status hi size=sze
  file open/d tag hi
  calc/nform=".00" p2p tag.getDataTable(0).signal abs
  calc/nform=".00" p2n tag.getDataTable(0).notch

  do ind 1 sze-1 1
    res tmp tag.getDataTable(ind)
    ! absolute value for peak-to-peak
    calc/nform=".00" cur tmp.signal abs
    if p2p lt cur
      calc p2p cur
    endif
    if p2n gt tmp.notch
      calc/nform=".00" p2n tmp.notch
    endif
  enddo

  file close tag
  assert/text="Peak-to-Peak (Meas: ^p2p, Thresh: ^vp2p)" p2p lt vp2p
  assert/text="Peak-to-Notch (Meas: ^p2n, Thresh: ^vp2n)" p2n gt vp2n
  if ( p2p ge vp2p ) or ( p2n le vp2n ) then 
    set failure 1
  endif
return
