/**
  Do NOT edit.
  This file is generated by ICEJVCC.
  See UDAT.jv for documentation.
*/

import CORE_types::*;
package UDAT_types;
import CORE_types::*;
endpackage
import UDAT_types::*;

module UDAT_core #(PORT=1, IBW=64,OBW=IBW, IFLG=0,OFLG=0, IOCLKS=1, IKR=16,OKR=4, PBW=32,PKR=1) (
  input[2:0] s_clks, input s_rst, input s_cs, input[31:0] s_addr,
                     input s_wr, input[31:0] s_wrbus, input s_rd, output[31:0] s_rdbus, output s_ack,
  input[3:0] io_clk, output[1:0] i_rdy, input i_ena, input[7:0] i_sel, input[IBW-1:0] i_bus,
                     output[1:0] o_rdy, input o_ena, output[7:0] o_sel, output[OBW-1:0] o_bus,
  output [7:0] s_test);
  wire T=1,F=0; wire[7:0] T8=~0,F8=0;
  localparam SBW=32, ARRAY=0, STREAM=1, BUFFER=2, BUFSTR=3, PACKET=4;
  localparam BCIO=0, BCI=1, BCO=2, BCIIO=3, BCIOO=4, BCIIIOO=5;
  localparam FRAW=0, FCXI=1, FBIT=2, FAXI=3, FALL=4, FSWP=5;
  localparam TIGHT=8, BPAR=1024, BDMA=2048, BENA=16384, DBLBUF=32768, NEMPTY=131072, RAHEAD=262144;
  localparam FLOW=BUFSTR, BUFCFG=BCIO, SELFPACE=1, PIPE=-1, MC=0, CW=6, AW=16, MBW=256, NP=1, BW=32, SIBW=BW, SOBW=BW, BIBW=BW, BOBW=BW, PIBW=PBW, POBW=PBW, IFMT=FRAW, OFMT=FSWP, DBGBW=32, DBGBD=10, P2=FLOW, P3=NP, P4=BW, P5=0, P6=0, P7=0;
  localparam XIBW=BIBW, XOBW=SOBW;
  localparam BWP=BW/8, IBWP=IBW/8, OBWP=OBW/8, XIBWP=XIBW/8, XOBWP=XOBW/8;
  localparam XIBWO=(XIBW>64)? 4 : (XIBW>32)? 3 : (XIBW>16)? 2 : (XIBW>8)? 1 : 0;
  localparam XOBWO=(XOBW>64)? 4 : (XOBW>32)? 3 : (XOBW>16)? 2 : (XOBW>8)? 1 : 0;
  localparam SUB=(PORT>10)? PORT-10:0;

  wire s_clk=s_clks[0],clk=s_clks[0],clk2=s_clks[1]; wire[1:0] clks=s_clks;
  logic rst,s_wrsys,s_wrscid; logic[31:0] s_sys; logic s_csm,s_csd,s_ena; logic[3:0] s_scid; 
  logic c_rd,c_wr,c_wok; logic[15:0] c_adr; logic[31:0] c_wbus,c_rbus; wire c_ok;
  always @(posedge s_clk) begin
    s_csd <= s_cs && s_addr[11:0]==12'hFFC;
    s_csm <= s_cs && !s_csd;
    s_wrsys <= s_cs && s_wr && s_addr[11:0]==0;
    if (s_rst) s_sys <= 0; else if (s_wrsys) s_sys <= s_wrbus;
    rst <= s_rst || s_sys[23];
    if (s_rst) c_wok <= 1; else if (!c_wr) c_wok <= !s_sys[22];
    s_ena <= (SUB==0)? s_sys[0] : s_clks[2];
  end
  wire frst=!s_ena; wire s_opt=s_sys[4]; wire[3:0] s_ifmt=s_sys[11:8], s_ofmt=s_sys[15:12]; wire [1:0] s_vbpr=s_sys[21:20];
  wire i_frst = frst; wire o_frst = frst; wire p_frst = frst;

  wire [31:0] s_sub, s_rdbusm, s_rdbust; wire [63:0] s_val; wire [15:0] s_ind; wire[25:0] s_set;
  wire s_csr=s_csm && !s_sub[24] && !s_addr[0];
  setter #(26,1) s_bank (clk,rst,s_csm&s_wr,s_addr,s_wrbus,s_sub,s_ind,s_set,s_val);
  portstatusblk #(PORT,"UDAT",P2,P3,P4,P5,P6,P7) s_sblk (s_clk,s_csr,s_addr,s_wr,s_wrbus,s_rd,s_rdbusm, clk,1'b1,c_adr,c_wok&c_wr,c_wbus,c_rd,c_rbus);
  assign s_rdbus = s_rdbusm;

  wire i_clk=io_clk[0], o_clk=(IOCLKS>1)?io_clk[1]:io_clk[0];
  logic bi_rd,so_wen,bi_nxt,bi_rok,so_wok; logic[7:0] so_swaps;
  logic[AW-1:0] bi_adr,bi_len; logic[31:0] bi_dma;
  logic[XIBW-1:0] bi_bus; logic[XIBWP-1:0] bi_sel; logic[XOBW-1:0] so_wbus; logic[XOBWP-1:0] so_wsel;
  logic[XIBWO-1:0] bi_adrb;  always @(posedge s_clk) bi_adrb <= bi_adr;
  logic[7:0] bi_busb; assign bi_busb = bi_bus >> {bi_adrb,3'h0};
  logic i_val; always @(posedge i_clk) i_val <= i_ena;
  wire c_rdy = (SELFPACE!=0) || (bi_rok && so_wok);

  fiaoNxM #(IBW+IBWP,XIBW+XIBWP,IKR,5,IFLG^BPAR,BPAR|BDMA|BENA) f_i (i_clk,i_frst, i_rdy,i_val,{i_sel,i_bus}, s_clk,i_frst, bi_rok,bi_rd,bi_dma,bi_nxt,bi_adr,bi_len,{bi_sel,bi_bus});
  logic so_wen_; logic[XOBWP-1:0] so_wsel_; logic[XOBW-1:0] so_wbus_;   convertEndian f_oswp (s_clk,o_frst,so_swaps, so_wen,so_wsel,so_wbus, so_wen_,so_wsel_,so_wbus_);
  generate if (SUB&2) begin
    assign o_bus=so_wbus_, o_sel=so_wsel_, o_rdy=so_wen_, so_wok=o_ena;
  end else begin
    fifoNxM #(XOBW+XOBWP,OBW+OBWP,OKR,5,BPAR,OFLG^BPAR) f_o (s_clk,o_frst, so_wok,so_wen_,{so_wsel_,so_wbus_}, o_clk,o_frst, o_rdy,o_ena,{o_sel,o_bus});
    if (SUB==2) assign s_ack = bi_rok;
  end endgenerate

  logic c_start,c_done,c_active; logic[15:0] c_cnt,c_stat;
  always @(posedge clk) begin
    if (frst) c_start <= 0; else c_start <= s_ena && c_rdy && !c_start && !c_active;
    if (frst) c_active <= 0; else c_active <= c_start || (c_active && !c_done);
    if (c_start) c_cnt <= 0; else c_cnt <= c_cnt+1;
  end
  flowcontrol f_c (clk, frst, s_opt, c_cnt, c_ok);

  import CORE_funcs::*;

  localparam NL=243, PT_AUTO=-1, PT_NONE=0, PT_NOOP=1, PT_ICE=2, PT_SDDS=3, PT_VRT=4, PT_VRTL=5, PT_VRTW=6, PT_VRTX=7,
     PT_VRTD=8, PF_FILL=0, PF_TIME=1, PF_OUID=2, PF_SOS=3, PF_FB3=4, PF_ANYSID=5, PF_BYPASS=6, PF_CTXF=7, PF_XSR=8,
     PF_XIF=9, PF_XRF=10, PF_XGAIN=11, XFER=256, OUID=1068407, DIFI=6971934;
  localparam CV_halo_sys=0, CV_halo_flag=28, CV_halo_func=64, CV_halo_fmts=68, CV_halo_flow=72, CV_halo_impl=76;
  localparam CV_pkty=256,CV_flags=260,CV_sid=264,CV_pinc=268,CV_cwsec=272,CV_nwsec=276,CV_cpsec=280,CV_npsec=288,
    CV_mpsec=296,CV_counts=304,CV_nseq=308,CV_swaps=312,CV_length=316,CV_ifix=320,CV_mfix=324,CV_nfix=328,CV_pad=332,
    CV_pstate=336,CV_npinc=340,CV_ouid=344,CV_pass=348,CV_vctx=352,CV_dbps=356;

  int8 pkty;
  uint12 flags;
  uint16 sid;
  uint20 pinc;
  uint32 cwsec;
  uint32 nwsec;
  uint40 cpsec;
  uint40 npsec;
  uint40 mpsec;
  uint32 counts;
  uint8 nseq;
  int8 swaps;
  uint12 length;
  uint4 ifix;
  uint4 mfix;
  uint4 nfix;
  uint32 pad;
  uint4 pstate;
  uint20 npinc;
  int24 ouid;
  uint4 pass;
  uint28 vctx;
  uint6 dbps;

  /* verilator lint_off UNOPTFLAT */
  Line c_ln[243];  wire c_en[243];  wire c_xn[243];
  /* verilator lint_on UNOPTFLAT */

  setLine #(1,0,0) f_1 (c_ln[1],"startMethod",c_start,F);    // public int process ( BufferI bi , StreamO so ) {
  uint14 ulen;                                               // uint14 ulen ;
  uint12 xfer, bfer, i;                                      // uint12 xfer , bfer , i ;
  uint8 ioff, seq;                                           // uint8 ioff , seq ;
  uint4 ooff, bpa, j;                                        // uint4 ooff , bpa , j ;
  uint6 bps, coff;                                           // uint6 bps , coff ;
  uint32 bx, by, bz;                                         // uint32 bx , by , bz ;
  uint40 lpsec;                                              // uint40 lpsec ;
  int32 difws;                                               // int32 difws ;
  int44 difps;                                               // int44 difps ;
  uint16 id;                                                 // uint16 id ;
  uint2 ifb;                                                 // uint2 ifb ;
  uint10 pfix;                                               // uint10 pfix ;
  int28 dpsec, fpsec;                                        // int28 dpsec , fpsec ;
  int20 phinc;                                               // int20 phinc ;
  int32 bc;                                                  // int32 bc ;
  boolean isNone, isNoop, isICE, isSDDS, isVRT, isVRTi, isVRTj, isVRTd, isVRTc, isVCTX, isSID, isBE, isNB, isOK; // boolean isNone , isNoop , isICE , isSDDS , isVRT , isVRTi , isVRTj , isVRTd , isVRTc , isVCTX , isSID , isBE , isNB , isOK ;
  boolean anyID, hasOUID, hasSID, usePad, useTC, useOUID, anyOUID, fb3, ctxf, xSR, xIF, xRF, xGain, byp; // boolean anyID , hasOUID , hasSID , usePad , useTC , useOUID , anyOUID , fb3 , ctxf , xSR , xIF , xRF , xGain , byp ;
  boolean okICE, okSDDS, okVRT, okIn, okLen, oknSec, doFill, doWrap, doStop, doClip, doTrim; // boolean okICE , okSDDS , okVRT , okIn , okLen , oknSec , doFill , doWrap , doStop , doClip , doTrim ;
  boolean cweqnw, cwgtnw, cwltnw, cpeqnp, cpgtnp, cpltnp, ceqn, cgtn, cltn, lpgtnp, needPad, needFill, needDrop; // boolean cweqnw , cwgtnw , cwltnw , cpeqnp , cpgtnp , cpltnp , ceqn , cgtn , cltn , lpgtnp , needPad , needFill , needDrop ;
  setLine #(1,0,1) f_21 (c_ln[21],"setVar",T,F);             // usePad = flags [ PF_FILL ] ;
  setLine #(1,0,1) f_22 (c_ln[22],"setVar",T,F);             // useTC = flags [ PF_TIME ] ;
  setLine #(1,0,1) f_23 (c_ln[23],"setVar",T,F);             // anyID = flags [ PF_ANYSID ] ;
  setLine #(1,0,1) f_24 (c_ln[24],"setVar",T,F);             // fb3 = flags [ PF_FB3 ] ;
  setLine #(1,0,1) f_25 (c_ln[25],"setVar",T,F);             // ctxf = flags [ PF_CTXF ] ;
  setLine #(1,0,1) f_26 (c_ln[26],"setVar",T,F);             // byp = flags [ PF_BYPASS ] ;
  setLine #(1,0,1) f_27 (c_ln[27],"setVar",T,F);             // useOUID = flags [ PF_OUID ] ;
  setLine #(1,0,1) f_28 (c_ln[28],"setVar",T,F);             // xSR = flags [ PF_XSR ] ;
  setLine #(1,0,1) f_29 (c_ln[29],"setVar",T,F);             // xIF = flags [ PF_XIF ] ;
  setLine #(1,0,1) f_30 (c_ln[30],"setVar",T,F);             // xRF = flags [ PF_XRF ] ;
  setLine #(1,0,1) f_31 (c_ln[31],"setVar",T,F);             // xGain = flags [ PF_XGAIN ] ;
  setLine #(1,0,1) f_32 (c_ln[32],"setVar",T,F);             // isNone = ( pkty == PT_NONE ) ;
  setLine #(1,0,1) f_33 (c_ln[33],"setVar",T,F);             // isNoop = ( pkty == PT_NOOP ) ;
  setLine #(1,0,1) f_34 (c_ln[34],"setVar",T,F);             // okICE = ( pkty == PT_AUTO ) || ( pkty == PT_ICE ) ;
  setLine #(1,0,1) f_35 (c_ln[35],"setVar",T,F);             // okSDDS = ( pkty == PT_SDDS ) ;
  setLine #(1,0,1) f_36 (c_ln[36],"setVar",T,F);             // okVRT = ( pkty == PT_AUTO ) || ( pkty >= PT_VRT ) ;
  setLine #(1,0,1) f_37 (c_ln[37],"setVar",T,F);             // okIn = bi.rok ;
  setLine #(1,0,1) f_38 (c_ln[38],"setVar",T,F);             // phinc = pinc ;
  setLine #(1,0,1) f_39 (c_ln[39],"setVar",T,F);             // okLen = ( length > 0 ) ;
  setLine #(1,0,1) f_40 (c_ln[40],"setVar",T,F);             // doTrim = length < XFER ;
  setLine #(1,1,1) f_41 (c_ln[41],"setVar",T,F);             // xfer = ! okIn ? 0 : doTrim ? length : XFER ;
  setLine #(1,0,1) f_42 (c_ln[42],"setVar",T,F);             // oknSec = ( nwsec > 0 ) ;
  setLine #(1,0,1) f_43 (c_ln[43],"setVar",T,F);             // difws = cwsec - nwsec ;
  setLine #(1,0,1) f_44 (c_ln[44],"setVar",T,F);             // difps = cpsec - npsec ;
  setLine #(1,1,1) f_45 (c_ln[45],"setVar",T,F);             // cwgtnw = ( difws > 0 ) ;
  setLine #(1,1,1) f_46 (c_ln[46],"setVar",T,F);             // cwltnw = ( difws < 0 ) ;
  setLine #(1,2,0) f_47 (c_ln[47],"setVar",T,F);             // cweqnw = ! cwgtnw && ! cwltnw ;
  setLine #(1,1,1) f_48 (c_ln[48],"setVar",T,F);             // cpgtnp = ( difps > ( phinc << 2 ) ) ;
  setLine #(1,1,1) f_49 (c_ln[49],"setVar",T,F);             // cpltnp = ( difps < - phinc ) ;
  setLine #(1,2,0) f_50 (c_ln[50],"setVar",T,F);             // cpeqnp = ! cpgtnp && ! cpltnp ;
  setLine #(1,2,0) f_51 (c_ln[51],"setVar",T,F);             // ceqn = cweqnw && cpeqnp ;
  setLine #(1,2,0) f_52 (c_ln[52],"setVar",T,F);             // cgtn = cwgtnw || ( cweqnw && cpgtnp ) ;
  setLine #(1,2,0) f_53 (c_ln[53],"setVar",T,F);             // cltn = cwltnw || ( cweqnw && cpltnp ) ;
  setLine #(1,1,1) f_54 (c_ln[54],"setVar",T,F);             // needPad = ( usePad && ! okIn ) ;
  setLine #(1,2,1) f_55 (c_ln[55],"setVar",T,F);             // needFill = ( useTC && oknSec && cltn ) ;
  setLine #(1,2,1) f_56 (c_ln[56],"setVar",T,F);             // needDrop = ( pstate == 4 ) && useTC && cgtn ;
  setLine #(1,0,1) f_57 (c_ln[57],"setVar",T,F);             // lpsec = cpsec + ( pinc << 8 ) ;
  setLine #(1,1,1) f_58 (c_ln[58],"setVar",T,F);             // lpgtnp = ( lpsec > npsec ) ;
  setLine #(1,1,1) f_59 (c_ln[59],"setVar",T,F);             // doClip = ( lpsec > mpsec ) ;
  setLine #(1,3,1) f_60 (c_ln[60],"setVar",T,F);             // doFill = ( needPad || needFill || needDrop ) && ! isNoop && ! isNone ;
  setLine #(1,2,1) f_61 (c_ln[61],"setVar",T,F);             // doStop = oknSec && cweqnw && lpgtnp && ! needPad ;
  setLine #(1,3,1) f_62 (c_ln[62],"setVar",T,F);             // fpsec = doClip ? l2i ( mpsec - cpsec ) : doStop ? l2i ( npsec - cpsec ) : ( pinc << 8 ) ;
  setLine #(1,1,1) f_63 (c_ln[63],"setVar",T,F);             // lpsec = ( pinc << 3 ) ;
  setLine #(1,0,1) f_64 (c_ln[64],"setVar",T,F);             // sid = 0 ;
  setLine #(1,0,1) f_65 (c_ln[65],"setVar",T,F);             // ooff = 0 ;
  setLine #(1,0,1) f_66 (c_ln[66],"setVar",T,F);             // seq = 0 ;
  setLine #(1,0,1) f_67 (c_ln[67],"setVar",T,F);             // ifb = 0 ;
  setLine #(1,0,1) f_68 (c_ln[68],"setVar",T,F);             // pfix = 0 ;
  setLine #(1,3,0) f_69 (c_ln[69],"print",s_vbpr[1],F);      // dprint ( "Top  Cur w=%08x p=%012lx  Nxt w=%08x p=%012lx  Counts=%x Pad=%x Fill=%x Drop=%x rOk=%x wOk=%x cnt=%d\n" , cwsec , cpsec , nwsec , npsec , counts , needPad ? 1 : 0 , needFill ? 1 : 0 , needDrop ? 1 : 0 , bi.rok ? 1 : 0 , so.wok ? 1 : 0 , c_cnt ) ;
  setLine #(1,4,0) f_70 (c_ln[70],"If",doFill,F);            // if ( doFill ) {
  setLine #(70,0,1) f_71 (c_ln[71],"setVar",T,F);            // pstate = 1 ;
  setLine #(70,0,1) f_72 (c_ln[72],"setVar",T,F);            // dpsec = fpsec ;
  setLine #(70,0,1) f_73 (c_ln[73],"setVar",T,F);            // bz = pad ;
  setLine #(70,1,0) f_74 (c_ln[74],"While",(so_wok && dpsec > 0) || (ifb != 0),c_xn[81]); // while ( ( so.wok && dpsec > 0 ) || ( ifb != 0 ) ) {
  setLine #(74,0,1) f_75 (c_ln[75],"setVar",T,F);            // cpsec = cpsec + pinc ;
  setLine #(74,0,1) f_76 (c_ln[76],"setVar",T,F);            // ifb = ! fb3 ? 0 : ( ifb == 2 ) ? 0 : ifb + 1 ;
  setLine #(74,0,1) f_77 (c_ln[77],"setVar",T,F);            // pfix = ( ifix == mfix ) ? pfix + nfix : pfix ;
  setLine #(74,0,1) f_78 (c_ln[78],"setVar",T,F);            // ifix = ( ifix == mfix ) ? 0 : ifix + 1 ;
  setLine #(74,0,1) f_79 (c_ln[79],"StreamO_wrLCS",T,F);     // so.wrLCS ( bz , ( dpsec < lpsec ) ? 1 : 0 , 0 ) ;
  setLine #(74,0,1) f_80 (c_ln[80],"setVar",T,F);            // dpsec -= pinc ;
  setLine #(74,1,0) f_81 (c_ln[81],"endWhile",c_xn[74],F);   // }
  setLine #(81,0,1) f_82 (c_ln[82],"setVar",T,F);            // counts [ 15 : 12 ] = counts [ 15 : 12 ] + 1 ;
  setLine #(81,0,1) f_83 (c_ln[83],"setVar",T,F);            // bz = 0 ;
  setLine #(81,1,0) f_84 (c_ln[84],"endIfE",c_xn[70],F);     // }
  setLine #(84,4,0) f_85 (c_ln[85],"ElseIf",okLen,c_xn[70]); // else if ( okLen ) {
  setLine #(85,0,1) f_86 (c_ln[86],"setVar",T,F);            // pstate = 2 ;
  setLine #(85,0,1) f_87 (c_ln[87],"setVar",T,F);            // i = 0 ;
  setLine #(85,1,0) f_88 (c_ln[88],"While",so_wok && i < xfer,c_xn[96]); // while ( so.wok && i < xfer ) {
  setLine #(88,0,1) f_89 (c_ln[89],"setVar",T,F);            // cpsec = cpsec + pinc ;
  setLine #(88,0,1) f_90 (c_ln[90],"setVar",T,F);            // pfix = ( ifix == mfix ) ? pfix + nfix : pfix ;
  setLine #(88,0,1) f_91 (c_ln[91],"setVar",T,F);            // ifix = ( ifix == mfix ) ? 0 : ifix + 1 ;
  setLine #(88,0,3) f_92 (c_ln[92],"BufferI_getL",T,F);      // bz = bi.getL ( i << 2 ) ;
  setLine #(88,3,1) f_93 (c_ln[93],"StreamO_wrLCS",T,F);     // so.wrLCS ( bz , ( length < 8 ) ? 1 : 0 , swaps ) ;
  setLine #(88,0,1) f_94 (c_ln[94],"setVar",T,F);            // i ++ ;
  setLine #(88,3,1) f_95 (c_ln[95],"setVar",T,F);            // length -- ;
  setLine #(88,4,0) f_96 (c_ln[96],"endWhile",c_xn[88],F);   // }
  setLine #(96,0,0) f_97 (c_ln[97],"BufferI_rnxt",T,F);      // bi.rnxt ( i << 2 ) ;
  setLine #(96,0,0) f_98 (c_ln[98],"endIfE",c_xn[85],F);     // }
  setLine #(98,4,0) f_99 (c_ln[99],"ElseIf",okIn && isNoop,c_xn[85]); // else if ( okIn && isNoop ) {
  setLine #(99,0,1) f_100 (c_ln[100],"setVar",T,F);          // pstate = 3 ;
  setLine #(99,0,1) f_101 (c_ln[101],"setVar",T,F);          // length = XFER ;
  setLine #(99,1,0) f_102 (c_ln[102],"endIfE",c_xn[99],F);   // }
  setLine #(102,4,0) f_103 (c_ln[103],"ElseIf",okIn && ! isNone,c_xn[99]); // else if ( okIn && ! isNone ) {
  setLine #(103,0,1) f_104 (c_ln[104],"setVar",T,F);         // pstate = 4 ;
  setLine #(103,0,1) f_105 (c_ln[105],"setVar",T,F);         // ulen = 0 ;
  setLine #(103,0,3) f_106 (c_ln[106],"BufferI_getL",T,F);   // bx = bi.getL ( 0 ) ;
  setLine #(103,1,3) f_107 (c_ln[107],"BufferI_getL",T,F);   // by = bi.getL ( 4 ) ;
  setLine #(103,2,3) f_108 (c_ln[108],"BufferI_getL",T,F);   // bz = bi.getL ( 8 ) ;
  setLine #(103,3,1) f_109 (c_ln[109],"setVar",T,F);         // anyOUID = ! useOUID || ! bx [ 3 ] ;
  setLine #(103,3,1) f_110 (c_ln[110],"setVar",T,F);         // hasOUID = bx [ 3 ] ;
  setLine #(103,3,1) f_111 (c_ln[111],"setVar",T,F);         // hasSID = ( bx [ 6 : 5 ] > 1 ) ? T : bx [ 4 ] ;
  setLine #(103,5,1) f_112 (c_ln[112],"setVar",T,F);         // isSID = bswap2 ( hasSID ? by [ 31 : 16 ] : bz [ 15 : 0 ] ) == sid ;
  setLine #(103,5,1) f_113 (c_ln[113],"setVar",T,F);         // isVRTi = ( bx [ 7 : 0 ] == 0x1C ) && ( ( bswap4 ( bz ) == ouid ) || anyOUID ) ;
  setLine #(103,4,1) f_114 (c_ln[114],"setVar",T,F);         // isVRTj = ( bx [ 7 : 0 ] == 0x08 ) && ( ( bswap4 ( by ) == ouid ) || anyOUID ) ;
  setLine #(103,5,1) f_115 (c_ln[115],"setVar",T,F);         // isVRTd = ( bx [ 7 : 0 ] == 0x18 ) && ( ( bswap4 ( bz ) == DIFI ) || anyOUID ) ;
  setLine #(103,5,1) f_116 (c_ln[116],"setVar",T,F);         // isVRTc = ( bx [ 7 : 0 ] == 0x49 ) && ( ( bswap4 ( bz ) == ouid ) || anyOUID ) ;
  setLine #(103,3,1) f_117 (c_ln[117],"setVar",T,F);         // isICE = okICE && ( bx == 0x00676665 ) ;
  setLine #(103,6,1) f_118 (c_ln[118],"setVar",T,F);         // isVRT = okVRT && ( isVRTi || isVRTj || isVRTd ) && ( isSID || anyID ) ;
  setLine #(103,6,1) f_119 (c_ln[119],"setVar",T,F);         // isVCTX = okVRT && isVRTc && ( isSID || anyID ) ;
  setLine #(103,7,0) f_120 (c_ln[120],"If",isICE,F);         // if ( isICE ) {
  setLine #(120,0,1) f_121 (c_ln[121],"setVar",T,F);         // ioff = 64 ;
  setLine #(120,0,1) f_122 (c_ln[122],"setVar",T,F);         // seq = by [ 7 : 0 ] ;
  setLine #(120,0,1) f_123 (c_ln[123],"setVar",T,F);         // bfer = bz [ 13 : 0 ] ;
  setLine #(120,0,1) f_124 (c_ln[124],"setVar",T,F);         // ulen = bz [ 13 : 0 ] ;
  setLine #(120,0,3) f_125 (c_ln[125],"BufferI_getL",T,F);   // bx = bi.getL ( 12 ) ;
  setLine #(120,3,1) f_126 (c_ln[126],"setVar",T,F);         // sid = bx [ 31 : 16 ] ;
  setLine #(120,1,3) f_127 (c_ln[127],"BufferI_getL",T,F);   // bx = bi.getL ( 16 ) ;
  setLine #(120,4,1) f_128 (c_ln[128],"setVar",T,F);         // bpa = bx [ 27 : 24 ] ;
  setLine #(120,5,0) f_129 (c_ln[129],"For",j+1 < bpa,F);    // for ( j = 1 ; j < bpa ; j ++ ) {
  setLine #(129,0,1) f_130 (c_ln[130],"setVar",T,F);         // ulen = ulen + bfer ;
  setLine #(129,0,0) f_131 (c_ln[131],"endFor",c_xn[129],F); // }
  setLine #(131,0,0) f_132 (c_ln[132],"endIfE",c_xn[120],F); // }
  setLine #(132,7,0) f_133 (c_ln[133],"ElseIf",isVRT,c_xn[120]); // else if ( isVRT ) {
  setLine #(133,0,1) f_134 (c_ln[134],"setVar",T,F);         // ooff = ( bx [ 2 ] ) ? 4 : 0 ;
  setLine #(133,0,1) f_135 (c_ln[135],"setVar",T,F);         // ioff = ! hasOUID ? 20 : ! hasSID ? 24 : 28 ;
  setLine #(133,0,1) f_136 (c_ln[136],"setVar",T,F);         // seq = bx [ 11 : 8 ] ;
  setLine #(133,0,1) f_137 (c_ln[137],"setVar",T,F);         // nseq = nseq & 0xF ;
  setLine #(133,1,1) f_138 (c_ln[138],"setVar",T,F);         // ulen = ( bswap2 ( bx [ 31 : 16 ] ) << 2 ) - ioff - ooff ;
  setLine #(133,0,3) f_139 (c_ln[139],"BufferI_getL",T,F);   // bx = bi.getL ( 12 ) ;
  setLine #(133,3,1) f_140 (c_ln[140],"setVar",T,F);         // isBE = isVRTi ? bx [ 22 ] : isVRTj ? bz [ 22 ] : T ;
  setLine #(133,3,1) f_141 (c_ln[141],"setVar",T,F);         // bps = isVRTi ? bx [ 27 : 24 ] : isVRTj ? bz [ 27 : 24 ] : dbps ;
  setLine #(133,4,0) f_142 (c_ln[142],"If",useTC,F);         // if ( useTC ) {
  setLine #(142,0,3) f_143 (c_ln[143],"BufferI_getL",T,F);   // by = bi.getL ( ioff - 12 ) ;
  setLine #(142,3,1) f_144 (c_ln[144],"setVar",T,F);         // nwsec = bswap4 ( by ) ;
  setLine #(142,1,3) f_145 (c_ln[145],"BufferI_getL",T,F);   // by = bi.getL ( ioff - 8 ) ;
  setLine #(142,4,1) f_146 (c_ln[146],"setVar",T,F);         // npsec [ 39 : 32 ] = bswap4 ( by ) ;
  setLine #(142,2,3) f_147 (c_ln[147],"BufferI_getL",T,F);   // by = bi.getL ( ioff - 4 ) ;
  setLine #(142,5,1) f_148 (c_ln[148],"setVar",T,F);         // npsec [ 31 : 0 ] = bswap4 ( by ) ;
  setLine #(142,6,0) f_149 (c_ln[149],"endIf",c_xn[142],F);  // }
  setLine #(149,0,1) f_150 (c_ln[150],"setVar",T,F);         // swaps [ 0 ] = ( bps == 15 ) && isBE ;
  setLine #(149,0,1) f_151 (c_ln[151],"setVar",T,F);         // swaps [ 1 ] = ( bps > 15 ) && isBE ;
  setLine #(149,0,1) f_152 (c_ln[152],"setVar",T,F);         // swaps [ 2 ] = ( bps == 11 ) && isBE ;
  setLine #(149,0,0) f_153 (c_ln[153],"print",s_vbpr[1],F);  // dprint ( "New Cur w=%08x p=%012lx  Nxt w=%08x p=%012lx\n" , cwsec , cpsec , nwsec , npsec ) ;
  setLine #(149,1,0) f_154 (c_ln[154],"endIfE",c_xn[133],F); // }
  setLine #(154,7,0) f_155 (c_ln[155],"ElseIf",isVCTX,c_xn[133]); // else if ( isVCTX ) {
  setLine #(155,0,1) f_156 (c_ln[156],"setVar",T,F);         // pstate = 5 ;
  setLine #(155,0,1) f_157 (c_ln[157],"setVar",T,F);         // ioff = bx [ 31 : 24 ] << 2 ;
  setLine #(155,0,1) f_158 (c_ln[158],"setVar",T,F);         // coff = hasOUID ? 28 : 20 ;
  setLine #(155,1,0) f_159 (c_ln[159],"If",ctxf,F);          // if ( ctxf ) {
  setLine #(159,0,3) f_160 (c_ln[160],"BufferI_getL",T,F);   // bx = bi.getL ( coff ) ;
  setLine #(159,3,1) f_161 (c_ln[161],"setVar",T,F);         // bx = brev4 ( bswap4 ( bx ) ) ;
  setLine #(159,4,0) f_162 (c_ln[162],"print",s_vbpr[0],F);  // vprint ( "UDAT Ctx bx=%08x coff=%d len=%d\n" , bx , coff , ioff ) ;
  setLine #(159,4,1) f_163 (c_ln[163],"StreamO_wrLCS",T,F);  // so.wrLCS ( bx , 2 , 0 ) ;
  setLine #(159,4,1) f_164 (c_ln[164],"setVar",T,F);         // coff += 4 + ( ( bx [ 2 : 2 ] ) << 3 ) + ( ( bx [ 1 : 1 ] ) << 2 ) ;
  setLine #(159,5,0) f_165 (c_ln[165],"If",bx[3] && xIF,F);  // if ( bx [ 3 ] && xIF ) {
  setLine #(165,0,3) f_166 (c_ln[166],"BufferI_getL",T,F);   // by = bi.getL ( coff ) ;
  setLine #(165,1,3) f_167 (c_ln[167],"BufferI_getL",T,F);   // bz = bi.getL ( coff + 4 ) ;
  setLine #(165,4,1) f_168 (c_ln[168],"setVar",T,F);         // bc = l2i ( ii2l ( bswap4 ( by ) , bswap4 ( bz ) ) >> 20 ) ;
  setLine #(165,5,0) f_169 (c_ln[169],"print",s_vbpr[0],F);  // vprint ( "UDAT Ctx IF bc=%d\n" , bc ) ;
  setLine #(165,5,1) f_170 (c_ln[170],"StreamO_wrLCS",T,F);  // so.wrLCS ( bc , 4 , 0 ) ;
  setLine #(165,6,0) f_171 (c_ln[171],"endIf",c_xn[165],F);  // }
  setLine #(171,0,1) f_172 (c_ln[172],"setVar",T,F);         // coff += ( ( bx [ 3 : 3 ] ) << 3 ) ;
  setLine #(171,1,0) f_173 (c_ln[173],"If",bx[4] && xRF,F);  // if ( bx [ 4 ] && xRF ) {
  setLine #(173,0,3) f_174 (c_ln[174],"BufferI_getL",T,F);   // by = bi.getL ( coff ) ;
  setLine #(173,1,3) f_175 (c_ln[175],"BufferI_getL",T,F);   // bz = bi.getL ( coff + 4 ) ;
  setLine #(173,4,1) f_176 (c_ln[176],"setVar",T,F);         // bc = l2i ( ii2l ( bswap4 ( by ) , bswap4 ( bz ) ) >> 20 ) ;
  setLine #(173,5,0) f_177 (c_ln[177],"print",s_vbpr[0],F);  // vprint ( "UDAT Ctx RF bc=%d\n" , bc ) ;
  setLine #(173,5,1) f_178 (c_ln[178],"StreamO_wrLCS",T,F);  // so.wrLCS ( bc , 4 , 0 ) ;
  setLine #(173,6,0) f_179 (c_ln[179],"endIf",c_xn[173],F);  // }
  setLine #(179,0,1) f_180 (c_ln[180],"setVar",T,F);         // coff += ( ( bx [ 4 : 4 ] + bx [ 5 : 5 ] + bx [ 6 : 6 ] ) << 3 ) + ( ( bx [ 7 : 7 ] ) << 2 ) ;
  setLine #(179,1,0) f_181 (c_ln[181],"If",bx[8] && xGain,F); // if ( bx [ 8 ] && xGain ) {
  setLine #(181,0,3) f_182 (c_ln[182],"BufferI_getL",T,F);   // by = bi.getL ( coff ) ;
  setLine #(181,3,1) f_183 (c_ln[183],"setVar",T,F);         // bc = bswap4 ( by ) >> 7 ;
  setLine #(181,4,0) f_184 (c_ln[184],"print",s_vbpr[0],F);  // vprint ( "UDAT Ctx GAIN bc=%d\n" , bc ) ;
  setLine #(181,4,1) f_185 (c_ln[185],"StreamO_wrLCS",T,F);  // so.wrLCS ( bc , 8 , 0 ) ;
  setLine #(181,5,0) f_186 (c_ln[186],"endIf",c_xn[181],F);  // }
  setLine #(186,0,1) f_187 (c_ln[187],"setVar",T,F);         // coff += ( ( bx [ 8 : 8 ] + bx [ 9 : 9 ] ) << 2 ) ;
  setLine #(186,1,0) f_188 (c_ln[188],"If",bx[10] && xSR,F); // if ( bx [ 10 ] && xSR ) {
  setLine #(188,0,3) f_189 (c_ln[189],"BufferI_getL",T,F);   // by = bi.getL ( coff ) ;
  setLine #(188,1,3) f_190 (c_ln[190],"BufferI_getL",T,F);   // bz = bi.getL ( coff + 4 ) ;
  setLine #(188,4,1) f_191 (c_ln[191],"setVar",T,F);         // bc = l2i ( ii2l ( bswap4 ( by ) , bswap4 ( bz ) ) >> 20 ) ;
  setLine #(188,5,0) f_192 (c_ln[192],"print",s_vbpr[0],F);  // vprint ( "UDAT Ctx SR bc=%d\n" , bc ) ;
  setLine #(188,5,1) f_193 (c_ln[193],"StreamO_wrLCS",T,F);  // so.wrLCS ( bc , 10 , 0 ) ;
  setLine #(188,6,0) f_194 (c_ln[194],"endIf",c_xn[188],F);  // }
  setLine #(194,0,1) f_195 (c_ln[195],"StreamO_wrLCS",T,F);  // so.wrLCS ( bx , 2 , 0 ) ;
  setLine #(194,1,1) f_196 (c_ln[196],"StreamO_setC",T,F);   // so.setC ( 0 ) ;
  setLine #(194,2,0) f_197 (c_ln[197],"endIf",c_xn[159],F);  // }
  setLine #(197,0,1) f_198 (c_ln[198],"setVar",T,F);         // counts [ 23 : 20 ] = counts [ 23 : 20 ] + 1 ;
  setLine #(197,1,0) f_199 (c_ln[199],"endIfE",c_xn[155],F); // }
  setLine #(199,7,0) f_200 (c_ln[200],"ElseIf",T,c_xn[155]); // else {
  setLine #(200,0,1) f_201 (c_ln[201],"setVar",T,F);         // ioff = 4 ;
  setLine #(200,0,1) f_202 (c_ln[202],"setVar",T,F);         // counts [ 30 : 24 ] = counts [ 30 : 24 ] + 1 ;
  setLine #(200,1,0) f_203 (c_ln[203],"endIf",c_xn[200],F|c_en[199]|c_en[154]|c_en[132]); // }
  setLine #(203,0,0) f_204 (c_ln[204],"BufferI_rnxt",T,F);   // bi.rnxt ( ioff ) ;
  setLine #(203,0,0) f_205 (c_ln[205],"If",ulen > 0,F);      // if ( ulen > 0 ) {
  setLine #(205,0,1) f_206 (c_ln[206],"setVar",T,F);         // length = ulen >> 2 ;
  setLine #(205,0,1) f_207 (c_ln[207],"setVar",T,F);         // counts [ 3 : 0 ] = counts [ 3 : 0 ] + 1 ;
  setLine #(205,1,0) f_208 (c_ln[208],"If",seq != nseq,F);   // if ( seq != nseq ) {
  setLine #(208,0,1) f_209 (c_ln[209],"setVar",T,F);         // counts [ 7 : 4 ] = counts [ 7 : 4 ] + 1 ;
  setLine #(208,1,0) f_210 (c_ln[210],"endIf",c_xn[208],F);  // }
  setLine #(210,0,1) f_211 (c_ln[211],"setVar",T,F);         // nseq = seq + 1 ;
  setLine #(210,0,1) f_212 (c_ln[212],"StreamO_setC",T,F);   // so.setC ( 0 ) ;
  setLine #(210,1,0) f_213 (c_ln[213],"endIf",c_xn[205],F);  // }
  setLine #(213,0,0) f_214 (c_ln[214],"endIf",c_xn[103],F|c_en[102]|c_en[98]|c_en[84]); // }
  setLine #(214,0,0) f_215 (c_ln[215],"If",needDrop,F);      // if ( needDrop ) {
  setLine #(215,0,1) f_216 (c_ln[216],"setVar",T,F);         // counts [ 11 : 8 ] = counts [ 11 : 8 ] + 1 ;
  setLine #(215,0,0) f_217 (c_ln[217],"BufferI_rnxt",T,F);   // bi.rnxt ( xfer << 2 ) ;
  setLine #(215,0,1) f_218 (c_ln[218],"setVar",T,F);         // length = length - xfer ;
  setLine #(215,1,0) f_219 (c_ln[219],"If",length > 0,F);    // if ( length > 0 ) {
  setLine #(219,0,1) f_220 (c_ln[220],"setVar",T,F);         // pstate = 4 ;
  setLine #(219,1,0) f_221 (c_ln[221],"endIf",c_xn[219],F);  // }
  setLine #(221,0,0) f_222 (c_ln[222],"endIf",c_xn[215],F);  // }
  setLine #(222,0,1) f_223 (c_ln[223],"setVar",T,F);         // counts [ 19 : 16 ] = ( length > 15 ) ? 15 : length [ 3 : 0 ] ;
  setLine #(222,1,1) f_224 (c_ln[224],"setVar",T,F);         // counts [ 31 ] = okIn ;
  setLine #(222,0,1) f_225 (c_ln[225],"setVar",T,F);         // cpsec = cpsec + pfix ;
  setLine #(222,1,1) f_226 (c_ln[226],"setVar",T,F);         // doWrap = ( cpsec >= mpsec ) ;
  setLine #(222,2,0) f_227 (c_ln[227],"If",doWrap,F);        // if ( doWrap ) {
  setLine #(227,0,1) f_228 (c_ln[228],"setVar",T,F);         // cpsec = cpsec - mpsec ;
  setLine #(227,0,1) f_229 (c_ln[229],"setVar",T,F);         // cwsec = cwsec + 1 ;
  setLine #(227,1,0) f_230 (c_ln[230],"endIf",c_xn[227],F);  // }
  setLine #(230,0,0) f_231 (c_ln[231],"If",pass == 0,F);     // if ( pass == 0 ) {
  setLine #(231,0,0) f_232 (c_ln[232],"Ram_wr",CV_counts,F); // this.counts = counts ;
  setLine #(231,1,0) f_233 (c_ln[233],"Ram_wr",CV_cwsec,F);  // this.cwsec = cwsec ;
  setLine #(231,2,2) f_234 (c_ln[234],"Ram_wrx",CV_cpsec,F); // this.cpsec = cpsec ;
  setLine #(231,4,0) f_235 (c_ln[235],"Ram_wr",CV_nwsec,F);  // this.nwsec = nwsec ;
  setLine #(231,5,2) f_236 (c_ln[236],"Ram_wrx",CV_npsec,F); // this.npsec = npsec ;
  setLine #(231,1,0) f_237 (c_ln[237],"print",s_vbpr[1],F);  // dprint ( "Upd  Counts=%x   Nxt w=%08x p=%012lx   Cur w=%08x p=%012lx   pstate=%d cnt=%d pass=%d\n" , counts , nwsec , npsec , cwsec , cpsec , pstate , c_cnt , pass ) ;
  setLine #(231,7,0) f_238 (c_ln[238],"endIf",c_xn[231],F);  // }
  setLine #(238,0,1) f_239 (c_ln[239],"setVar",T,F);         // pass = ( pass >= 14 ) ? 0 : pass + 1 ;
  setLine #(238,0,0) f_240 (c_ln[240],"BufferI_rokLen",T,F); // bi.rokLen ( XFER << 2 ) ;
  setLine #(238,0,0) f_241 (c_ln[241],"return",c_stat,F);    // return 0 ;
  setLine #(241,0,0) f_242 (c_ln[242],"endMethod",T,F);      // }

  assign cweqnw = ! cwgtnw && ! cwltnw;
  assign cpeqnp = ! cpgtnp && ! cpltnp;
  assign ceqn = cweqnw && cpeqnp;
  assign cgtn = cwgtnw || (cweqnw && cpgtnp);
  assign cltn = cwltnw || (cweqnw && cpltnp);
  always @(posedge clk) begin
    c_wr <= F; c_rd <= F; c_done <= F;
    bi_rd <= F; bi_nxt <= F;
    so_wen <= F; 
    if (s_set[0]) pkty <= s_val;
    if (s_set[1]) flags <= s_val;
    if (s_set[2]) sid <= s_val;
    if (s_set[3]) pinc <= s_val;
    if (s_set[4]) cwsec <= s_val;
    if (s_set[5]) nwsec <= s_val;
    if (s_set[7]) cpsec <= lswap(s_val);
    if (s_set[9]) npsec <= lswap(s_val);
    if (s_set[11]) mpsec <= lswap(s_val);
    if (s_set[12]) counts <= s_val;
    if (s_set[13]) nseq <= s_val;
    if (s_set[14]) swaps <= s_val;
    if (s_set[15]) length <= s_val;
    if (s_set[16]) ifix <= s_val;
    if (s_set[17]) mfix <= s_val;
    if (s_set[18]) nfix <= s_val;
    if (s_set[19]) pad <= s_val;
    if (s_set[20]) pstate <= s_val;
    if (s_set[21]) npinc <= s_val;
    if (s_set[22]) ouid <= s_val;
    if (s_set[23]) pass <= s_val;
    if (s_set[24]) vctx <= s_val;
    if (s_set[25]) dbps <= s_val;
    if (c_xn[21]) begin usePad <= flags[PF_FILL]; end
    if (c_xn[22]) begin useTC <= flags[PF_TIME]; end
    if (c_xn[23]) begin anyID <= flags[PF_ANYSID]; end
    if (c_xn[24]) begin fb3 <= flags[PF_FB3]; end
    if (c_xn[25]) begin ctxf <= flags[PF_CTXF]; end
    if (c_xn[26]) begin byp <= flags[PF_BYPASS]; end
    if (c_xn[27]) begin useOUID <= flags[PF_OUID]; end
    if (c_xn[28]) begin xSR <= flags[PF_XSR]; end
    if (c_xn[29]) begin xIF <= flags[PF_XIF]; end
    if (c_xn[30]) begin xRF <= flags[PF_XRF]; end
    if (c_xn[31]) begin xGain <= flags[PF_XGAIN]; end
    if (c_xn[32]) begin isNone <= (pkty == PT_NONE); end
    if (c_xn[33]) begin isNoop <= (pkty == PT_NOOP); end
    if (c_xn[34]) begin okICE <= (pkty == PT_AUTO) || (pkty == PT_ICE); end
    if (c_xn[35]) begin okSDDS <= (pkty == PT_SDDS); end
    if (c_xn[36]) begin okVRT <= (pkty == PT_AUTO) || (pkty >= PT_VRT); end
    if (c_xn[37]) begin okIn <= bi_rok; end
    if (c_xn[38]) begin phinc <= pinc; end
    if (c_xn[39]) begin okLen <= (length > 0); end
    if (c_xn[40]) begin doTrim <= length < XFER; end
    if (c_xn[41]) begin xfer <= ! okIn ? 0 : doTrim ? length : XFER; end
    if (c_xn[42]) begin oknSec <= (nwsec > 0); end
    if (c_xn[43]) begin difws <= cwsec - nwsec; end
    if (c_xn[44]) begin difps <= cpsec - npsec; end
    if (c_xn[45]) begin cwgtnw <= (difws > 0); end
    if (c_xn[46]) begin cwltnw <= (difws < 0); end
    if (c_xn[48]) begin cpgtnp <= (difps > (phinc << 2)); end
    if (c_xn[49]) begin cpltnp <= (difps < - phinc); end
    if (c_xn[54]) begin needPad <= (usePad && ! okIn); end
    if (c_xn[55]) begin needFill <= (useTC && oknSec && cltn); end
    if (c_xn[56]) begin needDrop <= (pstate == 4) && useTC && cgtn; end
    if (c_xn[57]) begin lpsec <= cpsec + (pinc << 8); end
    if (c_xn[58]) begin lpgtnp <= (lpsec > npsec); end
    if (c_xn[59]) begin doClip <= (lpsec > mpsec); end
    if (c_xn[60]) begin doFill <= (needPad || needFill || needDrop) && ! isNoop && ! isNone; end
    if (c_xn[61]) begin doStop <= oknSec && cweqnw && lpgtnp && ! needPad; end
    if (c_xn[62]) begin fpsec <= doClip ? l2i (mpsec - cpsec) : doStop ? l2i (npsec - cpsec) : (pinc << 8); end
    if (c_xn[63]) begin lpsec <= (pinc << 3); end
    if (c_xn[64]) begin sid <= 0; end
    if (c_xn[65]) begin ooff <= 0; end
    if (c_xn[66]) begin seq <= 0; end
    if (c_xn[67]) begin ifb <= 0; end
    if (c_xn[68]) begin pfix <= 0; end
    if (c_xn[69]) begin $write ("Top  Cur w=%08x p=%012x  Nxt w=%08x p=%012x  Counts=%x Pad=%x Fill=%x Drop=%x rOk=%x wOk=%x cnt=%d\n", cwsec, cpsec, nwsec, npsec, counts, needPad ? 1 : 0, needFill ? 1 : 0, needDrop ? 1 : 0, bi_rok ? 1 : 0, so_wok ? 1 : 0, c_cnt); end
    if (c_xn[71]) begin pstate <= 1; end
    if (c_xn[72]) begin dpsec <= fpsec; end
    if (c_xn[73]) begin bz <= pad; end
    if (c_xn[75]) begin cpsec <= cpsec + pinc; end
    if (c_xn[76]) begin ifb <= ! fb3 ? 0 : (ifb == 2) ? 0 : ifb + 1; end
    if (c_xn[77]) begin pfix <= (ifix == mfix) ? pfix + nfix : pfix; end
    if (c_xn[78]) begin ifix <= (ifix == mfix) ? 0 : ifix + 1; end
    if (c_xn[79]) begin so_wen <= T; so_wbus <= bz; so_wsel <= (dpsec < lpsec) ? 1 : 0; so_swaps <= 0; end
    if (c_xn[80]) begin dpsec <= dpsec - pinc; end
    if (c_xn[82]) begin counts[15:12] <= counts[15:12] + 1; end
    if (c_xn[83]) begin bz <= 0; end
    if (c_xn[86]) begin pstate <= 2; end
    if (c_xn[87]) begin i <= 0; end
    if (c_xn[89]) begin cpsec <= cpsec + pinc; end
    if (c_xn[90]) begin pfix <= (ifix == mfix) ? pfix + nfix : pfix; end
    if (c_xn[91]) begin ifix <= (ifix == mfix) ? 0 : ifix + 1; end
    if (c_en[92]) begin bi_rd <= T; bi_adr <= i << 2; end 
    if (c_xn[92]) begin bz <= bi_bus; end
    if (c_xn[93]) begin so_wen <= T; so_wbus <= bz; so_wsel <= (length < 8) ? 1 : 0; so_swaps <= swaps; end
    if (c_xn[94]) begin i <= i + 1; end
    if (c_xn[95]) begin length <= length - 1; end
    if (c_en[97]) begin bi_nxt <= T; bi_adr <= i << 2; end
    if (c_xn[100]) begin pstate <= 3; end
    if (c_xn[101]) begin length <= XFER; end
    if (c_xn[104]) begin pstate <= 4; end
    if (c_xn[105]) begin ulen <= 0; end
    if (c_en[106]) begin bi_rd <= T; bi_adr <= 0; end 
    if (c_xn[106]) begin bx <= bi_bus; end
    if (c_en[107]) begin bi_rd <= T; bi_adr <= 4; end 
    if (c_xn[107]) begin by <= bi_bus; end
    if (c_en[108]) begin bi_rd <= T; bi_adr <= 8; end 
    if (c_xn[108]) begin bz <= bi_bus; end
    if (c_xn[109]) begin anyOUID <= ! useOUID || ! bx[3]; end
    if (c_xn[110]) begin hasOUID <= bx[3]; end
    if (c_xn[111]) begin hasSID <= (bx[6:5] > 1) ? T : bx[4]; end
    if (c_xn[112]) begin isSID <= bswap2 (hasSID ? by[31:16] : bz[15:0]) == sid; end
    if (c_xn[113]) begin isVRTi <= (bx[7:0] == 8'h1C) && ((bswap4 (bz) == ouid) || anyOUID); end
    if (c_xn[114]) begin isVRTj <= (bx[7:0] == 8'h08) && ((bswap4 (by) == ouid) || anyOUID); end
    if (c_xn[115]) begin isVRTd <= (bx[7:0] == 8'h18) && ((bswap4 (bz) == DIFI) || anyOUID); end
    if (c_xn[116]) begin isVRTc <= (bx[7:0] == 8'h49) && ((bswap4 (bz) == ouid) || anyOUID); end
    if (c_xn[117]) begin isICE <= okICE && (bx == 32'h00676665); end
    if (c_xn[118]) begin isVRT <= okVRT && (isVRTi || isVRTj || isVRTd) && (isSID || anyID); end
    if (c_xn[119]) begin isVCTX <= okVRT && isVRTc && (isSID || anyID); end
    if (c_xn[121]) begin ioff <= 64; end
    if (c_xn[122]) begin seq <= by[7:0]; end
    if (c_xn[123]) begin bfer <= bz[13:0]; end
    if (c_xn[124]) begin ulen <= bz[13:0]; end
    if (c_en[125]) begin bi_rd <= T; bi_adr <= 12; end 
    if (c_xn[125]) begin bx <= bi_bus; end
    if (c_xn[126]) begin sid <= bx[31:16]; end
    if (c_en[127]) begin bi_rd <= T; bi_adr <= 16; end 
    if (c_xn[127]) begin bx <= bi_bus; end
    if (c_xn[128]) begin bpa <= bx[27:24]; end
    if (c_xn[129] || rst) begin j <= 1; end else if (c_en[129]) begin j <= j + 1; end
    if (c_xn[130]) begin ulen <= ulen + bfer; end
    if (c_xn[134]) begin ooff <= (bx[2]) ? 4 : 0; end
    if (c_xn[135]) begin ioff <= ! hasOUID ? 20 : ! hasSID ? 24 : 28; end
    if (c_xn[136]) begin seq <= bx[11:8]; end
    if (c_xn[137]) begin nseq <= nseq & 4'hF; end
    if (c_xn[138]) begin ulen <= (bswap2 (bx[31:16]) << 2) - ioff - ooff; end
    if (c_en[139]) begin bi_rd <= T; bi_adr <= 12; end 
    if (c_xn[139]) begin bx <= bi_bus; end
    if (c_xn[140]) begin isBE <= isVRTi ? bx[22] : isVRTj ? bz[22] : T; end
    if (c_xn[141]) begin bps <= isVRTi ? bx[27:24] : isVRTj ? bz[27:24] : dbps; end
    if (c_en[143]) begin bi_rd <= T; bi_adr <= ioff - 12; end 
    if (c_xn[143]) begin by <= bi_bus; end
    if (c_xn[144]) begin nwsec <= bswap4 (by); end
    if (c_en[145]) begin bi_rd <= T; bi_adr <= ioff - 8; end 
    if (c_xn[145]) begin by <= bi_bus; end
    if (c_xn[146]) begin npsec[39:32] <= bswap4 (by); end
    if (c_en[147]) begin bi_rd <= T; bi_adr <= ioff - 4; end 
    if (c_xn[147]) begin by <= bi_bus; end
    if (c_xn[148]) begin npsec[31:0] <= bswap4 (by); end
    if (c_xn[150]) begin swaps[0] <= (bps == 15) && isBE; end
    if (c_xn[151]) begin swaps[1] <= (bps > 15) && isBE; end
    if (c_xn[152]) begin swaps[2] <= (bps == 11) && isBE; end
    if (c_xn[153]) begin $write ("New Cur w=%08x p=%012x  Nxt w=%08x p=%012x\n", cwsec, cpsec, nwsec, npsec); end
    if (c_xn[156]) begin pstate <= 5; end
    if (c_xn[157]) begin ioff <= bx[31:24] << 2; end
    if (c_xn[158]) begin coff <= hasOUID ? 28 : 20; end
    if (c_en[160]) begin bi_rd <= T; bi_adr <= coff; end 
    if (c_xn[160]) begin bx <= bi_bus; end
    if (c_xn[161]) begin bx <= brev4 (bswap4 (bx)); end
    if (c_xn[162]) begin $write ("UDAT Ctx bx=%08x coff=%d len=%d\n", bx, coff, ioff); end
    if (c_xn[163]) begin so_wen <= T; so_wbus <= bx; so_wsel <= 2; so_swaps <= 0; end
    if (c_xn[164]) begin coff <= coff + 4 + ((bx[2:2]) << 3) + ((bx[1:1]) << 2); end
    if (c_en[166]) begin bi_rd <= T; bi_adr <= coff; end 
    if (c_xn[166]) begin by <= bi_bus; end
    if (c_en[167]) begin bi_rd <= T; bi_adr <= coff + 4; end 
    if (c_xn[167]) begin bz <= bi_bus; end
    if (c_xn[168]) begin bc <= l2i (ii2l (bswap4 (by), bswap4 (bz)) >>> 20); end
    if (c_xn[169]) begin $write ("UDAT Ctx IF bc=%d\n", bc); end
    if (c_xn[170]) begin so_wen <= T; so_wbus <= bc; so_wsel <= 4; so_swaps <= 0; end
    if (c_xn[172]) begin coff <= coff + ((bx[3:3]) << 3); end
    if (c_en[174]) begin bi_rd <= T; bi_adr <= coff; end 
    if (c_xn[174]) begin by <= bi_bus; end
    if (c_en[175]) begin bi_rd <= T; bi_adr <= coff + 4; end 
    if (c_xn[175]) begin bz <= bi_bus; end
    if (c_xn[176]) begin bc <= l2i (ii2l (bswap4 (by), bswap4 (bz)) >>> 20); end
    if (c_xn[177]) begin $write ("UDAT Ctx RF bc=%d\n", bc); end
    if (c_xn[178]) begin so_wen <= T; so_wbus <= bc; so_wsel <= 4; so_swaps <= 0; end
    if (c_xn[180]) begin coff <= coff + ((bx[4:4] + bx[5:5] + bx[6:6]) << 3) + ((bx[7:7]) << 2); end
    if (c_en[182]) begin bi_rd <= T; bi_adr <= coff; end 
    if (c_xn[182]) begin by <= bi_bus; end
    if (c_xn[183]) begin bc <= bswap4 (by) >>> 7; end
    if (c_xn[184]) begin $write ("UDAT Ctx GAIN bc=%d\n", bc); end
    if (c_xn[185]) begin so_wen <= T; so_wbus <= bc; so_wsel <= 8; so_swaps <= 0; end
    if (c_xn[187]) begin coff <= coff + ((bx[8:8] + bx[9:9]) << 2); end
    if (c_en[189]) begin bi_rd <= T; bi_adr <= coff; end 
    if (c_xn[189]) begin by <= bi_bus; end
    if (c_en[190]) begin bi_rd <= T; bi_adr <= coff + 4; end 
    if (c_xn[190]) begin bz <= bi_bus; end
    if (c_xn[191]) begin bc <= l2i (ii2l (bswap4 (by), bswap4 (bz)) >>> 20); end
    if (c_xn[192]) begin $write ("UDAT Ctx SR bc=%d\n", bc); end
    if (c_xn[193]) begin so_wen <= T; so_wbus <= bc; so_wsel <= 10; so_swaps <= 0; end
    if (c_xn[195]) begin so_wen <= T; so_wbus <= bx; so_wsel <= 2; so_swaps <= 0; end
    if (c_xn[196]) begin so_wsel <= 0; end
    if (c_xn[198]) begin counts[23:20] <= counts[23:20] + 1; end
    if (c_xn[201]) begin ioff <= 4; end
    if (c_xn[202]) begin counts[30:24] <= counts[30:24] + 1; end
    if (c_en[204]) begin bi_nxt <= T; bi_adr <= ioff; end
    if (c_xn[206]) begin length <= ulen >>> 2; end
    if (c_xn[207]) begin counts[3:0] <= counts[3:0] + 1; end
    if (c_xn[209]) begin counts[7:4] <= counts[7:4] + 1; end
    if (c_xn[211]) begin nseq <= seq + 1; end
    if (c_xn[212]) begin so_wsel <= 0; end
    if (c_xn[216]) begin counts[11:8] <= counts[11:8] + 1; end
    if (c_en[217]) begin bi_nxt <= T; bi_adr <= xfer << 2; end
    if (c_xn[218]) begin length <= length - xfer; end
    if (c_xn[220]) begin pstate <= 4; end
    if (c_xn[223]) begin counts[19:16] <= (length > 15) ? 15 : length[3:0]; end
    if (c_xn[224]) begin counts[31] <= okIn; end
    if (c_xn[225]) begin cpsec <= cpsec + pfix; end
    if (c_xn[226]) begin doWrap <= (cpsec >= mpsec); end
    if (c_xn[228]) begin cpsec <= cpsec - mpsec; end
    if (c_xn[229]) begin cwsec <= cwsec + 1; end
    if (c_xn[232]) begin c_wr <= T; c_adr <= CV_counts; c_wbus <= counts; end
    if (c_xn[233]) begin c_wr <= T; c_adr <= CV_cwsec; c_wbus <= cwsec; end
    if (c_en[234]) begin c_wr <= T; c_adr <= CV_cpsec; c_wbus <= cpsec; end 
    if (c_xn[234]) begin c_wr <= T; c_adr <= CV_cpsec + 4; c_wbus <= (cpsec) >> 32; end
    if (c_xn[235]) begin c_wr <= T; c_adr <= CV_nwsec; c_wbus <= nwsec; end
    if (c_en[236]) begin c_wr <= T; c_adr <= CV_npsec; c_wbus <= npsec; end 
    if (c_xn[236]) begin c_wr <= T; c_adr <= CV_npsec + 4; c_wbus <= (npsec) >> 32; end
    if (c_xn[237]) begin $write ("Upd  Counts=%x   Nxt w=%08x p=%012x   Cur w=%08x p=%012x   pstate=%d cnt=%d pass=%d\n", counts, nwsec, npsec, cwsec, cpsec, pstate, c_cnt, pass); end
    if (c_xn[239]) begin pass <= (pass >= 14) ? 0 : pass + 1; end
    if (c_en[240]) begin bi_len <= XFER << 2; end
    if (c_xn[241]) begin c_stat <= 0; c_done <= T; end
  end

  /* verilator lint_off WIDTHCONCAT */
  localparam int SEQ_PARAMS[243*4] = '{ 0,0,0,0, 11,0,0,0, 0,0,0,0, 0,0,0,0, 0,0,0,0, 0,0,0,0, 0,0,0,0, 0,0,0,0, 0,0,0,0, 0,0,0,0, 0,0,0,0, 0,0,0,0, 0,0,0,0, 0,0,0,0, 0,0,0,0, 0,0,0,0, 0,0,0,0, 0,0,0,0, 0,0,0,0, 0,0,0,0, 0,0,0,0, 21,1,0,0, 21,1,0,0, 21,1,0,0, 21,1,0,0, 21,1,0,0, 21,1,0,0, 21,1,0,0, 21,1,0,0, 21,1,0,0, 21,1,0,0, 21,1,0,0, 21,1,0,0, 21,1,0,0, 21,1,0,0, 21,1,0,0, 21,1,0,0, 21,1,0,0, 21,1,0,0, 21,1,0,0, 21,1,0,0, 21,1,1,0, 21,1,0,0, 21,1,0,0, 21,1,0,0, 21,1,1,0, 21,1,1,0, 21,1,2,0, 21,1,1,0, 21,1,1,0, 21,1,2,0, 21,1,2,0, 21,1,2,0, 21,1,2,0, 21,1,1,0, 21,1,2,0, 21,1,2,0, 21,1,0,0, 21,1,1,0, 21,1,1,0, 21,1,3,0, 21,1,2,0, 21,1,3,0, 21,1,1,0, 21,1,0,0, 21,1,0,0, 21,1,0,0, 21,1,0,0, 21,1,0,0, 24,1,3,0, 33,1,4,0, 21,70,0,0, 21,70,0,0, 21,70,0,0, 41,70,1,1, 21,74,0,0, 21,74,0,0, 21,74,0,0, 21,74,0,0, 10,74,0,0, 21,74,0,0, 42,74,1,0, 21,81,0,0, 21,81,0,0, 35,81,1,0, 34,84,4,0, 21,85,0,0, 21,85,0,0, 41,85,1,1, 21,88,0,0, 21,88,0,0, 21,88,0,0, 10,88,0,2, 10,88,3,0, 21,88,0,0, 21,88,3,0, 42,88,4,0, 10,96,0,0, 35,96,0,0, 34,98,4,0, 21,99,0,0, 21,99,0,0, 35,99,1,0, 34,102,4,0, 21,103,0,0, 21,103,0,0, 10,103,0,2, 10,103,1,2, 10,103,2,2, 21,103,3,0, 21,103,3,0, 21,103,3,0, 21,103,5,0, 21,103,5,0, 21,103,4,0, 21,103,5,0, 21,103,5,0, 21,103,3,0, 21,103,6,0, 21,103,6,0, 33,103,7,0, 21,120,0,0, 21,120,0,0, 21,120,0,0, 21,120,0,0, 10,120,0,2, 21,120,3,0, 10,120,1,2, 21,120,4,0, 45,120,5,0, 21,129,0,0, 46,129,0,0, 35,131,0,0, 34,132,7,0, 21,133,0,0, 21,133,0,0, 21,133,0,0, 21,133,0,0, 21,133,1,0, 10,133,0,2, 21,133,3,0, 21,133,3,0, 31,133,4,0, 10,142,0,2, 21,142,3,0, 10,142,1,2, 21,142,4,0, 10,142,2,2, 21,142,5,0, 32,142,6,0, 21,149,0,0, 21,149,0,0, 21,149,0,0, 24,149,0,0, 35,149,1,0, 34,154,7,0, 21,155,0,0, 21,155,0,0, 21,155,0,0, 31,155,1,0, 10,159,0,2, 21,159,3,0, 24,159,4,0, 10,159,4,0, 21,159,4,0, 31,159,5,0, 10,165,0,2, 10,165,1,2, 21,165,4,0, 24,165,5,0, 10,165,5,0, 32,165,6,0, 21,171,0,0, 31,171,1,0, 10,173,0,2, 10,173,1,2, 21,173,4,0, 24,173,5,0, 10,173,5,0, 32,173,6,0, 21,179,0,0, 31,179,1,0, 10,181,0,2, 21,181,3,0, 24,181,4,0, 10,181,4,0, 32,181,5,0, 21,186,0,0, 31,186,1,0, 10,188,0,2, 10,188,1,2, 21,188,4,0, 24,188,5,0, 10,188,5,0, 32,188,6,0, 10,194,0,0, 10,194,1,0, 32,194,2,0, 21,197,0,0, 35,197,1,0, 34,199,7,0, 21,200,0,0, 21,200,0,0, 32,200,1,0, 10,203,0,0, 31,203,0,0, 21,205,0,0, 21,205,0,0, 31,205,1,0, 21,208,0,0, 32,208,1,0, 21,210,0,0, 10,210,0,0, 32,210,1,0, 32,213,0,0, 31,214,0,0, 21,215,0,0, 10,215,0,0, 21,215,0,0, 31,215,1,0, 21,219,0,0, 32,219,1,0, 32,221,0,0, 21,222,0,0, 21,222,1,0, 21,222,0,0, 21,222,1,0, 31,222,2,0, 21,227,0,0, 21,227,0,0, 32,227,1,0, 31,230,0,0, 10,231,0,0, 10,231,1,0, 10,231,2,1, 10,231,4,0, 10,231,5,1, 24,231,1,0, 32,231,7,0, 21,238,0,0, 10,238,0,0, 14,238,0,0, 15,241,0,0};
  sequencer #(243,SEQ_PARAMS) c_seq (clks,rst, c_ln, c_en,c_xn);
  /* verilator lint_on WIDTHCONCAT */
  assign s_test = {c_cnt[0],c_done,c_active,c_start,o_ena,i_ena,o_frst,i_frst};
endmodule

