/**
  Do NOT edit.
  This file is generated by ICEJVCC.
  See UDAT.jv for documentation.
*/
package nxm.ice.core;
import nxm.ice.lib.*;
public class UDAT extends CoreFactory {

public static class JVM extends CORE       {                             public JVM() { setFlow(BUFSTR); } }
public static class CPU extends CoreNative { public native long alloc(); public CPU() { setFlow(BUFSTR); } }
public static class ICE extends CoreNative { public native long alloc(); public ICE() { setFlow(BUFSTR); } }

public final static String pktList = "Auto,None,Noop,ICE,SDDS,VRT,VRTL,VRTW,VRTX,VRTD";
public final static int PT_AUTO = -1, PT_NONE = 0, PT_NOOP = 1, PT_ICE = 2, PT_SDDS = 3, PT_VRT = 4, PT_VRTL = 5, PT_VRTW = 6, PT_VRTX = 7, PT_VRTD = 8;
public final static String flgList = "Fill,Time,OUID,SOS,FB3,AnySID,Bypass,CTXF,xSR,xIF,xRF,xGAIN";
public final static int PF_FILL = 0, PF_TIME = 1, PF_OUID = 2, PF_SOS = 3, PF_FB3 = 4, PF_ANYSID = 5, PF_BYPASS = 6, PF_CTXF = 7, PF_XSR = 8, PF_XIF = 9, PF_XRF = 10, PF_XGAIN = 11;
public static class CORE extends Core {
  public final static int FLOW = BUFSTR, SELFPACE = 1, IKR = 16, OKR = 4, OFMT = FSWP;
  public final static int BW = 32;
  public final static int XFER = 256;
  public final static int OUID = 0x104D77, DIFI = 0x6A621E;
  public double ctime;
  public double srate;
  public int bits;
  public int ptype;
  public int bpa;
  int pkty;
  int flags;
  int sid;
  int pinc;
  int cwsec, nwsec;
  long cpsec, npsec;
  long mpsec;
  int counts;
  int nseq;
  int swaps;
  int length;
  int ifix, mfix, nfix;
  int pad;
  int pstate;
  int npinc;
  int ouid;
  int pass;
  int vctx;
  int dbps;
  public void setTime (double time) {
    if (ctime > 60.0) time = ctime;
    else time += ctime;
    cwsec = d2i (floor (time));
    cpsec = d2l (frac (time) * 1.0e12);
    nwsec = 0;
    npsec = 0;
    putVars ("cwsec,cpsec,nwsec,npsec");
  }
  public void startup (double time) {
    setTime (time);
    poll ();
    pkty = ptype;
    putVars ("pkty");
  }
  public void setPhaseInc (double rate) {
    npinc = d2i (round (1.0e12 / rate / bpa * 4));
  }
  public boolean isAsync () {
    return (ptype != PT_NOOP) && getBit(flags, PF_TIME);
  }
  public double getRate () {
    return srate;
  }
  public boolean getCTXF () {
    return getBit(flags, PF_CTXF);
  }
  public int init () {
    pkty = PT_NONE;
    ptype = PT_NOOP;
    flags = 0;
    sid = -1;
    ctime = 0;
    srate = 10e6;
    bits = -16;
    pad = 0;
    ouid = 0;
    return 0;
  }
  public int set (String key, Value value) {
    if (isMatch (key, "S:PT")) ptype = value.toItem (pktList);
    else if (isMatch (key, "L:PKTY")) ptype = value.toL ();
    else if (isMatch (key, "L:SID")) sid = value.toL ();
    else if (isMatch (key, "L:OUID")) ouid = value.toL ();
    else if (isMatch (key, "L:BITS")) bits = value.toL ();
    else if (isMatch (key, "L:PAD")) pad = value.toL ();
    else if (isMatch (key, "D:CTIME")) ctime = value.toD ();
    else if (isMatch (key, "D:SRATE")) srate = value.toD ();
    else if (isMatch (key, "L:VCTX")) vctx = value.toL ();
    else if (isMatch (key, "L:FLAGS")) flags = value.toL ();
    else if (isMatch (key, "S:FLAGS")) flags = value.toMask (flgList);
    else if (isMatch (key, "D:NEXTSRATE")) {
      setPhaseInc (value.toD ());
      putVars ("npinc");
    }
    else if (isMatch (key, "D:STARTUP")) startup (value.toD ());
    else return super.set (key, value);
    return 0;
  }
  public int get (String key, Value value) {
    if (isMatch (key, "L:PKTY")) value.fromL (ptype);
    else if (isMatch (key, "L:SID")) value.fromL (sid);
    else if (isMatch (key, "L:FLAGS")) value.fromL (flags);
    else if (isMatch (key, "D:STARTUP")) value.fromD (ctime);
    else return super.get (key, value);
    return 0;
  }
  public int open () {
    sid &= 0xFFFF;
    bpa = (bits < 0) ? - bits * 2 / 8 : bits / 8;
    dbps = iabs (bits) - 1;
    nseq = 0;
    counts = 0;
    length = 0;
    swaps = 0;
    nwsec = 0;
    npsec = 0;
    mpsec = d2l (1.0e12);
    pstate = 0;
    if (ptype == PT_NOOP) {
      bpa = 4;
      pkty = ptype;
    }
    if (ptype == PT_VRTD) ouid = DIFI;
    setTime (cpuTime ());
    if (srate < 1e6) System.out.printf ("Sample Rate=%f too low for UDAT counters\n", srate);
    setPhaseInc (srate);
    pinc = npinc;
    if (srate == 300e6 && bpa == 3) {
      mfix = 8;
      nfix = 4;
    }
    if (nfix != 0) System.out.printf ("Fixup for UDAT fractional pinc=%d nfix=%d mfix=%d\n", pinc, nfix, mfix);
    flags=setBit(flags, PF_FB3, (bpa == 3));
    flags=setBit(flags, PF_ANYSID, (sid == 0xFFFF));
    flags=setBit(flags, PF_XSR, getBit(flags, PF_XSR) || getBit(vctx, 24));
    flags=setBit(flags, PF_XIF, getBit(flags, PF_XIF) || getBit(vctx, 25));
    flags=setBit(flags, PF_XRF, getBit(flags, PF_XRF) || getBit(vctx, 26));
    flags=setBit(flags, PF_XGAIN, getBit(flags, PF_XGAIN) || getBit(vctx, 27));
    flags=setBit(flags, PF_CTXF, getBit(flags, PF_CTXF) || (getBit(flags, PF_XSR) || getBit(flags, PF_XIF) || getBit(flags, PF_XRF) || getBit(flags, PF_XGAIN)));
    flags=setBit(flags, PF_OUID, getBit(flags, PF_OUID) && (ouid >= 0));
    if (ouid <= 0) ouid = OUID;
    if((this.halo.vbpr&1)!=0)System.out.printf ("UDAT pkty=%d:%d srate=%f bits=%d flags=%04x\n", ptype, pkty, srate, bits, flags);
    this.halo.state=1;
    return 0;
  }
  public int process (Buffer bi, Stream so) {
    int ulen;
    int xfer, bfer, i;
    int ioff, seq;
    int ooff, bpa, j;
    int bps, coff;
    int bx, by, bz;
    long lpsec;
    int difws;
    long difps;
    int id;
    int ifb;
    int pfix;
    int dpsec, fpsec;
    int phinc;
    int bc;
    boolean isNone, isNoop, isICE, isSDDS, isVRT, isVRTi, isVRTj, isVRTd, isVRTc, isVCTX, isSID, isBE, isNB, isOK;
    boolean anyID, hasOUID, hasSID, usePad, useTC, useOUID, anyOUID, fb3, ctxf, xSR, xIF, xRF, xGain, byp;
    boolean okICE, okSDDS, okVRT, okIn, okLen, oknSec, doFill, doWrap, doStop, doClip, doTrim;
    boolean cweqnw, cwgtnw, cwltnw, cpeqnp, cpgtnp, cpltnp, ceqn, cgtn, cltn, lpgtnp, needPad, needFill, needDrop;
    usePad = getBit(flags, PF_FILL);
    useTC = getBit(flags, PF_TIME);
    anyID = getBit(flags, PF_ANYSID);
    fb3 = getBit(flags, PF_FB3);
    ctxf = getBit(flags, PF_CTXF);
    byp = getBit(flags, PF_BYPASS);
    useOUID = getBit(flags, PF_OUID);
    xSR = getBit(flags, PF_XSR);
    xIF = getBit(flags, PF_XIF);
    xRF = getBit(flags, PF_XRF);
    xGain = getBit(flags, PF_XGAIN);
    isNone = (pkty == PT_NONE);
    isNoop = (pkty == PT_NOOP);
    okICE = (pkty == PT_AUTO) || (pkty == PT_ICE);
    okSDDS = (pkty == PT_SDDS);
    okVRT = (pkty == PT_AUTO) || (pkty >= PT_VRT);
    okIn = bi.rok;
    phinc = pinc;
    okLen = (length > 0);
    doTrim = length < XFER;
    xfer = ! okIn ? 0 : doTrim ? length : XFER;
    oknSec = (nwsec > 0);
    difws = cwsec - nwsec;
    difps = cpsec - npsec;
    cwgtnw = (difws > 0);
    cwltnw = (difws < 0);
    cweqnw = ! cwgtnw && ! cwltnw;
    cpgtnp = (difps > (phinc << 2));
    cpltnp = (difps < - phinc);
    cpeqnp = ! cpgtnp && ! cpltnp;
    ceqn = cweqnw && cpeqnp;
    cgtn = cwgtnw || (cweqnw && cpgtnp);
    cltn = cwltnw || (cweqnw && cpltnp);
    needPad = (usePad && ! okIn);
    needFill = (useTC && oknSec && cltn);
    needDrop = (pstate == 4) && useTC && cgtn;
    lpsec = cpsec + (pinc << 8);
    lpgtnp = (lpsec > npsec);
    doClip = (lpsec > mpsec);
    doFill = (needPad || needFill || needDrop) && ! isNoop && ! isNone;
    doStop = oknSec && cweqnw && lpgtnp && ! needPad;
    fpsec = doClip ? l2i (mpsec - cpsec) : doStop ? l2i (npsec - cpsec) : (pinc << 8);
    lpsec = (pinc << 3);
    sid = 0;
    ooff = 0;
    seq = 0;
    ifb = 0;
    pfix = 0;
    if((this.halo.vbpr&2)!=0)System.out.printf ("Top  Cur w=%08x p=%012x  Nxt w=%08x p=%012x  Counts=%x Pad=%x Fill=%x Drop=%x rOk=%x wOk=%x cnt=%d\n", cwsec, cpsec, nwsec, npsec, counts, needPad ? 1 : 0, needFill ? 1 : 0, needDrop ? 1 : 0, bi.rok ? 1 : 0, so.wok ? 1 : 0, 0);
    if (doFill) {
      pstate = 1;
      dpsec = fpsec;
      bz = pad;
      while ((so.wok && dpsec > 0) || (ifb != 0)) {
        cpsec = cpsec + pinc;
        ifb = ! fb3 ? 0 : (ifb == 2) ? 0 : ifb + 1;
        pfix = (ifix == mfix) ? pfix + nfix : pfix;
        ifix = (ifix == mfix) ? 0 : ifix + 1;
        so.wrLCS (bz, (dpsec < lpsec) ? 1 : 0, 0);
        dpsec -= pinc;
      }
      counts=setBits(counts, 15, 12, getBits(counts, 15, 12) + 1);
      bz = 0;
    }
    else if (okLen) {
      pstate = 2;
      i = 0;
      while (so.wok && i < xfer) {
        cpsec = cpsec + pinc;
        pfix = (ifix == mfix) ? pfix + nfix : pfix;
        ifix = (ifix == mfix) ? 0 : ifix + 1;
        bz = bi.getL (i << 2);
        so.wrLCS (bz, (length < 8) ? 1 : 0, swaps);
        i ++;
        length --;
      }
      bi.rnxt (i << 2);
    }
    else if (okIn && isNoop) {
      pstate = 3;
      length = XFER;
    }
    else if (okIn && ! isNone) {
      pstate = 4;
      ulen = 0;
      bx = bi.getL (0);
      by = bi.getL (4);
      bz = bi.getL (8);
      anyOUID = ! useOUID || ! getBit(bx, 3);
      hasOUID = getBit(bx, 3);
      hasSID = (getBits(bx, 6, 5) > 1) ? true : getBit(bx, 4);
      isSID = bswap2 (hasSID ? getBits(by, 31, 16) : getBits(bz, 15, 0)) == sid;
      isVRTi = (getBits(bx, 7, 0) == 0x1C) && ((bswap4 (bz) == ouid) || anyOUID);
      isVRTj = (getBits(bx, 7, 0) == 0x08) && ((bswap4 (by) == ouid) || anyOUID);
      isVRTd = (getBits(bx, 7, 0) == 0x18) && ((bswap4 (bz) == DIFI) || anyOUID);
      isVRTc = (getBits(bx, 7, 0) == 0x49) && ((bswap4 (bz) == ouid) || anyOUID);
      isICE = okICE && (bx == 0x00676665);
      isVRT = okVRT && (isVRTi || isVRTj || isVRTd) && (isSID || anyID);
      isVCTX = okVRT && isVRTc && (isSID || anyID);
      if (isICE) {
        ioff = 64;
        seq = getBits(by, 7, 0);
        bfer = getBits(bz, 13, 0);
        ulen = getBits(bz, 13, 0);
        bx = bi.getL (12);
        sid = getBits(bx, 31, 16);
        bx = bi.getL (16);
        bpa = getBits(bx, 27, 24);
        for (j = 1; j < bpa; j ++) {
          ulen = ulen + bfer;
        }
      }
      else if (isVRT) {
        ooff = (getBit(bx, 2)) ? 4 : 0;
        ioff = ! hasOUID ? 20 : ! hasSID ? 24 : 28;
        seq = getBits(bx, 11, 8);
        nseq = nseq & 0xF;
        ulen = (bswap2 (getBits(bx, 31, 16)) << 2) - ioff - ooff;
        bx = bi.getL (12);
        isBE = isVRTi ? getBit(bx, 22) : isVRTj ? getBit(bz, 22) : true;
        bps = isVRTi ? getBits(bx, 27, 24) : isVRTj ? getBits(bz, 27, 24) : dbps;
        if (useTC) {
          by = bi.getL (ioff - 12);
          nwsec = bswap4 (by);
          by = bi.getL (ioff - 8);
          npsec=setBits(npsec, 39, 32, bswap4 (by));
          by = bi.getL (ioff - 4);
          npsec=setBits(npsec, 31, 0, bswap4 (by));
        }
        swaps=setBit(swaps, 0, (bps == 15) && isBE);
        swaps=setBit(swaps, 1, (bps > 15) && isBE);
        swaps=setBit(swaps, 2, (bps == 11) && isBE);
        if((this.halo.vbpr&2)!=0)System.out.printf ("New Cur w=%08x p=%012x  Nxt w=%08x p=%012x\n", cwsec, cpsec, nwsec, npsec);
      }
      else if (isVCTX) {
        pstate = 5;
        ioff = getBits(bx, 31, 24) << 2;
        coff = hasOUID ? 28 : 20;
        if (ctxf) {
          bx = bi.getL (coff);
          bx = brev4 (bswap4 (bx));
          if((this.halo.vbpr&1)!=0)System.out.printf ("UDAT Ctx bx=%08x coff=%d len=%d\n", bx, coff, ioff);
          so.wrLCS (bx, 2, 0);
          coff += 4 + ((getBits(bx, 2, 2)) << 3) + ((getBits(bx, 1, 1)) << 2);
          if (getBit(bx, 3) && xIF) {
            by = bi.getL (coff);
            bz = bi.getL (coff + 4);
            bc = l2i (ii2l (bswap4 (by), bswap4 (bz)) >> 20);
            if((this.halo.vbpr&1)!=0)System.out.printf ("UDAT Ctx IF bc=%d\n", bc);
            so.wrLCS (bc, 4, 0);
          }
          coff += ((getBits(bx, 3, 3)) << 3);
          if (getBit(bx, 4) && xRF) {
            by = bi.getL (coff);
            bz = bi.getL (coff + 4);
            bc = l2i (ii2l (bswap4 (by), bswap4 (bz)) >> 20);
            if((this.halo.vbpr&1)!=0)System.out.printf ("UDAT Ctx RF bc=%d\n", bc);
            so.wrLCS (bc, 4, 0);
          }
          coff += ((getBits(bx, 4, 4) + getBits(bx, 5, 5) + getBits(bx, 6, 6)) << 3) + ((getBits(bx, 7, 7)) << 2);
          if (getBit(bx, 8) && xGain) {
            by = bi.getL (coff);
            bc = bswap4 (by) >> 7;
            if((this.halo.vbpr&1)!=0)System.out.printf ("UDAT Ctx GAIN bc=%d\n", bc);
            so.wrLCS (bc, 8, 0);
          }
          coff += ((getBits(bx, 8, 8) + getBits(bx, 9, 9)) << 2);
          if (getBit(bx, 10) && xSR) {
            by = bi.getL (coff);
            bz = bi.getL (coff + 4);
            bc = l2i (ii2l (bswap4 (by), bswap4 (bz)) >> 20);
            if((this.halo.vbpr&1)!=0)System.out.printf ("UDAT Ctx SR bc=%d\n", bc);
            so.wrLCS (bc, 10, 0);
          }
          so.wrLCS (bx, 2, 0);
          so.setC (0);
        }
        counts=setBits(counts, 23, 20, getBits(counts, 23, 20) + 1);
      }
      else {
        ioff = 4;
        counts=setBits(counts, 30, 24, getBits(counts, 30, 24) + 1);
      }
      bi.rnxt (ioff);
      if (ulen > 0) {
        length = ulen >> 2;
        counts=setBits(counts, 3, 0, getBits(counts, 3, 0) + 1);
        if (seq != nseq) {
          counts=setBits(counts, 7, 4, getBits(counts, 7, 4) + 1);
        }
        nseq = seq + 1;
        so.setC (0);
      }
    }
    if (needDrop) {
      counts=setBits(counts, 11, 8, getBits(counts, 11, 8) + 1);
      bi.rnxt (xfer << 2);
      length = length - xfer;
      if (length > 0) {
        pstate = 4;
      }
    }
    counts=setBits(counts, 19, 16, (length > 15) ? 15 : getBits(length, 3, 0));
    counts=setBit(counts, 31, okIn);
    cpsec = cpsec + pfix;
    doWrap = (cpsec >= mpsec);
    if (doWrap) {
      cpsec = cpsec - mpsec;
      cwsec = cwsec + 1;
    }
    if (pass == 0) {
      this.counts = counts;
      this.cwsec = cwsec;
      this.cpsec = cpsec;
      this.nwsec = nwsec;
      this.npsec = npsec;
      if((this.halo.vbpr&2)!=0)System.out.printf ("Upd  Counts=%x   Nxt w=%08x p=%012x   Cur w=%08x p=%012x   pstate=%d cnt=%d pass=%d\n", counts, nwsec, npsec, cwsec, cpsec, pstate, 0, pass);
    }
    pass = (pass >= 14) ? 0 : pass + 1;
    bi.rokLen (XFER << 2);
    return 0;
  }
  public int close () {
    this.halo.state=0;
    return 0;
  }
  public int poll () {
    double time = cpuTime ();
    int twsec = d2i (floor (time));
    long tpsec = d2l (frac (time) * 1.0e12);
    if (ptype <= PT_NOOP) return 0;
    if (getBit(flags, PF_TIME)) {
      getVars ("cwsec,cpsec,nwsec,npsec,counts");
      System.out.printf ("Poll EECLFDSU=%08x  Cpu=%08x:%012x  Nxt=%08x:%012x  Cur=%08x:%012x\n", counts, twsec, tpsec, nwsec, npsec, cwsec, cpsec);
    }
    return 5;
  }
}
}
