/**
  Do NOT edit.
  This file is generated by ICEJVCC.
  See REC.jv for documentation.
*/
#include "Modefs.c"
#include "Modems.c"

/** Define Signatures */
#define CORE_NAME REC
#define CORE_AREA nxm_ice_core
#define CORE_FLOW 1
#include "cores/CoreDefs.h"
#define NP 1
#define AW 16
#define BW 32
#define CW 6

enum { REC_OFEC = 9 };


/** Define CORE Plan Handles */
typedef struct {
  HALO halo;
  int_4 alg;
  int_4 upp;
  int_u4 terrs;
  int_u4 tbits;
  int_u1 vflg;
  int_u1 bpw;
  Modems_IFEC* ifec;
} REC;

#include "cores/CoreProtos.h"

/** CORE Code */

void* REC_alloc (char *config) {
  REC* plan = REC_plan();
  if (plan==NULL) return NULL;
  HW_alloc(plan,config);
  return (void*)plan;
}


int_4 REC_upload (REC* plan) {
  void *planp=(void*)plan;
  if (HW_isLocal(planp)) return 0;
  HW_push (planp,HW_PREP);
  HW_loadHdr (planp,5);
  HW_loadInt  (planp,plan->terrs);
  HW_loadInt  (planp,plan->tbits);
  HW_loadInt  (planp,plan->vflg);
  HW_loadInt  (planp,plan->bpw);
  HW_loadObj  (planp,Modems_IFEC_upload(plan->ifec));
  HW_push (planp,HW_OPEN);
  return 5;
}

int_4 REC_init (REC* plan) {
  plan->alg = Modefs_FEC_NONE;
  plan->upp = 0;
  plan->bpw = 2;
  plan->vflg = 0x80;
  plan->terrs = 0;
  plan->tbits = 0;
  return 0;
}

int_4 REC_set (REC* plan, String* key, Value* value) {
  if (isMatch (key, "S:ALG")) plan->alg = Value_toItem (value, Modefs_fecList);
  else if (isMatch (key, "S:FEC")) plan->alg = Value_toItem (value, Modefs_fecList);
  else if (isMatch (key, "L:BPW")) plan->bpw = Value_toL (value);
  else if (isMatch (key, "L:UPP")) plan->upp = Value_toL (value);
  else return Core_set (plan, key, value);
  return 0;
}

int_4 REC_get (REC* plan, String* key, Value* value) {
  if (isMatch (key, "L:ALG")) Value_fromL (value, plan->alg);
  else if (isMatch (key, "L:BPW")) Value_fromL (value, plan->bpw);
  else return Core_get (plan, key, value);
  return 0;
}

int_4 REC_open (REC* plan) {
  if (plan->alg == Modefs_FEC_TCM23) {
    plan->bpw = 3;
    plan->vflg |= 0x04;
  }
  plan->ifec = Modems_IFEC_new (REC_OFEC);
  Modems_IFEC_open (plan->ifec, plan->alg, plan->upp, plan->vflg);
  printf ("REC alg=%d bpw=%d vflg=%x\n", plan->alg, plan->bpw, plan->vflg);
  REC_upload (plan);
  return 0;
}

int_4 REC_process (REC* plan, Stream* si, Stream* so) {
  int_u4 bi;
  int_u4 ofec;
  int_1 bits, errs;
  while (si->rok && so->wok) {
    bi = Stream_rdBits (si, plan->bpw);
    ofec = Modems_IFEC_process (plan->ifec, bi, plan->bpw);
    bits = getBits(ofec, 19, 16);
    errs = getBits(ofec, 27, 24);
    Stream_wrBits (so, bits, ofec);
    plan->tbits += bits;
    plan->terrs += errs;
  }
  return 0;
}

int_4 REC_close (REC* plan) {
  if (HW_needsPut(plan)) { HW_push(plan,HW_PREP);  HW_unloadInt4(plan,0,&plan->terrs); HW_unloadInt4(plan,1,&plan->tbits);  HW_push(plan,HW_UPD); }
  printf ("iFEC alg=%d errs=%d of bits=%d \n", plan->alg, plan->terrs, plan->tbits);
  HW_push(plan,HW_CLOSE);
  return 0;
}

int_4 REC_poll (REC* plan) { return 0; }

int_4 REC_free (REC* plan) {
  HW_free(plan);
  free(plan);
}

#include "cores/CoreHandles.h"

REC* REC_subCore (HALO* halo, int_4 scid) {
  REC* plan = REC_plan();
  if (plan==NULL) return NULL;
  Core_copyHaloToSub(halo,&plan->halo,scid);
  REC_init(plan);
  return plan;
}
#undef CORE_NAME
#undef CORE_AREA
#undef CORE_FLOW
#undef AW
#undef BW
#undef CW
#undef NP
