/**
  Do NOT edit.
  This file is generated by ICEJVCC.
  See Noop.jv for documentation.
*/

/** Define Signatures */
#define CORE_NAME Noop
#define CORE_AREA nxm_ice_core
#define CORE_FLOW 1
#include "cores/CoreDefs.h"
#define NP 1
#define AW 16
#define BW 32
#define CW 6



/** Define CORE Plan Handles */
typedef struct {
  HALO halo;
  int_4 dec;
  int_4 throttle;
  int_u1 mdec;
  int_u1 idec;
  Value* vx;
} Noop;

#include "cores/CoreProtos.h"

/** CORE Code */

void* Noop_alloc (char *config) {
  Noop* plan = Noop_plan();
  if (plan==NULL) return NULL;
  HW_alloc(plan,config);
  return (void*)plan;
}


int_4 Noop_upload (Noop* plan) {
  void *planp=(void*)plan;
  if (HW_isLocal(planp)) return 0;
  HW_push (planp,HW_PREP);
  HW_loadHdr (planp,5);
  HW_loadInt  (planp,plan->dec);
  HW_loadInt  (planp,plan->throttle);
  HW_loadInt  (planp,plan->mdec);
  HW_loadInt  (planp,plan->idec);
  HW_loadInt  (planp,0);
  HW_push (planp,HW_OPEN);
  return 5;
}

int_4 Noop_init (Noop* plan) {
  plan->dec = 1;
  plan->throttle = 0;
  return 0;
}

int_4 Noop_set (Noop* plan, String* key, Value* value) {
  if (isMatch (key, "L:DEC")) plan->dec = Value_toL (value);
  else if (isMatch (key, "L:THROTTLE")) plan->throttle = Value_toL (value);
  else return Core_set (plan, key, value);
  return 0;
}

int_4 Noop_get (Noop* plan, String* key, Value* value) {
  if (isMatch (key, "L:DEC")) Value_fromL (value, plan->dec);
  else if (isMatch (key, "L:THROTTLE")) Value_fromL (value, plan->throttle);
  else if (isMatch (key, "D:XDIO")) Value_fromD (value, i2d (plan->dec));
  else return Core_get (plan, key, value);
  return 0;
}

int_4 Noop_open (Noop* plan) {
  plan->mdec = plan->dec - 1;
  plan->idec = 0;
  plan->vx = Value_new ("CI", 1);
  Noop_upload (plan);
  return 0;
}

int_4 Noop_process (Noop* plan, Stream* si, Stream* so) {
  while (si->rok && so->wok) {
    Stream_rd (si, plan->vx);
    if (plan->idec == 0) {
      Stream_wr (so, plan->vx);
    }
    plan->idec = (plan->idec == plan->mdec) ? 0 : plan->idec + 1;
  }
  return 0;
}

int_4 Noop_close (Noop* plan) {
  HW_push(plan,HW_CLOSE);
  return 0;
}

int_4 Noop_poll (Noop* plan) { return 0; }

int_4 Noop_free (Noop* plan) {
  HW_free(plan);
  free(plan);
}

#include "cores/CoreHandles.h"

Noop* Noop_subCore (HALO* halo, int_4 scid) {
  Noop* plan = Noop_plan();
  if (plan==NULL) return NULL;
  Core_copyHaloToSub(halo,&plan->halo,scid);
  Noop_init(plan);
  return plan;
}
#undef CORE_NAME
#undef CORE_AREA
#undef CORE_FLOW
#undef AW
#undef BW
#undef CW
#undef NP
