/**
  Do NOT edit.
  This file is generated by ICEJVCC.
  See MFPP.jv for documentation.
*/

/** Define Signatures */
#define CORE_NAME MFPP
#define CORE_AREA nxm_ice_core
#define CORE_FLOW 1
#include "cores/CoreDefs.h"
#define NP 1
#define AW 16
#define BW 32
#define CW 6

enum { MFPP_OHIT = 8 };
enum { MFPP_MHIT = ( 1 << MFPP_OHIT ) };
enum { MFPP_OTOP = 8 };
enum { MFPP_MTOP = ( 1 << MFPP_OTOP ) };
enum { MFPP_OWIN = 6 };
enum { MFPP_MWIN = ( 1 << MFPP_OWIN ) };
enum { MFPP_OFFT = 14 };
enum { MFPP_MFFT = ( 1 << MFPP_OFFT ) };
static char* MFPP_flgList = "Bypass,Strip,Tag,Log,Peak,Sort,Diff,HiThresh";
enum { MFPP_F_BYPASS = 0 };
enum { MFPP_F_STRIP = 1 };
enum { MFPP_F_TAG = 2 };
enum { MFPP_F_LOG = 3 };
enum { MFPP_F_PEAK = 4 };
enum { MFPP_F_SORT = 5 };
enum { MFPP_F_DIFF = 6 };
enum { MFPP_F_HITHRESH = 7 };


/** Define CORE Plan Handles */
typedef struct {
  HALO halo;
  real_4 thresh;
  int_2 frame;
  real_4 vthresh;
  int_2 mframe;
  int_2 nwin;
  int_2 ntop;
  real_4 tmin;
  int_u1 flags;
  int_2 itop;
  int_2 count;
  int_1 cntovr;
  int_1 isUp;
  int_2 iup;
  real_4 vtot;
  real_4 vhit;
  real_4 vnf;
  StatBuf* sbuf;
  int_4* hiti;
  real_4* hitv;
  int_u1 edgeL;
  int_u1 edgeR;
} MFPP;

#include "cores/CoreProtos.h"

/** CORE Code */

void* MFPP_alloc (char *config) {
  MFPP* plan = MFPP_plan();
  if (plan==NULL) return NULL;
  HW_alloc(plan,config);
  return (void*)plan;
}


int_4 MFPP_upload (MFPP* plan) {
  void *planp=(void*)plan;
  if (HW_isLocal(planp)) return 0;
  HW_push (planp,HW_PREP);
  HW_loadHdr (planp,21);
  HW_loadFlt  (planp,plan->thresh);
  HW_loadInt  (planp,plan->frame);
  HW_loadFlt  (planp,plan->vthresh);
  HW_loadInt  (planp,plan->mframe);
  HW_loadInt  (planp,plan->nwin);
  HW_loadInt  (planp,plan->ntop);
  HW_loadFlt  (planp,plan->tmin);
  HW_loadInt  (planp,plan->flags);
  HW_loadInt  (planp,plan->itop);
  HW_loadInt  (planp,plan->count);
  HW_loadInt  (planp,plan->cntovr);
  HW_loadInt  (planp,plan->isUp);
  HW_loadInt  (planp,plan->iup);
  HW_loadFlt  (planp,plan->vtot);
  HW_loadFlt  (planp,plan->vhit);
  HW_loadFlt  (planp,plan->vnf);
  HW_loadObj  (planp,StatBuf_upload(plan->sbuf));
  HW_loadBuf  (planp,plan->hiti,'i',0);
  HW_loadBuf  (planp,plan->hitv,'f',0);
  HW_loadInt  (planp,plan->edgeL);
  HW_loadInt  (planp,plan->edgeR);
  HW_push (planp,HW_OPEN);
  return 21;
}

int_4 MFPP_addToSort (MFPP* plan, int_4 itop, real_4 vtot, int_4 vind) {
  int_4 ii;
  int_1 rep0, rep1;
  for (ii = plan->itop; ii >= 0; ii --) {
    rep0 = (ii == plan->itop) || (plan->vtot > plan->hitv[ii]);
    rep1 = (ii > 0) && (plan->vtot > plan->hitv[ii-1]);
    if (rep1) {
      plan->hiti[ii] = plan->hiti[ii-1];
      plan->hitv[ii] = plan->hitv[ii-1];
    }
    else if (rep0) {
      plan->hiti[ii] = vind;
      plan->hitv[ii] = plan->vtot;
    }
  }
  if (plan->itop < plan->ntop) plan->itop ++;
  return plan->itop;
}

int_4 MFPP_init (MFPP* plan) {
  plan->thresh = 2.0F;
  plan->frame = 256;
  plan->ntop = 64;
  plan->tmin = 0;
  return 0;
}

int_4 MFPP_set (MFPP* plan, String* key, Value* value) {
  if (isMatch (key, "L:FRAME")) plan->frame = Value_toL (value);
  else if (isMatch (key, "L:WIDTH")) plan->nwin = Value_toL (value);
  else if (isMatch (key, "L:NTOP")) plan->ntop = Value_toL (value);
  else if (isMatch (key, "F:THRESH")) plan->thresh = Value_toF (value);
  else if (isMatch (key, "F:TMIN")) plan->tmin = Value_toF (value);
  else if (isMatch (key, "S:FLAGS")) plan->flags = Value_toMask (value, MFPP_flgList);
  else return Core_set (plan, key, value);
  return 0;
}

int_4 MFPP_get (MFPP* plan, String* key, Value* value) {
  if (isMatch (key, "L:FRAME")) Value_fromL (value, plan->frame);
  else if (isMatch (key, "L:WIDTH")) Value_fromL (value, plan->nwin);
  else return Core_get (plan, key, value);
  return 0;
}

int_4 MFPP_open (MFPP* plan) {
  if (plan->nwin > MFPP_MWIN) {
    printf ("Sliding window width=%d limited to max=%d\n", plan->nwin, MFPP_MWIN);
    plan->nwin = MFPP_MWIN;
  }
  if (plan->ntop > MFPP_MTOP) {
    printf ("Number peaks=%d limited to max=%d\n", plan->ntop, MFPP_MTOP);
    plan->ntop = MFPP_MTOP;
  }
  plan->sbuf = StatBuf_new (MFPP_OWIN);
  StatBuf_setLength (plan->sbuf, plan->nwin);
  plan->hiti = zallocBuf(sizeof(int_4)*(MFPP_MHIT));
  plan->hitv = zallocBuf(sizeof(real_4)*(MFPP_MHIT));
  plan->cntovr = 0;
  if (plan->ntop == 0) plan->flags |= MFPP_F_BYPASS;
  plan->vthresh = 1.0F / plan->thresh;
  plan->count = 0;
  plan->mframe = plan->frame - 1;
  plan->itop = 0;
  if(plan->halo.vbpr&1)printf ("MFPP frame=%d ntop=%d flags=%x\n", plan->frame, plan->ntop, plan->flags);
  MFPP_upload (plan);
  return 0;
}

int_4 MFPP_process (MFPP* plan, Stream* si, Stream* so) {
  real_4 v, vi, vmin, vmax, vmid, vchk, vthr, vd, vdx;
  int_1 cntok, hitu, hitd, hitm, topl, topn;
  int_1 bypass, strip, tag, log, peak, sort, diff, hsnr;
  int_4 ve, vc, vcx;
  int_u1 edgeM;
  int_2 ibin;
  bypass = getBit(plan->flags, 0);
  strip = getBit(plan->flags, 1);
  tag = getBit(plan->flags, 2);
  log = getBit(plan->flags, 3);
  peak = getBit(plan->flags, 4);
  sort = getBit(plan->flags, 5);
  diff = getBit(plan->flags, 6);
  hsnr = getBit(plan->flags, 7);
  while (si->rok && so->wok && ! plan->cntovr) {
    cntok = (plan->count >= plan->nwin) && (plan->edgeR == 0);
    plan->cntovr = (plan->count >= plan->mframe);
    ibin = plan->count - (plan->nwin >> 1);
    plan->count = (bypass || plan->count >= plan->mframe) ? 0 : plan->count + 1;
    vi = Stream_rdF (si);
    if (! strip) {
      Stream_wrL (so, fp2i (vi));
    }
    StatBuf_load (plan->sbuf, vi);
    vmid = StatBuf_getMid (plan->sbuf);
    vmin = StatBuf_getMinM (plan->sbuf, peak ? 0 : - 1);
    vmax = StatBuf_getMaxM (plan->sbuf, 1);
    v = diff ? vmid - vmin : vmid - plan->vnf;
    vthr = mulff (vmid, plan->vthresh);
    vchk = log ? vmid - plan->thresh : vthr;
    hitu = cntok && vchk > vmin;
    hitd = plan->cntovr || vmid < plan->vhit;
    hitm = hsnr && ((vmax - vmid) > plan->thresh);
    if (plan->isUp && hitd) {
      plan->edgeR = StatBuf_getMinI (plan->sbuf, 1);
      edgeM = imin (plan->edgeL, plan->edgeR);
      ve = ((ibin + edgeM) << 16) | (plan->iup - edgeM);
      if (plan->vtot < plan->tmin) {
      }
      else if (sort) {
        plan->itop = MFPP_addToSort (plan, plan->itop, plan->vtot, ve);
      }
      else if (plan->itop < plan->ntop) {
        plan->hiti[plan->itop] = ve;
        plan->hitv[plan->itop] = plan->vtot;
        plan->itop ++;
      }
      plan->isUp = 0;
      plan->vtot = 0;
    }
    else if (plan->isUp ? hitm : hitu) {
      plan->iup = ibin;
      plan->vtot = v;
      plan->vhit = vmid;
      if (! plan->isUp) {
        plan->vnf = vmin;
      }
      plan->edgeL = StatBuf_getMinI (plan->sbuf, -1);
      plan->isUp = 1;
    }
    else if (plan->isUp) {
      if (! peak) {
        plan->vtot += v;
      }
      else if (v > plan->vtot) {
        plan->vtot = v;
      }
    }
    else if (plan->edgeR > 0) {
      plan->edgeR --;
    }
  }
  while (so->wok && plan->cntovr) {
    plan->cntovr = (plan->count < plan->ntop);
    topl = (plan->count < plan->itop);
    topn = (plan->count == plan->ntop);
    vc = plan->hiti[plan->count];
    vd = plan->hitv[plan->count];
    plan->count = (plan->count >= plan->ntop) ? 0 : plan->count + 1;
    if (! topn || tag) {
      vcx = topn ? plan->itop : topl ? vc : 0;
      vdx = topn ? plan->vtot : topl ? vd : 0;
      Stream_wrL (so, vcx);
      Stream_wrL (so, fp2i (vdx));
      plan->vtot = plan->vtot + vd;
    }
    if (topn) {
      plan->itop = 0;
    }
  }
  return 0;
}

int_4 MFPP_close (MFPP* plan) {
  HW_push(plan,HW_CLOSE);
  return 0;
}

int_4 MFPP_poll (MFPP* plan) { return 0; }

int_4 MFPP_free (MFPP* plan) {
  HW_free(plan);
  free(plan);
}

#include "cores/CoreHandles.h"

MFPP* MFPP_subCore (HALO* halo, int_4 scid) {
  MFPP* plan = MFPP_plan();
  if (plan==NULL) return NULL;
  Core_copyHaloToSub(halo,&plan->halo,scid);
  MFPP_init(plan);
  return plan;
}
#undef CORE_NAME
#undef CORE_AREA
#undef CORE_FLOW
#undef AW
#undef BW
#undef CW
#undef NP
